/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.driver.crs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OUIComponent;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.osysmodel.driver.sdk.util.OsysUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCrsProductDriver
extends ProductDriver {
    private Logger logger = Logger.getLogger(AbstractCrsProductDriver.class.getName());
    private static final String NODE_ROLE_CLASS = "oracle.cluster.common.NodeRole";
    private static final String GET_ROLE_STR_METHOD = "getRoleStr";
    private static final String GET_NODE_CONFIG_ROLE_METHOD = "getNodeConfigRole";
    protected Map<File, Boolean> sharedCheckCached = new HashMap<File, Boolean>();
    protected CRSCluster crsCluster = null;
    protected HAS siha = null;
    protected Map<Host, OracleHome> gihomes = new HashMap<Host, OracleHome>();
    protected List<OracleHome> homes = new ArrayList<OracleHome>();
    protected ArrayList<Host> hosts = new ArrayList();
    private String[] node_names = null;
    private static Map<String, String> topLevelComponentsMap;
    private static Map<String, String> descriptionMap;
    String crsHome = null;
    protected CrsType crsType = CrsType.CRS;
    protected ArrayList<File> crsSftwareInsOnly = new ArrayList();
    protected ArrayList<File> userSpecifiedHomes = new ArrayList();

    protected CRSCluster makeClusterObj(String name) {
        CRSCluster crsCluster = new CRSCluster();
        crsCluster.setName(name);
        crsCluster.setClusterName(name);
        this.defaultValues((AbstractBaseTarget)crsCluster);
        crsCluster.setDbRAC(new ArrayList());
        crsCluster.setDbSI(new ArrayList());
        crsCluster.setHAS(new ArrayList());
        this.ti.getEntities().add(crsCluster);
        this.ti.setTop((AbstractBaseTarget)crsCluster);
        return crsCluster;
    }

    protected Host findHostByName(String name) {
        for (Host host : this.hosts) {
            if (!host.getHostName().equals(name)) continue;
            return host;
        }
        throw new ProductDriverException("Unknown host name in config:" + name, ProductDriverException.Type.InvalidConfiguration);
    }

    protected String[] fetchNodeNames() {
        if (this.node_names != null) {
            return this.node_names;
        }
        try {
            this.node_names = Cluster.getNodes();
        }
        catch (Exception e) {
            try {
                this.node_names = this.fetchNodeNames(this.crsHome);
            }
            catch (Exception e1) {
                throw new ProductDriverException((Throwable)e1, ProductDriverException.Type.ProductApiException);
            }
        }
        return this.node_names;
    }

    protected String[] fetchNodeNames(String homePath) {
        String[] nodes = new String[]{};
        nodes = OUIDriver.fetchNodeNames((String)homePath);
        if (nodes.length < 1) {
            throw new ProductDriverException("Failed to detect any node info by OUI", ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        return this.cutDomainName(nodes);
    }

    private String[] cutDomainName(String[] nodes) {
        String[] cutNodes = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            cutNodes[i] = this.extractHostName(nodes[i]);
        }
        return cutNodes;
    }

    protected String extractHostName(String nodeName) {
        String hostName = nodeName;
        if (nodeName.indexOf(".") != -1) {
            hostName = nodeName.substring(0, nodeName.indexOf("."));
        }
        return hostName;
    }

    protected String getCrsVersion() {
        Logger logger = Logger.getLogger(AbstractCrsProductDriver.class.getName());
        String ver = "";
        for (OracleHome oh : this.localInfo.getOracleHomes()) {
            if (!new File(oh.getPath()).equals(new File(this.crsHome))) continue;
            ver = ((OUIComponent)oh.getTopLevelOUI().get(0)).getVersion();
            break;
        }
        return ver;
    }

    protected void makeNodesForSIHA() {
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "makeNodesForSIHA");
        for (String name : this.fetchNodeNames()) {
            Host host = this.makeHostByNodeName(name);
            this.siha.setHost(host);
            this.siha.setName("has_" + host.getName());
            this.siha.setDisplayName("has_" + host.getName());
            this.hosts.add(host);
            this.ti.getEntities().add(host);
        }
        this.logger.exiting(((Object)((Object)this)).getClass().getName(), "makeNodesForSIHA");
    }

    protected void makeNodes() {
        this.logger.entering(((Object)((Object)this)).getClass().getName(), "makeNodes");
        if (this.crsCluster != null) {
            this.crsCluster.setNodes(new ArrayList());
        }
        for (String name : this.fetchNodeNames()) {
            Host host = this.makeHostByNodeName(name);
            if (this.crsCluster != null) {
                this.crsCluster.getNodes().add(host);
            }
            this.hosts.add(host);
            this.ti.getEntities().add(host);
        }
        this.logger.exiting(((Object)((Object)this)).getClass().getName(), "makeNodes");
    }

    private Host makeHostByNodeName(String name) {
        Host host = new Host();
        host.setName(name);
        this.defaultValues((AbstractBaseTarget)host);
        host.setNodeName(name);
        if (host.getNodeName().indexOf(".") != -1) {
            host.setDomainName(host.getNodeName().substring(host.getNodeName().indexOf(".") + 1));
            host.setHostName(host.getNodeName().substring(0, host.getNodeName().indexOf(".")));
        } else {
            host.setHostName(name);
            host.setDomainName(null);
        }
        return host;
    }

    public static Map<String, String> getTopLevelComponentsMap() {
        if (topLevelComponentsMap == null) {
            topLevelComponentsMap = new HashMap<String, String>();
            topLevelComponentsMap.put("oracle.crs", "crs");
            topLevelComponentsMap.put("oracle.siha", "siha");
            topLevelComponentsMap.put("oracle.server", "rac");
        }
        return topLevelComponentsMap;
    }

    protected String getHomeType(OracleHome oh) {
        String homeType = oh.getHomeType();
        if (homeType == null || homeType.trim().equalsIgnoreCase("")) {
            String ouiComponentType = "";
            Map<String, String> topLevelComponents = AbstractCrsProductDriver.getTopLevelComponentsMap();
            for (OUIComponent o : oh.getTopLevelOUI()) {
                if (!topLevelComponents.containsKey(o.getName())) continue;
                ouiComponentType = topLevelComponents.get(o.getName());
            }
            this.logger.info("ouiComponentType:  " + ouiComponentType);
            homeType = ouiComponentType;
            if (ouiComponentType.equals("crs") && this.crsType == CrsType.SIHA) {
                homeType = "siha";
            }
        }
        this.logger.info("homeType:  " + homeType);
        return homeType;
    }

    public static Map<String, String> getDescriptionMap() {
        if (descriptionMap == null) {
            descriptionMap = new HashMap<String, String>();
            descriptionMap.put("crs", "Grid Infrastructure Home");
            descriptionMap.put("rac", "Database Home");
            descriptionMap.put("sidb", "Database Home");
            descriptionMap.put("siha", "SIHA Home");
        }
        return descriptionMap;
    }

    protected void setHomeIds() {
        for (OracleHome oh : this.homes) {
            for (OUIComponent o : oh.getTopLevelOUI()) {
                this.ti.getEntities().add(o);
            }
            oh.setHomeType(this.getHomeType(oh));
            oh.setDescription(AbstractCrsProductDriver.getDescriptionMap().get(oh.getHomeType()));
            this.logger.fine("Hometype of:" + oh.getId() + " set to " + oh.getHomeType());
        }
    }

    protected OracleHome makeHome(String path, Host host) {
        this.getLocalInfo();
        OracleHome localHome = this.localInfo.getHome(path);
        if (localHome == null) {
            StringBuffer sb = new StringBuffer("Error: Crs Driver could not collect information about the Oracle home: {0} on {1}\nOne reason could be that the current user does not have enough privileges to read the product information from this Oracle home.\nTo workaround this issue, try running command as a user with read privileges on this Oracle home or as root user.\n");
            throw new ProductDriverException(MessageFormat.format(sb.toString(), path, host.getNodeName()));
        }
        if (localHome.getOracleBaseLocation() == null) {
            this.logger.log(Level.SEVERE, "OracleBase is null for OracleHome at " + path);
            StringBuffer sb = new StringBuffer("Error: Crs Driver could not collect the Oracle Base information about the Oracle Home: {0} on {1}\n");
            throw new ProductDriverException(MessageFormat.format(sb.toString(), path, host.getNodeName()));
        }
        if (localHome.getIsShared() || this.isShared(localHome.getPath())) {
            localHome.setIsShared(true);
            ArrayList<Host> h = localHome.getHosts();
            if (h == null) {
                h = new ArrayList<Host>();
            }
            h.add(host);
            localHome.setHosts(h);
            if (!this.homes.contains(localHome)) {
                this.homes.add(localHome);
                this.ti.getEntities().add(localHome);
            }
            return localHome;
        }
        OracleHome nonshared = this.copyHome(localHome);
        ArrayList<Host> h = new ArrayList<Host>();
        h.add(host);
        nonshared.setHosts(h);
        this.homes.add(nonshared);
        this.ti.getEntities().add(nonshared);
        return nonshared;
    }

    protected OracleHome findHome(String nodename, String path) {
        for (OracleHome home : this.homes) {
            if (!OUIDriver.areLocationsSame((String)home.getPath(), (String)path)) continue;
            for (Host host : home.getHosts()) {
                if (!host.getName().equals(nodename)) continue;
                return home;
            }
        }
        throw new ProductDriverException("No home found at " + path + " on " + nodename, ProductDriverException.Type.InvalidConfiguration);
    }

    protected OracleHome findOrMakeHome(String nodename, String path) {
        try {
            return this.findHome(nodename, path);
        }
        catch (ProductDriverException e) {
            return this.makeHome(path, this.findHostByName(nodename));
        }
    }

    protected void makeCrsHomes() {
        this.crsHome = this.detectCrsHome();
        this.logger.log(Level.FINE, "CrsHome=" + this.crsHome);
        boolean calledFromArr = this.userSpecifiedHomes.size() > 0;
        for (Host host : this.hosts) {
            if (calledFromArr) {
                if (this.crsSftwareInsOnly.contains(new File(this.crsHome)) || !this.userSpecifiedHomes.contains(new File(this.crsHome))) continue;
                this.gihomes.put(host, this.updateHome(this.makeHome(this.crsHome, host)));
                continue;
            }
            this.gihomes.put(host, this.updateHome(this.makeHome(this.crsHome, host)));
        }
        Host host = this.localInfo.getLocalHost();
        if (calledFromArr) {
            for (File insOnly : this.crsSftwareInsOnly) {
                OracleHome home = this.updateHome(this.makeHome(insOnly.getAbsolutePath(), host));
                if (this.gihomes.get(host) != null) continue;
                this.gihomes.put(host, home);
            }
        }
    }

    protected OracleHome updateHome(OracleHome home) {
        if (this.crsCluster != null) {
            home.setVersion(this.crsCluster.getVersion());
        }
        return home;
    }

    public String getNodeRole(String nodeName) {
        String nodeRole = null;
        try {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            Method m = clusterwareInfo.getClass().getMethod(GET_NODE_CONFIG_ROLE_METHOD, String.class, String.class);
            Object nodeRoleObj = m.invoke((Object)clusterwareInfo, this.crsHome, nodeName);
            Method getRoleMethod = Class.forName(NODE_ROLE_CLASS).getMethod(GET_ROLE_STR_METHOD, new Class[0]);
            if (Class.forName(NODE_ROLE_CLASS).isInstance(nodeRoleObj)) {
                Object obj = getRoleMethod.invoke(nodeRoleObj, new Object[0]);
                if (obj instanceof String) {
                    nodeRole = (String)obj;
                }
                this.logger.config("the node role for host:\t" + nodeName + " is:\t" + nodeRole);
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.config("Method not found" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ProductDriverException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.config("Could not get node role for node: " + nodeName + " with error " + e.getTargetException().getMessage());
        }
        catch (ClassNotFoundException e) {
            this.logger.config("Class not Found" + e.getMessage());
        }
        return nodeRole;
    }

    protected void makeDBHomes(ArrayList<File> dbHomes) {
        for (File home : dbHomes) {
            String[] nodes;
            for (String node : nodes = this.fetchNodeNames(home.getAbsolutePath())) {
                this.logger.log(Level.FINE, "Home=" + home);
                this.findOrMakeHome(node, home.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getConfigProperties() {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(this.crsHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params");
            prop.load(is);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return prop;
    }

    public boolean isShared(String ohPath) {
        if (this.sharedCheckCached.containsKey(new File(ohPath))) {
            return this.sharedCheckCached.get(new File(ohPath));
        }
        if (!OUIDriver.firstVersionLaterThanSecond((String)this.getCrsVersion(), (String)"11.2.0.3.0")) {
            return false;
        }
        boolean shared = true;
        this.logger.log(Level.FINE, "Checking whether Oracle Home \"" + ohPath + "\" is shared or not.");
        String crsHome = this.detectCrsHome();
        String[] nodes = new String[]{};
        nodes = new File(crsHome).equals(new File(ohPath)) ? this.fetchNodeNames() : this.fetchNodeNames(ohPath);
        shared = OsysUtility.isSharedPath((String)crsHome, (String)ohPath, (String[])nodes, (boolean)this.isStackRunning());
        this.sharedCheckCached.put(new File(ohPath), shared);
        return shared;
    }

    protected void makeCrsDaemons() {
        for (Host host : this.hosts) {
            HAS cd = new HAS();
            cd.setName("has_" + host.getName());
            cd.setNodeName(host.getHostName());
            cd.setVersion(this.crsCluster.getVersion());
            this.defaultValues((AbstractBaseTarget)cd);
            cd.setHost(host);
            cd.setCluster(this.crsCluster);
            cd.setNodeRole(this.getNodeRole(host.getNodeName()));
            if (this.gihomes.get(host) == null) continue;
            this.gihomes.get(host).getInstalledSWComponents().add(cd);
            OracleHome home = this.gihomes.get(host);
            home.setHomeType("crs");
            cd.setRuns_from(home);
            this.crsCluster.getHAS().add(cd);
            this.ti.getEntities().add(cd);
        }
    }

    protected String detectCrsHome() {
        if (this.crsHome != null) {
            return this.crsHome;
        }
        try {
            ArrayList homes = OUIDriver.getHomesList();
            boolean hasCrs = false;
            for (Object home : homes) {
                String[] homeInfo = (String[])home;
                String homePath = homeInfo[0];
                if ("IS_CRS_HOME".equals(homeInfo[1])) {
                    this.crsHome = homePath;
                    hasCrs = true;
                    continue;
                }
                File crsctl = new File(homePath + File.separator + "bin" + File.separator + "crsctl.bin");
                if (!crsctl.exists()) continue;
                this.crsSftwareInsOnly.add(new File(homePath));
            }
            if (!hasCrs && this.crsSftwareInsOnly.size() > 0) {
                String crsHomeInOlrFile = this.getCrsHomeFromOlrFile();
                this.crsHome = crsHomeInOlrFile != null && crsHomeInOlrFile.length() != 0 ? crsHomeInOlrFile : this.crsSftwareInsOnly.get(0).getAbsolutePath();
            }
            OUIDriver.endStdInventorySession();
        }
        catch (Exception e1) {
            throw new ProductDriverException("Failed to detect Grid Infrastructure setup due to " + e1.getMessage());
        }
        if (this.crsHome == null) {
            throw new ProductDriverException("Cannot detect any valid Grid Infrastructure setup.");
        }
        return this.crsHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCrsHomeFromOlrFile() {
        File olrFile = new File("/etc/oracle/olr.loc");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(olrFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("crs_home")) continue;
                String[] crshomeLine = line.split("=");
                if (crshomeLine == null || crshomeLine.length != 2) continue;
                String string = crshomeLine[1];
                return string;
            }
            reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    boolean isStackRunning() {
        boolean running = false;
        String crsHomePath = this.detectCrsHome();
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSConfigured(crsHomePath)) {
                this.crsType = CrsType.CRS;
            } else if (crsInfo.isHAConfigured(crsHomePath)) {
                this.crsType = CrsType.SIHA;
            } else if (this.crsSftwareInsOnly.size() > 0) {
                this.crsType = CrsType.SOFTWARE_ONLY;
            } else {
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            this.logger.log(Level.INFO, "crsType: " + (Object)((Object)this.crsType));
            if (this.crsType == CrsType.CRS) {
                running = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (this.crsType == CrsType.SIHA) {
                running = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
        }
        catch (InstallException e) {
            this.logger.log(Level.FINE, e.getMessage());
        }
        return running;
    }

    public LocalInfo getLocalInfo() {
        if (this.localInfo == null) {
            this.localInfo = new LocalInfo();
            this.localInfo.setOracleHomes(OUIDriver.getLocalInfo());
            for (OracleHome oh : this.localInfo.getOracleHomes()) {
                this.logger.config("Found local home at " + oh.getPath());
            }
            try {
                this.localInfo.setLocalHostName(Cluster.getLocalNode());
            }
            catch (Exception e) {
                if (this.node_names != null && this.node_names.length > 0) {
                    this.localInfo.setLocalHostName(this.node_names[0]);
                }
                throw new ProductDriverException("Failed to get local node info when crs stack down", ProductDriverException.Type.ProductApiException);
            }
            this.localInfo.setLocalHost(this.findHostByName(this.localInfo.getLocalHostName()));
        }
        return this.localInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrsType {
        NONE,
        CRS,
        SIHA,
        SOFTWARE_ONLY;

    }
}

