/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.patch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.common.EMtargetTypes;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.patch.ApplicabilityTarget;
import oracle.osysmodel.patchsdk.PatchPackageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSApplicabilityTarget
extends ApplicabilityTarget {
    private Map<EMtargetTypes, OPlanRecognizedCRSApplicabilityTarget> targetTypeMap = new HashMap<EMtargetTypes, OPlanRecognizedCRSApplicabilityTarget>();

    public CRSApplicabilityTarget() {
        this.targetTypeMap.put(EMtargetTypes.rac_database, OPlanRecognizedCRSApplicabilityTarget.rac);
        this.targetTypeMap.put(EMtargetTypes.cluster, OPlanRecognizedCRSApplicabilityTarget.crs);
        this.targetTypeMap.put(EMtargetTypes.oracle_database, OPlanRecognizedCRSApplicabilityTarget.sidb);
        this.targetTypeMap.put(EMtargetTypes.has, OPlanRecognizedCRSApplicabilityTarget.siha);
    }

    public String getDefaultApplicableTarget() {
        return OPlanRecognizedCRSApplicabilityTarget.rac.toString();
    }

    public List<String> makeOPlanRecognizedApplicableTargetsList(List<String> applicableTargets) throws PatchPackageException {
        if (applicableTargets != null && applicableTargets.size() > 0) {
            ArrayList<String> targets = new ArrayList<String>(applicableTargets.size());
            for (String target : applicableTargets) {
                try {
                    targets.add(OPlanRecognizedCRSApplicabilityTarget.valueOf(OPlanRecognizedCRSApplicabilityTarget.class, target).toString());
                }
                catch (IllegalArgumentException e) {
                    if (!this.targetTypeMap.containsKey(EMtargetTypes.valueOf(EMtargetTypes.class, (String)target))) continue;
                    targets.add(this.targetTypeMap.get(EMtargetTypes.valueOf(EMtargetTypes.class, (String)target)).toString());
                }
            }
            return targets;
        }
        return Collections.emptyList();
    }

    public String valueof(String targetType) {
        try {
            return OPlanRecognizedCRSApplicabilityTarget.valueOf(OPlanRecognizedCRSApplicabilityTarget.class, targetType).toString();
        }
        catch (IllegalArgumentException e) {
            throw new OPlanInternalException("the target type " + targetType + " is not recognized by oplan");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPlanRecognizedCRSApplicabilityTarget {
        rac,
        crs,
        sidb,
        siha;

    }
}

