/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import java.io.File;
import java.util.logging.Logger;

public class OPatchautoActionUtils {
    private static final Logger _logger = Logger.getLogger(OPatchautoActionUtils.class.getName());

    public static String[] findTmpRemoteImagePath(String homeLocation, String fileName) {
        String remoteImageLocation;
        String[] tempImageInfo = new String[2];
        if ((homeLocation = homeLocation.replace("\\", "/")).endsWith("/")) {
            homeLocation = homeLocation.substring(0, homeLocation.length() - 1);
        }
        String homeParent = homeLocation.substring(0, homeLocation.lastIndexOf("/"));
        String tmpHomeLocation = homeParent + File.separator + "opatchauto" + OPatchAutoHelper.getCurrentDateTimeStamp();
        String tempDirName = System.getProperty("remote.temp.dir.name", "opatchauto-tmp");
        String opatchAutoTmp = System.getProperty("remote.temp.dir.path", tmpHomeLocation + File.separator + tempDirName);
        tempImageInfo[0] = remoteImageLocation = opatchAutoTmp + File.separator + fileName;
        tempImageInfo[1] = tmpHomeLocation;
        return tempImageInfo;
    }

    public static boolean isFileExistInRemoteHost(RemoteConnectionHandler connectionHandler, String localImagePath, String remoteImagePath) throws RemoteConnectionException {
        boolean isFileExist = false;
        if (!StringUtil.isNullOrEmpty((String)remoteImagePath, (boolean)true) && !StringUtil.isNullOrEmpty((String)localImagePath, (boolean)true)) {
            long size;
            File localImage = new File(localImagePath);
            long localImageSize = localImage.length();
            if (connectionHandler.exists(remoteImagePath) && (size = connectionHandler.size(remoteImagePath)) == localImageSize) {
                isFileExist = true;
            }
        }
        _logger.info("Is File " + localImagePath + " exist in " + remoteImagePath + " on remote host " + connectionHandler.getHost() + ":" + isFileExist);
        return isFileExist;
    }

    public static void prepareRemoteLocationForFileTransfer(RemoteConnectionHandler connectionHandler, String remoteImagePath) throws RemoteConnectionException {
        if (connectionHandler.exists(remoteImagePath)) {
            connectionHandler.delete(remoteImagePath);
        } else {
            int index = remoteImagePath.replace("\\", "/").lastIndexOf("/");
            if (index > -1) {
                String parentDir = remoteImagePath.substring(0, index);
                if (!connectionHandler.exists(parentDir)) {
                    connectionHandler.mkdirs(parentDir);
                }
                if (!connectionHandler.isDirectory(parentDir)) {
                    throw new RemoteConnectionException(OPatchAutoHelper.getPublishedMessage((String)"70025", (Object[])new Object[]{connectionHandler.getHost().getHost(), parentDir}));
                }
            }
        }
    }
}

