/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSSignatureValue
extends XMLElement {
    public XSSignatureValue(Element element) throws DOMException {
        super(element);
    }

    public XSSignatureValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XSSignatureValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
    }

    public XSSignatureValue(Document owner, String id) throws DOMException {
        this(owner);
        if (id != null) {
            this.setId(id);
        }
    }

    public XSSignatureValue(Document owner, byte[] sigBytes) throws DOMException {
        this(owner);
        this.setSignatureBytes(sigBytes);
    }

    public XSSignatureValue(Document owner, byte[] sigBytes, String id) throws DOMException {
        this(owner);
        this.setSignatureBytes(sigBytes);
        if (id != null) {
            this.setId(id);
        }
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void setSignatureBytes(byte[] sigBytes) throws DOMException {
        NodeList nList = this.getChildNodes();
        for (int i = nList.getLength(); i > 0; --i) {
            Node n = nList.item(i - 1);
            if (n.getNodeType() != 3) continue;
            this.removeChild(n);
        }
        this.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(sigBytes)));
    }

    public byte[] getSignatureBytes() throws DOMException {
        byte[] sigBytes = null;
        String sbString = XMLUtils.collectText(this.getNode());
        if (sbString.length() != 0) {
            sigBytes = Base64.fromBase64(sbString);
        }
        return sigBytes;
    }

    public static byte[] fromDSA(byte[] dsaVal) {
        return XSSignatureValue.fromDSA(dsaVal, 20);
    }

    public static byte[] fromDSA(byte[] dsaVal, int size) {
        BigInteger r = null;
        BigInteger s = null;
        try {
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)new ByteArrayInputStream(dsaVal));
            r = ASN1Integer.inputValue((InputStream)sis);
            s = ASN1Integer.inputValue((InputStream)sis);
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        byte[] rb = XSSignatureValue.i2osp(r, size);
        byte[] sb = XSSignatureValue.i2osp(s, size);
        byte[] sigVal = new byte[size * 2];
        System.arraycopy(rb, 0, sigVal, 0, size);
        System.arraycopy(sb, 0, sigVal, size, size);
        return sigVal;
    }

    public static byte[] toDSA(byte[] sigVal) {
        int n = sigVal.length;
        BigInteger r = XSSignatureValue.os2ip(sigVal, 0, n / 2);
        BigInteger s = XSSignatureValue.os2ip(sigVal, n / 2, n / 2);
        ASN1Sequence dsaVal = new ASN1Sequence();
        dsaVal.addElement((ASN1Object)new ASN1Integer(r));
        dsaVal.addElement((ASN1Object)new ASN1Integer(s));
        return Utils.toBytes((Streamable)dsaVal);
    }

    private static byte[] i2osp(BigInteger x, int len) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException("Negative integer not allowed");
        }
        byte[] xb = Utils.toByteArray((BigInteger)x);
        if (xb.length > len) {
            throw new IllegalArgumentException("Integer too large");
        }
        if (xb.length == len) {
            return xb;
        }
        byte[] nb = new byte[len];
        System.arraycopy(xb, 0, nb, len - xb.length, xb.length);
        return nb;
    }

    private static BigInteger os2ip(byte[] b, int off, int len) {
        byte[] i = new byte[len];
        System.arraycopy(b, off, i, 0, len);
        return new BigInteger(1, i);
    }
}

