/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.EncryptOutputStream;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XEKeyInfo;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyValue;
import oracle.security.xmlsec.keys.RawX509Cert;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XEncUtils {
    private XEncUtils() {
    }

    public static XEEncryptedData encryptElement(Element inputElement, boolean contentOnly, String dataEncAlg, SecretKey dataEncKey, String dataEncKeyName) throws XEException {
        Document doc = inputElement.getOwnerDocument();
        String dataType = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
        XEEncryptedData ed = XEEncryptedData.newInstance(doc, null, dataType);
        XEEncryptionMethod em = ed.createEncryptionMethod(dataEncAlg);
        ed.setEncryptionMethod(em);
        if (dataEncKeyName != null) {
            XEKeyInfo ki = ed.createKeyInfo();
            ki.addKeyInfoData(ki.createKeyName(dataEncKeyName));
            ed.setKeyInfo(ki);
        }
        return XEEncryptedData.encryptAndReplace(inputElement, dataEncKey, ed);
    }

    public static XEEncryptedData encryptElement(Element inputElement, boolean contentOnly, String dataEncAlg, SecretKey dataEncKey, String keyEncAlg, Key keyEncKey, String keyEncKeyName) throws XEException {
        XEEncryptedData ed = XEncUtils.encryptElement(inputElement, contentOnly, dataEncAlg, dataEncKey, null);
        XEKeyInfo ki = ed.createKeyInfo();
        XEEncryptedKey ek = ki.createEncryptedKey();
        XEEncryptionMethod em = ek.createEncryptionMethod(keyEncAlg);
        if (keyEncAlg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            em.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        ek.setEncryptionMethod(em);
        ek.encryptKey(dataEncKey, keyEncKey, keyEncKeyName);
        ki.addKeyInfoData(ek);
        ed.setKeyInfo(ki);
        return ed;
    }

    public static XEEncryptedData encryptElement(Element inputElement, boolean contentOnly, String dataEncAlg, String keyEncAlg, Key keyEncKey, String keyEncKeyName, SecureRandom rbs) throws XEException {
        String alg;
        int keySize;
        if (dataEncAlg.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            keySize = 128;
            alg = "AES";
        } else if (dataEncAlg.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            keySize = 192;
            alg = "AES";
        } else if (dataEncAlg.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            keySize = 256;
            alg = "AES";
        } else if (dataEncAlg.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            keySize = 168;
            alg = "DESede";
        } else {
            throw new XECipherException("Unsupported data encryption algorithm " + dataEncAlg);
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(alg);
            if (rbs == null) {
                keyGen.init(keySize);
            } else {
                keyGen.init(keySize, rbs);
            }
            SecretKey dataEncKey = keyGen.generateKey();
            return XEncUtils.encryptElement(inputElement, contentOnly, dataEncAlg, dataEncKey, keyEncAlg, keyEncKey, keyEncKeyName);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException("JCE provider does not support this encryption algorithm", ex);
        }
    }

    public static Element decryptElement(Element encryptedData, Key key) throws XEException {
        XEEncryptedData ed = new XEEncryptedData(encryptedData);
        SecretKey dataDecKey = (SecretKey)XEncUtils.getDecryptionKey(ed.getKeyInfo(), ed.getEncryptionMethod(), key);
        return XEEncryptedData.decryptAndReplace(dataDecKey, encryptedData);
    }

    private static Key getDecryptionKey(XEKeyInfo ki, XEEncryptionMethod em, Key key) throws XEException {
        if (ki != null) {
            Key decKey;
            int i;
            int len;
            XEEncryptedKey ek = null;
            Vector eks = ki.getEncryptedKeys();
            if (eks.size() != 0) {
                ek = (XEEncryptedKey)eks.elementAt(0);
            } else {
                Vector rms = ki.getRetrievalMethods();
                len = rms.size();
                for (i = 0; i < len; ++i) {
                    KeyInfoData kid = (KeyInfoData)rms.elementAt(i);
                    try {
                        while ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(kid.getType())) {
                            kid = ((RetrievalMethod)kid).getKeyInfoData();
                        }
                    }
                    catch (ReferenceException ex) {
                        continue;
                    }
                    if (!"http://www.w3.org/2001/04/xmlenc#EncryptedKey".equals(kid.getType())) continue;
                    ek = (XEEncryptedKey)kid;
                    break;
                }
            }
            if (ek != null && (decKey = XEncUtils.getDecryptionKey(ek.getKeyInfo(), ek.getEncryptionMethod(), key)) != null) {
                return ek.getKey(em, decKey);
            }
            Vector ams = ki.getAgreementMethods();
            len = ams.size();
            for (i = 0; i < len; ++i) {
                PublicKey oPubKey;
                AgreementMethod am;
                block23: {
                    am = (AgreementMethod)ams.elementAt(i);
                    oPubKey = null;
                    OriginatorKeyInfo oki = am.getOriginatorKeyInfo();
                    if (oki != null) {
                        try {
                            Vector oCerts;
                            int j;
                            int n;
                            Vector kvs = oki.getKeyValues();
                            if (kvs.size() > 0) {
                                oPubKey = ((KeyValue)kvs.elementAt(0)).getPublicKey();
                            }
                            if (oPubKey == null) {
                                Vector ocds = oki.getX509Data();
                                n = ocds.size();
                                for (j = 0; j < n; ++j) {
                                    X509Data ocd = (X509Data)ocds.elementAt(i);
                                    oCerts = ocd.getCertificates();
                                    if (oCerts.size() <= 0) continue;
                                    oPubKey = ((X509Certificate)oCerts.elementAt(0)).getPublicKey();
                                    break;
                                }
                            }
                            if (oPubKey != null) break block23;
                            Vector orms = oki.getRetrievalMethods();
                            n = orms.size();
                            for (j = 0; j < n; ++j) {
                                KeyInfoData okid = (KeyInfoData)orms.elementAt(i);
                                try {
                                    while ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(okid.getType())) {
                                        okid = ((RetrievalMethod)okid).getKeyInfoData();
                                    }
                                }
                                catch (ReferenceException ex) {
                                    continue;
                                }
                                if ("http://www.w3.org/2001/04/xmlenc#DHKeyValue".equals(okid.getType())) {
                                    oPubKey = ((KeyValue)okid).getPublicKey();
                                } else if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(okid.getType())) {
                                    oCerts = ((X509Data)okid).getCertificates();
                                    if (oCerts.size() <= 0) continue;
                                    oPubKey = ((X509Certificate)oCerts.elementAt(0)).getPublicKey();
                                } else {
                                    if (!"http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(okid.getType())) continue;
                                    oPubKey = ((RawX509Cert)okid).getCertificate().getPublicKey();
                                }
                                break;
                            }
                        }
                        catch (IOException iex) {
                            throw new XEException(iex);
                        }
                    }
                }
                if (oPubKey == null || !(key instanceof PrivateKey)) continue;
                byte[] km = am.generateKeyMaterial(em, (PrivateKey)key, oPubKey);
                return new SecretKeySpec(km, em.getJCEKeyAlgorithm());
            }
        }
        return key;
    }

    public static OutputStream encryptBytes(XEEncryptedData ed, String dataEncAlg, SecretKey dataEncKey, String dataEncKeyName, String keyEncAlg, PublicKey keyEncKey, String keyEncKeyName) throws XEException, IOException {
        XEEncryptionMethod em = ed.createEncryptionMethod(dataEncAlg);
        ed.setEncryptionMethod(em);
        XEKeyInfo ki = ed.createKeyInfo();
        ed.setKeyInfo(ki);
        if (dataEncKeyName != null) {
            ki.addKeyInfoData(ki.createKeyName(dataEncKeyName));
        }
        XEEncryptedKey ek = ki.createEncryptedKey();
        ki.addKeyInfoData(ek);
        XEEncryptionMethod emk = ek.createEncryptionMethod(keyEncAlg);
        if (keyEncAlg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            emk.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        ek.setEncryptionMethod(emk);
        if (keyEncKeyName != null) {
            XEKeyInfo kki = ek.createKeyInfo();
            kki.addKeyInfoData(kki.createKeyName(keyEncKeyName));
            ek.setKeyInfo(kki);
        }
        ek.encryptKey(dataEncKey, keyEncKey, keyEncKeyName);
        XECipherData cipherData = ed.createCipherData();
        ed.setCipherData(cipherData);
        OutputStream os = cipherData.setCipherValueAsStream();
        EncryptOutputStream encOs = ed.createEncryptOutputStream(dataEncKey, null, os);
        return encOs;
    }

    public static InputStream decryptBytes(XEEncryptedData ed, PrivateKey keyDecKey) throws XEException {
        XEEncryptedKey ek = (XEEncryptedKey)ed.getKeyInfo().getEncryptedKeys().get(0);
        SecretKey dataDecKey = ek.getKey(ed.getEncryptionMethod(), keyDecKey);
        return ed.decryptToStream(dataDecKey);
    }
}

