/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.PBEKeySpec;
import oracle.security.xmlsec.keys.DHKeyValue;
import oracle.security.xmlsec.keys.DSAKeyValue;
import oracle.security.xmlsec.keys.ECKeyValue;
import oracle.security.xmlsec.keys.GenericKeyInfo;
import oracle.security.xmlsec.keys.GenericKeyValue;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.KeyValue;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.keys.MgmtData;
import oracle.security.xmlsec.keys.PGPData;
import oracle.security.xmlsec.keys.RSAKeyValue;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.SPKIData;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyUtils {
    public static KeyInfoData createKeyInfoData(Element element) {
        return KeyUtils.createKeyInfoData(element, null);
    }

    public static KeyInfoData createKeyInfoData(Element element, String systemId) {
        XMLElement result = KeyUtils.createInstance(element, systemId);
        if (result == null) {
            result = new GenericKeyInfo(element, systemId);
        }
        return (KeyInfoData)((Object)result);
    }

    public static KeyName createKeyName(Document owner) {
        return new KeyName(owner);
    }

    public static MgmtData createMgmtData(Document owner) {
        return new MgmtData(owner);
    }

    public static PGPData createPGPData(Document owner) {
        return new PGPData(owner);
    }

    public static SPKIData createSPKIData(Document owner) {
        return new SPKIData(owner);
    }

    public static X509Data createX509Data(Document owner) {
        return new X509Data(owner);
    }

    public static RetrievalMethod createRetrievalMethod(Document owner) {
        return new RetrievalMethod(owner);
    }

    public static KeyValue createKeyValue(Document owner) {
        return new KeyValue(owner);
    }

    public static KeyValue createKeyValue(Document owner, PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            return new KeyValue(owner, new RSAKeyValue(owner, (RSAPublicKey)publicKey));
        }
        if (publicKey instanceof DSAPublicKey) {
            return new KeyValue(owner, new DSAKeyValue(owner, (DSAPublicKey)publicKey));
        }
        if (publicKey instanceof DHPublicKey) {
            return new KeyValue(owner, new DHKeyValue(owner, (DHPublicKey)publicKey));
        }
        if (publicKey instanceof ECPublicKey) {
            return new KeyValue(owner, new ECKeyValue(owner, (ECPublicKey)publicKey));
        }
        throw new InvalidKeyException("Unsupported public key algorithm " + publicKey.getAlgorithm());
    }

    public static KeyValueData createKeyValueData(Element element) {
        return KeyUtils.createKeyValueData(element, null);
    }

    public static KeyValueData createKeyValueData(Element element, String systemId) {
        XMLElement result = KeyUtils.createInstance(element, systemId);
        if (result == null) {
            result = new GenericKeyValue(element, systemId);
        }
        return (KeyValueData)((Object)result);
    }

    private static XMLElement createInstance(Element element, String systemId) {
        XMLElement result = null;
        try {
            String xsiType = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String xsiLocal = null;
            String xsiNS = null;
            if (xsiType != null && xsiType.length() > 0) {
                xsiLocal = QName.getLocalPart(xsiType);
                xsiNS = QName.resolvePrefix(xsiType, element);
            }
            String nodeName = element.getNodeName();
            String tagLocal = element.getLocalName();
            String tagNS = element.getNamespaceURI();
            TagManager tagMgr = TagManager.getTagManager();
            Class<? extends XMLElement> c = null;
            if (xsiNS != null && xsiLocal != null) {
                c = tagMgr.getClassForTag(xsiNS, xsiLocal);
            }
            if (c == null && tagNS != null && tagLocal != null) {
                c = tagMgr.getClassForTag(tagNS, tagLocal);
            }
            if (c != null) {
                Constructor<? extends XMLElement> x = null;
                try {
                    x = c.getConstructor(Element.class, String.class);
                    result = x.newInstance(element, systemId);
                }
                catch (NoSuchMethodException ex) {
                    x = c.getConstructor(Element.class);
                    result = x.newInstance(element);
                    result.setSystemId(systemId);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result;
    }

    public static SecretKey generatePBKDF2BasedKey(char[] password, String salt, int iteration, int keySize) {
        try {
            SecretKeyFactory scf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] saltBytes = null;
            if (salt == null) {
                throw new IllegalArgumentException("The salt parameter must be non-null");
            }
            saltBytes = salt.getBytes("UTF-8");
            PBEKeySpec pbe = new PBEKeySpec(password, saltBytes, iteration, keySize);
            return scf.generateSecret(pbe);
        }
        catch (InvalidKeySpecException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (NoSuchAlgorithmException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
    }
}

