/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.UnixOperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.ToDoubleFunction;
import jdk.internal.platform.Container;
import jdk.internal.platform.Metrics;
import sun.management.BaseOperatingSystemImpl;
import sun.management.VMManagement;

class OperatingSystemImpl
extends BaseOperatingSystemImpl
implements UnixOperatingSystemMXBean {
    private static final int MAX_ATTEMPTS_NUMBER = 10;
    private final Metrics containerMetrics;
    private ContainerCpuTicks systemLoadTicks = new SystemCpuTicks();
    private ContainerCpuTicks processLoadTicks = new ProcessCpuTicks();

    OperatingSystemImpl(VMManagement vMManagement) {
        super(vMManagement);
        this.containerMetrics = Container.metrics();
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        return this.getCommittedVirtualMemorySize0();
    }

    @Override
    public long getTotalSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getMemoryAndSwapLimit();
            long l2 = this.containerMetrics.getMemoryLimit();
            if (l >= 0L && l2 >= 0L) {
                return l - l2;
            }
        }
        return this.getTotalSwapSpaceSize0();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getMemoryAndSwapLimit();
            long l2 = this.containerMetrics.getMemoryLimit();
            if (l >= 0L && l2 >= 0L) {
                long l3 = l - l2;
                if (l3 <= 0L) {
                    return 0L;
                }
                for (int i = 0; i < 10; ++i) {
                    long l4;
                    long l5;
                    long l6 = this.containerMetrics.getMemoryAndSwapUsage();
                    long l7 = this.containerMetrics.getMemoryUsage();
                    if (l6 <= 0L || l7 <= 0L || (l5 = l6 - l7) < 0L || (l4 = l3 - l5) < 0L) continue;
                    return l4;
                }
            }
        }
        return this.getFreeSwapSpaceSize0();
    }

    @Override
    public long getProcessCpuTime() {
        return this.getProcessCpuTime0();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        if (this.containerMetrics != null) {
            long l = this.containerMetrics.getMemoryUsage();
            long l2 = this.containerMetrics.getMemoryLimit();
            if (l > 0L && l2 >= 0L) {
                return l2 - l;
            }
        }
        return this.getFreePhysicalMemorySize0();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        long l;
        if (this.containerMetrics != null && (l = this.containerMetrics.getMemoryLimit()) >= 0L) {
            return l;
        }
        return this.getTotalPhysicalMemorySize0();
    }

    @Override
    public long getOpenFileDescriptorCount() {
        return this.getOpenFileDescriptorCount0();
    }

    @Override
    public long getMaxFileDescriptorCount() {
        return this.getMaxFileDescriptorCount0();
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.containerMetrics != null) {
            return this.systemLoadTicks.getContainerCpuLoad();
        }
        return this.getSystemCpuLoad0();
    }

    @Override
    public double getProcessCpuLoad() {
        if (this.containerMetrics != null) {
            return this.processLoadTicks.getContainerCpuLoad();
        }
        return this.getProcessCpuLoad0();
    }

    private boolean isCpuSetSameAsHostCpuSet() {
        if (this.containerMetrics != null && this.containerMetrics.getCpuSetCpus() != null) {
            return this.containerMetrics.getCpuSetCpus().length == this.getHostOnlineCpuCount0();
        }
        return false;
    }

    private native long getCommittedVirtualMemorySize0();

    private native long getFreePhysicalMemorySize0();

    private native long getFreeSwapSpaceSize0();

    private native long getMaxFileDescriptorCount0();

    private native long getOpenFileDescriptorCount0();

    private native long getProcessCpuTime0();

    private native double getProcessCpuLoad0();

    private native double getSystemCpuLoad0();

    private native long getTotalPhysicalMemorySize0();

    private native long getTotalSwapSpaceSize0();

    private native double getSingleCpuLoad0(int var1);

    private native int getHostConfiguredCpuCount0();

    private native int getHostOnlineCpuCount0();

    private native long getHostTotalCpuTicks0();

    private static native void initialize();

    static {
        OperatingSystemImpl.initialize();
    }

    private class SystemCpuTicks
    extends ContainerCpuTicks {
        private SystemCpuTicks() {
        }

        @Override
        protected DoubleSupplier defaultCpuLoadSupplier() {
            return () -> OperatingSystemImpl.this.getSystemCpuLoad0();
        }

        @Override
        protected ToDoubleFunction<int[]> cpuSetCalc() {
            return nArray -> {
                double d = 0.0;
                for (int n : nArray) {
                    double d2 = OperatingSystemImpl.this.getSingleCpuLoad0(n);
                    if (d2 < 0.0) {
                        return -1.0;
                    }
                    d += d2;
                }
                return d / (double)((int[])nArray).length;
            };
        }

        @Override
        protected LongSupplier cpuUsageSupplier() {
            return () -> OperatingSystemImpl.this.containerMetrics.getCpuUsage();
        }
    }

    private class ProcessCpuTicks
    extends ContainerCpuTicks {
        private ProcessCpuTicks() {
        }

        @Override
        protected DoubleSupplier defaultCpuLoadSupplier() {
            return () -> OperatingSystemImpl.this.getProcessCpuLoad0();
        }

        @Override
        protected ToDoubleFunction<int[]> cpuSetCalc() {
            return nArray -> {
                int n = OperatingSystemImpl.this.getHostOnlineCpuCount0();
                int n2 = OperatingSystemImpl.this.getAvailableProcessors();
                return Math.min(1.0, OperatingSystemImpl.this.getProcessCpuLoad0() * (double)n / (double)n2);
            };
        }

        @Override
        protected LongSupplier cpuUsageSupplier() {
            return () -> OperatingSystemImpl.this.getProcessCpuTime();
        }
    }

    private abstract class ContainerCpuTicks {
        private volatile long usageTicks;
        private volatile long totalTicks;

        private ContainerCpuTicks() {
        }

        private double getUsageDividesTotal(long l, long l2) {
            if (l < 0L || l2 <= 0L) {
                return -1.0;
            }
            long l3 = l - this.usageTicks;
            this.usageTicks = l;
            long l4 = l2 - this.totalTicks;
            this.totalTicks = l2;
            double d = 0.0;
            if (l3 > 0L && l4 > 0L) {
                d = (double)l3 / (double)l4;
            }
            d = Math.max(0.0, d);
            d = Math.min(1.0, d);
            return d;
        }

        public double getContainerCpuLoad() {
            assert (OperatingSystemImpl.this.containerMetrics != null);
            long l = OperatingSystemImpl.this.containerMetrics.getCpuQuota();
            long l2 = OperatingSystemImpl.this.containerMetrics.getCpuShares();
            if (l > 0L) {
                long l3 = OperatingSystemImpl.this.containerMetrics.getCpuNumPeriods();
                long l4 = TimeUnit.MICROSECONDS.toNanos(l * l3);
                return this.getUsageDividesTotal(this.cpuUsageSupplier().getAsLong(), l4);
            }
            if (l2 > 0L) {
                long l5 = OperatingSystemImpl.this.getHostTotalCpuTicks0();
                int n = OperatingSystemImpl.this.getHostOnlineCpuCount0();
                int n2 = OperatingSystemImpl.this.getAvailableProcessors();
                l5 = l5 * (long)n2 / (long)n;
                return this.getUsageDividesTotal(this.cpuUsageSupplier().getAsLong(), l5);
            }
            if (OperatingSystemImpl.this.isCpuSetSameAsHostCpuSet()) {
                return this.defaultCpuLoadSupplier().getAsDouble();
            }
            int[] nArray = OperatingSystemImpl.this.containerMetrics.getEffectiveCpuSetCpus();
            if (nArray == null || nArray.length <= 0) {
                nArray = OperatingSystemImpl.this.containerMetrics.getCpuSetCpus();
            }
            if (nArray == null) {
                return this.defaultCpuLoadSupplier().getAsDouble();
            }
            if (nArray.length > 0) {
                return this.cpuSetCalc().applyAsDouble(nArray);
            }
            return -1.0;
        }

        protected abstract DoubleSupplier defaultCpuLoadSupplier();

        protected abstract ToDoubleFunction<int[]> cpuSetCalc();

        protected abstract LongSupplier cpuUsageSupplier();
    }
}

