/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioDeleteOnExitHook;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.net.URLStreamHandlerFactory;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class NioClassLoaderService {
    public static final String DEFAULT_CLASSLOADER_KEY = "DEFAULT";
    private static NioClassLoaderService _instance;
    private static final Logger _log;
    private Map<String, ClassLoader> _classLoaderCache = new HashMap<String, ClassLoader>();
    private List<Path> _extractedPaths = new ArrayList<Path>();

    public static synchronized NioClassLoaderService getInstance() {
        if (_instance == null) {
            _instance = new NioClassLoaderService();
        }
        return _instance;
    }

    private NioClassLoaderService() {
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader((URL[])null);
    }

    public ClassLoader getClassLoader(String key) {
        return this.getClassLoader(key, (URL[])null);
    }

    public ClassLoader getClassLoader(URL url) {
        URL[] uRLArray;
        if (url != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        } else {
            uRLArray = null;
        }
        return this.getClassLoader(uRLArray);
    }

    public ClassLoader getClassLoader(String key, URL url) {
        URL[] uRLArray;
        if (url != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        } else {
            uRLArray = null;
        }
        return this.getClassLoader(key, uRLArray);
    }

    public synchronized ClassLoader getClassLoader(URL[] urls) {
        return this.getClassLoader(DEFAULT_CLASSLOADER_KEY, urls);
    }

    public synchronized ClassLoader getClassLoader(String key, URL[] urls) {
        return this.getClassLoader(key, urls, NioClassLoaderService.class.getClassLoader());
    }

    public synchronized ClassLoader getClassLoader(String key, URL[] urls, ClassLoader parentClassLoader) {
        ClassLoader classLoader = this.getCachedClassLoader(key);
        if (classLoader == null) {
            UpdateableURLClassLoader cl = new UpdateableURLClassLoader(new URL[0], parentClassLoader);
            this.setCacheClassLoader(key, cl);
            if (urls != null && urls.length > 0) {
                cl.addURLs(urls);
            }
            classLoader = cl;
        } else if (urls != null && urls.length > 0 && classLoader instanceof UpdateableURLClassLoader) {
            ((UpdateableURLClassLoader)classLoader).addURLs(urls);
        }
        return classLoader;
    }

    public void clearCachedClassLoader() {
        this.clearCachedClassLoader(DEFAULT_CLASSLOADER_KEY);
    }

    public void clearCachedClassLoader(String key) {
        this._classLoaderCache.remove(key);
    }

    public boolean hasClassLoader(String key) {
        return this._classLoaderCache.containsKey(key);
    }

    public ClassLoader getCachedClassLoader(String key) {
        return this._classLoaderCache.get(key);
    }

    public void setCacheClassLoader(String key, ClassLoader classLoader) {
        this._classLoaderCache.put(key, classLoader);
    }

    public boolean isClassLoaded(String className) {
        return this.isClassLoaded(className, this.getClassLoader());
    }

    public boolean isClassLoaded(String key, String className) {
        return this.isClassLoaded(className, this.getClassLoader(key));
    }

    public boolean isClassLoaded(String className, ClassLoader classloader) {
        if (className != null && classloader != null) {
            try {
                classloader.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public URL getLatestJar(List<URL> modules) {
        URL latestJar = null;
        if (modules != null && modules.size() > 0) {
            Version latestVersion = null;
            for (URL url : modules) {
                String version = this.getModuleVersion(url.getFile());
                if (version == null || version.trim().length() <= 0) continue;
                try {
                    Version v = new Version(version);
                    if (latestJar != null && v.compareTo(latestVersion) <= 0) continue;
                    latestJar = url;
                    latestVersion = v;
                }
                catch (Exception e) {
                    _log.fine("Unable to parse version from gpr jar " + url);
                }
            }
        }
        return latestJar;
    }

    public String getModuleVersion(String name) {
        if (name != null && name.length() > 0) {
            int index1 = name.lastIndexOf(95) + 1;
            int index2 = name.lastIndexOf(46);
            if (index1 > 0 && index2 > index1) {
                return name.substring(index1, index2);
            }
        }
        return null;
    }

    public List<URL> getModuleJars(Path dir, String modulePrefix) throws MalformedURLException {
        return this.getModuleJars(dir, modulePrefix, (Class)null);
    }

    public List<URL> getModuleJars(Path dir, String modulePrefix, Class locatorClazz) throws MalformedURLException {
        return this.getModuleJars(DEFAULT_CLASSLOADER_KEY, dir, modulePrefix, null, locatorClazz);
    }

    public List<URL> getModuleJars(Path dir, String modulePrefix, String version) throws MalformedURLException {
        return this.getModuleJars(DEFAULT_CLASSLOADER_KEY, dir, modulePrefix, version);
    }

    public List<URL> getModuleJars(String key, Path dir, String modulePrefix, String version) throws MalformedURLException {
        return this.getModuleJars(key, dir, modulePrefix, version, null);
    }

    public List<URL> getModuleJars(String key, Path dir, final String modulePrefix, final String version, Class locatorClazz) throws MalformedURLException {
        DirectoryStream.Filter<Path> filter;
        ArrayList<URL> modules;
        block16: {
            Path myself;
            modules = new ArrayList<URL>();
            filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    String name = entry.getFileName().toString();
                    if (version != null) {
                        return name.startsWith(modulePrefix + version) && name.endsWith(".jar");
                    }
                    return name.startsWith(modulePrefix) && name.endsWith(".jar");
                }
            };
            Path userDir = NioHelper.getInstance().getPath(System.getProperty("user.dir"), new String[0]);
            Path path = myself = locatorClazz == null ? this.determineMyself(this.getClassLoader(key)) : this.locateClass(locatorClazz, this.getClassLoader(key, null, locatorClazz.getClassLoader()));
            if (myself != null && !Files.isDirectory(myself, new LinkOption[0]) && Files.exists(myself, new LinkOption[0]) && !userDir.equals(myself.getParent())) {
                this.addMatchingModulesToList(myself.getParent(), filter, modules);
            }
            if (Files.isDirectory(userDir, new LinkOption[0])) {
                this.addMatchingModulesToList(userDir, filter, modules);
            }
            if (myself != null && Files.isRegularFile(myself, new LinkOption[0]) && !myself.getFileName().toString().toLowerCase().endsWith(".class")) {
                try {
                    LogManager manager = LogManager.getLogManager();
                    Logger logger = manager.getLogger("");
                    Level level = logger.getLevel();
                    logger.setLevel(Level.WARNING);
                    FileSystem fs = FileSystems.newFileSystem(NioHelper.getInstance().getInternalPath(myself), null);
                    logger.setLevel(level);
                    Path path2 = fs.getPath("/", new String[0]);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(path2, (DirectoryStream.Filter<? super Path>)filter);){
                        for (Path p : stream) {
                            URL url = new URL("jar:" + myself.toUri().toURL() + "!/" + p);
                            modules.add(url);
                        }
                    }
                    catch (IOException e) {
                        if (_log.isLoggable(Level.FINE)) {
                            _log.log(Level.FINE, "Error accessing " + path2, e);
                        }
                    }
                }
                catch (IOException e) {
                    if (!_log.isLoggable(Level.FINE)) break block16;
                    _log.log(Level.FINE, "Error accessing myself " + myself, e);
                }
            }
        }
        if (dir != null && Files.isDirectory(dir, new LinkOption[0])) {
            this.addMatchingModulesToList(dir, filter, modules);
        }
        return modules;
    }

    private void addMatchingModulesToList(Path path, DirectoryStream.Filter<Path> filter, List<URL> modules) throws MalformedURLException {
        block9: {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, filter);){
                for (Path p : stream) {
                    URL url = p.toUri().toURL();
                    if (modules.contains(url)) continue;
                    modules.add(url);
                }
            }
            catch (IOException e) {
                if (!_log.isLoggable(Level.FINE)) break block9;
                _log.log(Level.FINE, "Error accessing " + path, e);
            }
        }
    }

    private Path determineMyself(ClassLoader classloader) {
        return this.locateClass(NioClassLoaderService.class, classloader);
    }

    public Path locateClass(Class clazz) {
        return this.locateClass(clazz, this.getClassLoader());
    }

    public Path locateClass(String key, Class clazz) {
        return this.locateClass(clazz, this.getClassLoader(key));
    }

    public Path locateClass(Class clazz, ClassLoader classloader) {
        if (clazz != null) {
            return this.locateClass(clazz.getName(), classloader);
        }
        return null;
    }

    public Path locateClass(String className) {
        return this.locateClass(className, this.getClassLoader());
    }

    public Path locateClass(String key, String className) {
        return this.locateClass(className, this.getClassLoader(key));
    }

    public Path locateClass(String className, ClassLoader classloader) {
        block13: {
            if (className != null && classloader != null) {
                String fileFC = null;
                try {
                    URL classResource = classloader.getResource(className.endsWith(".class") ? className : className.replace('.', '/') + ".class");
                    if (classResource != null) {
                        String fileComponent;
                        fileFC = fileComponent = classResource.getFile();
                        if (classResource.getProtocol().equals("file")) {
                            return NioHelper.getInstance().getPath(classResource.toURI());
                        }
                        if (classResource.getProtocol().equals("jar")) {
                            int classSeparatorIndex = fileComponent.lastIndexOf("!");
                            if (classSeparatorIndex != -1) {
                                fileComponent = fileComponent.substring(0, classSeparatorIndex);
                            }
                            fileFC = fileComponent = fileComponent.replaceAll("\\+", "%2B");
                            if (!fileComponent.startsWith("file:")) {
                                fileComponent = "file:" + fileComponent;
                            }
                            URL u = new URL(fileComponent);
                            return Paths.get(u.toURI());
                        }
                    } else if (_log.isLoggable(Level.FINE)) {
                        _log.fine("Unable to locate class " + className);
                    }
                }
                catch (MalformedURLException | URISyntaxException e) {
                    if (_log.isLoggable(Level.FINE)) {
                        _log.fine(e.getMessage());
                    }
                    try {
                        return NioHelper.getInstance().getPath(new URI(URLDecoder.decode(fileFC, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException | URISyntaxException e1) {
                        if (!_log.isLoggable(Level.FINE)) break block13;
                        _log.fine(StringUtil.getStackTrace((Throwable)e1));
                        _log.fine(e1.getMessage());
                    }
                }
            }
        }
        return null;
    }

    private URL extractNestedJar(URL jarUrl) {
        URL newUrl;
        block17: {
            Path path;
            String url = jarUrl.toString();
            if (!url.startsWith("jar:")) {
                return jarUrl;
            }
            url = url.substring(4);
            int index = url.indexOf("!/");
            if (index <= -1) {
                return jarUrl;
            }
            String nestedJar = url.substring(index + 2);
            url = url.substring(0, index);
            try {
                path = NioHelper.getInstance().getPath(new URI(url));
            }
            catch (URISyntaxException e) {
                if (_log.isLoggable(Level.WARNING)) {
                    _log.log(Level.WARNING, "Error creating URI.", e);
                }
                if (url.startsWith("file:")) {
                    url = url.substring(5);
                }
                path = NioHelper.getInstance().getPath(url, new String[0]);
            }
            newUrl = null;
            try (FileSystem fs = FileSystems.newFileSystem(NioHelper.getInstance().getInternalPath(path), null);){
                Path dir;
                Path dest;
                Path nestedJarPath = fs.getPath(nestedJar, new String[0]);
                String extractDir = System.getProperty("SelfExtractionTask.temp.directory");
                if (extractDir == null || extractDir.length() < 1) {
                    extractDir = System.getProperty("java.io.tmpdir");
                }
                if (Files.exists(dest = (dir = NioHelper.getInstance().getPath(extractDir, new String[0])).resolve(nestedJar), new LinkOption[0]) && !this._extractedPaths.contains(dest)) {
                    Files.delete(dest);
                }
                if (!Files.exists(dest, new LinkOption[0])) {
                    Files.createDirectory(dest.getParent(), new FileAttribute[0]);
                    Files.copy(nestedJarPath, dest, new CopyOption[0]);
                    NioDeleteOnExitHook.add(dest);
                    this._extractedPaths.add(dest);
                }
                newUrl = dest.toUri().toURL();
            }
            catch (IOException e) {
                if (!_log.isLoggable(Level.WARNING)) break block17;
                _log.log(Level.WARNING, "Error extracting nexted jar!", e);
            }
        }
        return newUrl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._classLoaderCache != null && !this._classLoaderCache.isEmpty()) {
            this._classLoaderCache.clear();
        }
        if (this._extractedPaths != null) {
            for (Path f : this._extractedPaths) {
                if (f == null || !Files.exists(f, new LinkOption[0])) continue;
                try {
                    Files.delete(f);
                }
                catch (IOException e) {
                    NioDeleteOnExitHook.add(f);
                }
            }
        }
    }

    static {
        _log = Logger.getLogger(NioClassLoaderService.class.getName());
    }

    private class UpdateableURLClassLoader
    extends URLClassLoader {
        public UpdateableURLClassLoader(URL[] urls) {
            super(urls);
        }

        public UpdateableURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public UpdateableURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        @Override
        public void addURL(URL url) {
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Adding url to classpath " + url);
            }
            if (url != null) {
                if ("jar".equals(url.getProtocol())) {
                    URL newUrl = NioClassLoaderService.this.extractNestedJar(url);
                    if (newUrl != null) {
                        super.addURL(newUrl);
                    }
                } else {
                    super.addURL(url);
                }
            }
        }

        public void addURLs(URL[] urls) {
            if (urls != null) {
                for (URL url : urls) {
                    if (url == null) continue;
                    this.addURL(url);
                }
            }
        }
    }
}

