/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.enums;

import com.oracle.cie.nextgen.common.NLS;

public enum ValueSourceType {
    API(6, 1, "ValueSourceType_API"),
    CMD(0, 2, "ValueSourceType_CMD"),
    RSP(1, 3, "ValueSourceType_RSP"),
    PARENT(5, 4, "ValueSourceType_PARENT"),
    CLONE(7, 5, "ValueSourceType_CLONE"),
    CALC(4, 6, "ValueSourceType_CALC"),
    CODEBLOCK(2, 7, "ValueSourceType_CODEBLOCK"),
    DEFAULT(3, 8, "ValueSourceType_DEFAULT");

    private int value;
    private int priority;
    private String i18NKey;

    private ValueSourceType(int value, int priority, String i18NKey) {
        this.value = value;
        this.priority = priority;
        this.i18NKey = i18NKey;
    }

    public int getValue() {
        return this.value;
    }

    public String getI18NKey() {
        return this.i18NKey;
    }

    public String getI18NText() {
        return NLS.getString(this.getI18NKey());
    }

    public static ValueSourceType getEnum(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        return Enum.valueOf(ValueSourceType.class, str);
    }

    public static ValueSourceType getEnum(int value) {
        for (ValueSourceType type : ValueSourceType.values()) {
            if (type.value != value) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name();
    }

    public boolean externalSource() {
        return this == API || this == CMD || this == RSP;
    }

    public boolean canSet(ValueSourceType existingType) {
        if (existingType == null) {
            return true;
        }
        return this.priority < existingType.priority;
    }
}

