/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.utils.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OUIInputs {
    public static final String IGNORE_INVALID_ARGS = "ignoreInvalidArgs";
    protected static final String TRUE = Boolean.TRUE.toString();
    protected static final String HELP = "help";
    protected static final String OUI_OPTION_PREFIX = "oracle.installer.";
    protected static final String SRVM_OPTION_PREFIX = "oracle.srvm.";
    protected boolean ignoreInvalidArgs = false;
    protected Set<String> _passedInputs;
    protected Set<String> _valueMissing;
    protected Set<String> _invalidValues;
    protected Set<String> _invalidInputs;
    protected Set<String> _invalidDistinctInputs;
    protected Map<String, String> _invalidDependentInputs;
    private Set<String> _errMsgs;
    protected boolean isCaseSensitive = false;
    protected Map<String, String> caseMapping;

    public Set<String> getErrorMessages() {
        return this._errMsgs;
    }

    protected void addErrorMsg(String msg) {
        this.getErrorMessages().add(msg);
    }

    protected void addInvalidMsg(String invalidInputKey, String valueMissingKey, String invalidValueKey) {
        if (!Util.isEmpty(this._invalidInputs) && !this.ignoreInvalidArgs) {
            this.addErrorMsg(NLS.getMsg(invalidInputKey, Util.getString(this._invalidInputs)));
        }
        if (!Util.isEmpty(this._valueMissing)) {
            this.addErrorMsg(NLS.getMsg("options.value.missing", Util.getString(this._valueMissing)));
        }
        if (!Util.isEmpty(this._invalidValues)) {
            this.addErrorMsg(NLS.getMsg("options.invalid.value", Util.getString(this._invalidValues)));
        }
    }

    protected void clearError() {
        this._invalidDistinctInputs = new HashSet<String>();
        this._invalidDependentInputs = new HashMap<String, String>();
        this._invalidInputs = new HashSet<String>();
        this._valueMissing = new HashSet<String>();
        this._invalidValues = new HashSet<String>();
        this._errMsgs = new HashSet<String>();
    }

    protected void addCaseMap(Set<String> set) {
        for (String key : set) {
            this.addCaseMap(key);
        }
    }

    protected void addCaseMap(String str) {
        if (this.caseMapping == null) {
            this.caseMapping = new HashMap<String, String>();
        }
        this.caseMapping.put(str.toLowerCase(), str);
    }

    protected Set<String> getDeclaredKeys(Set<String> keys) {
        if (this.caseMapping == null) {
            return keys;
        }
        HashSet<String> retVal = new HashSet<String>(keys.size());
        for (String key : keys) {
            retVal.add(this.getDeclaredKey(key));
        }
        return retVal;
    }

    protected String getDeclaredKey(String key) {
        if (this.caseMapping == null || !this.caseMapping.containsKey(key.toLowerCase())) {
            return key;
        }
        return this.caseMapping.get(key.toLowerCase());
    }
}

