/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.utils;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioJdkHelper;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class UtilityOps {
    private static final Logger _logger = Logger.getLogger(UtilityOps.class.getName());
    private static Long _storedSessionTimeStamp = null;
    private static Long _storedLibrariesTimeStamp = null;
    private static Pattern _validPathPattern = Pattern.compile("^[\\w\\.\\-][ \\w\\.\\-]*$");

    public static String getSessionTimeStamp() {
        String timestamp = System.getProperty("oracle.installer.timestamp");
        if (StringUtil.isNullOrEmpty((String)timestamp)) {
            timestamp = UtilityOps.getTimeStamp();
        }
        return timestamp;
    }

    public static synchronized long getStoredSessionTimeStamp() {
        if (_storedSessionTimeStamp == null) {
            Date date = null;
            String timestamp = System.getProperty("oracle.installer.timestamp");
            if (!StringUtil.isNullOrEmpty((String)timestamp, (boolean)true)) {
                SimpleDateFormat source = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ssa", Locale.ENGLISH);
                try {
                    date = source.parse(timestamp);
                }
                catch (ParseException e) {
                    _logger.log(Level.WARNING, "Failed to parse session time stamp: \"" + timestamp + "\", using current time.", e);
                }
            }
            if (date == null) {
                date = new Date();
            }
            _storedSessionTimeStamp = date.getTime();
        }
        return _storedSessionTimeStamp;
    }

    public static synchronized long getLibrariesTimeStamp() {
        if (_storedLibrariesTimeStamp == null) {
            Date date = null;
            String timestamp = System.getProperty("oracle.installer.libraries.timestamp", System.getProperty("oracle.installer.timestamp"));
            _logger.info("Attempting to set up libraries timestamps with given value: " + timestamp);
            if (!StringUtil.isNullOrEmpty((String)timestamp, (boolean)true)) {
                SimpleDateFormat source = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ssa", Locale.ENGLISH);
                try {
                    date = source.parse(timestamp);
                }
                catch (ParseException e) {
                    try {
                        Instant instant = Instant.parse(timestamp);
                        date = Date.from(instant);
                    }
                    catch (DateTimeParseException ex) {
                        _logger.log(Level.WARNING, "Failed to parse libraries time stamp: \"" + timestamp + "\", using current time.", e);
                    }
                }
            }
            if (date == null) {
                date = new Date();
            }
            _storedLibrariesTimeStamp = date.getTime();
        }
        return _storedLibrariesTimeStamp;
    }

    public static Calendar getStoredSessionTimeStampCalendar() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(UtilityOps.getStoredSessionTimeStamp());
        return calendar;
    }

    public static String getTimeStamp() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ssa", Locale.ENGLISH);
        return df.format(d);
    }

    public static String getSessionTimeStamp(String format) throws ParseException {
        if (StringUtil.isNullOrEmpty((String)format, (boolean)true)) {
            format = "yyyyMMddHHmmss";
        }
        SimpleDateFormat target = new SimpleDateFormat(format);
        return target.format(new Date(UtilityOps.getStoredSessionTimeStamp()));
    }

    public static boolean isValidPathString(String path) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            _logger.fine("Invalid path (null or empty string)");
            return false;
        }
        File f = new File(path).getAbsoluteFile();
        path = f.getAbsolutePath();
        if (!ComdevHelper.isWindows() && path.contains(" ")) {
            _logger.fine("Invalid path (contains a space character)): " + path);
            return false;
        }
        while (f != null) {
            String name = f.getName();
            if (name.equals("")) {
                return true;
            }
            if (name.trim().equals("")) {
                _logger.fine("Invalid path: path element must not consist solely of whitespace: " + path);
                return false;
            }
            if (!name.equalsIgnoreCase("Program Files (x86)")) {
                if (!_validPathPattern.matcher(name).matches()) {
                    _logger.fine("Invalid path: only alphanumerics, underscore, dash, and dot are allowed, and interior spaces are allowed on Windows only: " + path);
                    return false;
                }
                if (name.endsWith(" ")) {
                    _logger.fine("Invalid path: path element contains a trailing space: " + path);
                    return false;
                }
            }
            f = f.getParentFile();
        }
        return true;
    }

    public static String getJVMD64Flag() {
        String result = "";
        if (NioJdkHelper.isD64Required()) {
            result = "-d64";
        }
        return result;
    }
}

