/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractTableModelListener
implements TableModelListener {
    @Override
    public final void tableChanged(TableModelEvent e) {
        TableModel source = (TableModel)e.getSource();
        int first = e.getFirstRow();
        int last = e.getLastRow();
        if (first == -1) {
            this.structureChanged(source);
            return;
        }
        if (first == 0 && last == Integer.MAX_VALUE) {
            this.dataChanged(source);
            return;
        }
        switch (e.getType()) {
            case -1: {
                this.rowsRemoved(source, first, last);
                break;
            }
            case 0: {
                if (e.getColumn() == -1) {
                    this.rowsChanged(source, first, last);
                    break;
                }
                this.cellsChanged(source, first, last, e.getColumn());
                break;
            }
            case 1: {
                this.rowsAdded(source, first, last);
                break;
            }
            default: {
                this.unknownEvent(e);
            }
        }
    }

    protected void unknownEvent(TableModelEvent e) {
    }

    protected void cellsChanged(TableModel source, int first, int last, int column) {
        this.rowsChanged(source, first, last);
    }

    protected abstract void structureChanged(TableModel var1);

    protected abstract void dataChanged(TableModel var1);

    protected abstract void rowsRemoved(TableModel var1, int var2, int var3);

    protected abstract void rowsChanged(TableModel var1, int var2, int var3);

    protected abstract void rowsAdded(TableModel var1, int var2, int var3);
}

