/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    protected GradientStyle _style = GradientStyle.VERTICAL;
    protected Color _c1;
    protected Color _c2;
    protected double _halfPoint = 0.5;

    public GradientPanel() {
    }

    public GradientPanel(Color bg) {
        if (bg == null) {
            this.setOpaque(false);
        } else {
            this.setBackground(bg);
        }
    }

    public GradientPanel(Color c1, Color c2, GradientStyle style) {
        this(c1, c2, style, 0.5);
    }

    public GradientPanel(Color c1, Color c2, GradientStyle style, Double halfPoint) {
        this._c1 = c1;
        this._c2 = c2;
        this._style = style != null ? style : GradientStyle.VERTICAL;
        this._halfPoint = halfPoint == null ? 0.5 : this.fitHalfPoint(halfPoint);
    }

    public Color getC1() {
        return this._c1;
    }

    public void setC1(Color c1) {
        if (this._c1 != c1) {
            this._c1 = c1;
            this.repaint();
        }
    }

    public Color getC2() {
        return this._c2;
    }

    public void setC2(Color c2) {
        if (this._c2 != c2) {
            this._c2 = c2;
            this.repaint();
        }
    }

    public double getHalfPoint() {
        return this._halfPoint;
    }

    public void setHalfPoint(double halfPoint) {
        double newhp = this.fitHalfPoint(halfPoint);
        if (this._halfPoint != newhp) {
            this._halfPoint = newhp;
            this.repaint();
        }
    }

    public GradientStyle getGradientStyle() {
        return this._style;
    }

    public void setGradientStyle(GradientStyle style) {
        if (style != null && this._style != style) {
            this._style = style;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._c1 == null || this._c2 == null || g == null || !Graphics2D.class.isAssignableFrom(g.getClass())) {
            super.paintComponent(g);
        } else {
            Graphics2D g2d = (Graphics2D)Graphics2D.class.cast(g);
            int w = this.getWidth();
            int h = this.getHeight();
            Point start = new Point(this._style == GradientStyle.SLASH ? w : 0, 0);
            Point end = null;
            switch (this._style.ordinal()) {
                case 0: {
                    end = new Point(0, h);
                    break;
                }
                case 1: {
                    end = new Point(w, 0);
                    break;
                }
                case 2: {
                    end = new Point(2 * h * h * w / (h * h + w * w), 2 * h * w * w / (h * h + w * w));
                    break;
                }
                case 3: {
                    end = new Point(w - 2 * h * h * w / (h * h + w * w), 2 * h * w * w / (h * h + w * w));
                }
            }
            double adj = (this._halfPoint - 0.5) * 2.0;
            if (adj < 0.0) {
                end.setLocation(end.getX() + (end.getX() - start.getX()) * adj, end.getY() + (end.getY() - start.getY()) * adj);
            } else if (adj > 0.0) {
                start.setLocation(start.getX() + (end.getX() - start.getX()) * adj, start.getY() + (end.getY() - start.getY()) * adj);
            }
            GradientPaint gpaint = new GradientPaint(start, this._c1, end, this._c2);
            g2d.setPaint(gpaint);
            g2d.fillRect(0, 0, w, h);
        }
    }

    private double fitHalfPoint(double halfPoint) {
        return halfPoint < 0.0 ? 0.0 : (halfPoint > 1.0 ? 1.0 : halfPoint);
    }

    public static enum GradientStyle {
        VERTICAL,
        HORIZONTAL,
        BACKSLASH,
        SLASH;

    }
}

