/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.ui.gui.GradientPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ImagePanel
extends GradientPanel {
    protected Anchor _anchor = Anchor.NORTHWEST;
    protected int _offsetX;
    protected int _offsetY;
    protected Axis _stretch = Axis.NONE;
    protected Axis _tile = Axis.NONE;
    protected Image _image;

    public static ImagePanel createImagePanel(String specs) {
        Image img = null;
        Anchor anchor = null;
        int offsetX = 0;
        int offsetY = 0;
        Axis stretch = null;
        Axis tile = null;
        Color bg = null;
        boolean useDefaultBg = true;
        Color c1 = null;
        Color c2 = null;
        GradientPanel.GradientStyle style = null;
        Double halfPoint = null;
        if (specs != null && !specs.isEmpty()) {
            for (String param : specs.split(";")) {
                String value;
                int colonPos = param.indexOf(58);
                String name = colonPos < 0 ? param : param.substring(0, colonPos);
                String string = value = colonPos < 0 ? null : param.substring(colonPos + 1, param.length());
                if ("IMG".equals(name)) {
                    URL url = ImagePanel.class.getClassLoader().getResource(value);
                    if (url == null) {
                        try {
                            File f = new File(value);
                            if (f.isFile()) {
                                url = f.toURI().toURL();
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (url == null) {
                        try {
                            url = new URL(value);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (url == null) continue;
                    img = Toolkit.getDefaultToolkit().getImage(url);
                    continue;
                }
                if ("ANCHOR".equals(name)) {
                    try {
                        anchor = Anchor.valueOf(value);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if ("OFFSETX".equals(name)) {
                    try {
                        offsetX = Integer.parseInt(value);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if ("OFFSETY".equals(name)) {
                    try {
                        offsetY = Integer.parseInt(value);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if ("STRETCH".equals(name)) {
                    try {
                        stretch = Axis.valueOf(value);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if ("TILE".equals(name)) {
                    try {
                        tile = Axis.valueOf(value);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if ("BG".equals(name)) {
                    bg = GUIUtilities.colorFromHex(value);
                    if (bg == null && !"NONE".equals(value)) continue;
                    useDefaultBg = false;
                    continue;
                }
                if ("C1".equals(name)) {
                    c1 = GUIUtilities.colorFromHex(value);
                    continue;
                }
                if ("C2".equals(name)) {
                    c2 = GUIUtilities.colorFromHex(value);
                    continue;
                }
                if ("GRADSTYLE".equals(name)) {
                    try {
                        style = GradientPanel.GradientStyle.valueOf(value);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (!"HP".equals(name)) continue;
                try {
                    halfPoint = Double.parseDouble(value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        ImagePanel p = c1 == null ? (useDefaultBg ? new ImagePanel(img, anchor, stretch, tile) : new ImagePanel(img, anchor, stretch, tile, bg)) : new ImagePanel(img, anchor, stretch, tile, c1, c2, style, halfPoint);
        p.setOffsetX(offsetX);
        p.setOffsetY(offsetY);
        return p;
    }

    public ImagePanel(Image image) {
        this(image, null, null, null);
    }

    public ImagePanel(Image image, Anchor anchor, Axis stretch, Axis tile) {
        this.init(image, anchor, stretch, tile);
    }

    public ImagePanel(Image image, Anchor anchor, Axis stretch, Axis tile, Color bg) {
        super(bg);
        this.init(image, anchor, stretch, tile);
    }

    public ImagePanel(Image image, Anchor anchor, Axis stretch, Axis tile, Color c1, Color c2, GradientPanel.GradientStyle style, Double halfPoint) {
        super(c1, c2, style, halfPoint);
        this.init(image, anchor, stretch, tile);
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        if (this._image != image) {
            this._image = image;
            this.repaint();
        }
    }

    public void setImage(URL imageURL) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(imageURL));
    }

    public Anchor getAnchor() {
        return this._anchor;
    }

    public void setAnchor(Anchor anchor) {
        if (anchor != null && anchor != this._anchor) {
            this._anchor = anchor;
            this.repaint();
        }
    }

    public int getOffsetX() {
        return this._offsetX;
    }

    public void setOffsetX(int offset) {
        this._offsetX = offset;
        this.repaint();
    }

    public int getOffsetY() {
        return this._offsetY;
    }

    public void setOffsetY(int offset) {
        this._offsetY = offset;
        this.repaint();
    }

    public Axis getStretch() {
        return this._stretch;
    }

    public void setStretch(Axis stretch) {
        if (this._stretch != null && this._stretch != stretch) {
            this._stretch = stretch;
            this.repaint();
        }
    }

    public Axis getTile() {
        return this._tile;
    }

    public void setTile(Axis tile) {
        if (this._tile != null && this._tile != tile) {
            this._tile = tile;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this._image != null && this._image.getWidth(this) >= 0 && this._image.getHeight(this) >= 0) {
            d.width = this._image.getWidth(this);
            d.height = this._image.getHeight(this);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._image != null) {
            int imgWidth = this._image.getWidth(this);
            int imgHeight = this._image.getHeight(this);
            if (imgWidth == -1 || imgHeight == -1) {
                return;
            }
            int width = imgWidth;
            int height = imgHeight;
            int offsetX = this._offsetX;
            int offsetY = this._offsetY;
            if (this._stretch != null) {
                switch (this._stretch.ordinal()) {
                    case 1: {
                        height = this.getHeight();
                        offsetY = 0;
                        break;
                    }
                    case 2: {
                        width = this.getWidth();
                        offsetX = 0;
                        break;
                    }
                    case 3: {
                        width = this.getWidth();
                        height = this.getHeight();
                        offsetY = 0;
                        offsetX = 0;
                    }
                }
            }
            int x = 0;
            int y = 0;
            if (this._anchor != null) {
                switch (this._anchor.ordinal()) {
                    case 0: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        x = this.getWidth() - width;
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: {
                        x = (this.getWidth() - width) / 2;
                    }
                }
                switch (this._anchor.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        y = this.getHeight() - height;
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        y = (this.getHeight() - height) / 2;
                    }
                }
            }
            int end_x = (x += offsetX) + width;
            int end_y = (y += offsetY) + height;
            if (this._tile != null) {
                switch (this._tile.ordinal()) {
                    case 1: {
                        while (y > 0) {
                            y -= height;
                        }
                        end_y = this.getHeight();
                        break;
                    }
                    case 2: {
                        while (x > 0) {
                            x -= width;
                        }
                        end_x = this.getWidth();
                        break;
                    }
                    case 3: {
                        while (x > 0) {
                            x -= width;
                        }
                        end_x = this.getWidth();
                        while (y > 0) {
                            y -= height;
                        }
                        end_y = this.getHeight();
                    }
                }
            }
            Graphics scratchGraphics = g.create();
            try {
                for (int currY = y; currY < end_y; currY += height) {
                    for (int currX = x; currX < end_x; currX += width) {
                        scratchGraphics.drawImage(this._image, currX, currY, width, height, this);
                    }
                }
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }

    private void init(Image image, Anchor anchor, Axis stretch, Axis tile) {
        this._image = image;
        this._anchor = anchor != null ? anchor : Anchor.CENTER;
        this._stretch = stretch != null ? stretch : Axis.NONE;
        this._tile = tile != null ? tile : Axis.NONE;
    }

    public static enum Anchor {
        NORTHWEST,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        CENTER;

    }

    public static enum Axis {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }
}

