/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class InputTableModel
extends AbstractTableModel {
    private TableModel model;

    public InputTableModel(TableModel model) {
        this.model = model;
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                InputTableModel.this.innerModelChanged(e);
            }
        });
    }

    private void innerModelChanged(TableModelEvent e) {
        if (e.getType() == 1) {
            this.fireTableRowsInserted(e.getFirstRow(), e.getLastRow());
        } else if (e.getType() == -1) {
            this.fireTableRowsDeleted(e.getFirstRow(), e.getLastRow());
        } else {
            this.fireTableRowsUpdated(e.getFirstRow(), e.getLastRow());
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount() + 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex < this.model.getRowCount()) {
            return this.model.isCellEditable(rowIndex, columnIndex);
        }
        return this.isEmptyColumnEditable(columnIndex);
    }

    protected boolean isEmptyColumnEditable(int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.model.getRowCount()) {
            return this.model.getValueAt(rowIndex, columnIndex);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        boolean inserted = false;
        boolean removed = false;
        if (!this.isEmptyValue(columnIndex, value) && rowIndex == this.model.getRowCount()) {
            this.addRowToEnd(value);
            inserted = true;
        } else if (rowIndex < this.model.getRowCount()) {
            this.model.setValueAt(value, rowIndex, columnIndex);
        }
        if (rowIndex < this.model.getRowCount() && this.isRowEmpty(rowIndex)) {
            this.removeRow(rowIndex);
            removed = true;
        }
        if (inserted) {
            this.fireTableRowsInserted(rowIndex, rowIndex);
        } else if (removed) {
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        } else {
            this.fireTableRowsUpdated(rowIndex, columnIndex);
        }
    }

    protected abstract boolean isEmptyValue(int var1, Object var2);

    protected abstract boolean isRowEmpty(int var1);

    protected abstract void addRowToEnd(Object var1);

    protected abstract void removeRow(int var1);
}

