/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import com.oracle.cie.common.comdev.Tree;
import com.oracle.cie.common.comdev.TreeDataModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeJTreeModel
implements Serializable,
TreeModel,
VetoableChangeListener {
    public static final int CHANGE_EVENT = 1;
    public static final int INSERT_EVENT = 2;
    public static final int REMOVE_EVENT = 3;
    public static final int STRUCTURE_EVENT = 4;
    private TreeDataModel _dataModel;
    private Tree _displayedRoot;
    private EventListenerList _listenerList = new EventListenerList();
    private ArrayList _interestedAttrs;

    public TreeJTreeModel(TreeDataModel m) {
        this.init(m);
    }

    public TreeDataModel getTreeDataModel() {
        return this._dataModel;
    }

    public void setTreeDataModel(TreeDataModel m) {
        this.init(m);
        this.fireEvent(this._displayedRoot, null, 4);
    }

    @Override
    public Object getRoot() {
        return this._displayedRoot;
    }

    public void setRoot(Tree root) {
        if (root == null) {
            return;
        }
        this._displayedRoot = root;
        this.fireEvent(this._displayedRoot, null, 4);
    }

    public void dispose() {
        this._dataModel.removeVetoableChangeListener(this);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this._dataModel.getSubtree(this._displayedRoot, (Tree)parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this._dataModel.getDegree(this._displayedRoot, (Tree)parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == null) {
            return false;
        }
        return this._dataModel.isLeaf(this._displayedRoot, (Tree)node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Tree t = (Tree)path.getLastPathComponent();
        if (newValue != null) {
            t.setKey(newValue);
        }
        this.fireEvent(t.getParent(), new Tree[]{t}, 1);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        Tree p = (Tree)parent;
        Tree c = (Tree)child;
        return p.getIndexOfSubtree(c);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this._listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this._listenerList.remove(TreeModelListener.class, l);
    }

    public void addInterestedAttribute(String name) {
        if (this._interestedAttrs == null) {
            this._interestedAttrs = new ArrayList();
        }
        if (!this._interestedAttrs.contains(name)) {
            this._interestedAttrs.add(name);
        }
    }

    public void removeInterestedAttribute(String name) {
        if (this._interestedAttrs != null) {
            this._interestedAttrs.remove(name);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (propertyName.equals("setRoot")) {
            this.setRoot((Tree)newValue);
            return;
        }
        Tree t = (Tree)evt.getSource();
        if (propertyName.equals("setKey")) {
            this.fireEvent(t.getParent(), new Tree[]{t}, 1);
            return;
        }
        if (propertyName.equals("reload")) {
            this.fireEvent(t, null, 4);
            return;
        }
        if (propertyName.equals("addSubtree") || propertyName.equals("insertSubtree")) {
            this.fireEvent(t, new Tree[]{(Tree)newValue}, 2);
            return;
        }
        if (propertyName.equals("removeSubtree")) {
            this.fireEvent(t, new Tree[]{(Tree)oldValue}, 3);
            return;
        }
        if (this._interestedAttrs == null) {
            return;
        }
        String attrName = null;
        if (propertyName.startsWith("setAttr")) {
            attrName = propertyName.substring("setAttr".length());
        }
        if (propertyName.startsWith("removeAttr")) {
            attrName = propertyName.substring("removeAttr".length());
        }
        if (attrName == null) {
            return;
        }
        for (int i = 0; i < this._interestedAttrs.size(); ++i) {
            if (!attrName.equals(this._interestedAttrs.get(i))) continue;
            this.fireEvent(t.getParent(), new Tree[]{t}, 1);
            return;
        }
    }

    protected TreeModelEvent createEvent(Tree parent, Tree[] subtrees) {
        Object[] path;
        Tree p;
        for (p = parent; p != null && p != this._displayedRoot; p = p.getParent()) {
        }
        if (p == null) {
            return null;
        }
        int[] indices = null;
        if (parent.getDepth() <= this._displayedRoot.getDepth()) {
            path = new Tree[]{this._displayedRoot};
            indices = new int[]{};
        } else {
            if (subtrees != null) {
                indices = new int[subtrees.length];
                for (int i = 0; i < subtrees.length; ++i) {
                    indices[i] = this._dataModel.getIndexOfSubtree(this._displayedRoot, parent, subtrees[i]);
                    if (indices[i] >= 0) continue;
                    return null;
                }
            }
            path = parent.getPath(this._displayedRoot);
        }
        if (path == null || path.length == 0) {
            return null;
        }
        return new TreeModelEvent((Object)this, path, indices, (Object[])subtrees);
    }

    protected void fireEvent(Tree parent, Tree[] subtrees, int eventType) {
        TreeModelEvent e = null;
        Object[] listeners = this._listenerList.getListenerList();
        block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null && (e = this.createEvent(parent, subtrees)) == null) {
                return;
            }
            TreeModelListener l = (TreeModelListener)listeners[i + 1];
            switch (eventType) {
                case 1: {
                    l.treeNodesChanged(e);
                    continue block6;
                }
                case 2: {
                    l.treeNodesInserted(e);
                    continue block6;
                }
                case 3: {
                    l.treeNodesRemoved(e);
                    continue block6;
                }
                case 4: {
                    l.treeStructureChanged(e);
                }
            }
        }
    }

    private void init(TreeDataModel m) {
        if (this._dataModel != null) {
            this._dataModel.removeVetoableChangeListener(this);
        }
        this._dataModel = m;
        this._dataModel.addVetoableChangeListener(this);
        this._displayedRoot = this._dataModel.getRoot();
    }
}

