/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.CommonException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CmdLineParser {
    private Map<String, String> _options = new HashMap<String, String>();
    private List<String> _arguments = new ArrayList<String>();
    private Collection<Collection<String>> _requiredOptions = new HashSet<Collection<String>>();
    private Collection<Collection<String>> _mutuallyExclusive = new ArrayList<Collection<String>>();

    public CmdLineParser() {
    }

    public CmdLineParser(Collection<Collection<String>> required, Collection<Collection<String>> mutuallyExclusive) {
        if (required != null) {
            this._requiredOptions.addAll(required);
        }
        if (mutuallyExclusive != null) {
            this._mutuallyExclusive.addAll(mutuallyExclusive);
        }
    }

    public void parse(String[] args) throws CommonException {
        this._options.clear();
        this._arguments.clear();
        if (args != null) {
            int indx;
            for (indx = 0; indx < args.length; ++indx) {
                if (args[indx] == null) {
                    throw new CommonException("Argument cannot be null");
                }
                if (!args[indx].startsWith("-")) break;
                if (args[indx].equals("--")) {
                    ++indx;
                    break;
                }
                String arg = args[indx];
                String value = "";
                int eqIdx = args[indx].indexOf(61);
                if (eqIdx >= 0) {
                    arg = args[indx].substring(0, eqIdx);
                    value = args[indx].substring(eqIdx + 1);
                } else if (indx + 1 < args.length) {
                    if (args[indx + 1] == null) {
                        throw new CommonException("Argument cannot be null");
                    }
                    if (!args[indx + 1].startsWith("-")) {
                        value = args[indx + 1];
                        ++indx;
                    }
                }
                if (this._options.containsKey(arg)) {
                    throw new CommonException("Duplicate argument:  " + arg);
                }
                for (Collection<String> exclusive : this._mutuallyExclusive) {
                    if (!exclusive.contains(arg)) continue;
                    for (String opt : exclusive) {
                        if (opt.equals(arg) || !this._options.containsKey(opt)) continue;
                        throw new CommonException("Mutually exclusive arguments:  " + arg + ", " + opt);
                    }
                }
                this._options.put(arg, value);
            }
            while (indx < args.length) {
                if (args[indx] == null) {
                    throw new CommonException("Argument cannot be null");
                }
                this._arguments.add(args[indx++]);
            }
        }
        for (Collection<String> required : this._requiredOptions) {
            boolean found = false;
            for (String opt : required) {
                if (!this._options.containsKey(opt)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new CommonException("Required option missing:  " + required);
        }
    }

    public Map<String, String> getOptionMap() {
        return Collections.unmodifiableMap(this._options);
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this._arguments);
    }
}

