/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreFactory;
import com.oracle.cie.common.util.ResourceBundleManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ObjectStoreManager {
    private static final Map _objectStoreMap = new HashMap();
    private static ClassLoader s_loader = ResourceBundleManager.class.getClassLoader();

    public static void setClassLoader(ClassLoader loader) {
        s_loader = loader;
    }

    public static synchronized IObjectStore getObjectStore() {
        return ObjectStoreManager.getObjectStore("public");
    }

    public static synchronized IObjectStore getObjectStore(String namespace) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        IObjectStore os = (IObjectStore)_objectStoreMap.get(namespace);
        if (os == null) {
            os = ObjectStoreFactory.createObjectStore(namespace);
            _objectStoreMap.put(namespace, os);
        }
        return os;
    }

    public static synchronized IObjectStore getObjectStore(String namespace, String backingNamespace) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        if (_objectStoreMap.containsKey(namespace)) {
            return (IObjectStore)_objectStoreMap.get(namespace);
        }
        IObjectStore bos = backingNamespace != null ? ObjectStoreManager.getObjectStore(backingNamespace) : ObjectStoreManager.getObjectStore();
        IObjectStore os = ObjectStoreFactory.createObjectStore(namespace, bos);
        _objectStoreMap.put(namespace, os);
        return os;
    }

    public static synchronized void purgeAll() {
        _objectStoreMap.clear();
    }

    public void storeNew(String namespace, String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must be non-null!");
        }
        ObjectStoreManager.loadNamespace(namespace, filename, false);
    }

    public void storeAll(String namespace, String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new IllegalArgumentException("Filename must be non-null!");
        }
        ObjectStoreManager.loadNamespace(namespace, filename, true);
    }

    public void storeAll(String filename) throws FileNotFoundException {
        this.storeAll("public", filename);
    }

    protected void loadNamespace(String filename) throws FileNotFoundException {
        ObjectStoreManager.loadNamespace("public", filename, true);
    }

    public static void loadNamespace(String namespace, String filename, boolean replace) throws FileNotFoundException {
        if (namespace == null || namespace.isEmpty()) {
            namespace = "public";
        }
        if (filename != null) {
            InputStream is = null;
            Properties props = new Properties();
            try {
                ClassLoader cl = s_loader != null ? s_loader : ObjectStoreManager.class.getClassLoader();
                is = cl.getResourceAsStream(filename);
                if (is == null) {
                    is = new FileInputStream(filename);
                }
                props.load(is);
                if (replace) {
                    ObjectStoreManager.getObjectStore(namespace).storeAll(props);
                } else {
                    ObjectStoreManager.getObjectStore(namespace).storeNew(props);
                }
                ObjectStoreManager.getObjectStore(namespace).storeAll(System.getProperties());
            }
            catch (IOException iox) {
                FileNotFoundException fnfx = new FileNotFoundException("Unable to read namespace property file: (" + filename + ")!");
                fnfx.initCause(iox);
                throw fnfx;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

