/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IoBridge;
import com.oracle.cie.common.util.IoBridgeImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StringSubstitutionUtility {
    public static boolean globalStrSubst(String inputFileName, Map<String, String> inputDataMap, Locale locale) throws IOException {
        return StringSubstitutionUtility.globalStrSubst(inputFileName, inputDataMap, locale, null);
    }

    public static boolean globalStrSubst(String inputFileName, Map<String, String> inputDataMap, Locale locale, CallBack callBack) throws IOException {
        return StringSubstitutionUtility.globalStrSubst(inputFileName, inputDataMap, locale, callBack, null);
    }

    public static boolean globalStrSubst(String inputFileName, Map<String, String> inputDataMap, Locale locale, CallBack callBack, IoBridge nioBridge) throws IOException {
        String outputFileName = inputFileName;
        if (inputFileName != null && (inputFileName.contains(".cas/CLI/") || inputFileName.contains(".cas/SDK/"))) {
            outputFileName = inputFileName.replaceAll(".cas/CLI/", "");
            outputFileName = inputFileName.replaceAll(".cas/SDK/", "");
        }
        return StringSubstitutionUtility.globalStrSubst(inputFileName, outputFileName, inputDataMap, locale, callBack, nioBridge);
    }

    public static boolean globalStrSubst(String inputFileName, String outputFileName, Map<String, String> inputDataMap, Locale locale) throws IOException {
        return StringSubstitutionUtility.globalStrSubst(inputFileName, outputFileName, inputDataMap, locale, null);
    }

    public static boolean globalStrSubst(String inputFileName, String outputFileName, Map<String, String> inputDataMap, Locale locale, CallBack callBack) throws IOException {
        return StringSubstitutionUtility.globalStrSubst(inputFileName, outputFileName, inputDataMap, locale, callBack, null);
    }

    public static boolean globalStrSubst(String inputFileName, String outputFileName, Map<String, String> inputDataMap, Locale locale, CallBack callBack, IoBridge ioBridge) throws IOException {
        if (ioBridge == null) {
            ioBridge = new IoBridgeImpl();
        }
        ArrayList<String> buffer = new ArrayList<String>();
        boolean dirtyFlag = !ioBridge.isEqual(inputFileName, outputFileName);
        try {
            String inputLine;
            if (callBack != null) {
                callBack.beforeFileRead(inputFileName);
            }
            BufferedReader reader = inputFileName.toLowerCase().endsWith(".xml") ? new BufferedReader(new InputStreamReader(ioBridge.getInputStream(inputFileName), "UTF-8")) : new BufferedReader(new InputStreamReader(ioBridge.getInputStream(inputFileName)));
            while ((inputLine = reader.readLine()) != null) {
                buffer.add(inputLine);
            }
            reader.close();
            if (callBack != null) {
                callBack.afterFileRead(inputFileName);
                callBack.beforeFileSubstitute(buffer);
            }
            for (int i = 0; i < buffer.size(); ++i) {
                String inputLineOri = inputLine = (String)buffer.get(i);
                for (String key : inputDataMap.keySet()) {
                    inputLine = StringSubstitutionUtility.substituteString(inputLine, key, inputDataMap.get(key));
                }
                if (inputLine.equals(inputLineOri)) continue;
                dirtyFlag = true;
                buffer.set(i, inputLine);
            }
            if (callBack != null) {
                callBack.contentModified(dirtyFlag);
                callBack.afterFileSubstitute(buffer);
            }
            if (dirtyFlag) {
                String parent;
                if (callBack != null) {
                    callBack.beforeFileWrite(outputFileName);
                }
                if (!ioBridge.exists(parent = ioBridge.getParent(outputFileName))) {
                    ioBridge.mkdirs(parent);
                    if (callBack != null) {
                        callBack.directoryCreated(parent);
                    }
                }
                PrintWriter out = inputFileName.toLowerCase().endsWith(".xml") ? new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(ioBridge.getOutputStream(outputFileName)), "UTF-8")) : new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(ioBridge.getOutputStream(outputFileName))));
                for (String line : buffer) {
                    out.println(line);
                }
                out.close();
                if (callBack != null) {
                    callBack.afterFileWrite(outputFileName);
                }
            }
        }
        catch (IOException x) {
            throw new IOException("Error performing global string substitution on file " + inputFileName + ".  " + x);
        }
        return dirtyFlag;
    }

    public static boolean globalStrSubst(InputStream is, OutputStream os, Map<String, String> inputDataMap, Locale locale, String fileName) throws IOException {
        ArrayList<String> buffer = new ArrayList<String>();
        boolean dirtyFlag = false;
        try {
            String inputLine;
            BufferedReader reader = fileName != null && fileName.toLowerCase().endsWith(".xml") ? new BufferedReader(new InputStreamReader(is, "UTF-8")) : new BufferedReader(new InputStreamReader(is));
            while ((inputLine = reader.readLine()) != null) {
                buffer.add(inputLine);
            }
            reader.close();
            for (int i = 0; i < buffer.size(); ++i) {
                String inputLineOri = inputLine = (String)buffer.get(i);
                for (String key : inputDataMap.keySet()) {
                    inputLine = StringSubstitutionUtility.substituteString(inputLine, key, inputDataMap.get(key));
                }
                if (inputLine.equals(inputLineOri)) continue;
                dirtyFlag = true;
                buffer.set(i, inputLine);
            }
            if (dirtyFlag) {
                PrintWriter out = fileName != null && fileName.toLowerCase().endsWith(".xml") ? new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), "UTF-8")) : new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(os)));
                for (String line : buffer) {
                    out.println(line);
                }
                out.close();
            }
        }
        catch (IOException x) {
            throw new IOException("Error performing global string substitution on file " + fileName + ".  " + x);
        }
        return dirtyFlag;
    }

    public static String substituteString(String inputString, String origString, String newString) {
        int endIdx;
        String prevString = "";
        int beginIdx = 0;
        String tempString2 = inputString;
        while ((endIdx = inputString.indexOf(origString, beginIdx)) >= 0) {
            String tempString = inputString.substring(beginIdx, endIdx);
            tempString = tempString.concat(newString);
            prevString = prevString + tempString;
            beginIdx = endIdx += origString.length();
            tempString2 = inputString.substring(beginIdx, inputString.length());
            tempString2 = prevString.concat(tempString2);
        }
        return tempString2;
    }

    public static interface CallBack {
        public void beforeFileRead(String var1);

        public void afterFileRead(String var1);

        public void beforeFileSubstitute(List<String> var1);

        public void afterFileSubstitute(List<String> var1);

        public void directoryCreated(String var1);

        public void contentModified(boolean var1);

        public void beforeFileWrite(String var1);

        public void afterFileWrite(String var1);
    }

    public static class CallBackAdapter
    implements CallBack {
        @Override
        public void beforeFileRead(String origFile) {
        }

        @Override
        public void afterFileRead(String origFile) {
        }

        @Override
        public void beforeFileSubstitute(List<String> buffer) {
        }

        @Override
        public void afterFileSubstitute(List<String> buffer) {
        }

        @Override
        public void directoryCreated(String directory) {
        }

        @Override
        public void contentModified(boolean dirtyFlag) {
        }

        @Override
        public void beforeFileWrite(String destFile) {
        }

        @Override
        public void afterFileWrite(String destFile) {
        }
    }
}

