/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.version;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.VersionRef;
import com.oracle.cie.common.util.version.ReverseVersionComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class VersionMatcher<V extends VersionRef> {
    public static final int MIN_MATCH = 3;
    private TreeMap<String, V> _verMap = new TreeMap();
    private int _minMatch = 3;

    public VersionMatcher(Collection<V> entries) {
        for (VersionRef entry : entries) {
            this._verMap.put(this.makeKey(entry), entry);
        }
    }

    public VersionMatcher(Collection<V> entries, int minMatch) {
        this(entries);
        this._minMatch = minMatch;
    }

    public Collection<V> getEntries() {
        return Collections.unmodifiableCollection(this._verMap.values());
    }

    public List<V> findMatchingVersions(String name, String version) {
        if (name == null) {
            return null;
        }
        ArrayList<VersionRef> versions = new ArrayList<VersionRef>();
        VersionRef ver = null;
        Version base = null;
        if (version != null) {
            ver = (VersionRef)this._verMap.get(this.makeKey(name, version));
            base = new Version(version);
        }
        if (ver == null) {
            VersionRef v;
            String key = this._verMap.higherKey(this.makeKey(name, null));
            while (key != null && (v = (VersionRef)this._verMap.get(key)).getName().equals(name)) {
                if (base == null || base.getNumMatchingPositions(new Version(v.getVersion())) >= this._minMatch) {
                    versions.add(v);
                }
                key = this._verMap.higherKey(key);
            }
            Collections.sort(versions, new ReverseVersionComparator(base));
        } else {
            versions.add(ver);
        }
        return versions;
    }

    private String makeKey(V entry) {
        return this.makeKey(entry.getName(), entry.getVersion());
    }

    private String makeKey(String name, String version) {
        if (name == null) {
            name = "";
        }
        if (version == null) {
            version = "";
        }
        return name + "\u0000" + version;
    }
}

