/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.xmldiff;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xmldiff.XmlDiffAction;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.datatype.XMLGregorianCalendar;

public class XmlDiff {
    private XmlDiffAspect _baseAspect;
    private XmlDiffAspect _patchedAspect;
    private String _idKey;
    private XmlDiffTreeFilter _filter;
    private XmlDiffTree _root;
    static final String ID_KEY = "Id";

    public static XmlDiffTree diffAspects(XmlDiffAspect aspectOne, XmlDiffAspect aspectTwo) throws XmlDiffException {
        return XmlDiff.diffAspects(aspectOne, aspectTwo, null);
    }

    public static XmlDiffTree diffAspects(XmlDiffAspect aspectOne, XmlDiffAspect aspectTwo, XmlDiffTreeFilter filter) throws XmlDiffException {
        XmlDiff xmlDiff = new XmlDiff(aspectOne, aspectTwo, null, filter);
        xmlDiff.executeDiff();
        return xmlDiff.getDiffTree();
    }

    public XmlDiff(XmlDiffAspect aspectOne, XmlDiffAspect aspectTwo) throws XmlDiffException {
        this(aspectOne, aspectTwo, null);
    }

    public XmlDiff(XmlDiffAspect aspectOne, XmlDiffAspect aspectTwo, String idKey) throws XmlDiffException {
        this(aspectOne, aspectTwo, idKey, null);
    }

    public XmlDiff(XmlDiffAspect aspectOne, XmlDiffAspect aspectTwo, String idKey, XmlDiffTreeFilter filter) throws XmlDiffException {
        this._baseAspect = aspectOne;
        this._patchedAspect = aspectTwo;
        this._idKey = idKey != null ? idKey : ID_KEY;
        XmlDiffTreeFilter xmlDiffTreeFilter = this._filter = filter == null ? new XmlDiffTreeFilter() : filter;
        if (!this._baseAspect.getElement().equals(this._patchedAspect.getElement())) {
            throw new XmlDiffException("Cannot diff aspects which do not contain the same element.");
        }
    }

    public XmlDiffTree getDiffTree() {
        return this._root;
    }

    public XmlDiffAspect getAspectOne() {
        return this._baseAspect;
    }

    public XmlDiffAspect getAspectTwo() {
        return this._patchedAspect;
    }

    protected void diffElements(XmlDiffAspect aspect1, XmlDiffAspect aspect2, XmlDiffTree node, XmlDiffTreeFilter filter, boolean parentFiltered) throws XmlDiffException {
        if (aspect1 == null && aspect2 == null) {
            throw new IllegalArgumentException("Both aspects being diffed may not be null.");
        }
        XmlDiffAspect queryAspect = aspect1 != null ? aspect1 : aspect2;
        Set<String> complexElements = this.getComplexNames(aspect1, aspect2);
        for (String element : complexElements) {
            XmlDiffTree child;
            int x;
            XmlDiffAspect[] value2;
            XmlDiffAspect[] value1 = aspect1 != null && aspect1.hasComplexName(element) ? aspect1.getComplexValue(element) : null;
            XmlDiffAspect[] xmlDiffAspectArray = value2 = aspect2 != null && aspect2.hasComplexName(element) ? aspect2.getComplexValue(element) : null;
            if (value1 == null && value2 == null || value1 != null && value1.length == 0 && value2 != null && value2.length == 0) continue;
            if (!StringUtil.isNullOrEmpty(this._idKey, true) && queryAspect.hasAttributeName(this._idKey)) {
                ArrayList<XmlDiffAspect> v1Col = new ArrayList<XmlDiffAspect>();
                ArrayList<XmlDiffAspect> v2Col = new ArrayList<XmlDiffAspect>();
                if (value1 != null) {
                    v1Col.addAll(Arrays.asList(value1));
                }
                if (value2 != null) {
                    v2Col.addAll(Arrays.asList(value2));
                }
                for (XmlDiffAspect v1 : v1Col) {
                    XmlDiffAspect found = null;
                    String id1 = this.getStringAttributeValue(v1, this._idKey);
                    if (id1 == null) {
                        throw new XmlDiffException("Encountered " + v1.getElement() + " type missing ID value: " + v1.getObject());
                    }
                    for (XmlDiffAspect v2 : v2Col) {
                        if (!id1.equals(this.getStringAttributeValue(v2, this._idKey))) continue;
                        found = v2;
                        v2Col.remove(v2);
                        break;
                    }
                    XmlDiffTree child2 = new XmlDiffTree(element, id1);
                    node.addChild(child2);
                    if (found != null) {
                        this.diffElements(v1, found, child2, filter, XmlDiff.isComplexTypeFiltered(filter, v1, parentFiltered));
                        continue;
                    }
                    if (!XmlDiff.isComplexTypeFiltered(filter, v1, parentFiltered)) {
                        child2.setAction(XmlDiffAction.DELETE);
                        this.diffElements(v1, null, child2, filter, false);
                        continue;
                    }
                    this.diffElements(v1, null, child2, filter, true);
                }
                if (v2Col.isEmpty()) continue;
                for (XmlDiffAspect v2 : v2Col) {
                    if (XmlDiff.isComplexTypeFiltered(filter, v2, parentFiltered)) continue;
                    XmlDiffTree child3 = new XmlDiffTree(element, this.getStringAttributeValue(v2, this._idKey), XmlDiffAction.CREATE);
                    node.addChild(child3);
                    this.diffElements(null, v2, child3, filter, parentFiltered);
                }
                continue;
            }
            if (value1 != null && value1.length > 0) {
                for (x = 0; x < value1.length; ++x) {
                    child = new XmlDiffTree(element);
                    node.addChild(child);
                    if (value2 != null && value2.length > x) {
                        this.diffElements(value1[x], value2[x], child, filter, XmlDiff.isComplexTypeFiltered(filter, value1[x], parentFiltered));
                        continue;
                    }
                    if (!XmlDiff.isComplexTypeFiltered(filter, value1[x], parentFiltered)) {
                        child.setAction(XmlDiffAction.DELETE);
                        this.diffElements(value1[x], null, child, filter, false);
                        continue;
                    }
                    this.diffElements(value1[x], null, child, filter, true);
                }
            }
            if (value2 == null || value2.length <= x) continue;
            while (x < value2.length) {
                if (!XmlDiff.isComplexTypeFiltered(filter, value2[x], parentFiltered)) {
                    child = new XmlDiffTree(element);
                    child.setAction(XmlDiffAction.CREATE);
                    node.addChild(child);
                    this.diffElements(null, value2[x], child, filter, parentFiltered);
                }
                ++x;
            }
        }
        this.diffSimpleTypes(aspect1, aspect2, node, filter, parentFiltered);
        this.diffAttributes(aspect1, aspect2, node, filter, parentFiltered, node.hasChange());
    }

    public boolean hasDiffs() throws XmlDiffException {
        if (this.getDiffTree() == null) {
            this.executeDiff();
        }
        return this.getDiffTree().hasChange();
    }

    public void executeDiff() throws XmlDiffException {
        this._root = new XmlDiffTree(this._baseAspect.getElement());
        this.diffElements(this._baseAspect, this._patchedAspect, this._root, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, this._baseAspect, false));
        if (this.getDiffTree().hasChange()) {
            DisjointSet sets = new DisjointSet();
            int aspectOneSize = this.unionFindDisjointSet(sets);
            HashSet<DSXmlDiffAspect> diffs = this.markDiffActions(sets, aspectOneSize);
            HashSet<DSXmlDiffAspect> filteredDiffs = this.applyFilters(diffs, sets);
            this._root = this.createDiffTree(filteredDiffs, sets, aspectOneSize);
        }
    }

    private int unionFindDisjointSet(DisjointSet sets) {
        Stack<AspectPair> stack = new Stack<AspectPair>();
        int aspectOneSize = 0;
        sets.init(this._baseAspect, 0, this._root, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, this._baseAspect, false));
        aspectOneSize = sets.disjointSet.size();
        sets.init(this._patchedAspect, aspectOneSize, null, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, this._patchedAspect, false));
        sets.union(0, aspectOneSize);
        stack.push(new AspectPair(0, aspectOneSize));
        while (!stack.isEmpty()) {
            AspectPair current = (AspectPair)stack.pop();
            HashSet<String> transitions = sets.getJoinedTransitions(current);
            for (String transition : transitions) {
                int foundPatch;
                int foundBase;
                ArrayList<Integer> transitionsInBase = this.getTransition(current.x1Index, transition, sets);
                ArrayList<Integer> transitionsInPatch = this.getTransition(current.x2Index, transition, sets);
                if (transitionsInBase.size() <= 0 || transitionsInPatch.size() <= 0 || (foundBase = sets.find(transitionsInBase.get(0))) == (foundPatch = sets.find(transitionsInPatch.get(0)))) continue;
                sets.union(foundBase, foundPatch);
                stack.push(new AspectPair(transitionsInBase, transitionsInPatch));
            }
        }
        return aspectOneSize;
    }

    private XmlDiffTree createDiffTree(HashSet<DSXmlDiffAspect> diffs, DisjointSet sets, int aspectOneSize) throws XmlDiffException {
        ArrayList<DSXmlDiffAspect> tree = new ArrayList<DSXmlDiffAspect>(sets.states.values());
        XmlDiffTree rootNode = new XmlDiffTree(this._baseAspect.getElement());
        Stack<DSXmlDiffAspect> aspectStack = new Stack<DSXmlDiffAspect>();
        Stack<XmlDiffTree> diffTreeStack = new Stack<XmlDiffTree>();
        HashMap<XmlDiffTree, ArrayList<XmlDiffTreeDSPair>> createdNodesMap = new HashMap<XmlDiffTree, ArrayList<XmlDiffTreeDSPair>>();
        for (int i = 0; i < aspectOneSize; ++i) {
            DSXmlDiffAspect node = (DSXmlDiffAspect)tree.get(i);
            XmlDiffTree treenode = new XmlDiffTree(node.getValueElement(), node.action);
            XmlDiffAspect aspect = node.value;
            if (node.action.equals((Object)XmlDiffAction.MODIFY) || (Integer)sets.parentSet.get(node.id) == node.id) {
                treenode = this.diffSimpleTypes(aspect, node.modified, treenode, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, aspect, false));
                treenode = this.diffAttributes(aspect, node.modified, treenode, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, aspect, false), !treenode.getAction().equals((Object)XmlDiffAction.NONE));
            } else {
                treenode = this.diffSimpleTypes(aspect, aspect, treenode, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, aspect, false));
                treenode = this.diffAttributes(aspect, aspect, treenode, this._filter, XmlDiff.isComplexTypeFiltered(this._filter, aspect, false), false);
            }
            if ((Integer)sets.parentSet.get(node.id) == node.id) {
                rootNode = treenode;
                aspectStack.push(node);
                diffTreeStack.push(treenode);
                continue;
            }
            while (!aspectStack.isEmpty() && !((DSXmlDiffAspect)aspectStack.peek()).value.equals(((DSXmlDiffAspect)((DisjointSet)sets).states.get(((DisjointSet)sets).parentSet.get((int)node.id))).value)) {
                DSXmlDiffAspect dSXmlDiffAspect = (DSXmlDiffAspect)aspectStack.pop();
                XmlDiffTree parentNode = (XmlDiffTree)diffTreeStack.pop();
                XmlDiffTreeDSPair ch = this.addCreateNode(dSXmlDiffAspect, diffs, sets, tree);
                while (ch != null) {
                    ArrayList<XmlDiffTreeDSPair> created = (ArrayList<XmlDiffTreeDSPair>)createdNodesMap.get(parentNode);
                    if (created == null) {
                        created = new ArrayList<XmlDiffTreeDSPair>();
                        createdNodesMap.put(parentNode, created);
                    }
                    created.add(ch);
                    ch = this.addCreateNode(dSXmlDiffAspect, diffs, sets, tree);
                }
            }
            if (!diffTreeStack.isEmpty()) {
                ((XmlDiffTree)diffTreeStack.peek()).addChild(treenode);
            }
            aspectStack.push(node);
            diffTreeStack.push(treenode);
        }
        for (Map.Entry entry : createdNodesMap.entrySet()) {
            TreeMap<Integer, XmlDiffTreeDSPair> indexMap = new TreeMap<Integer, XmlDiffTreeDSPair>();
            for (XmlDiffTreeDSPair xmlDiffTreeDSPair : (List)entry.getValue()) {
                int index = -1;
                DSXmlDiffAspect diff = xmlDiffTreeDSPair.getDiff();
                XmlDiffAspect[] children = ((DSXmlDiffAspect)((DisjointSet)sets).states.get(((DisjointSet)sets).parentSet.get((int)diff.id))).value.getComplexValue(diff.getValueElement());
                if (children != null) {
                    for (int x = 0; x < children.length; ++x) {
                        if (children[x] != diff.value) continue;
                        index = x;
                        break;
                    }
                }
                if (index > -1 && !indexMap.containsKey(index)) {
                    indexMap.put(index, xmlDiffTreeDSPair);
                    continue;
                }
                ((XmlDiffTree)entry.getKey()).addChild(xmlDiffTreeDSPair.getXmlDiffTree());
            }
            for (Map.Entry entry2 : indexMap.entrySet()) {
                ((XmlDiffTree)entry.getKey()).addChild(((XmlDiffTreeDSPair)entry2.getValue()).getXmlDiffTree(), (Integer)entry2.getKey());
            }
        }
        while (!aspectStack.isEmpty() && !diffs.isEmpty()) {
            DSXmlDiffAspect parentAspect = (DSXmlDiffAspect)aspectStack.pop();
            XmlDiffTree parentNode = (XmlDiffTree)diffTreeStack.pop();
            XmlDiffTreeDSPair ch = this.addCreateNode(parentAspect, diffs, sets, tree);
            while (ch != null) {
                parentNode.addChild(ch.getXmlDiffTree());
                ch = this.addCreateNode(parentAspect, diffs, sets, tree);
            }
        }
        return rootNode;
    }

    private XmlDiffTreeDSPair addCreateNode(DSXmlDiffAspect currentAspect, HashSet<DSXmlDiffAspect> diffs, DisjointSet sets, ArrayList<DSXmlDiffAspect> tree) throws XmlDiffException {
        Iterator<DSXmlDiffAspect> it = diffs.iterator();
        while (it.hasNext()) {
            DSXmlDiffAspect diffParent;
            DSXmlDiffAspect diff = it.next();
            DSXmlDiffAspect dSXmlDiffAspect = diffParent = (Integer)sets.parentSet.get(diff.id) != diff.id ? (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(diff.id)) : null;
            while (diffParent != null && (Integer)sets.disjointSet.get(diffParent.id) != diffParent.id) {
                diffParent = tree.get((Integer)sets.disjointSet.get(diffParent.id));
            }
            if (diff.action.equals((Object)XmlDiffAction.CREATE)) {
                Object value;
                int diffParentAspect = (Integer)sets.disjointSet.get(diffParent.id);
                int diffCurrentAspect = (Integer)sets.disjointSet.get(currentAspect.id);
                if (diffParent == null || diffParentAspect != diffCurrentAspect) continue;
                XmlDiffTreeDSPair ch = new XmlDiffTreeDSPair(new XmlDiffTree(diff.getValueElement(), diff.action), diff);
                for (String attribute : diff.value.getAttributeNames()) {
                    value = diff.value.getAttributeValue(attribute);
                    if (value == null) continue;
                    ch.getXmlDiffTree().addAttribute(attribute, diff.value.getAttributeType(attribute), null, value, XmlDiffAction.CREATE);
                }
                for (String simpletype : diff.value.getSimpleNames()) {
                    value = diff.value.getSimpleValue(simpletype);
                    if (value == null) continue;
                    ch.getXmlDiffTree().addSimpleType(simpletype, diff.value.getSimpleType(simpletype), null, value, XmlDiffAction.CREATE);
                }
                it.remove();
                XmlDiffTreeDSPair grch = this.addCreateNode(diff, diffs, sets, tree);
                while (grch != null) {
                    ch.getXmlDiffTree().addChild(grch.getXmlDiffTree());
                    grch = this.addCreateNode(diff, diffs, sets, tree);
                }
                return ch;
            }
            it.remove();
        }
        return null;
    }

    private HashSet<DSXmlDiffAspect> markDiffActions(DisjointSet sets, int aspectOneSize) throws XmlDiffException {
        HashSet<DSXmlDiffAspect> diffElements = new HashSet<DSXmlDiffAspect>();
        if (this._baseAspect != this._patchedAspect) {
            DSXmlDiffAspect treeset;
            int set;
            int[] setCounts = this.getSetCounts(sets, aspectOneSize);
            sets.resetValues();
            ((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)0))).modified = ((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)aspectOneSize))).value;
            HashMap<Integer, HashSet<Integer>> modified = this.getModifiedElements(aspectOneSize, setCounts, sets);
            for (set = 0; set < aspectOneSize; ++set) {
                HashSet<Integer> newModified;
                if (setCounts[set] == 0) continue;
                treeset = (DSXmlDiffAspect)sets.states.get(set);
                int min = treeset.trans.length();
                int modmin = set;
                HashSet<Integer> modifiedMap = modified.get(sets.parentSet.get(set));
                if (modifiedMap != null) {
                    for (Integer mod : modifiedMap) {
                        Integer diffParent = (Integer)sets.parentSet.get(set);
                        Integer modParent = (Integer)sets.parentSet.get(mod);
                        String modTrans = ((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)mod)).trans;
                        if (!((DSXmlDiffAspect)sets.states.get(mod)).getValueElement().equals(treeset.getValueElement()) || !((Integer)sets.disjointSet.get(diffParent)).equals(sets.disjointSet.get(modParent))) continue;
                        if (modifiedMap.size() >= 2) {
                            if (treeset.trans.equals(modTrans)) {
                                min = 0;
                                modmin = mod;
                                break;
                            }
                            int mindistance = this.stringDistance(treeset.trans, modTrans);
                            if (min <= mindistance) continue;
                            min = mindistance;
                            modmin = mod;
                            continue;
                        }
                        modmin = mod;
                        if (!treeset.trans.equals(modTrans)) continue;
                        min = 0;
                        break;
                    }
                }
                if (modmin == set) continue;
                if (min == 0) {
                    treeset.setAction(XmlDiffAction.NONE);
                    setCounts[set] = 0;
                } else {
                    treeset.setAction(XmlDiffAction.MODIFY);
                    treeset.modified = ((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)modmin))).value;
                    int n = set;
                    setCounts[n] = setCounts[n] - 1;
                }
                sets.disjointSet.remove(modmin);
                sets.disjointSet.add(modmin, set);
                ((DSXmlDiffAspect)sets.states.get(modmin)).setAction(XmlDiffAction.NONE);
                modifiedMap.remove(modmin);
                if (modifiedMap.isEmpty()) {
                    modified.remove(sets.parentSet.get(set));
                }
                if ((newModified = modified.get(modmin)) != null) {
                    modified.put(set, newModified);
                    modified.remove(modmin);
                }
                setCounts[modmin] = 0;
            }
            for (set = 0; set < setCounts.length; ++set) {
                String id1;
                if (setCounts[set] == 0) continue;
                treeset = (DSXmlDiffAspect)sets.states.get(set);
                if (treeset.value.hasAttributeName(this._idKey) && !StringUtil.isNullOrEmpty(id1 = this.getStringAttributeValue(((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)set))).value, this._idKey))) {
                    for (DSXmlDiffAspect diffElement : diffElements) {
                        if (!id1.equals(this.getStringAttributeValue(diffElement.value, this._idKey))) continue;
                        ((DSXmlDiffAspect)sets.states.get(set)).setAction(XmlDiffAction.MODIFY);
                        ((DSXmlDiffAspect)sets.states.get(diffElement.id)).setAction(XmlDiffAction.MODIFY);
                    }
                }
                diffElements.add(treeset);
            }
        }
        return diffElements;
    }

    private HashSet<DSXmlDiffAspect> applyFilters(HashSet<DSXmlDiffAspect> diffs, DisjointSet sets) {
        HashSet<DSXmlDiffAspect> diffElements = new HashSet<DSXmlDiffAspect>();
        HashSet<Integer> filtered = new HashSet<Integer>();
        HashSet<Integer> mustIncude = new HashSet<Integer>();
        for (DSXmlDiffAspect treeset : diffs) {
            if (this.isAspectFiltered(filtered, mustIncude, treeset, sets)) {
                treeset.setAction(XmlDiffAction.NONE);
                continue;
            }
            diffElements.add(treeset);
        }
        return diffElements;
    }

    private int[] getSetCounts(DisjointSet sets, int aspectOneSize) {
        int[] setCounts = new int[sets.disjointSet.size()];
        for (Map.Entry entry : sets.states.entrySet()) {
            int tree = (Integer)entry.getKey();
            DSXmlDiffAspect treeParent = (DSXmlDiffAspect)sets.states.get(sets.find(tree));
            DSXmlDiffAspect entryValue = (DSXmlDiffAspect)sets.states.get(tree);
            int leaves = this.getAspectSize(treeParent.id, sets);
            int finalTrees = this.getAspectSize(entryValue.id, sets);
            if (leaves != 0 || finalTrees != 0) continue;
            int count = (Integer)sets.disjointSet.get(treeParent.id);
            if (((DSXmlDiffAspect)entry.getValue()).id >= aspectOneSize) {
                int n = count;
                setCounts[n] = setCounts[n] + 1;
                if (setCounts[count] >= 0) {
                    treeParent.setAction(XmlDiffAction.CREATE);
                }
            } else {
                int n = count;
                setCounts[n] = setCounts[n] - 1;
                if (setCounts[count] <= 0) {
                    treeParent.setAction(XmlDiffAction.DELETE);
                }
            }
            if (setCounts[count] != 0) continue;
            treeParent.setAction(XmlDiffAction.NONE);
        }
        return setCounts;
    }

    private HashMap<Integer, HashSet<Integer>> getModifiedElements(int aspectOneSize, int[] setCounts, DisjointSet sets) {
        int set;
        HashMap<Integer, HashSet<Integer>> modified = new HashMap<Integer, HashSet<Integer>>();
        for (set = aspectOneSize; set < setCounts.length; ++set) {
            if (setCounts[set] == 0) continue;
            DSXmlDiffAspect treeset = (DSXmlDiffAspect)sets.states.get(set);
            if (!treeset.action.equals((Object)XmlDiffAction.CREATE)) continue;
            HashSet<Integer> modifiedMap = modified.get(sets.disjointSet.get((Integer)sets.parentSet.get(treeset.id)));
            if (modifiedMap == null) {
                modifiedMap = new HashSet();
            }
            modifiedMap.add(set);
            modified.put((Integer)sets.disjointSet.get((Integer)sets.parentSet.get(treeset.id)), modifiedMap);
            DSXmlDiffAspect currentParent = (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(treeset.id));
            while (currentParent != null && (Integer)sets.disjointSet.get(currentParent.id) != currentParent.id) {
                currentParent = (DSXmlDiffAspect)sets.states.get(sets.disjointSet.get(currentParent.id));
            }
            while (currentParent != null && (Integer)sets.disjointSet.get(currentParent.id) > aspectOneSize && currentParent.action != XmlDiffAction.CREATE) {
                currentParent.setAction(XmlDiffAction.CREATE);
                HashSet<Integer> modifiedParentMap = modified.get(sets.disjointSet.get((Integer)sets.parentSet.get(currentParent.id)));
                if (modifiedParentMap == null) {
                    modifiedParentMap = new HashSet();
                }
                modifiedParentMap.add((Integer)sets.disjointSet.get(currentParent.id));
                modified.put((Integer)sets.disjointSet.get((Integer)sets.parentSet.get(currentParent.id)), modifiedParentMap);
                int n = currentParent.id;
                setCounts[n] = setCounts[n] + 1;
                currentParent = (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(currentParent.id));
            }
        }
        for (set = 0; set < aspectOneSize; ++set) {
            if (setCounts[set] == 0 || !((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)set))).action.equals((Object)XmlDiffAction.DELETE)) continue;
            DSXmlDiffAspect currentParent = (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)set))).id));
            boolean allChildrenDeleted = true;
            while (allChildrenDeleted && currentParent != null && (Integer)sets.parentSet.get(currentParent.id) != currentParent.id && currentParent.action != XmlDiffAction.DELETE) {
                allChildrenDeleted = true;
                for (int element = 0; element < sets.parentSet.size() && allChildrenDeleted; ++element) {
                    if ((Integer)sets.parentSet.get(element) != currentParent.id || ((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)Integer.valueOf((int)element))).action.equals((Object)XmlDiffAction.DELETE)) continue;
                    allChildrenDeleted = false;
                }
                if (allChildrenDeleted) {
                    for (Map.Entry<Integer, HashSet<Integer>> modifiedMap : modified.entrySet()) {
                        for (Integer mod : modifiedMap.getValue()) {
                            DSXmlDiffAspect addedParent = (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(((DSXmlDiffAspect)((DisjointSet)sets).states.get((Object)mod)).id));
                            if (sets.disjointSet.get(addedParent.id) != sets.disjointSet.get(currentParent.id)) continue;
                            allChildrenDeleted = false;
                        }
                    }
                }
                if (!allChildrenDeleted) continue;
                currentParent.setAction(XmlDiffAction.DELETE);
                int n = currentParent.id;
                setCounts[n] = setCounts[n] - 1;
                currentParent = (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(currentParent.id));
            }
        }
        return modified;
    }

    private boolean isExcluded(DSXmlDiffAspect aspect, DisjointSet sets, Set<Integer> filteredElements) {
        boolean filtered = false;
        DSXmlDiffAspect parent = aspect;
        while (parent != null && !filtered) {
            if (filteredElements.contains(parent.id) || this._filter.excludeComplexElement(parent.value)) {
                filtered = true;
                filteredElements.add(aspect.id);
                filteredElements.add(parent.id);
            }
            if (parent.id != (Integer)sets.parentSet.get(parent.id)) {
                parent = (DSXmlDiffAspect)sets.states.get(sets.parentSet.get(parent.id));
                continue;
            }
            parent = null;
        }
        return filtered;
    }

    private boolean isAspectFiltered(Set<Integer> filteredElements, Set<Integer> mustIncludeElements, DSXmlDiffAspect aspect, DisjointSet sets) {
        boolean filtered = false;
        if (this._filter.hasExcludeRules() || this._filter.hasIncludeRules()) {
            if (filteredElements.contains(aspect.id) && !mustIncludeElements.contains(aspect.id)) {
                return true;
            }
            if (this._filter.hasExcludeRules() && this.isExcluded(aspect, sets, filteredElements)) {
                filtered = true;
            }
            if (this._filter.hasIncludeRules()) {
                if (mustIncludeElements.contains(aspect) || this._filter.includeComplexElement(aspect.value)) {
                    mustIncludeElements.add(aspect.id);
                    return false;
                }
                for (String simple : aspect.value.getSimpleNames()) {
                    Object simpleValues = aspect.value.getSimpleValue(simple);
                    if (!this._filter.includeSimpleElement(simple, simpleValues)) continue;
                    mustIncludeElements.add(aspect.id);
                    return false;
                }
            }
        }
        return filtered;
    }

    private int getAspectSize(int aspectId, DisjointSet sets) {
        HashSet nextElements = new HashSet();
        for (Map.Entry elements : ((HashMap)sets.transitionFunctions.get(aspectId)).entrySet()) {
            nextElements.addAll((Collection)elements.getValue());
        }
        return nextElements.size();
    }

    private int stringDistance(String s0, String s1) {
        int len1;
        if (s0.equals(s1)) {
            return 0;
        }
        int len0 = s0.length() + 1;
        if (len0 * (len1 = s1.length() + 1) > 10000) {
            int dist = Math.abs(len0 - len1);
            if (dist == 0 && !s0.equals(s1)) {
                dist = 1;
            }
            return dist;
        }
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        for (int j = 1; j < len1; ++j) {
            newcost[0] = j;
            for (int i = 1; i < len0; ++i) {
                int match = s0.charAt(i - 1) == s1.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i - 1] + match;
                int cost_insert = cost[i] + 1;
                int cost_delete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }

    private ArrayList<Integer> getTransition(ArrayList<Integer> tree, String transition, DisjointSet sets) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer t : tree) {
            HashMap trans = (HashMap)sets.transitionFunctions.get(t);
            if (trans == null || trans.get(transition) == null) continue;
            result.addAll((Collection)trans.get(transition));
        }
        return result;
    }

    protected Set<String> getComplexNames(XmlDiffAspect aspect1, XmlDiffAspect aspect2) {
        String[] aspectNames2;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String[] aspectNames1 = aspect1 != null ? aspect1.getComplexNames() : null;
        String[] stringArray = aspectNames2 = aspect2 != null ? aspect2.getComplexNames() : null;
        if (aspectNames1 != null && aspectNames1.length > 0) {
            names.addAll(Arrays.asList(aspectNames1));
        }
        if (aspectNames2 != null && aspectNames2.length > 0) {
            names.addAll(Arrays.asList(aspectNames2));
        }
        return names;
    }

    private static boolean isSimpleTypeFiltered(XmlDiffTreeFilter filter, String element, Object value, boolean parentFiltered) {
        return parentFiltered && !filter.includeSimpleElement(element, value) || !parentFiltered && filter.excludeSimpleElement(element, value);
    }

    private static boolean isComplexTypeFiltered(XmlDiffTreeFilter filter, XmlDiffAspect aspect, boolean parentFiltered) {
        return parentFiltered && !filter.includeComplexElement(aspect) || !parentFiltered && filter.excludeComplexElement(aspect);
    }

    private String getStringAttributeValue(XmlDiffAspect aspect, String attributeName) throws XmlDiffException {
        Object value = aspect.getAttributeValue(attributeName);
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            throw new XmlDiffException("The value for attribute " + attributeName + " was not of type String for aspect " + aspect);
        }
        return null;
    }

    protected XmlDiffTree diffSimpleTypes(XmlDiffAspect aspect1, XmlDiffAspect aspect2, XmlDiffTree node, XmlDiffTreeFilter filter, boolean parentFiltered) throws XmlDiffException {
        if (aspect1 == null && aspect2 == null) {
            throw new IllegalArgumentException("Both aspects being diffed may not be null.");
        }
        XmlDiffAspect queryAspect = aspect1 != null ? aspect1 : aspect2;
        Set<String> simpleElements = this.getSimpleNames(aspect1, aspect2);
        boolean hasChanges = false;
        for (String element : simpleElements) {
            Object value2;
            Object value1 = aspect1 != null && aspect1.hasSimpleName(element) ? aspect1.getSimpleValue(element) : null;
            Object object = value2 = aspect2 != null && aspect2.hasSimpleName(element) ? aspect2.getSimpleValue(element) : null;
            if (value1 == null && value2 == null) continue;
            if (value1 != null) {
                if (XmlDiff.isSimpleTypeFiltered(filter, element, value1, parentFiltered) || value2 != null && XmlDiff.valuesEqual(value1, value2)) {
                    node.addSimpleType(element, queryAspect.getSimpleType(element), value1, value1, XmlDiffAction.NONE);
                    continue;
                }
                if (value2 == null || node.getAction().isDelete()) {
                    node.addSimpleType(element, queryAspect.getSimpleType(element), value1, value2, XmlDiffAction.DELETE);
                    hasChanges = true;
                    continue;
                }
                node.addSimpleType(element, queryAspect.getSimpleType(element), value1, value2, XmlDiffAction.MODIFY);
                hasChanges = true;
                continue;
            }
            if (XmlDiff.isSimpleTypeFiltered(filter, element, value2, parentFiltered)) continue;
            node.addSimpleType(element, queryAspect.getSimpleType(element), value1, value2, XmlDiffAction.CREATE);
            hasChanges = true;
        }
        if (hasChanges) {
            if (node.getAction().equals((Object)XmlDiffAction.NONE)) {
                node.setAction(XmlDiffAction.MODIFY);
            }
        } else if (!node.getAction().equals((Object)XmlDiffAction.DELETE) && !node.getAction().equals((Object)XmlDiffAction.CREATE)) {
            node.setAction(XmlDiffAction.NONE);
        }
        return node;
    }

    protected Set<String> getSimpleNames(XmlDiffAspect aspect1, XmlDiffAspect aspect2) {
        String[] aspectNames2;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String[] aspectNames1 = aspect1 != null ? aspect1.getSimpleNames() : null;
        String[] stringArray = aspectNames2 = aspect2 != null ? aspect2.getSimpleNames() : null;
        if (aspectNames1 != null && aspectNames1.length > 0) {
            names.addAll(Arrays.asList(aspectNames1));
        }
        if (aspectNames2 != null && aspectNames2.length > 0) {
            names.addAll(Arrays.asList(aspectNames2));
        }
        return names;
    }

    protected XmlDiffTree diffAttributes(XmlDiffAspect aspect1, XmlDiffAspect aspect2, XmlDiffTree node, XmlDiffTreeFilter filter, boolean parentFiltered, boolean hasChanges) throws XmlDiffException {
        if (aspect1 == null && aspect2 == null) {
            throw new IllegalArgumentException("Both aspects being diffed may not be null.");
        }
        XmlDiffAspect queryAspect = aspect1 != null ? aspect1 : aspect2;
        Set<String> attributes = this.getAttributeNames(aspect1, aspect2);
        for (String attrib : attributes) {
            Object value2;
            Object value1 = aspect1 != null && aspect1.hasAttributeName(attrib) ? aspect1.getAttributeValue(attrib) : null;
            Object object = value2 = aspect2 != null && aspect2.hasAttributeName(attrib) ? aspect2.getAttributeValue(attrib) : null;
            if (value1 == null && value2 == null) continue;
            XmlDiffAction action = XmlDiffAction.NONE;
            if (!(parentFiltered || filter != null && filter.excludeAttribute(aspect1 != null ? aspect1 : aspect2, attrib))) {
                if (node.getAction() == XmlDiffAction.DELETE) {
                    action = XmlDiffAction.DELETE;
                    hasChanges = true;
                } else if (value1 == null) {
                    action = XmlDiffAction.CREATE;
                    hasChanges = true;
                } else if (value2 == null) {
                    action = XmlDiffAction.DELETE;
                    hasChanges = true;
                } else if (!XmlDiff.valuesEqual(value1, value2)) {
                    action = XmlDiffAction.MODIFY;
                    hasChanges = true;
                }
                node.addAttribute(attrib, queryAspect.getAttributeType(attrib), value1, value2, action);
                continue;
            }
            node.addAttribute(attrib, queryAspect.getAttributeType(attrib), value1, value1, action);
        }
        if (hasChanges) {
            if (node.getAction().equals((Object)XmlDiffAction.NONE)) {
                node.setAction(XmlDiffAction.MODIFY);
            }
        } else if (!node.getAction().equals((Object)XmlDiffAction.DELETE)) {
            node.setAction(XmlDiffAction.NONE);
        }
        return node;
    }

    protected Set<String> getAttributeNames(XmlDiffAspect aspect1, XmlDiffAspect aspect2) {
        String[] aspectNames2;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        String[] aspectNames1 = aspect1 != null ? aspect1.getAttributeNames() : null;
        String[] stringArray = aspectNames2 = aspect2 != null ? aspect2.getAttributeNames() : null;
        if (aspectNames1 != null && aspectNames1.length > 0) {
            names.addAll(Arrays.asList(aspectNames1));
        }
        if (aspectNames2 != null && aspectNames2.length > 0) {
            names.addAll(Arrays.asList(aspectNames2));
        }
        return names;
    }

    protected static boolean valuesEqual(Object value1, Object value2) {
        if ((value1 instanceof XMLGregorianCalendar || value1 instanceof GregorianCalendar) && (value2 instanceof XMLGregorianCalendar || value2 instanceof GregorianCalendar)) {
            GregorianCalendar v1 = value1 instanceof XMLGregorianCalendar ? ((XMLGregorianCalendar)value1).toGregorianCalendar() : (GregorianCalendar)value1;
            GregorianCalendar v2 = value2 instanceof XMLGregorianCalendar ? ((XMLGregorianCalendar)value2).toGregorianCalendar() : (GregorianCalendar)value2;
            return v1.compareTo(v2) == 0;
        }
        if (value1.getClass().isArray() && value2.getClass().isArray()) {
            Object[] valueArray1 = (Object[])value1;
            Object[] valueArray2 = (Object[])value2;
            if (valueArray1.length != valueArray2.length) {
                return false;
            }
            for (int i = 0; i < valueArray1.length; ++i) {
                if (XmlDiff.valuesEqual(valueArray1[i], valueArray2[i])) continue;
                return false;
            }
            return true;
        }
        return value1.equals(value2);
    }

    private static class DisjointSet {
        private List<Integer> disjointSet = new ArrayList<Integer>();
        private List<Integer> rank = new ArrayList<Integer>();
        private List<Integer> parentSet = new ArrayList<Integer>();
        private Map<Integer, DSXmlDiffAspect> states = new LinkedHashMap<Integer, DSXmlDiffAspect>();
        private Map<Integer, HashMap<String, LinkedList<Integer>>> transitionFunctions = new HashMap<Integer, HashMap<String, LinkedList<Integer>>>();

        private DisjointSet() {
        }

        public HashSet<String> getJoinedTransitions(AspectPair current) {
            HashSet<String> trans = new HashSet<String>();
            for (int x1 : current.x1Index) {
                trans.addAll(this.transitionFunctions.get(x1).keySet());
            }
            for (int x2 : current.x2Index) {
                trans.addAll(this.transitionFunctions.get(x2).keySet());
            }
            return trans;
        }

        public int find(int p) {
            while (p != this.disjointSet.get(p)) {
                p = this.disjointSet.get(p);
            }
            return p;
        }

        public void union(int base, int patch) {
            int root2;
            int root1 = this.find(base);
            if (root1 != (root2 = this.find(patch))) {
                if (this.rank.get(root1) > this.rank.get(root2)) {
                    this.disjointSet.remove(root1);
                    this.disjointSet.add(root1, root2);
                    int newrank = this.rank.get(root1) + this.rank.get(root2);
                    this.rank.remove(root2);
                    this.rank.add(root2, newrank);
                } else {
                    this.disjointSet.remove(root2);
                    this.disjointSet.add(root2, root1);
                    int newrank = this.rank.get(root1) + this.rank.get(root2);
                    this.rank.remove(root1);
                    this.rank.add(root1, newrank);
                }
            }
        }

        public DSXmlDiffAspect init(XmlDiffAspect aspect, int parentAspect, XmlDiffTree node, XmlDiffTreeFilter filter, boolean parentFilter) {
            if (aspect != null) {
                int id = this.disjointSet.size();
                DSXmlDiffAspect dsSet = new DSXmlDiffAspect(aspect, 0, id, filter, parentFilter);
                this.parentSet.add(parentAspect);
                this.disjointSet.add(id);
                this.rank.add(1);
                this.states.put(id, dsSet);
                HashSet<String> transToNextElement = new HashSet<String>();
                HashMap<String, LinkedList<Integer>> transitionToNextElement = new HashMap<String, LinkedList<Integer>>();
                for (String complexElement : aspect.getComplexNames()) {
                    XmlDiffAspect[] elements = aspect.getComplexValue(complexElement);
                    if (elements == null) continue;
                    for (XmlDiffAspect element : elements) {
                        XmlDiffTree child = new XmlDiffTree(element.getElement());
                        if (node != null) {
                            node.addChild(child);
                        }
                        DSXmlDiffAspect chSet = this.init(element, id, child, filter, parentFilter);
                        transToNextElement.add(chSet.trans);
                        LinkedList<Integer> nextState = (LinkedList<Integer>)transitionToNextElement.get(chSet.trans);
                        if (nextState == null) {
                            nextState = new LinkedList<Integer>();
                        }
                        nextState.add(chSet.id);
                        transitionToNextElement.put(chSet.trans, nextState);
                    }
                }
                this.transitionFunctions.put(dsSet.id, transitionToNextElement);
                return dsSet;
            }
            return null;
        }

        public static String transition(XmlDiffAspect aspect, XmlDiffTreeFilter filter, boolean parentFiltered) {
            StringBuffer trans = new StringBuffer();
            trans.append(aspect.getElement());
            Object[] attributes = aspect.getAttributeNames();
            Object[] values = aspect.getSimpleNames();
            Arrays.sort(attributes);
            Arrays.sort(values);
            for (Object attribute : attributes) {
                trans.append(",");
                trans.append((String)attribute);
                trans.append("=");
                trans.append(aspect.getAttributeValue((String)attribute));
            }
            for (Object value : values) {
                if (XmlDiff.isSimpleTypeFiltered(filter, aspect.getElement(), value, parentFiltered)) continue;
                trans.append(",");
                trans.append((String)value);
                trans.append("=");
                Object simpleVal = aspect.getSimpleValue((String)value);
                if (simpleVal instanceof String[]) {
                    Object[] simpleValues = (String[])simpleVal;
                    Arrays.sort(simpleValues);
                    trans.append("{");
                    for (Object val : simpleValues) {
                        trans.append(",");
                        trans.append((String)val);
                    }
                    trans.append("}");
                    continue;
                }
                trans.append(simpleVal);
            }
            return trans.toString();
        }

        public void resetValues() {
            for (Map.Entry<Integer, DSXmlDiffAspect> entry : this.states.entrySet()) {
                entry.getValue().value = this.states.get((Object)entry.getKey()).value;
            }
        }
    }

    private static class DSXmlDiffAspect
    implements Comparator<DSXmlDiffAspect> {
        int id;
        XmlDiffAspect value;
        XmlDiffAction action;
        String trans;
        XmlDiffAspect modified;

        public DSXmlDiffAspect(XmlDiffAspect xmlDiffAspect, int rank, int id, XmlDiffTreeFilter filter, boolean parentFiltered) {
            this.value = xmlDiffAspect;
            this.id = id;
            this.action = XmlDiffAction.NONE;
            this.trans = DisjointSet.transition(xmlDiffAspect, filter, parentFiltered);
        }

        public String toString() {
            return this.id + "-" + (Object)((Object)this.action);
        }

        @Override
        public int compare(DSXmlDiffAspect o1, DSXmlDiffAspect o2) {
            return new Integer(o1.id).compareTo(o2.id);
        }

        public String getValueElement() {
            return this.value.getElement();
        }

        public void setAction(XmlDiffAction action) {
            this.action = action;
        }
    }

    private class AspectPair {
        ArrayList<Integer> x1Index;
        ArrayList<Integer> x2Index;

        public AspectPair(int x1Id, int x2Id) {
            this.x1Index = new ArrayList();
            this.x1Index.add(x1Id);
            this.x2Index = new ArrayList();
            this.x2Index.add(x2Id);
        }

        public AspectPair(ArrayList<Integer> x1Index, ArrayList<Integer> x2Index) {
            this.x1Index = x1Index;
            this.x2Index = x2Index;
        }

        public String toString() {
            return "{" + this.x1Index + "," + this.x2Index + "}";
        }
    }

    class XmlDiffTreeDSPair {
        XmlDiffTree _xmlDiffTree;
        DSXmlDiffAspect _diff;

        public XmlDiffTreeDSPair(XmlDiffTree xmlDiffTree, DSXmlDiffAspect diff) {
            this._xmlDiffTree = xmlDiffTree;
            this._diff = diff;
        }

        public XmlDiffTree getXmlDiffTree() {
            return this._xmlDiffTree;
        }

        public DSXmlDiffAspect getDiff() {
            return this._diff;
        }
    }
}

