/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.engineeredsystem;

import dbmodel.bundle_xml.Subpatch;
import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.patchmodel.PatchingTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.dbsysmodel.engineeredsystem.HashComputeFunction;

public class InventoryAndActionOnlyV2
extends HashComputeFunction {
    @Override
    protected List<String> fileList(String patchLocation, SystemPatchBundleXML bundleXml) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (Subpatch subPatch : bundleXml.getSubpatches()) {
            if (subPatch.getPatchingTool() != PatchingTool.OPATCH) continue;
            String subPatchLoc = subPatch.getLocation();
            String subPatchAbsLoc = patchLocation + File.separator + subPatchLoc;
            if (EngineeredSystemPatchValidatorAndGenerator.IsSubPatchCompositePatch(subPatchAbsLoc)) {
                File compositePatchDir = new File(subPatchAbsLoc);
                if (!compositePatchDir.exists()) continue;
                for (File sp : compositePatchDir.listFiles()) {
                    if (!sp.isDirectory()) continue;
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).getAbsolutePath());
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).getAbsolutePath());
                }
                continue;
            }
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).getAbsolutePath());
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).getAbsolutePath());
        }
        return metaList;
    }
}

