/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.oplan.core.readme.TextReadmeGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMultiReadmeGenerator
extends TextReadmeGenerator {
    private static final Class c = TextMultiReadmeGenerator.class;
    private static final String autoFile = "OPatchAuto_InstallInstructions.txt";
    private static final String manualFile = "Manual_InstallInstructions.txt";

    public TextMultiReadmeGenerator(ReadmeFactory rf) {
        super(rf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> generateReadme() throws IOException {
        ArrayList<File> readmeList = new ArrayList<File>();
        List<Set<String>> splitHostList = this.rf.getSplitHostList();
        for (int i = 0; i < splitHostList.size(); ++i) {
            Set<String> filterHosts = splitHostList.get(i);
            this.setCurrentFilterHosts(filterHosts);
            File readme = null;
            readme = this.rf.isSplit() ? this.getReadmeFile(i + 1) : this.getReadmeFile();
            assert (!readme.isFile());
            this.generateConfigImageFile();
            FileWriter fw = new FileWriter(readme);
            try {
                this.arrangePlansOrder();
                ExecutionPlan singleEP = ExeuctionPlanUtil.first(this.allPlans);
                boolean old = this.subReadmeFile;
                this.writeProductName(fw);
                this.subReadmeFile = false;
                this.writeTitle(fw, singleEP);
                this.subReadmeFile = old;
                this.writeTraditionalReadmeNotice(fw);
                this.writeUseHTML(fw, readme);
                this.writeConfigImage(fw, singleEP);
                fw.write("\n\n");
                this.writePlansBlurb(fw, ExeuctionPlanUtil.applyNswitchbacks(this.allPlans));
                this.writePlansBlurb(fw, ExeuctionPlanUtil.rollbacks(this.allPlans));
                this.writeFullPlans(fw, ExeuctionPlanUtil.applyNswitchbacks(this.allPlans));
                this.writeFullPlans(fw, ExeuctionPlanUtil.rollbacks(this.allPlans));
                this.writeCopyRight(fw);
                fw.write("\n\n");
            }
            finally {
                fw.close();
            }
            readmeList.add(readme);
        }
        return readmeList;
    }

    protected void writePlansBlurb(FileWriter fw, List<ExecutionPlan> plans) throws IOException {
        if (plans.isEmpty()) {
            return;
        }
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plans.get(0));
        String msg = OPlanBundle.getReadmeMessage("AVAILABLE_" + operation + "_STRATEGY", "", "");
        fw.write("\n\n");
        fw.write(msg + "\n" + TextMultiReadmeGenerator.underline(msg));
        fw.write("\n\n");
        for (ExecutionPlan plan : plans) {
            this.writePlanBlurb(fw, plan, true, true);
        }
    }

    protected void _writePlanBlurb(FileWriter fw, ExecutionPlan plan) throws IOException {
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plan);
        String title = OPlanBundle.getPrefixedMessage(this.getClass(), ReadmeFactory.getStrategyBundlePrefixKey(plan), operation + "_TITLE", "", "");
        fw.write("\t* " + title + ": \n\t " + TextMultiReadmeGenerator.underline(title));
        fw.write("\n");
        fw.write("\t\t");
        String str = OPlanBundle.getPrefixedMessage(this.getClass(), ReadmeFactory.getStrategyBundlePrefixKey(plan), operation + "_MESSAGE", "'", plan.getAllStepsCount(), "'");
        fw.write(str);
        fw.write("\n");
        str = OPlanBundle.getReadmeMessage("REFER_TO_DETAILED", title, this.rf.getFileForTxtInstructions(plan).getAbsolutePath());
        fw.write(str);
        fw.write("\n\n");
    }

    protected void writeFullPlans(FileWriter fw, List<ExecutionPlan> plans) throws IOException {
        boolean old = this.subReadmeFile;
        this.subReadmeFile = true;
        for (ExecutionPlan plan : plans) {
            this.writeOnePlan(this.rf.getFileForTxtInstructions(plan), plan);
        }
        this.subReadmeFile = old;
    }
}

