/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.CommandActionType;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyHome
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(CopyHome.class.getName());

    public CopyHome(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<OracleHome> clones = OPlan.getInstance().getMakeCloneHome().getHomeClone(oh);
        for (OracleHome clone : clones) {
            String clonePath = clone.getPath();
            while (clonePath.lastIndexOf("/") == clonePath.length() - 1) {
                clonePath = clonePath.substring(0, clonePath.length() - 1);
            }
            cmds.add("mkdir -p " + clonePath.substring(0, clonePath.lastIndexOf("/")));
            cmds.add("cp -pR " + oh.getPath() + " " + clone.getPath());
        }
        return cmds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<CopyHome> {
        @Override
        public CopyHome getCommand(ActionType a, Strategy s) {
            Logger logger = Logger.getLogger(CopyHome.class.getName());
            logger.log(Level.FINEST, "In construct");
            if (!(a instanceof CommandAction) || !a.getType().equals(CommandActionType.CopyHome.toString())) {
                return null;
            }
            CopyHome ch = new CopyHome(a);
            return ch;
        }
    }
}

