/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cookies;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.common.OracleHome;
import oracle.oplan.sdk.cookies.CloneCookie;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeCloneHome {
    final Logger logger = Logger.getLogger(MakeCloneHome.class.getName());
    final int MAX_NO_OF_ITERATIONS = 15;
    protected ProductDriver productDriver;
    protected ConfigGraph graph;
    LocalInfo localInfo;
    Map<String, String> clonePathMap = new HashMap<String, String>();
    protected Map<OracleHome, List<OracleHome>> cloneMap = new HashMap<OracleHome, List<OracleHome>>();
    Set<String> homePaths = null;
    Map<String, String> cloneNameMap = new HashMap<String, String>();
    Set<String> homeNames = null;

    public MakeCloneHome(ConfigGraph cg, LocalInfo localInfo) {
        this.graph = cg;
        this.localInfo = localInfo;
    }

    @Deprecated
    public MakeCloneHome(ProductDriver pd, ConfigGraph cg) {
        this.productDriver = pd;
        this.graph = cg;
        this.localInfo = pd.getLocalInfo();
    }

    public List<OracleHome> getHomeClone(OracleHome oh) {
        if (this.cloneMap.containsKey(oh)) {
            return this.cloneMap.get(oh);
        }
        this.logger.finest("Creating clone of " + oh.getPath());
        ArrayList<OracleHome> cloneHomes = new ArrayList<OracleHome>();
        if (oh.getProperty(CloneCookie.class) != null) {
            if (((CloneCookie)oh.getProperty(CloneCookie.class)).getClonePath() == null) {
                throw new ProductDriverException("CloneCookie should not be set with a null clone path.");
            }
            this.addCloneHome(cloneHomes, oh, ((CloneCookie)oh.getProperty(CloneCookie.class)).getCloneName(), ((CloneCookie)oh.getProperty(CloneCookie.class)).getClonePath(), ((CloneCookie)oh.getProperty(CloneCookie.class)).getCloneOracleBaseLocation());
        } else {
            this.addCloneHome(cloneHomes, oh, this.subCloneHomeName(oh.getHomeName()), this.subCloneHomeDir(oh.getPath()), null);
        }
        this.cloneMap.put(oh, cloneHomes);
        return cloneHomes;
    }

    protected void addCloneHome(List<OracleHome> cloneHomes, OracleHome oh, String cloneName, String clonePath, String cloneOracleBaseLocation) {
        for (OracleHome cloneHome : cloneHomes) {
            if (!cloneHome.getPath().equalsIgnoreCase(clonePath)) continue;
            return;
        }
        OracleHome clone = this.copyHome(oh);
        if (cloneName == null || cloneName == "") {
            cloneName = oh.getHomeName() + "_clone";
        }
        clone.setName(cloneName);
        clone.setDescription("Clone of " + oh.getHomeName());
        clone.setHomeName(cloneName);
        clone.setDisplayName(cloneName);
        clone.setPath(clonePath);
        clone.setOriginalOracleHome(oh);
        if (cloneOracleBaseLocation != null) {
            clone.setOracleBaseLocation(cloneOracleBaseLocation);
        }
        cloneHomes.add(clone);
    }

    public String subCloneHomeDir(String original_path) {
        if (this.homePaths == null) {
            this.homePaths = new HashSet<String>();
            for (OracleHome oh : this.localInfo.getOracleHomes()) {
                this.homePaths.add(oh.getPath());
            }
        }
        if (this.clonePathMap.containsKey(original_path)) {
            return this.clonePathMap.get(original_path);
        }
        Pattern p = Pattern.compile("(.*?)(?:_(\\d+))?");
        Matcher m = p.matcher(original_path);
        if (!m.matches()) {
            throw new RuntimeException("subCloneHomePath pattern doesn't match");
        }
        String constant = m.group(1);
        String variable = m.group(2);
        int v = 1;
        if (variable != null && variable.length() != 0) {
            v = Integer.parseInt(variable);
        }
        int no_of_iterations = 0;
        String next_path = null;
        while (no_of_iterations <= 15) {
            String path = constant + "_" + String.valueOf(v + 1);
            if (this.homePaths.contains(path)) {
                ++v;
                continue;
            }
            File cloneDir = new File(path);
            if (cloneDir.exists()) {
                ++no_of_iterations;
                ++v;
                continue;
            }
            next_path = path;
            break;
        }
        if (next_path == null) {
            this.logger.log(Level.FINE, "Finished iterating but couldn't find a unique clone path. Creating path with original path with the current timestamp.");
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            next_path = original_path + "_" + ts.toString();
        }
        this.homePaths.add(next_path);
        this.clonePathMap.put(original_path, next_path);
        return next_path;
    }

    protected String subCloneHomeName(String original_name) {
        if (this.homeNames == null) {
            this.homeNames = new HashSet<String>();
            for (OracleHome oh : this.localInfo.getOracleHomes()) {
                this.homeNames.add(oh.getHomeName());
            }
        }
        if (this.cloneNameMap.containsKey(original_name)) {
            return this.cloneNameMap.get(original_name);
        }
        Pattern p = Pattern.compile("(.*?)(?:_(\\d+))?");
        Matcher m = p.matcher(original_name);
        if (!m.matches()) {
            throw new RuntimeException("subCloneHomeName pattern doesn't match");
        }
        String constant = m.group(1);
        String variable = m.group(2);
        int v = 1;
        if (variable != null && variable.length() != 0) {
            v = Integer.parseInt(variable);
        }
        while (true) {
            String next_name;
            if (!this.homeNames.contains(next_name = constant + "_" + String.valueOf(v + 1))) {
                this.homeNames.add(next_name);
                this.cloneNameMap.put(original_name, next_name);
                return next_name;
            }
            ++v;
        }
    }

    public OracleHome copyHome(OracleHome oh) {
        OracleHome clone = new OracleHome();
        clone.setDescription(oh.getDescription());
        clone.setDisplayName(oh.getDisplayName());
        clone.setName(oh.getName());
        clone.setHomeName(oh.getHomeName());
        clone.setARUId(oh.getARUId());
        clone.setPath(oh.getPath());
        clone.setOriginalOracleHome(oh.getOriginalOracleHome());
        clone.setARUId(oh.getARUId());
        clone.setCentralInvPtr(oh.getCentralInvPtr());
        clone.setHomeGuid(oh.getHomeGuid());
        clone.setHomeType(oh.getHomeType());
        clone.setHosts(oh.getHosts());
        clone.setInstalledSWComponents(new ArrayList(oh.getInstalledSWComponents()));
        clone.setOwner(oh.getOwner());
        clone.setPatches(oh.getPatches());
        clone.setOracleBaseLocation(oh.getOracleBaseLocation());
        clone.setPlatform(oh.getPlatform());
        clone.setTopComponents(oh.getTopComponents());
        clone.setTopLevelOUI(oh.getTopLevelOUI());
        clone.setType(oh.getType());
        clone.setVersion(oh.getVersion());
        clone.setVersionOPatch(oh.getVersionOPatch());
        clone.setId(UUID.randomUUID().toString());
        return clone;
    }
}

