/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.resource;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.db_crs.CRSCluster;
import model.patchmodel.PatchPackage;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.Readme;
import oracle.opatch.system.automation.jaxb.SqlCommand;
import oracle.oplan.core.readme.HtmlReadmeGenerator;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.OPlanInternalException;

public class OPlanBundle {
    public static final String LOOK = "LOOK(";
    public static final String LOOK_E = ")";
    static Logger logger = Logger.getLogger(OPlanBundle.class.getName());
    static Map<String, String> msgMapForEM = new HashMap<String, String>();

    public static String getMessage(Class clazz, String resName, Object ... params) throws MissingResourceException {
        String message = OPlanBundle.getBundle(clazz).getString(resName);
        if (message == null) {
            return null;
        }
        String trim = message.trim();
        if (trim.startsWith(LOOK) && trim.endsWith(LOOK_E)) {
            String newKey = trim.substring(LOOK.length());
            newKey = newKey.substring(0, newKey.length() - LOOK_E.length());
            return OPlanBundle.getMessage(clazz, newKey, params);
        }
        if (params == null || params.length == 0) {
            return OPlanBundle.replaceOPatchautoMessageFor12(message);
        }
        return OPlanBundle.replaceOPatchautoMessageFor12(MessageFormat.format(message, params));
    }

    public static String getReadmeMessage(String resName, Object ... params) throws MissingResourceException {
        String message = null;
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        String readmeResource = oplanIntgFactory.getReadmeResourceBundleLocation();
        int index = readmeResource.indexOf(".properties");
        if (index != -1) {
            readmeResource = readmeResource.substring(0, index);
        }
        if (readmeResource != null) {
            ResourceBundle rb = ResourceBundle.getBundle(readmeResource, Locale.getDefault(), OPlanBundle.class.getClassLoader());
            try {
                message = rb.getString(resName);
                if (message != null) {
                    return MessageFormat.format(message, params);
                }
            }
            catch (MissingResourceException e) {
                logger.info("Can not find message " + resName + " in oplancore resource bundle, need to look for it in product resource bundle");
            }
        }
        return OPlanBundle.getMessage(HtmlReadmeGenerator.class, resName, params);
    }

    public static String getPrefixedReadmeMessage(String prefix, String resName, Object ... params) throws MissingResourceException {
        if (prefix == null || prefix.equals("")) {
            return OPlanBundle.getReadmeMessage(resName, params);
        }
        String message = null;
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        String readmeResource = oplanIntgFactory.getReadmeResourceBundleLocation();
        int index = readmeResource.indexOf(".properties");
        if (index != -1) {
            readmeResource = readmeResource.substring(0, index);
        }
        if (readmeResource != null) {
            ResourceBundle rb = ResourceBundle.getBundle(readmeResource, Locale.getDefault(), OPlanBundle.class.getClassLoader());
            try {
                message = rb.getString(prefix + "-" + resName);
                if (message != null) {
                    return MessageFormat.format(message, params);
                }
            }
            catch (MissingResourceException e) {
                logger.info("Can not find message " + resName + " in oplancore resource bundle, need to look for it in product resource bundle");
            }
            try {
                message = rb.getString(resName);
                if (message != null) {
                    return MessageFormat.format(message, params);
                }
            }
            catch (MissingResourceException e) {
                logger.info("Can not find message " + resName + " in oplancore resource bundle, need to look for it in product resource bundle");
            }
        }
        return OPlanBundle.getPrefixedMessage(HtmlReadmeGenerator.class, prefix, resName, params);
    }

    public static boolean checkIfMessageExisted(Class clazz, String resName) throws MissingResourceException {
        Enumeration<String> messageKeys = OPlanBundle.getBundle(clazz).getKeys();
        while (messageKeys.hasMoreElements()) {
            String key = messageKeys.nextElement();
            if (!key.equals(resName)) continue;
            return true;
        }
        return false;
    }

    public static String getMessage(String resName, Object ... params) throws MissingResourceException, FileNotFoundException, IOException {
        Automation e;
        OPlanEnv oplanenv = OPlan.getInstance().getOPlanEnv();
        URL rburl = null;
        if (oplanenv.getAutomationFileMap() != null) {
            e = oplanenv.getAutomationFileMap().entrySet().iterator().next();
            rburl = new URL((URL)e.getValue(), ((Automation)e.getKey()).getBundleFile());
        } else if (oplanenv.getAutomations() != null) {
            e = oplanenv.getAutomations().iterator().next();
            rburl = new URL(e.getBundleFile());
        }
        InputStream fis = rburl.openStream();
        PropertyResourceBundle rb = new PropertyResourceBundle(fis);
        String output = rb.getString(resName);
        return OPlanBundle.replaceOPatchautoMessageFor12(MessageFormat.format(output, params));
    }

    public static String getPrefixedMessage(Class clazz, String prefix, String resName, Object ... params) throws MissingResourceException {
        if (prefix == null || prefix.equals("")) {
            return OPlanBundle.getMessage(clazz, resName, params);
        }
        String message = null;
        try {
            message = OPlanBundle.getMessage(clazz, prefix + "-" + resName, params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (message == null) {
            return OPlanBundle.getMessage(clazz, resName, params);
        }
        return message;
    }

    private static String replaceOPatchautoMessageFor12(String message) {
        String version;
        AbstractBaseTarget rootTarget;
        if (message != null && OPlan.getInstance().haveInitIntgFactory() && OPlan.getInstance().getOPlanEnv().getExecutionMode().equals(ExecutionMode.OPATCH.toString()) && (rootTarget = OPlan.getInstance().getConfigGraph().getRootVertex()) != null && rootTarget instanceof CRSCluster && (version = OPlan.getInstance().getConfigGraph().getRootVertex().getVersion()) != null && version.startsWith("12.1")) {
            message = message.replaceAll("OPatch [a|A]uto", "OPatchauto");
        }
        return message;
    }

    private static ResourceBundle getBundle(Class classs) throws MissingResourceException {
        String name = classs.getPackage().getName() + ".Bundle";
        ResourceBundle ret = ResourceBundle.getBundle(name, Locale.getDefault(), classs.getClassLoader());
        return ret;
    }

    public static String getPrefixedMessageNE(Class clazz, String prefix, String resName, Object ... params) {
        String res = null;
        try {
            res = OPlanBundle.getPrefixedMessage(clazz, prefix, resName, params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return res;
    }

    public static String getMessageNE(Class clazz, String resName, Object ... params) {
        String res = null;
        try {
            res = OPlanBundle.getMessage(clazz, resName, params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return res;
    }

    public static String getATitle(Readme readme) {
        String res;
        if (readme == null) {
            return null;
        }
        if (readme.getTitle() == null) {
            return null;
        }
        if (readme.getTitle().getPropertyKey() != null && (res = OPlanBundle.getFromAutomationResourceBundle(readme.getTitle().getPropertyKey())) != null) {
            return res;
        }
        if (readme.getTitle().getValue() == null) {
            return null;
        }
        if (readme.getTitle().getValue().equals("")) {
            return null;
        }
        return readme.getTitle().getValue();
    }

    public static String getStepMessage(Readme readme) {
        String res;
        if (readme == null) {
            return null;
        }
        if (readme.getMessage() == null) {
            return null;
        }
        ExecutionMode executionMode = OPlan.getInstance().getOPlanEnv().getExecutionMode();
        if (readme.getMessage().getPropertyKey() != null && (res = OPlanBundle.getFromAutomationResourceBundle(readme.getMessage().getPropertyKey())) != null) {
            if (executionMode.equals((Object)ExecutionMode.EM)) {
                return MessageFormat.format(res, "'", "'");
            }
            return res;
        }
        if (readme.getMessage().getValue() == null) {
            return null;
        }
        if (readme.getMessage().getValue().equals("")) {
            return null;
        }
        if (executionMode.equals((Object)ExecutionMode.EM)) {
            return MessageFormat.format(readme.getMessage().getValue(), "'", "'");
        }
        return readme.getMessage().getValue();
    }

    public static String getStepTroubleshoot(Readme readme) {
        String res;
        if (readme == null) {
            return null;
        }
        if (readme.getTroubleshoot() == null) {
            return null;
        }
        ExecutionMode executionMode = OPlan.getInstance().getOPlanEnv().getExecutionMode();
        if (readme.getTroubleshoot().getPropertyKey() != null && (res = OPlanBundle.getFromAutomationResourceBundle(readme.getTroubleshoot().getPropertyKey())) != null) {
            if (executionMode.equals((Object)ExecutionMode.EM)) {
                return MessageFormat.format(res, "'", "'");
            }
            return res;
        }
        if (readme.getTroubleshoot().getValue() == null) {
            return null;
        }
        if (readme.getTroubleshoot().getValue().equals("")) {
            return null;
        }
        if (executionMode.equals((Object)ExecutionMode.EM)) {
            return MessageFormat.format(readme.getTroubleshoot().getValue(), "'", "'");
        }
        return readme.getTroubleshoot().getValue();
    }

    public static String getErrorMessage(SqlCommand.ErrorHandling.FatalError error) {
        String res;
        if (error == null) {
            return null;
        }
        if (error.getMessage() == null) {
            return null;
        }
        if (error.getMessage().getPropertyKey() != null && (res = OPlanBundle.getFromAutomationResourceBundle(error.getMessage().getPropertyKey())) != null) {
            return res;
        }
        if (error.getMessage().getValue() == null) {
            return null;
        }
        if (error.getMessage().getValue().equals("")) {
            return null;
        }
        return error.getMessage().getValue();
    }

    public static String getFromAutomationResourceBundle(String resName) {
        ResourceBundle rb;
        String message = null;
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        String automationResource = oplanIntgFactory.getAutomationResourceBundleLocation();
        int index = automationResource.indexOf(".properties");
        if (index != -1) {
            automationResource = automationResource.substring(0, index);
        }
        if (automationResource != null) {
            try {
                rb = ResourceBundle.getBundle(automationResource, Locale.getDefault(), OPlanBundle.class.getClassLoader());
                message = rb.getString(resName);
            }
            catch (MissingResourceException e) {
                message = null;
            }
        }
        if (message == null) {
            try {
                String name = OPlanBundle.class.getPackage().getName() + ".AutomationBundle";
                rb = ResourceBundle.getBundle(name, Locale.getDefault(), OPlanBundle.class.getClassLoader());
                message = rb.getString(resName);
            }
            catch (MissingResourceException e) {
                message = null;
            }
        }
        if (message == null) {
            try {
                String rbFile;
                PatchPackage primaryPatch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
                if (primaryPatch != null && primaryPatch.getAutoXmls() != null && !primaryPatch.getAutoXmls().isEmpty() && (rbFile = primaryPatch.getResourceBundle()) != null) {
                    rb = new PropertyResourceBundle(new ByteArrayInputStream(rbFile.getBytes()));
                    message = rb.getString(resName);
                }
            }
            catch (IOException e) {
                throw new OPlanInternalException("Fail to get the message string " + resName + " from the resource bundle ", e);
            }
        }
        message = OPlanBundle.replaceMsgForEM(message);
        return OPlanBundle.replaceOPatchautoMessageFor12(message);
    }

    private static String replaceMsgForEM(String message) {
        ExecutionMode executionMode;
        String result = message;
        if (result != null && ExecutionMode.EM.equals((Object)(executionMode = OPlan.getInstance().getOPlanEnv().getExecutionMode()))) {
            Set<String> matchKeys = msgMapForEM.keySet();
            for (String matchKey : matchKeys) {
                result = result.replace(matchKey, msgMapForEM.get(matchKey));
            }
        }
        return result;
    }

    static {
        msgMapForEM.put("%Host.hostName%", OPlanBundle.getMessage(OPlan.class, "HOST_NAME_REPLACE", new Object[0]));
        msgMapForEM.put("%OracleHome.description%", OPlanBundle.getMessage(OPlan.class, "ORACLE_HOME_DESC_REPLACE", new Object[0]));
        msgMapForEM.put("%RACDatabase.databaseName%", "");
        msgMapForEM.put("%OracleHome.homeName%", "");
    }
}

