/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api;

import java.util.Date;
import java.util.List;
import java.util.Map;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.api.Patch;

public interface DomainConfigInventory {
    public void createPatchEntries(List<Patch> var1) throws DomainInventoryUpdatingException;

    public List<PatchInventoryEntry> removePatchEntry(List<String> var1) throws DomainInventoryUpdatingException, DomainInventoryLoadingException;

    public PatchInventoryEntry removePatchEntry(String var1) throws DomainInventoryUpdatingException, DomainInventoryLoadingException;

    public Status getPatchStatus(String var1, PhaseType var2) throws DomainInventoryLoadingException;

    public Map<String, Status> getPatchStatus(List<String> var1, PhaseType var2) throws DomainInventoryLoadingException;

    public PatchInventoryEntry getPatchInventoryEntry(String var1) throws DomainInventoryLoadingException;

    public List<PatchInventoryEntry> getPatchInventoryEntries() throws DomainInventoryLoadingException;

    public List<Patch> getDelta(List<Patch> var1, PhaseType var2) throws DomainInventoryLoadingException;

    public void updateActionStatus(String var1, String var2, PhaseType var3, Status var4) throws DomainInventoryUpdatingException, DomainInventoryLoadingException;

    public void addEntry(String var1, Date var2, String var3) throws DomainInventoryUpdatingException;

    public ActionInventoryEntry removeEntry(String var1) throws DomainInventoryLoadingException, DomainInventoryUpdatingException;

    public ActionInventoryEntry getEntry(String var1) throws DomainInventoryLoadingException;

    public boolean entryExists(String var1) throws DomainInventoryLoadingException;

    public List<ActionInventoryEntry> getEntries() throws DomainInventoryLoadingException;

    public static interface ActionInventoryEntry {
        public String getName();

        public String getDate();

        public String getActor();
    }

    public static interface PatchInventoryEntry {
        public String getPatchId();

        public String getPatchUpi();

        public List<Phase> getPhases();

        public static interface Phase {
            public PhaseType getPhaseType();

            public Status getPatchStatus();

            public void setPatchStatus(Status var1);

            public List<ActionEntry> getActionEntries();

            public static interface ActionEntry {
                public String getActionId();

                public Status getActionStatus();

                public String getDate();
            }
        }
    }

    public static enum Status {
        INITIAL("initial"),
        SUCCESS("success"),
        FAILURE("failure"),
        NA("not_applicable"),
        WARNING("warning");

        private final String value;

        private Status(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Status fromValue(String v) {
            for (Status c : Status.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum PhaseType {
        ONLINE("online"),
        OFFLINE("offline");

        private final String value;

        private PhaseType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static PhaseType fromValue(String v) {
            for (PhaseType c : PhaseType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

