/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Utility {
    private static final Logger logger = Logger.getLogger("Utility");

    public static Map<String, String> createChecksumHash(Map<String, String> map) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            File file = new File(entry.getValue());
            String checksum = Utility.getCheckSum(file);
            result.put(entry.getKey(), checksum);
            logger.info("Checksum calculated: File path:" + key + " , checksum value:" + checksum);
        }
        return result;
    }

    public static String getCheckSum(File file) throws IOException {
        return Utility.digestFile(file, "SHA-256");
    }

    private static String getHex(byte[] raw) {
        String HEXES = "0123456789ABCDEF";
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (int i = 0; i < raw.length; ++i) {
            byte b = raw[i];
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String getSha1sum(File file) throws IOException {
        return Utility.digestFile(file, "SHA-1");
    }

    public static String getSha256sum(File file) throws IOException {
        return Utility.digestFile(file, "SHA-256");
    }

    private static String digestFile(File file, String algo) throws IOException {
        file = file.getCanonicalFile();
        FileInputStream in = new FileInputStream(file);
        int len = 0;
        MessageDigest md = null;
        byte[] buffer = new byte[4096];
        try {
            md = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            logger.severe("Utility getCheckSum() failed: " + e.getMessage());
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            ((InputStream)in).close();
            throw re;
        }
        while ((len = ((InputStream)in).read(buffer)) >= 0) {
            md.update(buffer, 0, len);
        }
        byte[] b = md.digest();
        ((InputStream)in).close();
        return Utility.getHex(b);
    }
}

