/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.OPatchAutoOptionsException;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPCommandGenerator;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import com.oracle.glcm.patch.auto.rhp.executor.RHPParamCreator;
import com.oracle.glcm.patch.auto.rhp.executor.RHPResult;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import com.oracle.glcm.patch.auto.rhp.repository.system.ProductDriverException;
import com.oracle.glcm.patch.auto.rhp.validation.OPatchautoRHPValidationController;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import com.oracle.glcm.patch.auto.tracking.bindings.StatusType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OPatchAutoRHPExecutor {
    private final Logger _log = Logger.getLogger(OPatchAutoRHPExecutor.class.getName());
    private static final String OPATCH_AUTO_NAMESPACE = "opatchauto";
    private static final String DEFAULT_LOG_DIR = "cfgtoollogs";
    private static final String LOG_FILENAME_DATE_FORMAT = "yyyy-MM-dd_hh-mm-ssa";

    public void prepareExecution(OPatchAutoRHPOptions options, OPatchAutoCommand command) throws OPatchAutoException {
        boolean isSuccessful = false;
        PatchTracking patchTracking = null;
        try {
            String sessionId;
            String log = options.getOption("logfile").getValue(this.getDefaultLogFileLocation(OPatchAutoHelper.getOPatchAutoHome()));
            String logLevel = options.getOption("logpriority").getValue();
            LogFactory logFactory = LogFactory.getFactory();
            logFactory.setupLogging(log, logLevel != null ? logLevel.toUpperCase() : null, true, new String[0]);
            Reporter defaultReporter = Reporting.getDefaultReporter();
            if (defaultReporter != null) {
                defaultReporter.setMessageLoggingLevel(Level.INFO);
            }
            this._log.info("OPatchAuto version: " + OPatchAutoHelper.getInstance().getOPatchAutoVersion());
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchAuto.session.log.file", (Object[])new Object[]{log}));
            OPatchAutoHelper.redirectStandardStreams((String)log);
            OPatchAutoOption sessionOption = options.getOption("session");
            if (command.isResume()) {
                sessionId = sessionOption.getValue();
                patchTracking = new PatchTracking(sessionId);
                if (patchTracking.getSessionStatus().equals((Object)StatusType.SUCCESS)) {
                    OPatchAutoOptionsException exception = new OPatchAutoOptionsException("68155", new Object[]{sessionId});
                    exception.setHelpRequested(true);
                    throw exception;
                }
                if (!patchTracking.isExistingSession()) {
                    throw new OPatchAutoException("68011", new Object[]{sessionId});
                }
                this._log.info("Resuming existing session with id " + sessionId);
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchAuto.resuming.existing.session", (Object[])new Object[]{sessionId}));
                patchTracking.populatePreviousSessionOptionValues((OPatchAutoOptions)options);
                if (patchTracking.getSessionStatus().equals((Object)StatusType.INCOMPLETE) && options.getOption("batches").hasValue()) {
                    OPatchAutoOption contine = options.getOption("continue");
                    contine.setValue(Boolean.TRUE.toString());
                }
                command = patchTracking.getCommand();
                command.setResumed(true);
                options.setCommand(command);
            } else {
                if (command.isRollback() && sessionOption.hasValue()) {
                    String prevSessionId = sessionOption.getValue();
                    PatchTracking previousPatchTracking = new PatchTracking(prevSessionId);
                    if (!previousPatchTracking.isExistingSession()) {
                        throw new OPatchAutoException("68012", new Object[]{prevSessionId});
                    }
                    if (previousPatchTracking.getCommand() != OPatchAutoCommand.apply) {
                        throw new OPatchAutoException("68013", new Object[]{OPatchAutoCommand.apply, prevSessionId, previousPatchTracking.getCommand()});
                    }
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchAuto.loading.previous.session", (Object[])new Object[]{prevSessionId}));
                    previousPatchTracking.populatePreviousSessionOptionValues((OPatchAutoOptions)options, true);
                }
                sessionId = PatchTracking.generateSessionId();
                patchTracking = new PatchTracking(sessionId, command);
                options.getOption("session").setValue(sessionId);
            }
            options.validate(command);
            options.logOptions();
            this.validateOptions(command, options);
            this.initialize(options);
            RHPOperation operationType = OPatchautoRHPHelper.getRHPOperationType(command, options);
            if (operationType == null) {
                throw new OPatchAutoException(Integer.toString(75053), new Object[0]);
            }
            this.validateRHPSession(operationType, options);
            patchTracking.initSessionExecution((OPatchAutoOptions)options);
            if (!patchTracking.isExistingSession()) {
                this._log.info("The id for this session is " + sessionId);
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchAuto.id.for.session", (Object[])new Object[]{sessionId}));
            }
            this.startExecution(command, options);
            isSuccessful = true;
            this.writeSessionProperties(OPatchautoRHPHelper.getRHPSessionPropertyFile(), options.getOption("session").getValue(), isSuccessful);
        }
        catch (Throwable t) {
            try {
                if (t instanceof OPatchAutoException) {
                    throw (OPatchAutoException)t;
                }
                throw new OPatchAutoException(t);
            }
            catch (Throwable throwable) {
                this.writeSessionProperties(OPatchautoRHPHelper.getRHPSessionPropertyFile(), options.getOption("session").getValue(), isSuccessful);
                if ((options.getOption("batches").hasValue() || options.getOption("continue").isSwitchEnabled()) && isSuccessful) {
                    patchTracking.updateSessionStatus(StatusType.INCOMPLETE);
                } else {
                    patchTracking.updateSessionStatus(isSuccessful ? StatusType.SUCCESS : StatusType.FAILURE);
                }
                throw throwable;
            }
        }
        if ((options.getOption("batches").hasValue() || options.getOption("continue").isSwitchEnabled()) && isSuccessful) {
            patchTracking.updateSessionStatus(StatusType.INCOMPLETE);
        } else {
            patchTracking.updateSessionStatus(isSuccessful ? StatusType.SUCCESS : StatusType.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessionProperties(String sessionFile, String sessionID, boolean isSuccess) {
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(sessionFile);
            prop.setProperty("sessionid", sessionID);
            prop.setProperty("status", Boolean.toString(isSuccess));
            prop.store(output, null);
            this._log.info("Session ID stored =" + sessionID);
            this._log.info("Session status =" + isSuccess);
        }
        catch (IOException iOException) {
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void startExecution(OPatchAutoCommand command, OPatchAutoRHPOptions options) throws OPatchAutoException {
        RHPCommandGenerator generator = new RHPCommandGenerator();
        RHPOperation operationType = OPatchautoRHPHelper.getRHPOperationType(command, options);
        RHPParamCreator paramGenerator = new RHPParamCreator();
        RHPParams params = paramGenerator.createParams(command, options, operationType);
        List<Command> commandList = generator.getCommand(operationType);
        RHPCommandExecutor commandExecutor = new RHPCommandExecutor();
        for (Command rhpCommand : commandList) {
            Reporting.report((String)rhpCommand.getStatusMessage(RHPCommandExecutor.Status.START, params));
            rhpCommand.preExecute(params);
            List<String> commands = generator.generateCommand(rhpCommand, params);
            List<RHPResult> resultList = commandExecutor.executeRHPCommand(commands, null, null, true);
            try {
                this.processResult(resultList);
                rhpCommand.postExecute(params);
                Reporting.report((String)rhpCommand.getStatusMessage(RHPCommandExecutor.Status.SUCCESSFUL, params));
            }
            catch (OPatchAutoException e) {
                Reporting.report((String)rhpCommand.getStatusMessage(RHPCommandExecutor.Status.FAILED, params));
                throw e;
            }
        }
    }

    private void processResult(List<RHPResult> resultList) throws OPatchAutoException {
        for (RHPResult result : resultList) {
            if (result.getReturnCode() == 0) continue;
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"RHPCommandExecutor.command.execution.failed", (Object[])new Object[0]));
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"RHPCommandExecutor.command.failed", (Object[])new Object[]{result.getCommand()}));
            String errorMsg = StringUtil.isNullOrEmpty((String)result.getErrorMessage(), (boolean)true) ? result.getCommandOutput() : result.getErrorMessage();
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"RHPCommandExecutor.failed.command.output", (Object[])new Object[]{errorMsg}));
            throw new OPatchAutoException(Integer.toString(75051), new Object[]{result.getCommand()});
        }
    }

    private void initialize(OPatchAutoRHPOptions options) throws OPatchAutoException {
        String invPtrLocStr = options.getOption("inventory.pointer.location").getValue();
        String oracleHome = System.getProperty("OPatch.ORACLE_HOME");
        OPatchautoRHPHelper.setupEnvironment(oracleHome, invPtrLocStr);
        OracleHomeInformationLoader ohInfoLoader = OracleHomeInformationLoader.getInstance();
        try {
            ohInfoLoader.loadInventory(oracleHome);
        }
        catch (ProductDriverException e) {
            throw new OPatchAutoException(Integer.toString(75005), new Object[]{e.getLocalizedMessage()});
        }
    }

    private void validateRHPSession(RHPOperation operation, OPatchAutoRHPOptions options) throws OPatchAutoException {
        OPatchautoRHPValidationController rhpValidationController = new OPatchautoRHPValidationController();
        List<RHPValidationResult> resultList = rhpValidationController.validate(operation, options);
        if (!resultList.isEmpty()) {
            for (RHPValidationResult result : resultList) {
                if (result.getStatus() != RHPValidationResult.ValidationStatus.FAILED) continue;
                if (result.getParams() != null && result.getParams().length > 0) {
                    throw new OPatchAutoException(Integer.toString(result.getFailureReason().getErrorCode()), result.getParams());
                }
                throw new OPatchAutoException(Integer.toString(result.getFailureReason().getErrorCode()), new Object[0]);
            }
        }
    }

    private void validateOptions(OPatchAutoCommand command, OPatchAutoRHPOptions options) throws OPatchAutoException {
        Set<OPatchAutoOptionGroup> optionGroups = options.getRHPOptionGroups();
        for (OPatchAutoOptionGroup optionGroup : optionGroups) {
            Set requireOptions;
            if (optionGroup.getRelationship().isRequiredTogether()) {
                requireOptions = optionGroup.validateRequiredTogether(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    throw new OPatchAutoOptionsException("68020", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
                }
                requireOptions = optionGroup.validateRequiredTogether(true);
                if (requireOptions == null || requireOptions.isEmpty()) continue;
                throw new OPatchAutoOptionsException("68022", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
            }
            if (optionGroup.getRelationship().isMutuallyExclusive()) {
                requireOptions = optionGroup.validateMutuallyExclusive(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    throw new OPatchAutoOptionsException("68024", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
                }
                requireOptions = optionGroup.validateMutuallyExclusive(true);
                if (requireOptions == null || requireOptions.isEmpty()) continue;
                throw new OPatchAutoOptionsException("68026", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
            }
            if (optionGroup.getRelationship().isIfFirstThenAllRequired()) {
                requireOptions = optionGroup.validateIfFirstThenAllRequired(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    throw new OPatchAutoOptionsException("68020", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
                }
                requireOptions = optionGroup.validateIfFirstThenAllRequired(true);
                if (requireOptions == null || requireOptions.isEmpty()) continue;
                throw new OPatchAutoOptionsException("68022", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
            }
            if (optionGroup.getRelationship().isIfFirstThenAtLeastOneRequired()) {
                requireOptions = optionGroup.validateIfFirstThenAtLeastOneRequired(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    throw new OPatchAutoOptionsException("68028", new Object[]{((OPatchAutoOption)optionGroup.getOptions().iterator().next()).getKey(), OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
                }
                requireOptions = optionGroup.validateIfFirstThenAtLeastOneRequired(true);
                if (requireOptions == null || requireOptions.isEmpty()) continue;
                throw new OPatchAutoOptionsException("68022", new Object[]{OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
            }
            if (!optionGroup.getRelationship().isIfFirstThenExcludeAll() || (requireOptions = optionGroup.validateIfFirstThenExcludeAll()) == null || requireOptions.isEmpty()) continue;
            throw new OPatchAutoOptionsException("68159", new Object[]{((OPatchAutoOption)optionGroup.getOptions().iterator().next()).getArg(), OPatchAutoRHPExecutor.getOptionNames(requireOptions)});
        }
        Set<OPatchAutoOption> requiredArgs = options.getRequiredRHPCommandOptions(command);
        if (!requiredArgs.isEmpty()) {
            LinkedHashSet<OPatchAutoOption> missingRequired = new LinkedHashSet<OPatchAutoOption>();
            for (OPatchAutoOption option : requiredArgs) {
                if (option == null || option.hasValue()) continue;
                missingRequired.add(option);
            }
            if (!missingRequired.isEmpty()) {
                throw new OPatchAutoOptionsException("68022", new Object[]{OPatchAutoRHPExecutor.getOptionNames(missingRequired)});
            }
        }
    }

    private static Collection<String> getOptionNames(Collection<OPatchAutoOption> options) {
        ArrayList<String> missingRequired = new ArrayList<String>();
        if (options != null) {
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                missingRequired.add(option.getArg());
            }
        }
        return missingRequired;
    }

    private String getDefaultLogFileLocation(String home) {
        return this.getDefaultLogDirectoryLocation(home) + File.separator + OPATCH_AUTO_NAMESPACE + OPatchAutoHelper.getCurrentDateTimeStamp((String)LOG_FILENAME_DATE_FORMAT) + ".log";
    }

    private String getDefaultLogDirectoryLocation(String home) {
        return home + File.separator + DEFAULT_LOG_DIR + File.separator + OPATCH_AUTO_NAMESPACE;
    }
}

