/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.command;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RHPSwitchBackHomeCommand
extends Command {
    @Override
    public List<String> generateCommand(RHPParams params) throws OPatchAutoException {
        OracleHomeInformationLoader.OracleHomeType homeType = OracleHomeInformationLoader.getInstance().getHomeType(params.getOracleHome());
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append(this.getRHPExecutable(params.getRHPClientHome()));
        commandBuilder.append(" ");
        commandBuilder.append("move");
        commandBuilder.append(" ");
        commandBuilder.append(this.getHomeType(homeType));
        commandBuilder.append(" ");
        commandBuilder.append(this.getDestinationHomeparam(homeType));
        commandBuilder.append(" ");
        commandBuilder.append(this.getDestinationWorkingCopyID(params));
        if (params.isContinued()) {
            commandBuilder.append(" ");
            commandBuilder.append("-continue");
        } else {
            commandBuilder.append(" ");
            commandBuilder.append("-sourcewc");
            commandBuilder.append(" ");
            commandBuilder.append(this.getSourceWorkingCopyID(params));
            commandBuilder.append(" ");
            commandBuilder.append("-ignorewcpatches");
            if (!StringUtil.isNullOrEmpty((String)params.getBatches())) {
                commandBuilder.append(this.generateBatchesCommand(params.getBatches()));
            } else if (!StringUtil.isNullOrEmpty((String)params.getSAF())) {
                commandBuilder.append(" ");
                commandBuilder.append("-smartmove");
                commandBuilder.append(" ");
                commandBuilder.append("-saf");
                commandBuilder.append(" ");
                commandBuilder.append(params.getSAF());
            } else if (params.isNonRolling()) {
                commandBuilder.append(" ");
                commandBuilder.append("-nonrolling");
            }
            if (params.isAnalyze()) {
                commandBuilder.append(" ");
                commandBuilder.append("-eval");
            }
            if (!StringUtil.isNullOrEmpty((String)params.getStopOption())) {
                commandBuilder.append(" ");
                commandBuilder.append("-stopoption");
                commandBuilder.append(" ");
                commandBuilder.append(params.getStopOption());
            }
            if (!StringUtil.isNullOrEmpty((String)params.getDrainTimeout())) {
                commandBuilder.append(" ");
                commandBuilder.append("-drain_timeout");
                commandBuilder.append(" ");
                commandBuilder.append(params.getDrainTimeout());
            }
        }
        this._logger.fine("Generated command::" + commandBuilder.toString());
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandBuilder.toString());
        return commandList;
    }

    private String getSourceWorkingCopyID(RHPParams params) throws OPatchAutoException {
        String workingCopyID = null;
        try {
            workingCopyID = OPatchautoRHPHelper.findWorkingCopyID(params.getOracleHome());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty((String)workingCopyID)) {
            throw new OPatchAutoException(Integer.toString(75055), new Object[]{params.getOracleHome()});
        }
        return workingCopyID;
    }

    private String getDestinationWorkingCopyID(RHPParams params) throws OPatchAutoException {
        String workingCopyID = null;
        try {
            workingCopyID = OPatchautoRHPHelper.findPreviousHomeWorkingCopyID(params.getOracleHome());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty((String)workingCopyID)) {
            throw new OPatchAutoException(Integer.toString(75054), new Object[]{params.getOracleHome()});
        }
        return workingCopyID;
    }

    @Override
    public RHPOperation getOperationType() {
        return RHPOperation.SWITCH_BACK_HOME;
    }

    @Override
    public String getStatusMessage(RHPCommandExecutor.Status status, RHPParams params) {
        String statusMsg = "";
        String destinationWorkingCopyID = "";
        try {
            destinationWorkingCopyID = this.getDestinationWorkingCopyID(params);
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        switch (status) {
            case START: {
                if (params.isAnalyze()) {
                    statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchBackHomeCommand.status.msg.analyze.start", (Object[])new Object[]{params.getOracleHome(), destinationWorkingCopyID});
                    break;
                }
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchBackHomeCommand.status.msg.start", (Object[])new Object[]{params.getOracleHome(), destinationWorkingCopyID});
                break;
            }
            case SUCCESSFUL: {
                if (params.isAnalyze()) {
                    statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchBackHomeCommand.status.msg.analyze.successful", (Object[])new Object[]{params.getOracleHome(), destinationWorkingCopyID});
                    break;
                }
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPSwitchBackHomeCommand.status.msg.successful", (Object[])new Object[]{params.getOracleHome(), destinationWorkingCopyID});
                break;
            }
            case FAILED: {
                statusMsg = params.isAnalyze() ? OPatchAutoHelper.getLocalizedString((String)"RHPSwitchBackHomeCommand.status.msg.analyze.failed", (Object[])new Object[]{params.getOracleHome(), destinationWorkingCopyID}) : OPatchAutoHelper.getLocalizedString((String)"RHPSwitchBackHomeCommand.status.msg.failed", (Object[])new Object[]{params.getOracleHome(), destinationWorkingCopyID});
            }
        }
        return statusMsg;
    }

    private String getHomeType(OracleHomeInformationLoader.OracleHomeType homeType) {
        String type = null;
        switch (homeType) {
            case CRS: {
                type = "gihome";
                break;
            }
            case RAC: 
            case SIDB: {
                type = "database";
            }
        }
        this._logger.fine("The home type is " + type);
        return type;
    }

    private String getDestinationHomeparam(OracleHomeInformationLoader.OracleHomeType homeType) {
        String param = null;
        switch (homeType) {
            case CRS: {
                param = "-destwc";
                break;
            }
            case RAC: 
            case SIDB: {
                param = "-patchedwc";
            }
        }
        this._logger.fine("The destination param is " + param);
        return param;
    }
}

