/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.executor;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.executor.RHPResult;
import com.oracle.glcm.patch.auto.rhp.executor.ReaderThread;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RHPCommandExecutor {
    private static final Logger _log = Logger.getLogger(RHPCommandExecutor.class.getName());

    public List<RHPResult> executeRHPCommand(List<String> commands, File executionDir, Map<String, String> envVars, boolean logToConsole) {
        ArrayList<RHPResult> rhpResultList = new ArrayList<RHPResult>();
        for (String cmd : commands) {
            RHPResult result = RHPCommandExecutor.execute(cmd, executionDir, envVars, logToConsole);
            rhpResultList.add(result);
        }
        return rhpResultList;
    }

    private static RHPResult execute(String cmd, File executionDir, Map<String, String> envVariable, boolean logToConsole) {
        _log.info("Executing command " + cmd);
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Executing command " + cmd + " in dir " + executionDir + " with env " + envVariable);
        }
        String osname = System.getProperty("os.name", "");
        ArrayList<String> cmdToExecute = new ArrayList<String>();
        String bashCommand = OPatchautoRHPHelper.getBashCmd(cmd);
        cmdToExecute.add(bashCommand);
        if (!osname.equalsIgnoreCase("SunOS") && !osname.equalsIgnoreCase("HP-UX")) {
            cmdToExecute.add("-m");
        } else if (osname.equalsIgnoreCase("HP-UX")) {
            cmdToExecute.add("+m");
        }
        cmdToExecute.add("-c");
        cmdToExecute.add(cmd);
        RHPResult ret = new RHPResult(cmd);
        ProcessBuilder pb = new ProcessBuilder(cmdToExecute);
        if (executionDir != null) {
            pb.directory(executionDir);
        }
        if (envVariable != null && !envVariable.isEmpty()) {
            Map<String, String> currentEnv = pb.environment();
            currentEnv.putAll(envVariable);
        }
        int retValue = -1;
        try {
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream, "ErrorStream", false);
            ReaderThread rinput = new ReaderThread(inputStream, "InputStream", logToConsole);
            rinput.start();
            rerror.start();
            retValue = process.waitFor();
            try {
                rerror.join();
                rinput.join();
                if (retValue != 0 && cmd.contains("-continue")) {
                    String output;
                    String string = output = StringUtil.isNullOrEmpty((String)rinput.getOutput(), (boolean)true) ? rerror.getOutput() : rinput.getOutput();
                    if (!StringUtil.isNullOrEmpty((String)output) && output.contains("PRGO-1610")) {
                        retValue = 0;
                    }
                }
                ret.setCommandOutput(rinput.getOutput());
                ret.setErrorMessage(rerror.getOutput());
            }
            catch (InterruptedException ie) {
                retValue = -1;
                ret.setErrorMessage(ie.getMessage());
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        _log.finest("Error message:" + ret.getErrorMessage());
        _log.finest("Output message:" + ret.getCommandOutput());
        _log.finest("Return code: " + ret.getReturnCode());
        return ret;
    }

    public static enum Status {
        START,
        SUCCESSFUL,
        FAILED;

    }
}

