/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.validation;

import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPCommandGenerator;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import com.oracle.glcm.patch.auto.rhp.executor.RHPParamCreator;
import com.oracle.glcm.patch.auto.rhp.executor.RHPResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationFailureReason;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidator;
import java.util.List;
import java.util.logging.Logger;

public class RHPImageValidator
implements RHPValidator {
    private final Logger _logger = Logger.getLogger(RHPImageValidator.class.getName());

    @Override
    public RHPValidationResult validate(OPatchAutoRHPOptions options) {
        RHPValidationResult result = null;
        String imageID = null;
        try {
            imageID = options.getOption("image.id").getValue();
            RHPCommandGenerator generator = new RHPCommandGenerator();
            RHPParamCreator paramGenerator = new RHPParamCreator();
            RHPParams params = paramGenerator.createParams(OPatchAutoCommand.apply, options, RHPOperation.QUERY_IMAGE);
            List<Command> commandList = generator.getCommand(RHPOperation.QUERY_IMAGE);
            RHPCommandExecutor commandExecutor = new RHPCommandExecutor();
            for (Command command : commandList) {
                List<String> commands = generator.generateCommand(command, params);
                List<RHPResult> resultList = commandExecutor.executeRHPCommand(commands, null, null, false);
                result = this.processResult(resultList, imageID);
            }
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        if (result == null) {
            result = new RHPValidationResult(RHPValidator.ValidatorID.QUERY_IMAGE_VALIDATOR, RHPValidationResult.ValidationStatus.SUCCESS, null, new Object[0]);
        }
        return result;
    }

    private RHPValidationResult processResult(List<RHPResult> resultList, String imgID) throws OPatchAutoException {
        RHPValidationResult validationResult = null;
        for (RHPResult result : resultList) {
            if (result.getReturnCode() != 0) {
                validationResult = new RHPValidationResult(RHPValidator.ValidatorID.QUERY_IMAGE_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.IMAGE_NOT_AVALIABLE, imgID);
                this._logger.fine("Query image error output::" + result.getErrorMessage());
            }
            this._logger.fine("Query image command output::" + result.getCommandOutput());
        }
        return validationResult;
    }
}

