/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class RepositoryUtils {
    private static String _logDestination;
    private static String _logLevel;

    public static Collection<String[]> parseNameVersionString(String s) throws RepositoryCommonException {
        String[] nameVersionSplit;
        if (StringUtil.isNullOrEmpty((String)s, (boolean)true)) {
            throw new RepositoryCommonException("Unable to parse null/empty name:version string.");
        }
        ArrayList<String[]> nameVersions = new ArrayList<String[]>();
        for (String nv : nameVersionSplit = s.split(",")) {
            try {
                String[] nameVersion = RepositoryUtils.parseSingleNameVersionString(nv);
                if (nameVersion == null) continue;
                nameVersions.add(nameVersion);
            }
            catch (RepositoryCommonException e) {
                throw new RepositoryCommonException("Unable to parse name:version string specified :" + s);
            }
        }
        return nameVersions;
    }

    public static String[] parseSingleNameVersionString(String nv) throws RepositoryCommonException {
        String[] nameVersion = null;
        if (!StringUtil.isNullOrEmpty((String)nv, (boolean)true)) {
            nameVersion = nv.split(":");
            if (nameVersion.length != 2) {
                throw new RepositoryCommonException("Unable to parse name:version string specified :" + nv);
            }
            nameVersion[0] = nameVersion[0].trim();
            nameVersion[1] = nameVersion[1].trim();
            if (nameVersion[0].length() < 1 || nameVersion[1].length() < 1) {
                throw new RepositoryCommonException("Unable to parse name:version string specified :" + nv);
            }
        }
        return nameVersion;
    }

    public static boolean isCARB(File file) {
        return "carb".equalsIgnoreCase(RepositoryUtils.getFileExtension(file.getName()));
    }

    public static boolean isJAR(File file) {
        return "jar".equalsIgnoreCase(RepositoryUtils.getFileExtension(file.getName()));
    }

    public static boolean isXML(File file) {
        return "xml".equalsIgnoreCase(RepositoryUtils.getFileExtension(file.getName()));
    }

    public static boolean isPOM(File file) {
        return "pom".equalsIgnoreCase(RepositoryUtils.getFileExtension(file.getName()));
    }

    private static String getFileExtension(String fileName) {
        int index;
        if (fileName != null && (index = fileName.lastIndexOf(".")) > -1 && index + 1 < fileName.length()) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static File createDir(String dirName) throws IOException {
        File tmpDir = new File(dirName);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Error creating Directory " + dirName);
        }
        return tmpDir;
    }

    public static File createFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            String absolutePath = file.getAbsolutePath();
            String filePath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
            RepositoryUtils.createDir(filePath);
            file.createNewFile();
        }
        return file;
    }

    public static Map<String, String> parseCommandLineArgs(String[] args) throws RepositoryCommonException {
        return RepositoryUtils.parseCommandLineArgs(args, null);
    }

    public static Map<String, String> parseCommandLineArgs(String[] args, Collection<String> requiredArgs) throws RepositoryCommonException {
        return RepositoryUtils.parseCommandLineArgs(args, requiredArgs, null);
    }

    public static Map<String, String> parseCommandLineArgs(String[] args, Collection<String> requiredArgs, Collection<String> switches) throws RepositoryCommonException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (args != null && args.length > 0) {
            for (int x = 0; x < args.length; ++x) {
                String value;
                String arg = args[x];
                if (arg == null || !arg.startsWith("-")) {
                    throw new RepositoryCommonException("Invalid argument: \"" + arg + "\" in list: " + Arrays.toString(args));
                }
                int eqIdx = arg.indexOf(61);
                if (eqIdx >= 0) {
                    options.put(arg.substring(0, eqIdx), arg.substring(eqIdx + 1));
                    continue;
                }
                if (args.length <= ++x || args[x].startsWith("-")) {
                    if (switches == null || !switches.contains(arg)) {
                        throw new RepositoryCommonException("Invalid argument: \"" + arg + "\" in list: " + Arrays.toString(args));
                    }
                    value = "true";
                } else {
                    value = args[x];
                }
                options.put(arg, value);
            }
        }
        if (requiredArgs != null && !requiredArgs.isEmpty()) {
            ArrayList<String> missingRequired = new ArrayList<String>(requiredArgs);
            for (String arg : options.keySet()) {
                missingRequired.remove(arg);
            }
            if (!missingRequired.isEmpty()) {
                throw new RepositoryCommonException("Missing Required Arguments: " + missingRequired);
            }
        }
        return options;
    }

    public static void setupLogging(Map<String, String> argMap) {
        RepositoryUtils.setupLogging(argMap, null);
    }

    public static void setupLogging(Map<String, String> argMap, String defaultLoggingDestination) {
        String log = null;
        String logLevel = null;
        if (argMap != null) {
            log = argMap.remove("-log");
            logLevel = argMap.remove("-logLevel");
        }
        RepositoryUtils.setupLogging(log, logLevel, defaultLoggingDestination);
    }

    public static void setupLogging(String log, String logLevel, String defaultLoggingDestination) {
        if (StringUtil.isNullOrEmpty((String)log, (boolean)true) && defaultLoggingDestination != null) {
            log = defaultLoggingDestination;
        }
        if (StringUtil.isNullOrEmpty((String)logLevel, (boolean)true)) {
            logLevel = Level.INFO.getName();
        }
        if (!StringUtil.isNullOrEmpty((String)log, (boolean)true)) {
            _logDestination = log;
            _logLevel = logLevel;
            LogFactory.getFactory().setupLogging(log, logLevel, new String[0]);
        }
    }

    public static String getLogDestination() {
        return _logDestination;
    }

    public static String getLogLevel() {
        return _logLevel;
    }
}

