/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.ant;

import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestFactory;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public abstract class CommonRepoTask
extends Task {
    protected String _log;
    protected String _logLevel;
    protected File _props;
    protected String _repoURL;
    protected File _localRepo;
    protected String _username;
    protected String _password;
    protected File _repoBaseDir;
    protected boolean _failOnError = true;
    protected String _resultProperty;
    protected Set<Property> _properties = new HashSet<Property>();
    protected boolean _logExecToConsole = false;
    protected List<Repo> _repos = new ArrayList<Repo>();

    public void execute() throws BuildException {
        try {
            RepositoryUtils.setupLogging(this._log, this._logLevel, "stdout");
            Properties properties = RepoCommonConfig.loadProperties(this.getProps());
            if (this.getProps() != null && !properties.containsKey("PROPERTIES_FILE_LOCATION")) {
                properties.setProperty("PROPERTIES_FILE_LOCATION", this.getProps().getAbsolutePath());
            }
            if (this.getProperties() != null && !this.getProperties().isEmpty()) {
                for (Property property : this.getProperties()) {
                    properties.setProperty(property.getName(), property.getValue());
                }
            }
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            if (this.getRepoURL() != null) {
                for (String repoURL : this.getRepoURL().split(",")) {
                    String trim = repoURL.trim();
                    if (trim.isEmpty()) continue;
                    repositories.add(RestFactory.getRepository(null, (String)trim, (String)this.getUsername(), (String)this.getPassword()));
                }
            }
            if (this.getRepos() != null && !this.getRepos().isEmpty()) {
                for (Repo repo : this.getRepos()) {
                    Repository repository = RestFactory.getRepository(null, (String)repo.getUrl(), (String)repo.getUsername(), (String)repo.getPassword());
                    if (repo.isLocalRepository()) {
                        repository.setLocalRepository(true);
                    }
                    if (repo.isReadOnly()) {
                        repository.setReadOnly(true);
                    }
                    repositories.add(repository);
                }
            }
            RepoCommonConfig repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(repositories, this.getLocalRepo(), properties, this.getRepoBaseDir());
            this.executeTask(repoCommonConfig);
            this.setProjectResultProperty("0");
        }
        catch (Exception e) {
            this.setProjectResultProperty("1");
            if (this._failOnError) {
                if (e instanceof BuildException) {
                    throw (BuildException)e;
                }
                throw new BuildException((Throwable)e);
            }
            StringWriter sw = new StringWriter();
            PrintWriter printWriter = new PrintWriter(sw);
            e.printStackTrace(printWriter);
            printWriter.close();
            this.log(sw.toString(), 0);
        }
    }

    protected void setProjectResultProperty(String result) {
        if (this.getResultProperty() != null && !this.getResultProperty().isEmpty()) {
            this.getProject().setNewProperty(this.getResultProperty(), result);
        }
    }

    protected abstract void executeTask(RepoCommonConfig var1) throws BuildException;

    public String getLog() {
        return this._log;
    }

    public void setLog(String log) {
        this._log = log;
    }

    public String getLogLevel() {
        return this._logLevel;
    }

    public void setLogLevel(String logLevel) {
        this._logLevel = logLevel;
    }

    public File getProps() {
        return this._props;
    }

    public void setProps(File props) {
        this._props = props;
    }

    public String getRepoURL() {
        return this._repoURL;
    }

    public void setRepoURL(String repoURL) {
        this._repoURL = repoURL;
    }

    public File getLocalRepo() {
        return this._localRepo;
    }

    public void setLocalRepo(File localRepo) {
        this._localRepo = localRepo;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public File getRepoBaseDir() {
        return this._repoBaseDir;
    }

    public void setRepoBaseDir(File repoBaseDir) {
        this._repoBaseDir = repoBaseDir;
    }

    public void setFailOnError(boolean failOnError) {
        this._failOnError = failOnError;
    }

    public String getResultProperty() {
        return this._resultProperty;
    }

    public void setResultProperty(String resultProperty) {
        this._resultProperty = resultProperty;
    }

    public Set<Property> getProperties() {
        return this._properties;
    }

    public Property createProperty() {
        Property p = new Property();
        this._properties.add(p);
        return p;
    }

    public List<Repo> getRepos() {
        return this._repos;
    }

    public Repo createRepo() {
        Repo repo = new Repo();
        this._repos.add(repo);
        return repo;
    }

    public void setLogExecToConsole(boolean logExecToConsole) {
        this._logExecToConsole = logExecToConsole;
    }

    public boolean isLogExecToConsole() {
        return this._logExecToConsole;
    }

    public static class Repo {
        private String _url;
        private String _username;
        private String _password;
        private boolean _localRepository;
        private boolean _readOnly;

        public String getUrl() {
            return this._url;
        }

        public void setUrl(String url) {
            this._url = url;
        }

        public String getUsername() {
            return this._username;
        }

        public void setUsername(String username) {
            this._username = username;
        }

        public String getPassword() {
            return this._password;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public boolean isLocalRepository() {
            return this._localRepository;
        }

        public void setLocalRepository(boolean localRepository) {
            this._localRepository = localRepository;
        }

        public boolean isReadOnly() {
            return this._readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this._readOnly = readOnly;
        }
    }
}

