/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.config;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RepoCommonConfig {
    public static final String PROPERTIES_FILE_LOCATION = "PROPERTIES_FILE_LOCATION";
    protected Properties _properties;
    protected File _repoBaseDir = null;
    protected List<Repository> _remoteRepositories = null;
    protected Repository _cacheRepository = null;

    public static RepoCommonConfig createRepoCommonConfig(String repo, String repoURL, String cacheRepo, Properties properties, File repoBaseDir, String username, String password) throws RestException, RepositoryCommonException {
        return RepoCommonConfig.createRepoCommonConfig(RepoCommonConfig.getRepoMap(repo, repoURL), cacheRepo, properties, repoBaseDir, username, password);
    }

    protected static Map<String, String> getRepoMap(String repo, String repoURL) {
        LinkedHashMap<String, String> repoMap = null;
        if (!StringUtil.isNullOrEmpty((String)repo, (boolean)true)) {
            if (repoURL == null) {
                repoURL = "";
            }
            repoMap = new LinkedHashMap<String, String>();
            repoMap.put(repo, repoURL);
        } else if (!StringUtil.isNullOrEmpty((String)repoURL, (boolean)true)) {
            String[] repoURLs;
            repoMap = new LinkedHashMap();
            for (String url : repoURLs = repoURL.split(",")) {
                url = url.trim();
                while (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                String repoName = url.substring(url.lastIndexOf("/") + 1);
                if (repoMap.containsKey(repoName) && !((String)repoMap.get(repoName)).equals(url)) {
                    repoName = url;
                }
                repoMap.put(repoName, url);
            }
        }
        return repoMap;
    }

    public static RepoCommonConfig createRepoCommonConfig(Map<String, String> repoMap, String cacheRepo, Properties properties, File repoBaseDir, String username, String password) throws RestException, RepositoryCommonException {
        return RepoCommonConfig.createRepoCommonConfig(RepoCommonConfig.getRemoteRepositoriesFromRepoMap(repoMap, username, password), RepoCommonConfig.getCacheRepoFile(cacheRepo), properties, repoBaseDir);
    }

    protected static List<Repository> getRemoteRepositoriesFromRepoMap(Map<String, String> repoMap, String username, String password) {
        ArrayList<Repository> remoteRepositories = null;
        if (repoMap != null && !repoMap.isEmpty()) {
            remoteRepositories = new ArrayList<Repository>();
            for (String repo : repoMap.keySet()) {
                String repoURL = repoMap.get(repo);
                if (!StringUtil.isNullOrEmpty((String)repoURL, (boolean)true)) {
                    remoteRepositories.add(RestFactory.getRepository((String)repo, (RepositoryType)RepositoryType.LOCAL, (String)repoURL, (String)repo, (String)username, (String)password));
                    continue;
                }
                remoteRepositories.add(RestFactory.getRepository((String)repo, (String)username, (String)password));
            }
        }
        return remoteRepositories;
    }

    protected static File getCacheRepoFile(String cacheRepo) {
        File cacheRepoFile = null;
        if (!StringUtil.isNullOrEmpty((String)cacheRepo, (boolean)true)) {
            cacheRepoFile = new File(cacheRepo);
        }
        return cacheRepoFile;
    }

    public static RepoCommonConfig createRepoCommonConfig(List<Repository> remoteRepositories, String cacheRepo, File propertiesFile, File repoBaseDir) throws RestException, RepositoryCommonException {
        File cacheRepoFile = null;
        if (!StringUtil.isNullOrEmpty((String)cacheRepo, (boolean)true)) {
            cacheRepoFile = new File(cacheRepo);
        }
        return RepoCommonConfig.createRepoCommonConfig(remoteRepositories, cacheRepoFile, propertiesFile, repoBaseDir);
    }

    public static RepoCommonConfig createRepoCommonConfig(List<Repository> remoteRepositories, File cacheRepo, File propertiesFile, File repoBaseDir) throws RestException, RepositoryCommonException {
        try {
            return RepoCommonConfig.createRepoCommonConfig(remoteRepositories, cacheRepo, RepoCommonConfig.loadProperties(propertiesFile), repoBaseDir);
        }
        catch (IOException e) {
            throw new RepositoryCommonException(e);
        }
    }

    public static RepoCommonConfig createRepoCommonConfig(List<Repository> remoteRepositories, File cacheRepo, Properties properties, File repoBaseDir) throws RestException, RepositoryCommonException {
        if (cacheRepo != null) {
            RestFactory.getRestHandlerConfig().setDefaultCacheRepository(cacheRepo);
        }
        return new RepoCommonConfig(remoteRepositories, RestFactory.getRestHandlerConfig().getDefaultCacheRepository(), properties, repoBaseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        if (propertiesFile != null) {
            if (!propertiesFile.exists() || !propertiesFile.isFile()) {
                throw new FileNotFoundException("File not found: " + propertiesFile.getAbsolutePath());
            }
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(propertiesFile);
                properties.load(fin);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public RepoCommonConfig(List<Repository> remoteRepositories, Repository cacheRepository, Properties properties, File repoBaseDir) throws RepositoryCommonException {
        this._remoteRepositories = remoteRepositories;
        if (cacheRepository == null) {
            throw new RepositoryCommonException("The cache repo must be specified.");
        }
        this._cacheRepository = cacheRepository;
        this._properties = new Properties();
        if (properties != null) {
            this._properties.putAll((Map<?, ?>)properties);
        }
        this._properties.setProperty("LOCAL_CACHE_REPOSITORY", cacheRepository.getCacheLocation().getAbsolutePath());
        this._repoBaseDir = repoBaseDir != null ? repoBaseDir : new File("target/repo-base-dir");
    }

    public List<Repository> getRemoteRepositories() {
        return this._remoteRepositories;
    }

    public void addRemoteRepository(Repository repository, boolean first) {
        if (repository != null) {
            if (this._remoteRepositories == null) {
                this._remoteRepositories = new ArrayList<Repository>();
            }
            if (first) {
                this._remoteRepositories.add(0, repository);
            } else {
                this._remoteRepositories.add(repository);
            }
        }
    }

    public Repository getCacheRepository() {
        return this._cacheRepository;
    }

    public Repository[] getRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (this._cacheRepository != null) {
            repositories.add(this._cacheRepository);
        }
        if (this._remoteRepositories != null) {
            repositories.addAll(this._remoteRepositories);
        }
        return repositories.toArray(new Repository[repositories.size()]);
    }

    public File getRepoBaseDir() {
        return this.getRepoBaseDir(true);
    }

    public File getRepoBaseDir(boolean mkdirs) {
        if (mkdirs) {
            this._repoBaseDir.mkdirs();
        }
        return this._repoBaseDir;
    }

    public void setRepoBaseDir(File repoBaseDir) {
        this._repoBaseDir = repoBaseDir;
    }

    public void setProperty(String key, String value) {
        if (StringUtil.isNullOrEmpty((String)key)) {
            return;
        }
        if (value == null) {
            this._properties.remove(key);
        } else {
            this._properties.setProperty(key, value);
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        if (StringUtil.isNullOrEmpty((String)key, (boolean)true)) {
            return defaultValue != null ? defaultValue : "";
        }
        String value = this._properties.getProperty(key);
        value = value != null ? value.trim() : defaultValue;
        return value;
    }

    public String getRepoUsername() {
        List<Repository> remoteRepos = this.getRemoteRepositories();
        if (remoteRepos != null && !remoteRepos.isEmpty()) {
            Repository repo = remoteRepos.get(0);
            return repo.getUsername();
        }
        return null;
    }

    public String getRepoPassword() {
        List<Repository> remoteRepos = this.getRemoteRepositories();
        if (remoteRepos != null && !remoteRepos.isEmpty()) {
            Repository repo = remoteRepos.get(0);
            return repo.getPassword();
        }
        return null;
    }

    public String getProperty(String key, boolean required) throws RepositoryCommonException {
        String value = this.getProperty(key);
        if (required && StringUtil.isNullOrEmpty((String)value)) {
            throw new RepositoryCommonException("The required property value was null or empty:" + key);
        }
        return value;
    }

    public boolean hasProperty(String key) {
        String value = this.getProperty(key);
        return !StringUtil.isNullOrEmpty((String)value, (boolean)true);
    }

    public void store(OutputStream out, String comments) throws IOException, RepositoryCommonException {
        if (this._properties != null) {
            this._properties.store(out, comments);
        }
    }

    public Properties getProperties() {
        return this._properties;
    }

    public Map<String, String> getProperties(String regex) {
        HashMap<String, String> propMap = null;
        if (regex != null) {
            Properties properties = this.getProperties();
            for (String name : properties.stringPropertyNames()) {
                String value;
                if (!name.matches(regex)) continue;
                if (propMap == null) {
                    propMap = new HashMap<String, String>();
                }
                if ((value = properties.getProperty(name)) != null) {
                    value = value.trim();
                }
                propMap.put(name, value);
            }
        }
        return propMap;
    }

    public void configureAuxLocalRepos(String auxLocalRepos, String readOnlyLocalRepos) {
        ArrayList<String> auxLocalReposList = new ArrayList<String>();
        if (!StringUtil.isNullOrEmpty((String)auxLocalRepos, (boolean)true)) {
            for (String auxRepo : auxLocalRepos.split(",")) {
                auxLocalReposList.add(auxRepo.trim());
            }
        }
        ArrayList<String> readOnlyLocalReposList = new ArrayList<String>();
        if (!StringUtil.isNullOrEmpty((String)readOnlyLocalRepos, (boolean)true)) {
            for (String readOnlyLocalRepo : readOnlyLocalRepos.split(",")) {
                auxLocalReposList.add(readOnlyLocalRepo.trim());
                readOnlyLocalReposList.add(readOnlyLocalRepo.trim());
            }
        }
        for (String auxRepo : auxLocalReposList) {
            Repository repository = RestFactory.getRepository(null, (String)auxRepo, null, null);
            repository.setLocalRepository(true);
            if (readOnlyLocalReposList.contains(auxRepo)) {
                repository.setReadOnly(true);
            }
            this.addRemoteRepository(repository, true);
        }
    }
}

