/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandler;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.GroupNameVersion;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.repository.common.CommonCommandLine;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleModifier
extends CommonCommandLine {
    private static final Logger _log = Logger.getLogger(ModuleModifier.class.getName());
    private RepoCommonConfig _repoCommonConfig;
    private Collection<Artifact> _artifacts;
    private String _groupId;
    private String _name;
    private String _version;
    private String _type;
    private Properties _properties;
    private Repository _destinationRepo;

    public ModuleModifier(RepoCommonConfig repoCommonConfig, Collection<Artifact> moduleArtifacts, String group, String name, String version, String type, Properties properties, Repository destinationRepo) {
        this._repoCommonConfig = repoCommonConfig;
        this._artifacts = moduleArtifacts;
        this._groupId = group;
        this._name = name;
        this._version = version;
        this._type = type;
        this._properties = properties;
        this._destinationRepo = destinationRepo;
    }

    public void modify() throws RepositoryCommonException {
        if (this._artifacts == null || this._artifacts.isEmpty()) {
            throw new RepositoryCommonException("No artifacts were specified for modification.");
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Modifying artifacts " + this._artifacts);
        }
        if (StringUtil.isNullOrEmpty((String)this._groupId, (boolean)true) && StringUtil.isNullOrEmpty((String)this._name, (boolean)true) && StringUtil.isNullOrEmpty((String)this._version, (boolean)true) && StringUtil.isNullOrEmpty((String)this._type, (boolean)true) && this._properties == null) {
            throw new RepositoryCommonException("No values were provided for modification.");
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Using modification values groupId=" + this._groupId + " name=" + this._name + " version=" + this._version + " type=" + this._type);
        }
        try {
            if (this._destinationRepo == null) {
                this._destinationRepo = RestFactory.getRestHandlerConfig().getDefaultCacheRepository();
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Defaulted destination repository to local-cache repository " + this._destinationRepo + " since one was not provided.");
                }
            } else if (!this._destinationRepo.getType().isCache()) {
                throw new RepositoryCommonException("The destination repository specified was not of type " + RepositoryType.CACHE);
            }
            RestHandler restHandler = RestFactory.getRestHandler();
            for (Artifact artifact : this._artifacts) {
                List dependencies;
                _log.info("Processing artifact " + artifact);
                File file = restHandler.retrieveArtifact(artifact, this._repoCommonConfig.getRemoteRepositories(), true);
                DependencyFileType type = DependencyManagementHelper.detectDependencyFileType((File)file);
                if (type == null) {
                    throw new RepositoryCommonException("Unable to determine dependency file type for artifact " + artifact + " which resides at " + file);
                }
                DependencyFileHandler fileHandler = DependencyManagementFactory.getInstance().getDependencyFileHandler(type);
                Module module = fileHandler.readDependenciesFile(file);
                this.modifyValues((GroupNameVersion)module);
                if (this._properties != null) {
                    _log.info("Changing properties of artifact " + artifact.getCoordinateString() + " from " + module.getProperties() + " to " + this._properties);
                    module.setProperties(this._properties);
                }
                if ((dependencies = module.getDependencies()) != null && !dependencies.isEmpty()) {
                    for (Artifact artifact1 : this._artifacts) {
                        for (Dependency dependency : dependencies) {
                            if (!dependency.equals((Object)artifact1)) continue;
                            _log.info("Changing values of dependency " + dependency.getCoordinateString() + " in module " + module.getCoordinateString());
                            this.modifyValues((GroupNameVersion)dependency);
                        }
                    }
                }
                File destFile = module.getLocalLocation(this._destinationRepo.getCacheLocation());
                fileHandler.writeDependenciesFile(module, destFile);
            }
        }
        catch (RepositoryCommonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryCommonException(e);
        }
    }

    private void modifyValues(GroupNameVersion gnv) {
        if (!StringUtil.isNullOrEmpty((String)this._groupId, (boolean)true)) {
            _log.info("Changing group of artifact " + gnv.getCoordinateString() + " from " + gnv.getGroup() + " to " + this._groupId);
            gnv.setGroup(this._groupId);
        }
        if (!StringUtil.isNullOrEmpty((String)this._name, (boolean)true)) {
            _log.info("Changing name of artifact " + gnv.getCoordinateString() + " from " + gnv.getName() + " to " + this._name);
            gnv.setName(this._name);
        }
        if (!StringUtil.isNullOrEmpty((String)this._version, (boolean)true)) {
            _log.info("Changing version of artifact " + gnv.getCoordinateString() + " from " + gnv.getVersionString() + " to " + this._version);
            gnv.setVersion(this._version);
        }
        if (!StringUtil.isNullOrEmpty((String)this._type, (boolean)true)) {
            _log.info("Changing type of artifact " + gnv.getCoordinateString() + " from " + gnv.getType() + " to " + this._type);
            gnv.setType(this._type);
        }
    }

    public static void main(String[] args) {
        int retVal = 0;
        try {
            LinkedHashMap<String, String> additionalArguments = new LinkedHashMap<String, String>();
            additionalArguments.put("modules", "<module-coordinates>");
            additionalArguments.put("group", "<group>");
            additionalArguments.put("name", "<name>");
            additionalArguments.put("version", "<version>");
            additionalArguments.put("type", "<type>");
            additionalArguments.put("properties", "<propName=propValue>");
            additionalArguments.put("destRepo", "<destRepo>");
            RepoCommonConfig repoCommonConfig = ModuleModifier.getRepoCommonConfig(args, additionalArguments);
            HashSet<Artifact> modules = null;
            String group = null;
            String name = null;
            String version = null;
            String type = null;
            Properties properties = null;
            Repository destRepo = null;
            Map<String, String> additionalArgumentValues = ModuleModifier.getAdditionalArgumentValues();
            if (additionalArgumentValues != null && !additionalArgumentValues.isEmpty()) {
                String[] split;
                String value = additionalArgumentValues.get("modules");
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    modules = new HashSet<Artifact>();
                    for (String s : split = value.trim().split(",")) {
                        modules.add(DependencyManagementFactory.getArtifact((String)s));
                    }
                }
                group = additionalArgumentValues.get("group");
                name = additionalArgumentValues.get("name");
                version = additionalArgumentValues.get("version");
                type = additionalArgumentValues.get("type");
                value = additionalArgumentValues.get("properties");
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    properties = new Properties();
                    for (String s : split = value.trim().split(",")) {
                        String[] nameValue = s.split("=");
                        if (nameValue.length != 2) {
                            throw new CommonCommandLine.CommonCommandLineException("The properties option was not the expected format <propName=propValue>");
                        }
                        properties.setProperty(nameValue[0], nameValue[1]);
                    }
                }
                if (!StringUtil.isNullOrEmpty((String)(value = additionalArgumentValues.get("destRepo")), (boolean)true)) {
                    destRepo = RestFactory.getRepository(null, (String)value, null, null);
                }
            }
            ModuleModifier moduleModifier = new ModuleModifier(repoCommonConfig, modules, group, name, version, type, properties, destRepo);
            moduleModifier.modify();
        }
        catch (CommonCommandLine.CommonCommandLineException e) {
            System.out.println(e.getMessage());
            ModuleModifier.printUsage(ModuleModifier.class);
            retVal = -1;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "The module modifier failed.", e);
            e.printStackTrace();
            retVal = -1;
        }
        System.exit(retVal);
    }
}

