/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

class DepUnselector
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private List<TVertex> _unselectedItems = new ArrayList<TVertex>();
    private List<TVertex> _conflictsErr = new ArrayList<TVertex>();

    DepUnselector(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
    }

    public List<TVertex> getUnselectedItems() {
        return this._unselectedItems;
    }

    public List<TVertex> getConflictsErr() {
        return this._conflictsErr;
    }

    public boolean hasErrors() {
        return !this._conflictsErr.isEmpty();
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._unselectedItems.clear();
        this._conflictsErr.clear();
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        if (edge == null) {
            this.trace("UNSELECTING DEPENDENCIES FOR ", vertex, ">");
        } else if (((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS) {
            this.trace("PROCESSING CONFLICT <", vertex, "> which conflicts with <" + edge.getDest(), ">");
        } else {
            this.trace("PROCESSING DEPENDENCY <", vertex, "> which depends on <" + edge.getDest(), ">");
        }
        VKey vKey = (VKey)vertex.getKey();
        if (edge != null && ((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS) {
            this.traceAction("NOACTION: no action for conflicting vertex ", vKey);
            return false;
        }
        if (vKey.getInstalledState() == VKey.InstalledState.INSTALLED) {
            this.traceAction("ERROR: cannot unselect installed vertex ", vKey);
            this._conflictsErr.add(vertex);
            return false;
        }
        if (vKey.getSelectedState() != VKey.SelectedState.SELECTED) {
            if (edge == null) {
                this.traceAction("NOACTION: the starting vertex is already unselected ", vKey);
                this._unselectedItems.add(vertex);
                return true;
            }
            this.traceAction("NOACTION: the vertex is not selected ", vKey);
            return false;
        }
        if (vKey.getType() == VKey.VType.OR_COND && ConditionHelper.isOrSatisfied(this._graph, vertex)) {
            this.traceAction("NOACTION: OR condition still holds, no need to unselect ", vKey);
            return false;
        }
        if (vKey.wasStateSetInOp()) {
            this.traceAction("ERROR: found dependency selected during current operation ", vKey);
            this._conflictsErr.add(vertex);
            return false;
        }
        if (vKey.getType() == VKey.VType.TINFO) {
            this.traceAction("UNSELECT: unselecting vertex ", vKey);
            vKey.setSelectedState(VKey.SelectedState.NOTSELECTED);
            this._unselectedItems.add(vertex);
        } else if (vKey.getType() == VKey.VType.AND_COND) {
            vKey.setSelectedState(VKey.SelectedState.PENDING_AND_COND);
        } else {
            this.traceAction("NOACTION: preserving state of intermediate AND and OR vertices for correct unselection of dependencies ", vKey);
        }
        return true;
    }
}

