/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionFinalizer;
import com.oracle.cie.dependency.ConditionMarker;
import com.oracle.cie.dependency.ConflictSourceFinder;
import com.oracle.cie.dependency.DepUnselector;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.DependencyHolder;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.ExtSelectabilityDetector;
import com.oracle.cie.dependency.InstalledCondCandMarker;
import com.oracle.cie.dependency.InstalledConditionResolver;
import com.oracle.cie.dependency.InstalledItemsMarker;
import com.oracle.cie.dependency.OrResolver;
import com.oracle.cie.dependency.PrereqsUnselector;
import com.oracle.cie.dependency.PrerequisitesSorter;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.UncondPrereqsSelector;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.dao.ConditionalOp;
import com.oracle.cie.dependency.dao.ConditionalOr;
import com.oracle.cie.dependency.dao.Dependency;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.DirectedGraphHelper;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SelectionTarget<T extends DependencyHolder> {
    private static Logger _log = Logger.getLogger(SelectionTarget.class.getName());
    protected DirectedGraph<VKey, TVertex, EKey, TEdge> _depGraph;
    protected Map<T, TVertex> _vertexMap;

    protected void init() {
        this._depGraph = new DirectedGraph<VKey, TVertex, EKey, TEdge>(TVertex.getFactory(), TEdge.getFactory());
        this.populateGraph();
        this.markExistingItems();
    }

    public DirectedGraph<VKey, TVertex, EKey, TEdge> getGraph() {
        return this._depGraph;
    }

    protected abstract List<T> getItems();

    protected abstract List<T> getItems(T var1, DependencyRef var2);

    protected abstract List<T> getImplicitConflicts(T var1);

    protected abstract List<T> getExistingItems();

    protected abstract Comparator<T> getItemComparator();

    protected abstract OrResolver getDefaultOrResolver(T var1, DependencyRef var2);

    protected OrResolver getDefaultOrResolver(T parent, DependencyRef req, ConditionalOr or) {
        return this.getDefaultOrResolver(parent, req);
    }

    protected abstract void throwSelectionConflictException(Collection<TVertex> var1, Collection<TVertex> var2, Collection<TVertex> var3, Collection<TVertex> var4) throws DependencyException;

    protected abstract void throwUndeterministicSelectionException(Collection<TVertex> var1, DirectedGraph<VKey, TVertex, EKey, TEdge> var2) throws DependencyException;

    protected void throwDependencyException(ErrorType errorType) throws DependencyException {
        this.throwDependencyException(errorType, null);
    }

    protected abstract void throwDependencyException(ErrorType var1, Throwable var2) throws DependencyException;

    public void setSelectableItems(Collection<T> selectable) {
        ArrayList<T> selectableCopy = new ArrayList<T>(selectable);
        for (DependencyHolder t : this._vertexMap.keySet()) {
            ((VKey)this._vertexMap.get(t).getKey()).setExtSelectable(selectableCopy.remove(t));
        }
        if (!selectableCopy.isEmpty()) {
            for (DependencyHolder missing : selectableCopy) {
                _log.warning("The selectable item is not in the graph: " + missing);
            }
        }
    }

    public void setSelectable(T item, boolean selectable) {
        TVertex v = this._vertexMap.get(item);
        if (v == null) {
            _log.warning("The selectable item is not in the graph: " + item);
        }
        ((VKey)this._vertexMap.get(item).getKey()).setExtSelectable(selectable);
    }

    public void setRequiredItems(Collection<T> required) {
        ArrayList<T> requiredCopy = new ArrayList<T>(required);
        for (DependencyHolder t : this._vertexMap.keySet()) {
            ((VKey)this._vertexMap.get(t).getKey()).setRequired(requiredCopy.remove(t));
        }
        if (!requiredCopy.isEmpty()) {
            for (DependencyHolder missing : requiredCopy) {
                _log.warning("The required item is not in the graph: " + missing);
            }
        }
    }

    public void setRequired(T item, boolean required) {
        TVertex v = this._vertexMap.get(item);
        if (v == null) {
            _log.warning("The selectable item is not in the graph: " + item);
        }
        ((VKey)this._vertexMap.get(item).getKey()).setRequired(required);
    }

    public List<T> getSelectableItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (!this.isSelectable(item)) continue;
            items.add(item);
        }
        return this.orderItems(items, true);
    }

    public List<T> getRequiredItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (!this.isRequired(item)) continue;
            items.add(item);
        }
        return items;
    }

    public List<T> getInstalledItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (!this.isInstalled(item)) continue;
            items.add(item);
        }
        return items;
    }

    public List<T> getSelectedItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (!this.isSelected(item)) continue;
            items.add(item);
        }
        return items;
    }

    public List<T> getUnSelectedItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (this.isSelected(item)) continue;
            items.add(item);
        }
        return items;
    }

    public List<T> getSelectedSelectableItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (!this.isSelectable(item) || !this.isSelected(item)) continue;
            items.add(item);
        }
        return items;
    }

    public Map<T, List<DependencyRef>> getUnresolvedItems() {
        HashMap<DependencyHolder, ArrayList<DependencyRef>> items = new HashMap<DependencyHolder, ArrayList<DependencyRef>>();
        for (TVertex vertex : this._depGraph.getVertices()) {
            if (!this.isUnresolved(vertex)) continue;
            DependencyHolder parent = (DependencyHolder)((VKey)vertex.getKey()).getParent();
            ArrayList<DependencyRef> refs = (ArrayList<DependencyRef>)items.get(parent);
            if (refs == null) {
                refs = new ArrayList<DependencyRef>();
                items.put(parent, refs);
            }
            refs.add(((VKey)vertex.getKey()).getUnresolvedDep());
        }
        return items;
    }

    public boolean isSelectable(T item) {
        TVertex v = this._vertexMap.get(item);
        return v != null && ((VKey)v.getKey()).isExtSelectable();
    }

    public boolean isRequired(T item) {
        TVertex v = this._vertexMap.get(item);
        return v != null && ((VKey)v.getKey()).isRequired();
    }

    public boolean isInstalled(T item) {
        TVertex v = this._vertexMap.get(item);
        return v != null && ((VKey)v.getKey()).getInstalledState() == VKey.InstalledState.INSTALLED;
    }

    public boolean isConflict(T item) {
        TVertex v = this._vertexMap.get(item);
        return v != null && ((VKey)v.getKey()).getInstalledState() == VKey.InstalledState.CONFLICTS_WITH_INSTALLED;
    }

    public boolean isSelected(T item) {
        TVertex v = this._vertexMap.get(item);
        return v != null && ((VKey)v.getKey()).getSelectedState() == VKey.SelectedState.SELECTED;
    }

    public boolean isUnresolved(TVertex v) {
        return v != null && ((VKey)v.getKey()).getType() == VKey.VType.UNRESOLVED;
    }

    public List<T> selectWithPrerequisites(T item) throws DependencyException {
        return this.selectWithPrerequisites(item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> selectWithPrerequisites(T item, boolean force) throws DependencyException {
        TVertex v;
        TVertex start = this._vertexMap.get(item);
        if (!force && !((VKey)start.getKey()).isExtSelectable()) {
            this.throwDependencyException(ErrorType.NOT_SELECTABLE);
        }
        if ((v = this._vertexMap.get(item)) == null) {
            this.throwDependencyException(ErrorType.NOT_PRESENT);
        }
        if (v != null && ((VKey)v.getKey()).getInstalledState() == VKey.InstalledState.INSTALLED) {
            _log.warning("Item is already installed.");
            this.throwDependencyException(ErrorType.ALREADY_INSTALLED);
        }
        if (v != null && ((VKey)v.getKey()).getSelectedState() == VKey.SelectedState.SELECTED) {
            _log.warning("Item is already selected.");
            this.throwDependencyException(ErrorType.ALREADY_SELECTED);
        }
        this.saveGraphState();
        ByteArrayOutputStream traceBuffer = _log.isLoggable(Level.FINEST) ? new ByteArrayOutputStream() : null;
        try {
            this.selectVertex(v, traceBuffer == null ? null : new PrintStream(traceBuffer));
            this.acceptGraphState();
        }
        catch (DependencyException ex) {
            this.restoreGraphState();
            throw ex;
        }
        catch (Throwable ex) {
            this.restoreGraphState();
            this.throwDependencyException(ErrorType.UNKNOWN, ex);
        }
        finally {
            if (traceBuffer != null) {
                _log.finest("\n" + traceBuffer.toString());
            }
        }
        this.dumpSelection();
        return this.getSelectedSelectableItems();
    }

    public List<T> unselectWithDependents(T item) throws DependencyException {
        return this.unselectWithDependents(item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> unselectWithDependents(T item, boolean force) throws DependencyException {
        TVertex v;
        TVertex start = this._vertexMap.get(item);
        if (!force && !((VKey)start.getKey()).isExtSelectable()) {
            this.throwDependencyException(ErrorType.NOT_SELECTABLE);
        }
        if ((v = this._vertexMap.get(item)) == null) {
            this.throwDependencyException(ErrorType.NOT_PRESENT);
        }
        if (v != null && ((VKey)v.getKey()).getInstalledState() == VKey.InstalledState.INSTALLED) {
            _log.warning("Item is installed and can not be unselected.");
            this.throwDependencyException(ErrorType.ALREADY_INSTALLED);
        }
        if (v != null && ((VKey)v.getKey()).getSelectedState() != VKey.SelectedState.SELECTED) {
            _log.warning("Item is not selected.");
            this.throwDependencyException(ErrorType.NOT_SELECTED);
        }
        ByteArrayOutputStream traceOut = null;
        if (_log.isLoggable(Level.FINEST)) {
            traceOut = new ByteArrayOutputStream();
        }
        this.saveGraphState();
        try {
            this.unselectVertex(v, traceOut == null ? null : new PrintStream(traceOut));
            this.acceptGraphState();
        }
        catch (DependencyException ex) {
            this.restoreGraphState();
            throw ex;
        }
        catch (Throwable ex) {
            this.restoreGraphState();
            this.throwDependencyException(ErrorType.UNKNOWN, ex);
        }
        finally {
            if (traceOut != null) {
                _log.finest("\n" + traceOut.toString());
            }
        }
        this.dumpSelection();
        return this.getSelectedSelectableItems();
    }

    public List<T> getOrderedSelection() {
        return this.orderItems(this.getSelectedItems(), false);
    }

    public List<T> getOrderedUnSelection() {
        return this.orderItems(this.getUnSelectedItems(), false);
    }

    public List<T> getOrderedSelectableItems() {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        for (DependencyHolder item : this._vertexMap.keySet()) {
            if (!this.isSelectable(item)) continue;
            items.add(item);
        }
        return this.orderItems(items, false);
    }

    public List<T> getOrderedItems() {
        return this.orderItems(new ArrayList<T>(this._vertexMap.keySet()), false);
    }

    public void clearSelection() {
        for (TVertex v : this._depGraph.getVertices()) {
            ((VKey)v.getKey()).setSelectedState(VKey.SelectedState.NOTSELECTED);
        }
        this.dumpSelection();
    }

    public void resolveVertex(T item, TVertex vertex) {
        if (this.isUnresolved(vertex)) {
            this._vertexMap.put(item, vertex);
            VKey<T> key = VKey.newKey(item);
            this.getGraph().replaceVertexKey((VKey)vertex.getKey(), key);
            vertex.setKey(key);
            this.addDependencies(item, vertex);
            this.addImplicitConflicts(item, vertex);
        }
    }

    public void unselectAll() {
        for (TVertex vertex : this._vertexMap.values()) {
            if (((VKey)vertex.getKey()).getSelectedState() != VKey.SelectedState.SELECTED) continue;
            ((VKey)vertex.getKey()).setSelectedState(VKey.SelectedState.NOTSELECTED);
        }
    }

    protected void populateGraph() {
        List<T> items = this.getItems();
        this._vertexMap = new LinkedHashMap<T, TVertex>();
        for (DependencyHolder t : items) {
            this._vertexMap.put(t, this._depGraph.insertVertex(VKey.newKey(t)));
        }
        for (TVertex vertex : this._vertexMap.values()) {
            DependencyHolder item = (DependencyHolder)((VKey)vertex.getKey()).getItem();
            this.addDependencies(item, vertex);
            this.addImplicitConflicts(item, vertex);
        }
    }

    protected void addDependencies(T item, TVertex vertex) {
        Dependency dep;
        if (item != null && vertex != null && (dep = item.getDependency()) != null) {
            if (dep.isSetAnd()) {
                this.addAndDependency(item, vertex, dep.getAnd());
            }
            if (dep.isSetOr()) {
                this.addOrDependency(item, vertex, dep.getConditionalOr());
            }
            if (dep.isSetRequires()) {
                this.addRequiresDep(item, vertex, dep.getRequires());
            }
            if (dep.isSetConflicts()) {
                this.addConflictsDep(item, vertex, dep.getConflicts());
            }
        }
    }

    protected void addAndDependency(T parentItem, TVertex parent, ConditionalOp and) {
        TVertex parentV = ((VKey)parent.getKey()).getType() != VKey.VType.OR_COND ? parent : this._depGraph.attachVertexFrom(parent, VKey.newAndKey(parentItem, and.toString(), and), EKey.newKey());
        ((VKey)parentV.getKey()).setId(and.getId());
        for (ConditionalOp conditionalOp : and.getAnd()) {
            this.addAndDependency(parentItem, parentV, conditionalOp);
        }
        for (ConditionalOp conditionalOp : and.getConditionalOr()) {
            this.addOrDependency(parentItem, parentV, conditionalOp);
        }
        for (DependencyRef dependencyRef : and.getRequires()) {
            this.addRequiresDep(parentItem, parentV, dependencyRef);
        }
        for (DependencyRef dependencyRef : and.getConflicts()) {
            this.addConflictsDep(parentItem, parentV, dependencyRef);
        }
    }

    protected void addOrDependency(T parentItem, TVertex parent, ConditionalOp or) {
        TVertex parentV = null;
        parentV = ((VKey)parent.getKey()).getType() == VKey.VType.OR_COND ? parent : (or instanceof ConditionalOr && ((ConditionalOr)or).getDefaultChoiceString() != null ? this._depGraph.attachVertexFrom(parent, VKey.newResolvableOrKey(parentItem, or.toString(), this.getDefaultOrResolver(parentItem, null, (ConditionalOr)or)), EKey.newKey()) : this._depGraph.attachVertexFrom(parent, VKey.newOrKey(parentItem, or.toString()), EKey.newKey()));
        ((VKey)parentV.getKey()).setId(or.getId());
        for (ConditionalOp conditionalOp : or.getAnd()) {
            this.addAndDependency(parentItem, parentV, conditionalOp);
        }
        for (ConditionalOp conditionalOp : or.getConditionalOr()) {
            this.addOrDependency(parentItem, parentV, conditionalOp);
        }
        for (DependencyRef dependencyRef : or.getRequires()) {
            this.addRequiresDep(parentItem, parentV, dependencyRef);
        }
        for (DependencyRef dependencyRef : or.getConflicts()) {
            this.addConflictsDep(parentItem, parentV, dependencyRef);
        }
    }

    protected void addRequiresDep(T parentItem, TVertex parent, DependencyRef req) {
        List<T> matches = this.getItems(parentItem, req);
        String id = req.getId();
        switch (matches.size()) {
            case 0: {
                VKey<T> newkey = VKey.newUnresolvedKey(parentItem, req);
                newkey.setId(id);
                this._depGraph.attachVertexFrom(parent, newkey, EKey.newKey());
                break;
            }
            case 1: {
                ((VKey)this._vertexMap.get(matches.get(0)).getKey()).setId(id);
                this._depGraph.insertDirectedEdge(parent, this._vertexMap.get(matches.get(0)), EKey.newKey());
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder("Multiple dependency matches: ");
                for (DependencyHolder match : matches) {
                    sb.append(match).append(" ");
                }
                TVertex orV = ((VKey)parent.getKey()).getType() == VKey.VType.OR_COND ? parent : this._depGraph.attachVertexFrom(parent, VKey.newResolvableOrKey(parentItem, sb.toString(), this.getDefaultOrResolver(parentItem, req)), EKey.newKey());
                for (DependencyHolder match : matches) {
                    this._depGraph.insertDirectedEdge(orV, this._vertexMap.get(match), EKey.newKey());
                    ((VKey)this._vertexMap.get(match).getKey()).setId(id);
                }
            }
        }
    }

    protected void addConflictsDep(T parentItem, TVertex parent, DependencyRef confl) {
        List<T> matches = this.getItems(parentItem, confl);
        switch (matches.size()) {
            case 0: {
                this._depGraph.attachVertexFrom(parent, VKey.newUnresolvedKey(parentItem, confl), EKey.newConflictKey());
                break;
            }
            default: {
                for (DependencyHolder match : matches) {
                    this._depGraph.insertDirectedEdge(parent, this._vertexMap.get(match), EKey.newConflictKey());
                }
            }
        }
    }

    protected void addImplicitConflicts(T parentItem, TVertex parent) {
        List<T> matches = this.getImplicitConflicts(parentItem);
        for (DependencyHolder match : matches) {
            this._depGraph.insertDirectedEdge(parent, this._vertexMap.get(match), EKey.newConflictKey());
        }
    }

    protected void saveGraphState() {
        for (TVertex v : this._depGraph.getVertices()) {
            ((VKey)v.getKey()).startSelectionOperation();
        }
    }

    protected void restoreGraphState() {
        for (TVertex v : this._depGraph.getVertices()) {
            ((VKey)v.getKey()).rollbackSelectionOperation();
        }
    }

    protected void acceptGraphState() {
        for (TVertex v : this._depGraph.getVertices()) {
            ((VKey)v.getKey()).commitSelectionOperation();
        }
    }

    protected void markExistingItems() {
        this.markExistingItems(this.getExistingItems());
    }

    protected void markExistingItems(List<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<TVertex> vertices = new ArrayList<TVertex>();
        for (DependencyHolder th : items) {
            TVertex v = this._vertexMap.get(th);
            if (v == null) {
                _log.info("Item is not present in the graph: " + th);
                continue;
            }
            vertices.add(v);
        }
        this.markInstalledVertices(vertices);
    }

    protected void markInstalledVertices(List<TVertex> vertices) {
        ByteArrayOutputStream traceBuffer = _log.isLoggable(Level.FINEST) ? new ByteArrayOutputStream() : null;
        PrintStream traceOut = traceBuffer == null ? null : new PrintStream(traceBuffer);
        for (TVertex v : vertices) {
            VKey vKey = (VKey)v.getKey();
            if (vKey.getInstalledState() == VKey.InstalledState.INSTALLED) {
                _log.warning("Duplicate entry in the installed items list: " + vKey);
                continue;
            }
            vKey.setInstalledState(VKey.InstalledState.INSTALLED);
        }
        ArrayList<TVertex> verticesWithCondConflicts = new ArrayList<TVertex>();
        InstalledItemsMarker selMarker = new InstalledItemsMarker(this._depGraph, traceOut);
        for (TVertex v : vertices) {
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, selMarker, v, true);
            if (!selMarker.hasConditionalConflicts()) continue;
            verticesWithCondConflicts.add(v);
        }
        if (!verticesWithCondConflicts.isEmpty()) {
            boolean anyConditionsResolved;
            InstalledConditionResolver condResolver = new InstalledConditionResolver(this._depGraph, traceOut);
            do {
                anyConditionsResolved = false;
                for (TVertex v : verticesWithCondConflicts) {
                    DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, condResolver, v, true);
                    anyConditionsResolved = anyConditionsResolved || condResolver.wasAbleToResolveCondition();
                }
            } while (anyConditionsResolved);
        }
        InstalledCondCandMarker condMarker = new InstalledCondCandMarker(this._depGraph, traceOut);
        for (TVertex v : vertices) {
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, condMarker, v, true);
        }
        for (TVertex v : this._depGraph.getVertices()) {
            VKey key = (VKey)v.getKey();
            if (key.getInstalledState() != VKey.InstalledState.COND_PREREQ_CANDIDATE && key.getInstalledState() != VKey.InstalledState.COND_CONFL_CANDIDATE) continue;
            key.setInstalledState(VKey.InstalledState.NOTINSTALLED);
        }
        if (traceBuffer != null) {
            _log.finest("\n" + traceBuffer.toString());
        }
    }

    protected void selectVertex(TVertex vertex, PrintStream traceOut) throws DependencyException {
        UncondPrereqsSelector sel = new UncondPrereqsSelector(this._depGraph, traceOut);
        ConditionMarker orMarker = new ConditionMarker(this._depGraph, traceOut);
        ConditionFinalizer orFinalizer = new ConditionFinalizer(this._depGraph, traceOut);
        ConflictSourceFinder conflSourceFinder = new ConflictSourceFinder(this._depGraph, traceOut);
        LinkedList<TVertex> verticesToSelect = new LinkedList<TVertex>();
        LinkedHashSet<TVertex> verticesToUnselect = new LinkedHashSet<TVertex>();
        LinkedHashSet<TVertex> orsToResolve = new LinkedHashSet<TVertex>();
        verticesToSelect.add(vertex);
        if (traceOut != null) {
            traceOut.println("SELECTING " + vertex.getKey());
        }
        while (!verticesToSelect.isEmpty() || !verticesToUnselect.isEmpty()) {
            while (!verticesToSelect.isEmpty()) {
                TVertex toSelect = (TVertex)verticesToSelect.removeFirst();
                DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, sel, toSelect, true);
                if (sel.hasErrors()) {
                    if (traceOut != null) {
                        traceOut.println("ERROR: couldn't select " + toSelect);
                    }
                    this.throwSelectionConflictException(sel.getUnresolvedPrereqsErr(), sel.getSelfConflictsErr(), sel.getPrereqsConflictingWithInstalledErr(), sel.getInstalledConflictsErr());
                }
                verticesToUnselect.addAll(sel.getConflictsWhichWerePrevioslySelected());
                for (TVertex priorConfl : sel.getSelectionsWhichWerePrevioslyConflicts()) {
                    DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, conflSourceFinder, priorConfl, false);
                    verticesToUnselect.addAll(conflSourceFinder.getConflictSourceItems());
                }
                orsToResolve.addAll(sel.getUnresolvedOrs());
            }
            for (TVertex toUnselect : verticesToUnselect) {
                _log.finer("Unselecting " + ((VKey)toUnselect.getKey()).getItem() + " since it conflicts with " + ((VKey)vertex.getKey()).getItem());
                this.unselectVertex(toUnselect, traceOut);
            }
            verticesToUnselect.clear();
            ArrayList<TVertex> resolvedOrs = new ArrayList<TVertex>();
            ArrayList<TVertex> resolvableOrs = new ArrayList<TVertex>();
            ArrayList<TVertex> possiblyResolvableOrs = new ArrayList<TVertex>();
            ArrayList<TVertex> unresolvableOrs = new ArrayList<TVertex>();
            for (TVertex or : orsToResolve) {
                DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, orMarker, or, true);
                switch (((VKey)or.getKey()).getSelectedState()) {
                    case NOTSELECTED: {
                        unresolvableOrs.add(or);
                        break;
                    }
                    case RESOLVED_SELECTION_CANDIDATE: {
                        resolvedOrs.add(or);
                        break;
                    }
                    case RESOLVABLE_SELECTION_CANDIDATE: {
                        resolvableOrs.add(or);
                        break;
                    }
                    case POSSIBLE_SELECTION_CANDIDATE: {
                        possiblyResolvableOrs.add(or);
                    }
                }
            }
            orsToResolve.clear();
            if (!unresolvableOrs.isEmpty()) {
                if (traceOut != null) {
                    traceOut.println("ERROR: found unresolvable <ORs> " + unresolvableOrs);
                }
                this.throwUndeterministicSelectionException(unresolvableOrs, this._depGraph);
            }
            orsToResolve.addAll(possiblyResolvableOrs);
            for (TVertex resolvedOr : resolvedOrs) {
                DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, orFinalizer, resolvedOr, true);
                assert (!orFinalizer.hasErrors());
            }
            boolean selectionChanged = false;
            for (TVertex resolvableOr : resolvableOrs) {
                if (selectionChanged) {
                    orsToResolve.add(resolvableOr);
                    continue;
                }
                DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, orFinalizer, resolvableOr, true);
                if (orFinalizer.hasErrors()) {
                    if (!orFinalizer.getUnresolvedPrereqsErr().isEmpty() || !orFinalizer.getSelfConflictsErr().isEmpty()) {
                        if (traceOut != null) {
                            traceOut.println("ERROR: couldn't resolve " + resolvableOr);
                        }
                        this.throwSelectionConflictException(orFinalizer.getUnresolvedPrereqsErr(), orFinalizer.getSelfConflictsErr(), null, null);
                        continue;
                    }
                    for (TVertex rollbackVtx : orFinalizer.getModifiedVertices()) {
                        ((VKey)rollbackVtx.getKey()).resetSelectionOperation();
                    }
                    orsToResolve.add(resolvableOr);
                    continue;
                }
                selectionChanged = !orFinalizer.getSelectedItemVertices().isEmpty() || !orFinalizer.getPriorSelectedConflicts().isEmpty();
                verticesToSelect.addAll(orFinalizer.getSelectedItemVertices());
                verticesToUnselect.addAll(orFinalizer.getPriorSelectedConflicts());
            }
        }
        if (!orsToResolve.isEmpty()) {
            this.throwUndeterministicSelectionException(orsToResolve, this._depGraph);
        }
    }

    protected void unselectVertex(TVertex vertex, PrintStream traceOut) throws DependencyException {
        DepUnselector depUnselector = new DepUnselector(this._depGraph, traceOut);
        PrereqsUnselector prereqsUnselector = new PrereqsUnselector(this._depGraph, traceOut);
        ExtSelectabilityDetector reachDetector = new ExtSelectabilityDetector(traceOut);
        LinkedList<TVertex> verticesToUnselect = new LinkedList<TVertex>();
        verticesToUnselect.add(vertex);
        if (traceOut != null) {
            traceOut.println("UNSELECTING " + vertex.getKey());
        }
        while (!verticesToUnselect.isEmpty()) {
            TVertex currVtx = (TVertex)verticesToUnselect.removeFirst();
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, depUnselector, currVtx, false);
            if (depUnselector.hasErrors()) {
                if (traceOut != null) {
                    traceOut.println("ERROR: unable to unselect vertex: " + currVtx);
                }
                this.throwSelectionConflictException(null, depUnselector.getConflictsErr(), null, null);
            }
            ArrayList<TVertex> unselectionCandidates = new ArrayList<TVertex>();
            for (TVertex unselVtx : depUnselector.getUnselectedItems()) {
                DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, prereqsUnselector, unselVtx, true);
                unselectionCandidates.addAll(prereqsUnselector.getUnselectionCandidates());
            }
            for (TVertex candVtx : unselectionCandidates) {
                DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, reachDetector, candVtx, false);
                if (reachDetector.isReachableFromExtSelectable()) continue;
                if (traceOut != null) {
                    traceOut.println("ORPHAN_VERTEX: vertex needs to be unselected: " + candVtx);
                }
                verticesToUnselect.add(candVtx);
            }
        }
    }

    protected List<T> orderItems(List<T> items, boolean isSelectable) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        ByteArrayOutputStream traceBuffer = _log.isLoggable(Level.FINEST) ? new ByteArrayOutputStream() : null;
        PrintStream traceOut = traceBuffer == null ? null : new PrintStream(traceBuffer);
        HashSet<Object> vertices = new HashSet<Object>();
        HashSet<DependencyHolder> foreignItems = new HashSet<DependencyHolder>();
        for (DependencyHolder item : items) {
            TVertex v = this._vertexMap.get(item);
            if (v == null) {
                _log.warning("Item is not in the graph: " + item);
                if (foreignItems.add(item)) continue;
                _log.warning("Found duplicate item: " + item);
                continue;
            }
            if (vertices.add(v)) continue;
            _log.warning("Found duplicate item: " + item);
        }
        ArrayList<List<TVertex>> reversePreqsChains = new ArrayList<List<TVertex>>();
        PrerequisitesSorter sorter = new PrerequisitesSorter(traceOut);
        for (Object v : vertices) {
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, sorter, v, true, sorter);
            reversePreqsChains.add(sorter.getReversePrereqsList());
        }
        ArrayList<Object> groups = new ArrayList<Object>();
        for (List list : reversePreqsChains) {
            Object primary = null;
            ArrayList<PrereqsChainGroup> arrayList = new ArrayList<PrereqsChainGroup>();
            for (PrereqsChainGroup prereqsChainGroup : groups) {
                if (!prereqsChainGroup.hasCommonVertices(list)) continue;
                if (primary == null) {
                    primary = prereqsChainGroup;
                    ((PrereqsChainGroup)primary).addChain(list);
                    continue;
                }
                arrayList.add(prereqsChainGroup);
            }
            if (primary == null) {
                PrereqsChainGroup group = this.createPrereqsChainGroup(list);
                groups.add(group);
                continue;
            }
            for (PrereqsChainGroup prereqsChainGroup : arrayList) {
                ((PrereqsChainGroup)primary).addGroup(prereqsChainGroup);
                groups.remove(prereqsChainGroup);
            }
        }
        PrereqsChainGroupComparator comp = new PrereqsChainGroupComparator();
        Collections.sort(groups, comp);
        LinkedHashSet<TVertex> linkedHashSet = new LinkedHashSet<TVertex>();
        for (PrereqsChainGroup prereqsChainGroup : groups) {
            ArrayList<TVertex> groupVertices = new ArrayList<TVertex>(prereqsChainGroup.getSortedVertices());
            if (isSelectable) {
                Collections.reverse(groupVertices);
            }
            linkedHashSet.addAll(groupVertices);
        }
        linkedHashSet.retainAll(vertices);
        ArrayList<DependencyHolder> finalList = new ArrayList<DependencyHolder>();
        for (TVertex v : linkedHashSet) {
            finalList.add((DependencyHolder)((VKey)v.getKey()).getItem());
        }
        finalList.addAll(foreignItems);
        assert (finalList.containsAll(items));
        if (traceBuffer != null) {
            _log.finest("\n" + traceBuffer.toString());
        }
        return finalList;
    }

    public List<T> getDirectDependencies(T item) {
        final ArrayList items = new ArrayList();
        TVertex vertex = this._vertexMap.get(item);
        if (vertex != null) {
            VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> visitor = new VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>>(System.out){

                @Override
                public boolean preVisit(TEdge edge, TVertex vertex) {
                    super.preVisit(edge, vertex);
                    if (edge == null) {
                        return true;
                    }
                    EKey eKey = (EKey)edge.getKey();
                    VKey vKey = (VKey)vertex.getKey();
                    if (eKey.getType() != EKey.EType.CONFLICTS && vKey.getType() == VKey.VType.TINFO) {
                        items.add((DependencyHolder)((VKey)vertex.getKey()).getItem());
                    }
                    return vKey.getType() != VKey.VType.TINFO && vKey.getType() != VKey.VType.UNRESOLVED;
                }
            };
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, visitor, vertex, true);
        }
        return items;
    }

    public List<T> getSelectedDirectDependencies(T item) {
        ArrayList<DependencyHolder> items = new ArrayList<DependencyHolder>();
        List<T> directDependencies = this.getDirectDependencies(item);
        List<T> orderedSelection = this.getOrderedSelection();
        for (DependencyHolder orderedItem : orderedSelection) {
            if (!directDependencies.contains(orderedItem)) continue;
            items.add(orderedItem);
        }
        return items;
    }

    public List<T> getAllDependencies(T item) {
        final ArrayList items = new ArrayList();
        TVertex vertex = this._vertexMap.get(item);
        if (vertex != null) {
            VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> visitor = new VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>>(System.out){

                @Override
                public boolean preVisit(TEdge edge, TVertex vertex) {
                    super.preVisit(edge, vertex);
                    if (edge == null) {
                        return true;
                    }
                    EKey eKey = (EKey)edge.getKey();
                    VKey vKey = (VKey)vertex.getKey();
                    if (eKey.getType() == EKey.EType.CONFLICTS || vKey.getType() == VKey.VType.UNRESOLVED) {
                        return false;
                    }
                    if (vKey.getType() == VKey.VType.TINFO) {
                        items.add((DependencyHolder)((VKey)vertex.getKey()).getItem());
                    }
                    return true;
                }
            };
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, visitor, vertex, true);
        }
        return items;
    }

    public List<T> getAllDependents(T item) {
        final ArrayList items = new ArrayList();
        TVertex vertex = this._vertexMap.get(item);
        if (vertex != null) {
            VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> visitor = new VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>>(System.out){

                @Override
                public boolean preVisit(TEdge edge, TVertex vertex) {
                    super.preVisit(edge, vertex);
                    if (edge == null) {
                        return true;
                    }
                    EKey eKey = (EKey)edge.getKey();
                    VKey vKey = (VKey)vertex.getKey();
                    if (eKey.getType() == EKey.EType.CONFLICTS || vKey.getType() == VKey.VType.UNRESOLVED) {
                        return false;
                    }
                    if (vKey.getType() == VKey.VType.TINFO) {
                        items.add((DependencyHolder)((VKey)vertex.getKey()).getItem());
                    }
                    return true;
                }
            };
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, visitor, vertex, false);
        }
        return items;
    }

    public List<T> getAllDirectConflicts(T item) {
        final LinkedHashSet items = new LinkedHashSet();
        TVertex vertex = this._vertexMap.get(item);
        if (vertex != null) {
            VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> visitor = new VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>>(System.out){

                @Override
                public boolean preVisit(TEdge edge, TVertex vertex) {
                    super.preVisit(edge, vertex);
                    if (edge == null) {
                        return true;
                    }
                    EKey eKey = (EKey)edge.getKey();
                    VKey vKey = (VKey)vertex.getKey();
                    if (vKey.getType() == VKey.VType.UNRESOLVED) {
                        return false;
                    }
                    if (eKey.getType() == EKey.EType.CONFLICTS && vKey.getType() == VKey.VType.TINFO) {
                        items.add((DependencyHolder)((VKey)vertex.getKey()).getItem());
                    }
                    return false;
                }
            };
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, visitor, vertex, true);
            DirectedGraphHelper.depthFirstEdgeTraversal(this._depGraph, visitor, vertex, false);
        }
        return new ArrayList(items);
    }

    public void dumpInstalled() {
        if (_log.isLoggable(Level.FINER)) {
            StringBuilder instSb = new StringBuilder("\n");
            instSb.append("INSTALLED ITEMS\n");
            instSb.append("---------------------------------------------------------------\n");
            StringBuilder conflSb = new StringBuilder();
            conflSb.append("---------------------------------------------------------------\n");
            conflSb.append("CONFLICTS\n");
            conflSb.append("---------------------------------------------------------------\n");
            StringBuilder posConflSb = new StringBuilder();
            posConflSb.append("---------------------------------------------------------------\n");
            posConflSb.append("POSSIBLE CONFLICTS\n");
            posConflSb.append("---------------------------------------------------------------\n");
            for (DependencyHolder item : this._vertexMap.keySet()) {
                TVertex v = this._vertexMap.get(item);
                switch (((VKey)v.getKey()).getInstalledState()) {
                    case INSTALLED: {
                        instSb.append(item).append('\n');
                        break;
                    }
                    case CONFLICTS_WITH_INSTALLED: {
                        conflSb.append(item).append('\n');
                        break;
                    }
                    case COND_CONFL: {
                        posConflSb.append(item).append('\n');
                    }
                }
            }
            _log.finer(instSb.append((CharSequence)conflSb).append((CharSequence)posConflSb).toString());
        }
    }

    public void dumpSelection() {
        if (_log.isLoggable(Level.FINE)) {
            StringBuilder selSb = new StringBuilder("\n");
            selSb.append("SELECTED SELECTABLE ITEMS\n");
            selSb.append("---------------------------------------------------------------\n");
            StringBuilder nonSelSb = new StringBuilder();
            nonSelSb.append("---------------------------------------------------------------\n");
            nonSelSb.append("SELECTED NON-SElECTABLE ITEMS\n");
            nonSelSb.append("---------------------------------------------------------------\n");
            List<T> selItems = this.getSelectedItems();
            for (DependencyHolder selItem : selItems) {
                if (this.isSelectable(selItem)) {
                    selSb.append(selItem).append('\n');
                    continue;
                }
                nonSelSb.append(selItem).append('\n');
            }
            _log.fine(selSb.append((CharSequence)nonSelSb).toString());
        }
    }

    public void dumpGraph() {
        if (_log.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder("\n");
            sb.append("---------------------------------------------------------------\n");
            sb.append("ALL VERTICES\n");
            sb.append("---------------------------------------------------------------\n");
            for (TVertex vertex : this._depGraph.getVertices()) {
                sb.append(vertex).append('\n');
            }
            sb.append("---------------------------------------------------------------\n");
            _log.finer(sb.toString());
        }
        this.dumpInstalled();
        this.dumpSelection();
    }

    protected PrereqsChainGroup createPrereqsChainGroup(List<TVertex> chain) {
        return new PrereqsChainGroup(chain);
    }

    public static enum ErrorType {
        NOT_SELECTABLE,
        NOT_PRESENT,
        ALREADY_INSTALLED,
        ALREADY_SELECTED,
        NOT_SELECTED,
        CONFLICTS,
        UNDETERMINISTIC,
        UNKNOWN;

    }

    protected class PrereqsChainGroup {
        private final ReversePrereqsChainComparator _comp;
        private Set<TVertex> _vertices;
        private SortedSet<List<TVertex>> _prereqsChains;
        private Integer _numReqItems;

        protected PrereqsChainGroup(List<TVertex> depChain) {
            this._comp = new ReversePrereqsChainComparator();
            this._vertices = new HashSet<TVertex>();
            this._prereqsChains = new TreeSet<List<TVertex>>(this._comp);
            this.addChain(depChain);
        }

        public SortedSet<List<TVertex>> getPrereqsChains() {
            return this._prereqsChains;
        }

        public LinkedHashSet<TVertex> getSortedVertices() {
            boolean dropEmptyChains = this._prereqsChains.size() > 1;
            LinkedHashSet<TVertex> vertexList = new LinkedHashSet<TVertex>();
            for (List list : this._prereqsChains) {
                if (dropEmptyChains && list.size() == 1) continue;
                vertexList.addAll(list);
            }
            return vertexList;
        }

        public boolean hasCommonVertices(List<TVertex> depChain) {
            for (TVertex v : depChain) {
                if (!this._vertices.contains(v)) continue;
                return true;
            }
            return false;
        }

        public void addChain(List<TVertex> chain) {
            this._prereqsChains.add(chain);
            this._vertices.addAll(chain);
            this._numReqItems = null;
        }

        public void addGroup(PrereqsChainGroup g) {
            this._prereqsChains.addAll(g._prereqsChains);
            this._vertices.addAll(g._vertices);
            this._numReqItems = null;
        }

        public int getNumRequiredVertices() {
            if (this._numReqItems == null) {
                int num = 0;
                for (TVertex v : this._vertices) {
                    if (!((VKey)v.getKey()).isRequired()) continue;
                    ++num;
                }
                this._numReqItems = num;
            }
            return this._numReqItems;
        }

        public int getSize() {
            return this._prereqsChains.size();
        }
    }

    private class PrereqsChainGroupComparator
    implements Comparator<PrereqsChainGroup> {
        private Comparator<T> _itemComp;

        private PrereqsChainGroupComparator() {
            this._itemComp = SelectionTarget.this.getItemComparator();
        }

        @Override
        public int compare(PrereqsChainGroup group1, PrereqsChainGroup group2) {
            if (group1.getNumRequiredVertices() != group2.getNumRequiredVertices()) {
                return group2.getNumRequiredVertices() - group1.getNumRequiredVertices();
            }
            if (group1.getSize() != group2.getSize()) {
                return group2.getSize() - group1.getSize();
            }
            List<TVertex> chain1 = group1.getPrereqsChains().first();
            List<TVertex> chain2 = group2.getPrereqsChains().first();
            DependencyHolder info1 = (DependencyHolder)((VKey)chain1.get(chain1.size() - 1).getKey()).getItem();
            DependencyHolder info2 = (DependencyHolder)((VKey)chain2.get(chain2.size() - 1).getKey()).getItem();
            return this._itemComp.compare(info1, info2);
        }
    }

    private class ReversePrereqsChainComparator
    implements Comparator<List<TVertex>> {
        private Comparator<T> _itemComp;

        private ReversePrereqsChainComparator() {
            this._itemComp = SelectionTarget.this.getItemComparator();
        }

        @Override
        public int compare(List<TVertex> list1, List<TVertex> list2) {
            if (list2.containsAll(list1)) {
                return -1;
            }
            if (list1.containsAll(list2)) {
                return 1;
            }
            if (list2.size() != list1.size()) {
                return list1.size() - list2.size();
            }
            DependencyHolder info1 = (DependencyHolder)((VKey)list1.get(list1.size() - 1).getKey()).getItem();
            DependencyHolder info2 = (DependencyHolder)((VKey)list2.get(list2.size() - 1).getKey()).getItem();
            return this._itemComp.compare(info1, info2);
        }
    }
}

