/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.OrResolver;
import com.oracle.cie.dependency.dao.ConditionalOp;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.dao.VersionRange;
import com.oracle.cie.dependency.event.VertexListener;
import com.oracle.cie.dependency.event.VertexStateChangeEvent;
import java.util.ArrayList;
import java.util.List;

public class VKey<T> {
    protected VType _type;
    protected InstalledState _installedState;
    protected SelectedState _selectedState;
    protected SelectedState _savedState;
    protected OrResolver _resolver;
    protected T _item;
    protected boolean _extSelectable;
    protected boolean _required;
    protected T _parent;
    protected DependencyRef _unresolvedDep;
    protected boolean _inOperation;
    protected boolean _stateSetInOp;
    protected String _descr;
    protected ConditionalOp _andCond;
    protected boolean _hasConflicts;
    protected String _id = null;
    protected boolean _skipNotDefaultNode = false;
    protected List<VertexListener> _listeners = new ArrayList<VertexListener>();

    public static <T> VKey<T> newAndKey(T parent, String descr, ConditionalOp andCond) {
        VKey<T> key = new VKey<T>();
        key._type = VType.AND_COND;
        key._parent = parent;
        key._descr = descr;
        key._andCond = andCond;
        return key;
    }

    public static <T> VKey<T> newOrKey(T parent, String descr) {
        VKey<T> key = new VKey<T>();
        key._type = VType.OR_COND;
        key._parent = parent;
        key._descr = descr;
        return key;
    }

    public static <T> VKey<T> newResolvableOrKey(T parent, String descr, OrResolver resolver) {
        VKey<T> key = new VKey<T>();
        key._type = VType.OR_COND;
        key._parent = parent;
        key._descr = descr;
        key._resolver = resolver;
        return key;
    }

    public static <T> VKey<T> newKey(T tInfo) {
        VKey<T> key = new VKey<T>();
        key._type = VType.TINFO;
        key._item = tInfo;
        return key;
    }

    public static <T> VKey<T> newUnresolvedKey(T parent, DependencyRef dep) {
        VKey<T> key = new VKey<T>();
        key._type = VType.UNRESOLVED;
        key._unresolvedDep = dep;
        key._parent = parent;
        key._descr = dep.toString();
        return key;
    }

    private VKey() {
        this._installedState = InstalledState.NOTINSTALLED;
        this._selectedState = SelectedState.NOTSELECTED;
    }

    public VType getType() {
        return this._type;
    }

    public boolean isExtSelectable() {
        return this._extSelectable;
    }

    public void setExtSelectable(boolean extSelectable) {
        this._extSelectable = extSelectable;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public OrResolver getResolver() {
        return this._resolver;
    }

    public T getItem() {
        return this._item;
    }

    public T getParent() {
        return this._parent;
    }

    public DependencyRef getUnresolvedDep() {
        return this._unresolvedDep;
    }

    public ConditionalOp getAndCond() {
        return this._andCond;
    }

    public InstalledState getInstalledState() {
        return this._installedState;
    }

    public void setInstalledState(InstalledState state) {
        assert (state != null);
        this._installedState = state;
        for (VertexListener listener : this._listeners) {
            listener.stateChanged(new VertexStateChangeEvent(this, state, null));
        }
    }

    public SelectedState getSelectedState() {
        return this._selectedState;
    }

    public void setSelectedState(SelectedState state) {
        assert (state != null);
        assert (this._installedState != InstalledState.INSTALLED && this._installedState != InstalledState.CONFLICTS_WITH_INSTALLED);
        if (this._inOperation) {
            this._stateSetInOp = true;
        }
        this._selectedState = state;
        for (VertexListener listener : this._listeners) {
            listener.stateChanged(new VertexStateChangeEvent(this, null, state));
        }
    }

    public boolean wasStateSetInOp() {
        return this._stateSetInOp;
    }

    public SelectedState getSavedState() {
        return this._savedState;
    }

    public void startSelectionOperation() {
        this._savedState = this._selectedState;
        this._inOperation = true;
        this._stateSetInOp = false;
    }

    public void rollbackSelectionOperation() {
        this._selectedState = this._savedState;
        this._inOperation = false;
        for (VertexListener listener : this._listeners) {
            listener.stateChanged(new VertexStateChangeEvent(this, null, this._selectedState));
        }
    }

    public void resetSelectionOperation() {
        this._selectedState = this._savedState;
        this._stateSetInOp = false;
        for (VertexListener listener : this._listeners) {
            listener.stateChanged(new VertexStateChangeEvent(this, null, this._selectedState));
        }
    }

    public void commitSelectionOperation() {
        switch (this._selectedState.ordinal()) {
            case 4: 
            case 5: 
            case 6: {
                this._selectedState = SelectedState.NOTSELECTED;
            }
        }
        this._inOperation = false;
    }

    public String getDescr() {
        return this._descr;
    }

    public boolean getHasConflicts() {
        return this._hasConflicts;
    }

    public void setHasConflicts(boolean b) {
        this._hasConflicts = b;
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        switch (this.getType().ordinal()) {
            case 0: {
                sb.append(this.getItem());
                break;
            }
            case 2: {
                sb.append("AND for ").append(this.getParent()).append(" ").append(this._descr);
                break;
            }
            case 1: {
                sb.append("OR for ").append(this.getParent()).append(" ").append(this._descr);
                break;
            }
            case 3: {
                sb.append("DEP for ").append(this.getParent());
                sb.append(" (").append(this.getUnresolvedDep().getName());
                sb.append(this.getVersionDetails(this.getUnresolvedDep()));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDetails());
        sb.append("[").append((Object)this.getType()).append("|").append((Object)this.getInstalledState()).append("|").append((Object)this.getSelectedState());
        if (this.getType() == VType.OR_COND) {
            sb.append("|").append(this._resolver);
        }
        sb.append("]");
        return sb.toString();
    }

    public String getVersionDetails(DependencyRef dep) {
        StringBuilder sb = new StringBuilder();
        if (dep.isSetVersion()) {
            sb.append(" - ").append(dep.getVersion());
        } else {
            for (VersionRange range : dep.getVersionRanges()) {
                sb.append(" ").append(range.isMinInclusive() ? "[" : "(").append(range.isSetMin() ? range.getMin() : "_");
                sb.append("-").append(range.isSetMax() ? range.getMax() : "_").append(range.isMaxInclusive() ? "]" : ")");
            }
        }
        return sb.toString();
    }

    public void addListener(VertexListener vl) {
        this._listeners.add(vl);
    }

    public void removeListener(VertexListener vl) {
        this._listeners.remove(vl);
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public boolean isSkipNotDefaultNode() {
        return this._skipNotDefaultNode;
    }

    public void setSkipNotDefaultNode(boolean b) {
        this._skipNotDefaultNode = b;
    }

    public static enum VType {
        TINFO,
        OR_COND,
        AND_COND,
        UNRESOLVED;

    }

    public static enum InstalledState {
        INSTALLED,
        CONFLICTS_WITH_INSTALLED,
        COND_PREREQ,
        COND_CONFL,
        COND_PREREQ_CANDIDATE,
        COND_CONFL_CANDIDATE,
        NOTINSTALLED;

    }

    public static enum SelectedState {
        SELECTED,
        CONFLICTS,
        NOTSELECTED,
        PENDING_AND_COND,
        RESOLVED_SELECTION_CANDIDATE,
        RESOLVABLE_SELECTION_CANDIDATE,
        POSSIBLE_SELECTION_CANDIDATE;

    }
}

