/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.ContentTypeHelper;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.wrappers.WrapperFactory;

public class ContentTypeHelperImpl
implements ContentTypeHelper {
    @Override
    public String getContentTypeForPatchApply(String patchDirectory) throws OPatchException {
        String contentType = "";
        String out = "";
        Path patchDirectoryPath = WrapperFactory.getNioServiceWrapper().getPath(patchDirectory, new String[0]);
        if (!this.isEmpty(patchDirectory) && Files.isReadable(patchDirectoryPath)) {
            try {
                OPatchPatch[] patchArray;
                for (OPatchPatch patch : patchArray = OPatchPatch.getPatches(patchDirectory)) {
                    PatchObject patchObject = patch.getPo();
                    if (patchObject.getPatchInventory().getPatchModel().equals("one-off")) {
                        OLogger.log((int)OLogger.INFO, (String)("Checking patch " + patchObject.getPatchInventory().patchID + ":"));
                        contentType = patchObject.getPatchInventory().getPatchContentType();
                        OLogger.log((int)OLogger.INFO, (String)("Content Type for Apply: " + contentType));
                        out = out + "Checking patch " + patchObject.getPatchInventory().patchID + ":\n";
                        out = out + "Content Type for Apply: " + contentType + "\n";
                        continue;
                    }
                    OLogger.log((int)OLogger.INFO, (String)("Patch " + patchObject.getPatchInventory().patchID + " does not support this option and hence this check will be skipped"));
                    out = out + "Patch " + patchObject.getPatchInventory().patchID + " does not support this option and hence this check will be skipped\n";
                }
                return out;
            }
            catch (OPatchException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
                throw e;
            }
        }
        return contentType;
    }

    @Override
    public String getContentTypeForPatchRollback(String oracleHome, String patchID) throws Exception {
        String contentType = "";
        Path oracleHomePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHome, new String[0]);
        if (!this.isEmpty(patchID) && !this.isEmpty(oracleHome) && Files.isReadable(oracleHomePath)) {
            String[] patchIDs = new String[]{patchID};
            StringBuffer patchStorage = new StringBuffer(oracleHome + File.separator + OPatchEnv.getPatchStorageName());
            Path patchStoragePath = WrapperFactory.getNioServiceWrapper().getPath(patchStorage.toString(), new String[0]);
            DirectoryStream.Filter<Path> dirFilter = this.getDirectoriesFilter(patchIDs);
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchStoragePath, dirFilter);
                Iterator<Path> dirStreamItr = dirStream.iterator();
                if (null == dirStreamItr || !dirStreamItr.hasNext()) {
                    OLogger.log((int)OLogger.FINE, (String)("There is no patchID " + patchID + " under patchStorageDir " + patchStoragePath.toAbsolutePath().toString()));
                    return contentType;
                }
                String compositeFilePatch = CompositePatchObject.getCompositeFilePathFromOH((String)oracleHome, (String)patchID);
                String[] constituentList = new String[]{compositeFilePatch};
                int n = 0;
                Path compositeFilePatchPath = WrapperFactory.getNioServiceWrapper().getPath(compositeFilePatch, new String[0]);
                constituentList = Files.exists(compositeFilePatchPath, new LinkOption[0]) ? CompositePatchObject.getConstituentList((String)compositeFilePatch) : new String[]{patchID};
                PatchObject[] patchObject = OPatchUtilHelper.getPatchesToRollback((String)oracleHome, (String[])constituentList, (String)"ContentTypeForPatchRollback");
                PatchObject[] patchObjectArray = patchObject;
                int n2 = patchObjectArray.length;
                if (n < n2) {
                    PatchObject po = patchObjectArray[n];
                    contentType = po.getPatchInventory().getPatchContentType();
                    OLogger.log((int)OLogger.INFO, (String)("Content Type for Rollback: " + contentType));
                    return contentType;
                }
            }
            catch (Exception e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
                throw e;
            }
        }
        OLogger.log((int)OLogger.INFO, (String)("Content Type for Rollback: " + contentType));
        return contentType;
    }

    private boolean isEmpty(String string) {
        return null == string || string.equals("") || string.isEmpty();
    }

    private DirectoryStream.Filter<Path> getDirectoriesFilter(final String[] patchIDs) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                for (String patchID : patchIDs) {
                    if (!entry.getFileName().toString().startsWith(patchID + "_")) continue;
                    return true;
                }
                return false;
            }
        };
        return filter;
    }
}

