/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.opatch.BackupFailureException;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchOverCASUtil;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingFlow;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.cas.client.CASClientFactory;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.nio.RepoFileSystemEnv;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchcommon.opatchpatch.OPatchPatchUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckNoOpPatchesOption;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;
import oracle.opatch.opatchsdk.OPatchBackupFileNotFoundException;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchLanguage;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchPatchType;
import oracle.opatch.opatchsdk.OPatchSnowballPatchingMode;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.opatchsdk.ResultObject;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.opatchutil.cleanuphome.InactivePatchesUtil;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.TwoPhaseMatchType;
import oracle.opatch.twophase.TwoPhaseOperations;
import oracle.opatch.twophase.TwoPhasePatching;
import oracle.opatch.util.perfmonitor.MethodTracker;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;
import oracle.opatch.util.perfmonitor.TrackerTags;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchTarget {
    public static final OPatchTarget HELP = new OPatchTarget();
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int NOT_EXECUTED = 2;
    public static final String UNDEFINED_CHECKSUM = "-1";
    private static final String ID_OPTION = "-id";
    private static final String ID_FILE_OPTION = "-idfile";
    private static final String PATCH_BASE_FILE = "-phBaseFile";
    private static final String WORK_FILE = "SDKWork.txt";
    private static final String PREREQ_RESULT = "-prereq_result";
    protected static boolean isTargetInitialized;
    private OPatchContext context = null;
    private String lastTargetExeLogFile = "";
    private List<PatchObject> prereqPatchObject = null;
    private OPatchSnowballPatchingMode mode = null;

    private OPatchTarget() {
    }

    public OPatchSnowballPatchingMode getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPatchTarget(OPatchContext opatchContext) throws OPatchException {
        Class<OPatchTarget> clazz = OPatchTarget.class;
        synchronized (OPatchTarget.class) {
            block22: {
                String oracleHomePath;
                block21: {
                    if (opatchContext == null) {
                        throw new OPatchException("Argument OPatchContext <opatchContext> cannot be null.");
                    }
                    if (isTargetInitialized) {
                        throw new OPatchException("The target is already initialized for this context \"" + opatchContext.getOracleHome() + "\". Please reuse the same.");
                    }
                    this.context = opatchContext;
                    oracleHomePath = this.context.getOracleHome();
                    OPatchEnv.setupPatchStorage((String)oracleHomePath);
                    OPatchEnv.setOPatchSDKMode((boolean)true);
                    System.setProperty("OPatch.PATH", OUIReplacer.getEnv((String)"PATH"));
                    System.setProperty("OPatch.PLATFORM_ID", OUIReplacer.getEnv((String)"OPATCH_PLATFORM_ID"));
                    System.setProperty("OPatch.NO_FUSER", OUIReplacer.getEnv((String)"OPATCH_NO_FUSER"));
                    if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                        OPatchEnv.setBranchKey((String)"SDK");
                    }
                    boolean isCustom = false;
                    if (OPatchEnv.getCustomLogDir() != null && !OPatchEnv.getCustomLogDir().equals("")) {
                        isCustom = true;
                    }
                    String workSheetPath = "";
                    try {
                        if (OPatchEnv.getOhWritePermission()) {
                            try {
                                workSheetPath = OPatchTarget.getWorkSheet(oracleHomePath);
                                SystemCall.createNewFile((String)workSheetPath);
                                break block21;
                            }
                            catch (Exception e) {
                                OPatchException oe = new OPatchException("Not able to create temporary file \"" + workSheetPath);
                                oe.setStackTrace(e.getStackTrace());
                                throw oe;
                            }
                        }
                        if (!isCustom) {
                            throw new OPatchException("This is a read-only Oracle Home. Please set custom scratch working directory and re-try");
                        }
                    }
                    finally {
                        isTargetInitialized = true;
                    }
                }
                try {
                    OPatchSDK.initLogFileIfUninitialized((String)oracleHomePath);
                    OPatchSDK.disableConsoleOutput();
                }
                catch (Exception e) {
                    if (!OPatchEnv.isOPatchSDKMode()) break block22;
                    try {
                        OPatchACL.invokeOLogger((Object)HELP, (String)"enableConsoleOutput", null);
                    }
                    catch (Exception e1) {
                        throw new OPatchException(e1.getMessage());
                    }
                    throw new OPatchException(e.getMessage());
                }
                finally {
                    OPatchSDK.enableConsoleOutput();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFileVersions(HashMap<String, String> fileVersionMap) {
        StringBuffer timeMsg;
        OPatchUtils.disableConsoleOutput();
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: getFileVersions(HashMap<String, String> fileVersionMap)");
        String oh = this.getContext().getOracleHome();
        Set<String> filePaths = fileVersionMap.keySet();
        Iterator<String> fileIter = filePaths.iterator();
        while (fileIter.hasNext()) {
            String path = fileIter.next();
            fileVersionMap.put(path, "");
            OLogger.debug((String)("Input: " + path));
        }
        boolean fvExist = ProcessFileVersions.existFvOh((String)oh);
        Map ohMap = new HashMap();
        if (fvExist) {
            try {
                OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: cached OH file/version file exists, parse the file into HashMap. \n");
                timeMsg = new StringBuffer("Begin Parse Cached Files");
                OLogger.logTime((StringBuffer)timeMsg);
                NApplyDataSerializer serializer = new NApplyDataSerializer();
                ohMap = serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "fv_oh.txt");
                timeMsg = new StringBuffer("End Parse Cached Files");
                OLogger.logTime((StringBuffer)timeMsg);
                OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Traverse OH file/version HashMap, update incoming fileVersionMap. \n");
                timeMsg = new StringBuffer("Begin Search File Version");
                OLogger.logTime((StringBuffer)timeMsg);
                Set keys = ohMap.keySet();
                for (String fileName : keys) {
                    String oldVersion;
                    int ret;
                    String fileVer = (String)ohMap.get(fileName);
                    if (!fileVersionMap.containsKey(fileName) || (ret = OPatchSessionHelper.isGreaterDecimal((String)(oldVersion = fileVersionMap.get(fileName)), (String)fileVer)) >= 0) continue;
                    fileVersionMap.put(fileName, fileVer);
                }
                timeMsg = new StringBuffer("End Search File Version");
                OLogger.logTime((StringBuffer)timeMsg);
            }
            catch (Throwable t) {
                OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Failed to get File Version from cached files, re-run regular process.");
                OLogger.printStackTrace((Throwable)t);
                fvExist = false;
            }
        }
        if (!fvExist) {
            try {
                timeMsg = new StringBuffer("Begin Load Inventory");
                OLogger.logTime((StringBuffer)timeMsg);
                IIPMReadServices readServices = this.getContext().loadInventory();
                OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
                timeMsg = new StringBuffer("End Load Inventory");
                OLogger.logTime((StringBuffer)timeMsg);
                timeMsg = new StringBuffer("Begin Search File Version");
                OLogger.logTime((StringBuffer)timeMsg);
                for (OneOffEntry myOneOff : installedOneOffs) {
                    PatchAction[] pa;
                    for (PatchAction paIndiv : pa = myOneOff.getPatchActions()) {
                        DeleteAction da;
                        if (paIndiv instanceof CopyAction) {
                            String oldVersion;
                            int ret;
                            CopyAction cp = (CopyAction)paIndiv;
                            if (!cp.isSnowBallCopyAction()) continue;
                            String fileName = cp.getFilename();
                            String fileVer = cp.getFileVersion();
                            String logMesg = "file=" + fileName + ";fileVer=" + fileVer;
                            OLogger.debug((String)logMesg);
                            if (fileVersionMap.containsKey(fileName) && (ret = OPatchSessionHelper.isGreaterDecimal((String)(oldVersion = fileVersionMap.get(fileName)), (String)fileVer)) < 0) {
                                fileVersionMap.put(fileName, fileVer);
                            }
                        }
                        if (!(paIndiv instanceof DeleteAction) || !(da = (DeleteAction)paIndiv).isSnowBallDeleteAction()) continue;
                        String file = da.getFileName();
                        String value = da.getFileVersion();
                        if (!fileVersionMap.containsKey(file) || fileVersionMap.get(file).equals("")) continue;
                        String oldVer = fileVersionMap.get(file);
                        if (value.startsWith("le")) {
                            StringBuffer buff;
                            String updateValue = value.substring(2);
                            int retVal = OPatchSessionHelper.isGreaterDecimal((String)oldVer, (String)updateValue);
                            if (retVal != -1) {
                                buff = new StringBuffer("Delete Action " + da.toString() + " version is less thanor equal to --> " + oldVer + ".");
                                buff.append("\nWe will not delete this version " + value + ".");
                                OLogger.debug((StringBuffer)buff);
                                continue;
                            }
                            if (retVal != -1) continue;
                            fileVersionMap.put(file, "");
                            buff = new StringBuffer("Remove this copy action's " + da.toString() + " with this version" + value);
                            OLogger.debug((StringBuffer)buff);
                            continue;
                        }
                        if (value.equals("")) {
                            if (oldVer.equals("")) continue;
                            fileVersionMap.put(file, value);
                            StringBuffer buff = new StringBuffer("Remove this copy action's " + da.toString() + " with this version" + value);
                            OLogger.debug((StringBuffer)buff);
                            continue;
                        }
                        int retVal = OPatchSessionHelper.isGreaterDecimal((String)oldVer, (String)value);
                        if (retVal != 0) {
                            StringBuffer buff = new StringBuffer("Delete Action " + da.toString() + " version is not equal to --> " + oldVer + ".");
                            buff.append("\nWe will skip this version " + value + ".");
                            OLogger.debug((StringBuffer)buff);
                            continue;
                        }
                        if (retVal != 0) continue;
                        fileVersionMap.put(file, "");
                        StringBuffer buff = new StringBuffer("Remove this copy action's " + da.toString() + " with this version" + value);
                        OLogger.debug((StringBuffer)buff);
                    }
                }
            }
            catch (Throwable t) {
                while (fileIter.hasNext()) {
                    String path = fileIter.next();
                    if (fileVersionMap.get(path) != "") continue;
                    fileVersionMap.put(path, null);
                }
                OLogger.logError((String)"OPatchTarget::getFileVersions", (Object[])new Object[]{"Can't get file version", t.getMessage()});
                OLogger.printStackTrace((Throwable)t);
            }
            finally {
                timeMsg = new StringBuffer("End Search File Version");
                OLogger.logTime((StringBuffer)timeMsg);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getFileVersions(HashMap<String, String> fileVersionMap)");
        OPatchUtils.enableConsoleOutput();
    }

    public static int compareFileVersions(String firstVersion, String secondVersion) throws OPatchException {
        if (firstVersion != null && !Pattern.matches("^\\d+[.]\\d+|^$", firstVersion)) {
            throw new OPatchException("Invalid version " + firstVersion);
        }
        if (secondVersion != null && !Pattern.matches("^\\d+[.]\\d+|^$", secondVersion)) {
            throw new OPatchException("Invalid version " + secondVersion);
        }
        return OPatchSessionHelper.isGreaterDecimal((String)firstVersion, (String)secondVersion);
    }

    public synchronized OPatchPatch[] getPatchesToRollbackOnConflict() {
        OneOffEntry[] oneoff = OPatchEnv.getOneOffToRoll();
        if (oneoff == null) {
            return new OPatchPatch[0];
        }
        OPatchPatch[] op = new OPatchPatch[oneoff.length];
        for (int i = 0; i < oneoff.length; ++i) {
            op[i] = new OPatchPatch(oneoff[i]);
            op[i].setOracleHome(this.context.getOracleHome());
        }
        return op;
    }

    protected static String getWorkSheet(String oracleHomePath) {
        Path workSheetFile;
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath((String)oracleHomePath));
        if (OPatchEnv.getCustomLogDir() != null && !OPatchEnv.getCustomLogDir().equals("")) {
            buff.setLength(0);
            buff.append(OPatchEnv.getCustomLogDir());
            buff.append(File.separator);
            buff.append("opatch");
        }
        if (!Files.exists(workSheetFile = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(workSheetFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                OLogger.debug((String)e.getMessage());
            }
        }
        buff.append(File.separator);
        buff.append(WORK_FILE);
        return buff.toString();
    }

    protected static String getCompsXMLLoc(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("ContentsXML");
        buff.append(File.separator);
        buff.append("comps.xml");
        return buff.toString();
    }

    public synchronized OPatchPatch[] getInstalledPatches(String offset) throws OPatchException {
        int i;
        OPatchUtils.disableConsoleOutput();
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: getInstalledPatches(String offset)");
        OPatchPatch[] installedPatches = this.context.getInstalledActivePatches();
        OPatchPatch[] inactivePatches = this.context.getInstalledInactivePatches();
        ArrayList<OPatchPatch> allPatches = new ArrayList<OPatchPatch>();
        for (i = 0; i < installedPatches.length; ++i) {
            allPatches.add(installedPatches[i]);
        }
        for (i = 0; i < inactivePatches.length; ++i) {
            allPatches.add(inactivePatches[i]);
        }
        OPatchPatch[] allPatchesArr = new OPatchPatch[allPatches.size()];
        allPatches.toArray(allPatchesArr);
        ArrayList<OPatchPatch> touchedPatches = new ArrayList<OPatchPatch>();
        for (int i2 = 0; i2 < allPatchesArr.length; ++i2) {
            if (!this.isFilePatched(allPatchesArr[i2], offset)) continue;
            touchedPatches.add(allPatchesArr[i2]);
        }
        Object[] touchedPatchArr = new OPatchPatch[touchedPatches.size()];
        touchedPatches.toArray(touchedPatchArr);
        Arrays.sort(touchedPatchArr);
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getInstalledPatches(String offset)");
        OPatchUtils.enableConsoleOutput();
        return touchedPatchArr;
    }

    private boolean isFilePatched(OPatchPatch patch, String offset) {
        try {
            OPatchAction[] oc = patch.getActions();
            for (int i = 0; i < oc.length; ++i) {
                OPatchCopyAction oca;
                String relativeFilePath;
                if (!(oc[i] instanceof OPatchCopyAction) || !OPatchUtils.compareFileOffsets(offset, relativeFilePath = (oca = (OPatchCopyAction)oc[i]).getRelativeChildPath(), this.context.getOracleHome())) continue;
                return true;
            }
            return false;
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized String getChecksum(String offset, boolean fromInventory) throws OPatchException {
        String finalChecksum = UNDEFINED_CHECKSUM;
        try {
            boolean check;
            StringBuffer path = new StringBuffer(this.context.getOracleHome());
            path.append(File.separator);
            path.append(offset);
            Path f = WrapperFactory.getNioServiceWrapper().getPath(path.toString(), new String[0]);
            boolean bl = check = !Files.exists(f, new LinkOption[0]) || Files.exists(f, new LinkOption[0]) && Files.isDirectory(f, new LinkOption[0]);
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            if (!fromInventory) {
                return OPatchTarget.getChecksum(f.toAbsolutePath().toString());
            }
            OPatchPatch[] installPatches = this.getInstalledPatches(offset);
            if (installPatches.length == 0) {
                return UNDEFINED_CHECKSUM;
            }
            OPatchPatch latestPatch = installPatches[0];
            ChecksumEntity[] cke = latestPatch.getChecksumList();
            String canPath = f.toAbsolutePath().normalize().toString();
            for (int i = 0; i < cke.length; ++i) {
                String computeFilePath = cke[i].getComputeFilePath(this.context.getOracleHome(), latestPatch.getPo());
                Path fcompute = WrapperFactory.getNioServiceWrapper().getPath(computeFilePath, new String[0]);
                String computeCanPath = fcompute.toAbsolutePath().normalize().toString();
                if (!canPath.equals(computeCanPath)) continue;
                finalChecksum = cke[i].getChecksum();
                break;
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return finalChecksum;
    }

    public static String getChecksum(String absoluteFileName) throws OPatchException {
        String checksum = "";
        try {
            boolean check;
            Path f = WrapperFactory.getNioServiceWrapper().getPath(absoluteFileName, new String[0]);
            boolean bl = check = !Files.exists(f, new LinkOption[0]) || Files.exists(f, new LinkOption[0]) && Files.isDirectory(f, new LinkOption[0]);
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            checksum = OPatchSessionHelper.computeChecksum((String)absoluteFileName);
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return checksum;
    }

    public synchronized String getChecksum(String fileOffset, OPatchPatch patch) throws OPatchException {
        String finalChecksum = UNDEFINED_CHECKSUM;
        try {
            boolean check;
            String oh = patch.getOracleHome();
            if (oh == null || oh.equals("")) {
                throw new OPatchException("The given OPatchPatch object is not an installed patch.");
            }
            ChecksumEntity[] cke = patch.getChecksumList();
            StringBuffer path = new StringBuffer(this.context.getOracleHome());
            path.append(File.separator);
            path.append(fileOffset);
            Path f = WrapperFactory.getNioServiceWrapper().getPath(path.toString(), new String[0]);
            boolean bl = check = !Files.exists(f, new LinkOption[0]) || Files.exists(f, new LinkOption[0]) && Files.isDirectory(f, new LinkOption[0]);
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            String canPath = f.toAbsolutePath().normalize().toString();
            for (int i = 0; i < cke.length; ++i) {
                String computeFilePath = cke[i].getComputeFilePath(oh, patch.getPo());
                Path fcompute = WrapperFactory.getNioServiceWrapper().getPath(computeFilePath, new String[0]);
                String computeCanPath = fcompute.toAbsolutePath().normalize().toString();
                if (!canPath.equals(computeCanPath)) continue;
                finalChecksum = cke[i].getChecksum();
                break;
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return finalChecksum;
    }

    public synchronized OPatchPatch[] getInstalledPatches(String offset, String patchID) throws OPatchException {
        OPatchPatch[] op = this.getInstalledPatches(offset);
        ArrayList<OPatchPatch> filteredPatches = new ArrayList<OPatchPatch>();
        for (int i = 0; i < op.length; ++i) {
            if (!op[i].getPatchId().equals(patchID)) continue;
            filteredPatches.add(op[i]);
        }
        Object[] newOP = new OPatchPatch[filteredPatches.size()];
        filteredPatches.toArray(newOP);
        Arrays.sort(newOP);
        return newOP;
    }

    public synchronized OPatchPatch[] getInstalledPatches(String offset, String patchID, String language) throws OPatchException {
        OPatchPatch[] patches = this.getInstalledPatches(offset);
        if (language == null) {
            language = "";
        }
        ArrayList<OPatchPatch> langPatches = new ArrayList<OPatchPatch>();
        String inputPatchID = patchID;
        for (int i = 0; i < patches.length; ++i) {
            Locale langLocale = patches[i].getPatchLanguage();
            String lang = OPatchPatchLanguage.getLanguageCode(langLocale);
            if (!language.equals("")) {
                if (!inputPatchID.equals(patches[i].getPatchId()) || !language.equals(lang)) continue;
                langPatches.add(patches[i]);
                continue;
            }
            if (!inputPatchID.equals(patches[i].getPatchId())) continue;
            langPatches.add(patches[i]);
        }
        if (langPatches.size() == 0) {
            return new OPatchPatch[0];
        }
        OPatchPatch[] langPatchArr = new OPatchPatch[langPatches.size()];
        langPatches.toArray(langPatchArr);
        return langPatchArr;
    }

    public synchronized InputStream getBackupFileStream(OPatchPatch patch, String offset) throws OPatchException, OPatchBackupFileNotFoundException {
        OPatchUtils.disableConsoleOutput();
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: getBackupFileStream(OPatchPatch patch,String offset)");
        try {
            String oracleHomePath = this.context.getOracleHome();
            String cookedPatchID = patch.getCookedPatchID();
            OPatchAction[] oc = patch.getActions();
            for (int j = 0; j < oc.length; ++j) {
                OPatchCopyAction oca;
                String relativeFilePath;
                if (!(oc[j] instanceof OPatchCopyAction) || !OPatchUtils.compareFileOffsets(offset, relativeFilePath = (oca = (OPatchCopyAction)oc[j]).getRelativeChildPath(), this.context.getOracleHome())) continue;
                String backupFile = oca.getBackupRollbackPath(oracleHomePath, cookedPatchID);
                Path f = WrapperFactory.getNioServiceWrapper().getPath(backupFile, new String[0]);
                if (!Files.exists(f, new LinkOption[0])) {
                    throw new OPatchBackupFileNotFoundException("BackupFile path \"" + backupFile + "\" of patch \"" + patch.getPatchId() + "\" does not exist.");
                }
                if (!Files.isReadable(f)) {
                    throw new OPatchException("BackupFile path \"" + backupFile + "\" of patch \"" + patch.getPatchId() + "\" cannot be read.");
                }
                InputStream fin = Files.newInputStream(f, new OpenOption[0]);
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getBackupFileStream(OPatchPatch patch,String offset)");
                return fin;
            }
        }
        catch (OPatchBackupFileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        OPatchUtils.enableConsoleOutput();
        String msg = "Not able to find backup file for the input OPatchPatch object and the file offset.";
        throw new OPatchException(msg);
    }

    public synchronized InputStream getFileStream(OPatchPatch patch, String offset) throws OPatchException {
        try {
            OPatchPatch[] patches = this.getInstalledPatches(offset);
            for (int i = 0; i < patches.length; ++i) {
                if (!patch.equals(patches[i])) continue;
                if (i == 0) {
                    StringBuffer path = new StringBuffer(this.context.getOracleHome());
                    path.append(File.separator);
                    path.append(offset);
                    Path f = WrapperFactory.getNioServiceWrapper().getPath(path.toString(), new String[0]);
                    f = f.toAbsolutePath().normalize();
                    if (!Files.exists(f, new LinkOption[0])) {
                        System.out.println("Patched file does not exist");
                        return null;
                    }
                    if (Files.exists(f, new LinkOption[0]) && !Files.isReadable(f)) {
                        throw new OPatchException("Patched file path \"" + path.toString() + "\" of patch \"" + patch.getPatchId() + "\" does not exist (or) cannot be read.");
                    }
                    InputStream fin = Files.newInputStream(f, new OpenOption[0]);
                    return fin;
                }
                return this.getBackupFileStream(patches[i - 1], offset);
            }
        }
        catch (IOException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (OPatchException e) {
            throw e;
        }
        String msg = "Not able to find patched file for the input OPatchPatch object and the file offset.";
        throw new OPatchException(msg);
    }

    public synchronized boolean isPatchApplied(OPatchPatch patch) {
        try {
            int i;
            String uniqID = patch.getUniquePatchIdentifier();
            OPatchPatch[] installedPatches = this.getContext().getInstalledActivePatches();
            OPatchPatch[] inactivePatches = this.getContext().getInstalledInactivePatches();
            for (i = 0; i < installedPatches.length; ++i) {
                if (!patch.equals(installedPatches[i])) continue;
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: isPatchApplied(OPatchPatch patch)");
                return true;
            }
            for (i = 0; i < inactivePatches.length; ++i) {
                if (!patch.equals(inactivePatches[i])) continue;
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: isPatchApplied(OPatchPatch patch)");
                return true;
            }
            return false;
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized OPatchAction[] getActionsThatCouldBeApplied(OPatchPatch patch) throws OPatchException {
        String oh = this.getOracleHome();
        Vector<OPatchAction> validActions = new Vector<OPatchAction>();
        Vector<OPatchAction> finalActions = new Vector<OPatchAction>();
        try {
            OPatchCopyAction copyAct;
            if (this.isPatchApplied(patch)) {
                throw new OPatchException("This API cannot be used for an installed patch. The input patch is already installed in the Oracle Home.");
            }
            PatchObject po = patch.po;
            Vector includedPC = new Vector();
            PrereqAPI.checkComponents((String)oh, (PatchObject)po, includedPC);
            for (int i = 0; i < includedPC.size(); ++i) {
                PatchComponent validPC = (PatchComponent)includedPC.get(i);
                OPatchComponent oPC = new OPatchComponent(validPC);
                OPatchAction[] oa = patch.getActions(oPC);
                for (int j = 0; j < oa.length; ++j) {
                    validActions.add(oa[j]);
                }
            }
            HashMap ohMap = new HashMap();
            boolean fvExist = ProcessFileVersions.existFvOh((String)oh);
            if (fvExist) {
                try {
                    NApplyDataSerializer serializer = new NApplyDataSerializer();
                    ohMap = new HashMap(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "fv_oh.txt"));
                    if (patch.getPatchType() == OPatchPatchType.SNOWBALL) {
                        for (int i = 0; i < validActions.size(); ++i) {
                            OPatchAction act = (OPatchAction)validActions.get(i);
                            if (!(act instanceof OPatchCopyAction) || !PrereqAPI.checkFileVersion((String)oh, (CopyAction)(copyAct = (OPatchCopyAction)act).getCopyAction(), ohMap)) continue;
                            finalActions.add(act);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fvExist = false;
                }
            }
            if (!fvExist) {
                Map m = PrereqAPI.getCopyActionMap((String)oh);
                if (patch.getPatchType() == OPatchPatchType.SNOWBALL) {
                    for (int i = 0; i < validActions.size(); ++i) {
                        OPatchAction act = (OPatchAction)validActions.get(i);
                        if (!(act instanceof OPatchCopyAction) || !PrereqAPI.checkFileVersion((String)oh, (CopyAction)(copyAct = (OPatchCopyAction)act).getCopyAction(), (Map)m)) continue;
                        finalActions.add(act);
                    }
                }
            }
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            String oracleHomePath = this.context.getOracleHome();
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"after read operation by API \"getActionsThatCouldBeApplied\"";
                OPatchException oe = new OPatchException(errorMsg);
                oe.setStackTrace(t.getStackTrace());
                throw oe;
            }
        }
        OPatchAction[] finalAct = new OPatchAction[finalActions.size()];
        finalActions.toArray(finalAct);
        return finalAct;
    }

    public synchronized void cleanupPatchStorage(boolean cleanupRollbackArea) throws OPatchException {
        block25: {
            try {
                int i;
                OPatchContext oc = this.getContext();
                String oh = this.getOracleHome();
                OPatchUtils.disableConsoleOutput();
                OPatchACL.setSilent((Object)oc, (boolean)true);
                OUSession.cleanup((String)oh);
                if (!cleanupRollbackArea) break block25;
                OPatchPatch[] activePatches = oc.getInstalledActivePatches();
                OPatchPatch[] inactivePatches = oc.getInstalledInactivePatches();
                OPatchPatch[] allPatches = new OPatchPatch[(activePatches != null ? activePatches.length : 0) + (inactivePatches != null ? inactivePatches.length : 0)];
                for (i = 0; i < activePatches.length; ++i) {
                    allPatches[i] = activePatches[i];
                }
                for (i = 0; i < inactivePatches.length; ++i) {
                    allPatches[allPatches.length - i - 1] = inactivePatches[i];
                }
                Path f = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getPatchStorageDirectoryPath((String)oh), new String[0]);
                try (DirectoryStream<Path> elements = Files.newDirectoryStream(f);){
                    int i2;
                    String dirPath;
                    ArrayList<String> allDirs = new ArrayList<String>();
                    ArrayList<String> noDeleteDirs = new ArrayList<String>();
                    String patchStorageDir = OPatchEnv.getPatchStorageDirectoryPath((String)oh);
                    for (Path element : elements) {
                        dirPath = element.toString();
                        Path fDir = WrapperFactory.getNioServiceWrapper().getPath(dirPath, new String[0]);
                        if (!Files.isDirectory(fDir, new LinkOption[0])) continue;
                        allDirs.add(dirPath);
                    }
                    for (i2 = 0; i2 < allPatches.length; ++i2) {
                        String cookedPatchID = allPatches[i2].getCookedPatchID();
                        dirPath = patchStorageDir + File.separator + cookedPatchID;
                        noDeleteDirs.add(dirPath);
                    }
                    allDirs.removeAll(noDeleteDirs);
                    for (i2 = 0; i2 < allDirs.size(); ++i2) {
                        String dirToDelete = (String)allDirs.get(i2);
                        OPatchSessionHelper.deleteRecurse((String)dirToDelete);
                    }
                }
                catch (IOException e) {
                    OLogger.debug((String)e.getMessage());
                }
            }
            catch (IllegalAccessException e) {
                OPatchException oe = new OPatchException(e.getMessage());
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
            catch (OPatchException e) {
                throw e;
            }
            finally {
                OPatchUtils.enableConsoleOutput();
            }
        }
    }

    public synchronized void apply(OPatchPatch patch) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: apply(OPatchPatch patch)");
        OPatchPatch[] patches = new OPatchPatch[]{patch};
        this.NApply(patches);
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: apply(OPatchPatch patch)");
    }

    public synchronized void rollback(OPatchPatch patch) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: rollback(OPatchPatch patch)");
        OPatchPatch[] patches = new OPatchPatch[]{patch};
        this.NRollback(patches);
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: rollback(OPatchPatch patch)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(OPatchPatch[] patches, boolean skipConflict, boolean forceConflict) throws OPatchException {
        OPatchSDK.initLogFileIfUninitialized((String)OPatchEnv.getOracleHome());
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(OPatchPatch[] patches,boolean skipConflict, boolean forceConflict)");
        try {
            if (skipConflict && forceConflict) {
                throw new OPatchException("OPatch does not allow 'skipConflict' & 'forceConflict' to be given together as 'true'.");
            }
            if (skipConflict) {
                this.getContext().skipConflict = true;
            }
            if (forceConflict) {
                this.getContext().forceConflict = true;
            }
            this.NApply(patches);
        }
        finally {
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(OPatchPatch[] patches,boolean skipConflict, boolean forceConflict)");
            this.getContext().skipConflict = false;
            this.getContext().forceConflict = false;
        }
    }

    public synchronized boolean hasRunPhaseOne(OPatchPatch[] pis) {
        PatchObject[] raw = new PatchObject[pis.length];
        for (int i = 0; i < pis.length; ++i) {
            raw[i] = pis[i].getOneOffEntry().getPatchObject();
        }
        TwoPhaseMatchType t = OPatchOverCASUtil.deserializeStatus((String)this.getOracleHome(), (PatchObject[])raw);
        switch (t) {
            case NONE: {
                OLogger.justlog((int)OLogger.INFO, (String)OLogger.getString((String)"OUI-68201"));
                return false;
            }
            case DIFFERENT: {
                OLogger.justlog((int)OLogger.INFO, (String)OLogger.getString((String)"OUI-68202"));
                return false;
            }
            case SAME: {
                OLogger.justlog((int)OLogger.INFO, (String)OLogger.getString((String)"OUI-68203"));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(OPatchPatch[] patches) throws OPatchException {
        OPatchEnv.COMMIT_ABORT_WRAPPER.setCommandName("napply");
        OPatchSDK.initLogFileIfUninitialized((String)OPatchEnv.getOracleHome());
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(OPatchPatch[] patches)");
        MethodTrackerObj trackerObj = MethodTracker.getTracker((String)TrackerTags.NAPPLY);
        trackerObj.start();
        try {
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                if (!this.hasRunPhaseOne(patches)) {
                    OPatchOverCASUtil.serializeData((String)this.getOracleHome(), (OPatchPatch[])patches);
                } else {
                    OPatchEnv.setCASPhase2();
                }
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            String prereqResultFileLoc = OPatchEnv.getPrereqResultFileLoc((String)this.getOracleHome());
            Path wsObj = WrapperFactory.getNioServiceWrapper().getPath(workSheetLoc, new String[0]);
            BufferedWriter bw = Files.newBufferedWriter(wsObj, Charset.forName("UTF-8"), new OpenOption[0]);
            PrintWriter pw = new PrintWriter(bw);
            for (int i = 0; i < patches.length; ++i) {
                String patchLocation = patches[i].getPatchLocation();
                pw.println(patchLocation);
            }
            pw.flush();
            bw.close();
            pw.close();
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
                    OPatchEnv.COMMIT_ABORT_WRAPPER.setExitCode(0);
                    RepoFileSystemEnv.restoreMementoToOH((String)OPatchEnv.getOracleHome());
                    OPatchEnv.COMMIT_ABORT_WRAPPER.reset();
                    RepoFileSystemEnv.setupCasRepoFileSystem((String)OPatchEnv.getOracleHome());
                }
            }
            finally {
                try {
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException i) {}
                OLogger.printlnOnLog((String)"SDK NApply::clean and update cached files(2-phase) after napply completes.");
                ProcessFileVersions proc = new ProcessFileVersions();
                proc.cleanCachedFiles(this.getOracleHome());
                OPatchEnv.unsetHashMatch();
                OPatchEnv.unsetFATwoPhase();
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            trackerObj.end();
            try {
                String statistics = MethodTracker.getStatistics((boolean)OLogger.isDebug());
                OLogger.justlog((int)OLogger.INFO, (String)statistics);
            }
            catch (Exception ex) {
                OLogger.printlnOnLog((String)("Error while printing Method Tracker Statistics. Message : " + ex.getMessage()));
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(OPatchPatch[] patches)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NRollback(OPatchPatch[] patches) throws OPatchException {
        OPatchEnv.COMMIT_ABORT_WRAPPER.setCommandName("nrollback");
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NRollback(OPatchPatch[] patches)");
        try {
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                if (!this.hasRunPhaseOne(patches)) {
                    OPatchOverCASUtil.serializeData((String)this.getOracleHome(), (OPatchPatch[])patches);
                } else {
                    OPatchEnv.setCASPhase2();
                }
            }
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            Path wsObj = WrapperFactory.getNioServiceWrapper().getPath(workSheetLoc, new String[0]);
            BufferedWriter bw = Files.newBufferedWriter(wsObj, Charset.forName("UTF-8"), new OpenOption[0]);
            PrintWriter pw = new PrintWriter(bw);
            for (int i = 0; i < patches.length; ++i) {
                String patchID = patches[i].getPatchLanguageId();
                pw.println(patchID);
            }
            pw.flush();
            bw.close();
            pw.close();
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                if (PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
                    OPatchEnv.COMMIT_ABORT_WRAPPER.setExitCode(0);
                    RepoFileSystemEnv.restoreMementoToOH((String)OPatchEnv.getOracleHome());
                    OPatchEnv.COMMIT_ABORT_WRAPPER.reset();
                    RepoFileSystemEnv.setupCasRepoFileSystem((String)OPatchEnv.getOracleHome());
                }
            }
            finally {
                try {
                    OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollback(OPatchPatch[] patches)");
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {}
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public synchronized String getLastSessionLogFile() {
        if (!this.lastTargetExeLogFile.equals("")) {
            return this.lastTargetExeLogFile;
        }
        String defaultLogfileLocation = OPatchSDK.getCurrentOPatchSessionLogFile((String)this.getOracleHome());
        if (defaultLogfileLocation == null) {
            return null;
        }
        Path logfile = WrapperFactory.getNioServiceWrapper().getPath(defaultLogfileLocation, new String[0]);
        if (!Files.exists(logfile, new LinkOption[0]) || logfile.toString().length() == 0) {
            defaultLogfileLocation = null;
        }
        return defaultLogfileLocation;
    }

    public String getOracleHome() {
        return this.context.getOracleHome();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.context.toString());
        return sb.toString();
    }

    private synchronized StatusCheck prereqResultToInt(PrereqResult pRes) {
        int i = 0;
        if (pRes == null || pRes.getResult() == null) {
            i = 2;
        } else if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            i = 1;
        } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            i = 2;
        }
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (readServices.isLocked()) {
                readServices.release();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        StatusCheck sc = new StatusCheck(i, pRes.toString());
        return sc;
    }

    private synchronized StatusCheck prereqResultArrayListToInt(ArrayList resultsArray) {
        boolean isNotExecuted = false;
        Iterator itr = resultsArray.iterator();
        boolean neCount = false;
        boolean fCount = false;
        int combinedStatus = 0;
        StringBuffer buff = new StringBuffer("");
        boolean failStatus = false;
        boolean notExecutedStatus = false;
        if (resultsArray.size() == 0) {
            notExecutedStatus = true;
        }
        while (itr.hasNext()) {
            PrereqResult pRes = (PrereqResult)itr.next();
            if (pRes == null || pRes.getResult() == null) {
                failStatus = true;
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                failStatus = true;
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                notExecutedStatus = true;
            }
            buff.append(pRes.toString());
        }
        if (failStatus) {
            combinedStatus = 1;
        } else if (notExecutedStatus) {
            combinedStatus = 2;
        }
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (readServices.isLocked()) {
                readServices.release();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        StatusCheck sc = new StatusCheck(combinedStatus, buff.toString());
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkActiveFilesAndExecutables() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkActiveFilesAndExecutablesAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Exception e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkActiveServices() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkActiveServices((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkApplicable() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkApplicableAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Exception e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkCentralInventoryForOH() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkCentralInventoryForOH((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkCentralInventoryForRWSession() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkCentralInventoryForRWSession((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkCentralInventoryLocation() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkCentralInventoryLocationAndPrint());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkConflictAgainstOH() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkConflictAgainstOHWithDetailAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Exception e) {
            OLogger.printStackTrace((Throwable)e);
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkConflictAmongPatches() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkConflictAmongPatchesAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Exception e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkIfOHLockedForPatching() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkIfOHLockedForPatching((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkInstalledOneOffs() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkInstalledOneOffsAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkOracleHome() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkOracleHome((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkOraInstLocation() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkOraInstLocation((String)this.context.getInvPtrLocation()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkOUILocation() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkOUILocation((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkOUIVersionCompatible() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkOUIVersionCompatible((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOPatchCompatibleAgainstOH() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkopatchcompatibleagainstohAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkPatchApplicableOnCurrentPlatform() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchApplicableOnCurrentPlatformAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchApplyDependents() throws OPatchException {
        String beaHomePath = this.getContext().getBeaHomePath();
        if (beaHomePath != null && !beaHomePath.equals("")) {
            Path f = null;
            try {
                f = WrapperFactory.getNioServiceWrapper().getPath(beaHomePath, new String[0]);
            }
            catch (NullPointerException e) {
                OPatchException oe = new OPatchException("Argument for BEA Home is null");
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
            if (f.isAbsolute() && Files.isDirectory(f, new LinkOption[0]) && Files.isReadable(f)) {
                OPatchEnv.setBeaHomePath((String)beaHomePath);
                OPatchEnv.setBeaHome((boolean)true);
            } else {
                throw new OPatchException("Invalid argument beaHomePath. Possible causes are: beaHomePath is not an absolute path, beaHomePath is not a path to a directory, beaHomePath is not readable. ");
            }
        }
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchApplyDependentsAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkPatchRollbackDependents() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchRollbackDependentsAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchShipHome() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchShipHomeAndPrint((List)patchObjects));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkRequiredLibs() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkRequiredLibsAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkRollbackable() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkRollbackableAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkSystemCommandAvailable() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkSystemCommandAvailableAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkSystemSpace() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkSystemSpaceAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkUserAdminPrivilege() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PrereqAPI.checkUserAdminPrivilege((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchsetUpdateCompatible() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkPatchsetUpdateCompatibleAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchsetUpdateComponents() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkPatchsetUpdateComponentsAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkDBInstanceUp() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkdbinstanceupAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkRollbackSid() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkRollbackSidAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkMinimumOpatchVersion() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkMinimumOpatchVersionAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkComponents() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultArrayListToInt(PQSession.checkComponentsAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOneoffSuperset() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkOneoffSupersetAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchingModel() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkPatchingModelAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkIfRequiredDeleteActionExist() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkIfRequiredDeleteActionExistAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck canApplyThisPatch(OPatchPatch patch) throws OPatchException {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.getContext().getPrereqPatches();
            this.getContext().setPrereqPatchesToTest(new OPatchPatch[]{patch}, true);
            PrereqResult presult = PQSession.checkPatchingModelAndPrint((String)this.context.getOracleHome());
            this.getContext().setPrereqPatchesToTest(patches, true);
            StatusCheck statusCheck = this.prereqResultToInt(presult);
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForNooppatches() {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: checkForNooppatches()");
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkForNooppatchesAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        finally {
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: checkForNooppatches()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForNooppatches(CheckNoOpPatchesOption option) {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkForNooppatchesAndPrint((String)this.context.getOracleHome(), (CheckNoOpPatchesOption)option, (List)patchObjects));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForIdenticalPatchInOracleHome() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkForIdenticalPatchInOracleHomeAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    public synchronized StatusCheck checkFusionAppsCompatible() {
        try {
            OPatchUtils.disableConsoleOutput();
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkFusionAppsCompatibleAndPrint((String)this.context.getOracleHome()));
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkConflictWithPatchsetUpdate() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkConflictWithPatchsetUpdateAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForInputValues() {
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.context.getPrereqPatches();
            List patchObjects = OPatchPatchUtil.convertPatches((OPatchPatch[])patches);
            StatusCheck statusCheck = this.prereqResultToInt(PQSession.checkForInputValuesAndPrint((String)this.context.getOracleHome(), (List)patchObjects));
            return statusCheck;
        }
        catch (Throwable e) {
            StatusCheck statusCheck = new StatusCheck(2, e.getMessage());
            return statusCheck;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
    }

    private void throwThrowableOnFail(boolean needThrowThrowableOnFirstFail, OPatchPatchPrereq prereqObject, StatusCheck checkResult, HashMap validationResult) throws FailedPrereqException {
        if (needThrowThrowableOnFirstFail && checkResult.getStatusCode() == 1) {
            throw new FailedPrereqException("Prerequisite " + prereqObject.toString() + " failed.");
        }
        validationResult.put(prereqObject, checkResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap runAllRollbackPrereqs(boolean needThrowThrowableOnFirstFail) throws FailedPrereqException, Throwable {
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        Throwable th = null;
        if (prereqPatches == null || prereqPatches.length == 0) {
            throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for rollback pre-requisites.");
        }
        ArrayList<String> patchesToApplyList = new ArrayList<String>();
        for (OPatchPatch prereqPatch : prereqPatches) {
            patchesToApplyList.add(prereqPatch.getPatchId());
        }
        PrereqAPI.setPatchesToApplyList(patchesToApplyList);
        try {
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_INSTALLED_ONE_OFFS, this.checkInstalledOneOffs(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE, this.checkFusionAppsCompatible(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_ROLLBACK_DEPENDENTS, this.checkPatchRollbackDependents(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ROLLBACKABLE, this.checkRollbackable(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, this.checkActiveServices(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME, this.checkCentralInventoryForOH(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION, this.checkCentralInventoryForRWSession(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION, this.checkCentralInventoryLocation(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, this.checkOracleHome(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, this.checkOraInstLocation(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_LOCATION, this.checkOUILocation(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE, this.checkOUIVersionCompatible(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE, this.checkOPatchCompatibleAgainstOH(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, this.checkMinimumOpatchVersion(), prereqResults);
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE, this.checkUserAdminPrivilege(), prereqResults);
        }
        catch (Throwable t) {
            th = t;
            return th;
        }
        finally {
            if (th != null) {
                OLogger.printStackTrace((Throwable)new RuntimeException(th));
            }
            if (prereqResults != null) {
                OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Rollback Prerequisite checks status -------\n ");
                OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
            }
            if (th != null) {
                throw th;
            }
            return prereqResults;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap runAllRollbackPrereqsForAutoDB(boolean needThrowThrowableOnFirstFail) throws FailedPrereqException, Throwable {
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        Throwable th = null;
        if (prereqPatches == null || prereqPatches.length == 0) {
            throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for rollback pre-requisites.");
        }
        ArrayList<String> patchesToApplyList = new ArrayList<String>();
        for (OPatchPatch prereqPatch : prereqPatches) {
            patchesToApplyList.add(prereqPatch.getPatchId());
        }
        PrereqAPI.setPatchesToApplyList(patchesToApplyList);
        OneOffEntry[] rbOneOffs = new OneOffEntry[prereqPatches.length];
        for (int i = 0; i < prereqPatches.length; ++i) {
            rbOneOffs[i] = prereqPatches[i].getOneOffEntry();
        }
        try {
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_INSTALLED_ONE_OFFS, this.checkInstalledOneOffs(), prereqResults);
            if (Rules.SystemWrite_continue()) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, this.checkForInputValues(), prereqResults);
            }
            if (Rules.SystemWrite_continue() && OPatchSessionHelper.hasHotPatch((PrereqSet)new PrereqSet(rbOneOffs))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_DB_INSTANCE_UP, this.checkDBInstanceUp(), prereqResults);
            }
            if (Rules.SystemWrite_continue()) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, this.checkSystemCommandAvailable(), prereqResults);
            }
            if (!(OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome((String)oh) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1())) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
            }
            if (Rules.OUIRead_continue() && Rules.SystemWrite_continue()) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ROLLBACK_SID, this.checkRollbackSid(), prereqResults);
            }
            if (!(OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome((String)oh) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1())) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ROLLBACKABLE, this.checkRollbackable(), prereqResults);
            }
            if (Rules.OUIRead_continue()) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_ROLLBACK_DEPENDENTS, this.checkPatchRollbackDependents(), prereqResults);
            }
            this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, this.checkMinimumOpatchVersion(), prereqResults);
        }
        catch (Throwable t) {
            th = t;
            return th;
        }
        finally {
            if (th != null) {
                OLogger.printStackTrace((Throwable)new RuntimeException(th));
            }
            if (prereqResults != null) {
                OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Rollback Prerequisite checks status -------\n ");
                OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
            }
            if (th != null) {
                throw th;
            }
            return prereqResults;
        }
    }

    private synchronized void backupForRollbackForTwoPhase() {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        String oh = this.getContext().getOracleHome();
        OPatchPatch[] patches = this.getContext().getPrereqPatches();
        try {
            String[] noopPatchIDs = serializer.deserializeNoOpCheckResult(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "pi_noOps.txt");
            for (OPatchPatch patch : patches) {
                if (OPatchUtils.checkNoOpId(noopPatchIDs, patch)) continue;
                PatchObject po = patch.po;
                try {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Start back up files for system roll-back. ");
                    po.backupForRollback(oh, "ApplySession");
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: End back up files for system roll-back. ");
                }
                catch (RuntimeException e) {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: backupForRollback() throws RuntimeException. ");
                    BackupFailureException b1 = new BackupFailureException(e.getMessage(), e.getCause());
                    b1.setStackTrace(e.getStackTrace());
                    throw b1;
                }
            }
            OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Save backupForRollback status (true) into disk. ");
            serializer.serializeBackUpStatus(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "do_backup.txt", "true");
        }
        catch (Throwable t) {
            OLogger.printStackTrace((Throwable)t);
            try {
                serializer.serializeBackUpStatus(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "do_backup.txt", "false");
            }
            catch (IOException e) {
                OLogger.printlnOnLog((String)"OPatch failed to store do_backup.txt");
            }
        }
    }

    private synchronized boolean canSkipPrereqChecks() {
        ProcessFileVersions proc = new ProcessFileVersions();
        String oh = this.getContext().getOracleHome();
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        OneOffEntry[] pohs = new OneOffEntry[]{};
        OneOffEntry[] pis = new OneOffEntry[prereqPatches.length];
        for (int i = 0; i < prereqPatches.length; ++i) {
            OneOffEntry pi;
            pis[i] = pi = prereqPatches[i].patch;
        }
        try {
            pohs = PrereqAPI.getInstalledOneOff((String)oh);
        }
        catch (Throwable e) {
            OLogger.printlnOnLog((String)"Converting Throwable to RuntimeException");
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            return false;
        }
        boolean b1 = proc.validateResult(oh, pohs, pis);
        Path pr = WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "prereq_result.txt", new String[0]);
        boolean b2 = Files.exists(pr, new LinkOption[0]);
        return b1 && b2;
    }

    public synchronized boolean checkPrereqResults(HashMap prereqResults) {
        for (Map.Entry entry : prereqResults.entrySet()) {
            StatusCheck re = (StatusCheck)entry.getValue();
            if (re.getStatusCode() == 0) continue;
            return false;
        }
        return true;
    }

    public synchronized HashMap runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail, OPatchSnowballPatchingMode mode) throws FailedPrereqException, Throwable {
        MethodTrackerObj trackerObj = MethodTracker.getTracker((String)TrackerTags.PREREQ_INITIAL);
        trackerObj.start();
        OPatchSDK.initLogFileIfUninitialized((String)OPatchEnv.getOracleHome());
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail, OPatchSnowballPatchingMode mode)");
        OPatchEnv.printCASDynamicLoadingToLog((String)this.context.getCasClasspathLoader().getDebugMsg(), (boolean)false);
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        boolean skipPrereq = this.canSkipPrereqChecks();
        if (skipPrereq) {
            try {
                prereqResults = serializer.deserializePrereqResult(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "prereq_result.txt");
                if (prereqResults != null) {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Skip prereq checks, re-use cached prereq results. \n");
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Re-run prereq checks that relate to active file/active services. \n");
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, this.checkActiveServices(), prereqResults);
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Finish all prereq checks. \n");
                    OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                    OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
                } else {
                    skipPrereq = false;
                }
            }
            catch (Throwable t) {
                OLogger.printlnOnLog((String)"OPatch failed to parse prereq_result.txt, re-run all prereq checks");
                skipPrereq = false;
            }
        }
        boolean isCAS = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
        if (!skipPrereq || isCAS && !this.hasRunPhaseOne(this.getContext().getPrereqPatches())) {
            OPatchEnv.setFATwoPhase();
            if (!isCAS) {
                prereqResults = this.runAllApplyPrereqs(needThrowThrowableOnFirstFail);
            } else {
                OLogger.printlnOnLogAndVerbose((String)"runAllApplyPrereqs:: run CAS NApply phase1 to shadow OH");
                OUSession.setNeedThrowThrowableOnFirstFail((boolean)needThrowThrowableOnFirstFail);
                OUSession.setPhaseOneReport((boolean)true);
                try {
                    if (!PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
                        this.runCASNApply();
                    }
                }
                catch (Throwable e) {
                    throw e;
                }
                finally {
                    prereqResults = this.runAllOrValidatePrereqs(needThrowThrowableOnFirstFail, false);
                    OUSession.setPhaseOneReport((boolean)false);
                }
            }
            try {
                OLogger.printlnOnLog((String)"FA_TWO_PHASE: Save prereq checks results into disk. \n");
                serializer.serializePrereqResult(OPatchEnv.getPrereqResultFileLoc((String)oh) + File.separator + "prereq_result.txt", prereqResults);
            }
            catch (IOException e) {
                OLogger.printlnOnLog((String)"OPatch failed to store prereq_result.txt");
            }
            OPatchEnv.unsetFATwoPhase();
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail, OPatchSnowballPatchingMode mode)");
        trackerObj.end();
        try {
            String statistics = MethodTracker.getStatistics((boolean)OLogger.isDebug());
            OLogger.justlog((int)OLogger.INFO, (String)statistics);
        }
        catch (Exception ex) {
            OLogger.printlnOnLog((String)("Error while printing Method Tracker Statistics. Message : " + ex.getMessage()));
        }
        return prereqResults;
    }

    private synchronized boolean checkIfPrereqsPassed(HashMap prereqResults) {
        OLogger.printlnOnLogAndVerbose((String)"checkIfPrereqsPassed:: check if all prereqs passed.");
        for (OPatchPatchPrereq key : prereqResults.keySet()) {
            StatusCheck statusCheck;
            if (key.equals(OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES) || key.equals(OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES) || key.equals(OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES) || (statusCheck = (StatusCheck)prereqResults.get(key)).getStatusCode() != 1) continue;
            StringBuffer tBuff = new StringBuffer("This prereq: ");
            tBuff.append(key.toString());
            tBuff.append(" failed. OPatch won't run CAS napply phase1. ");
            OLogger.printlnOnLogAndVerbose((String)tBuff.toString());
            return false;
        }
        return true;
    }

    private synchronized void runCASNApply() throws FailedPrereqException {
        OLogger.printlnOnLogAndVerbose((String)"runCASNApply:: OPatch SDK calls CAS NApply phase1");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        String oh = this.getContext().getOracleHome();
        String logFile = "";
        this.lastTargetExeLogFile = "";
        OPatchPatch[] patches = this.getContext().getPrereqPatches();
        if (patches == null || patches.length == 0) {
            throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for apply pre-requisites.");
        }
        try {
            this.lastTargetExeLogFile = logFile;
            String workSheetLoc = OPatchTarget.getWorkSheet(oh);
            OLogger.printlnOnLogAndVerbose((String)("runCASNApply:: Get worksheetloc for incoming patches from " + workSheetLoc));
            Path wsObj = WrapperFactory.getNioServiceWrapper().getPath(workSheetLoc, new String[0]);
            BufferedWriter bw = Files.newBufferedWriter(wsObj, Charset.forName("UTF-8"), new OpenOption[0]);
            PrintWriter pw = new PrintWriter(bw);
            for (int i = 0; i < patches.length; ++i) {
                String patchLocation = patches[i].getPatchLocation();
                OLogger.printlnOnLogAndVerbose((String)("runCASNApply:: This incoming patch is " + patchLocation));
                pw.println(patchLocation);
            }
            pw.flush();
            bw.close();
            pw.close();
            OUSession.setPatchBaseFile((String)workSheetLoc);
            try {
                OLogger.printlnOnLogAndVerbose((String)"runCASNApply:: serialize current OH and pi status, and run napply phase1");
                OLogger.disableConsoleOutput((boolean)false);
                OPatchOverCASUtil.serializeData((String)oh, (OPatchPatch[])patches);
                NApplyData.setPrereqPatchObject((List)OPatchPatchUtil.convertPatches((OPatchPatch[])patches));
                OPatchEnv.setCASFlow((boolean)true);
                OPatchOverCAS.INSTANCE.prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY);
            }
            catch (Throwable e) {
                if (e instanceof ExitTwoPhaseException) {
                    OLogger.printlnOnLog((String)e.getMessage());
                    return;
                }
                OLogger.printlnOnLog((String)"napply phase1 in validation fails");
                e.printStackTrace();
                throw e;
            }
            finally {
                OPatchEnv.setCASFlow((boolean)false);
                if (OPatchEnv.isCASCleanupNeeded() || OPatchEnv.getCASInitCounter() > 0) {
                    OPatchOverCAS.INSTANCE.cleanupCAS();
                    OPatchEnv.decrementCASInitCounter();
                }
                OLogger.enableConsoleOutput((boolean)false);
            }
        }
        catch (Throwable t) {
            OLogger.printStackTrace((Throwable)t);
        }
    }

    private void print(HashMap PR) {
        for (Object prereqname : PR.keySet()) {
            OPatchPatchPrereq pr = (OPatchPatchPrereq)prereqname;
            int pValue = pr.getValue();
            StatusCheck sc = (StatusCheck)PR.get(pr);
            int rStatus = sc.getStatusCode();
            String rResult = sc.getResult();
            System.out.println(pValue + " --- < " + rStatus + " , " + rResult + " >");
            System.out.println("\n");
        }
    }

    public synchronized HashMap runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail) throws FailedPrereqException, Throwable {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail)");
        MethodTrackerObj trackerObj = MethodTracker.getTracker((String)TrackerTags.PREREQ_INITIAL);
        trackerObj.start();
        HashMap prereqResults = null;
        try {
            prereqResults = OPatchEnv.isContinueOnPrereqFailure() ? this.runAllOrValidatePrereqsForAutoDB(needThrowThrowableOnFirstFail, true) : this.runAllOrValidatePrereqs(needThrowThrowableOnFirstFail, true);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail)");
            trackerObj.end();
        }
        return prereqResults;
    }

    public synchronized HashMap runAllApplyInitialPrereqs(boolean needThrowThrowableOnFirstFail) throws FailedPrereqException, Throwable {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: runAllApplyInitialPrereqs(boolean needThrowThrowableOnFirstFail)");
        MethodTrackerObj trackerObj = MethodTracker.getTracker((String)TrackerTags.PREREQ_INITIAL);
        trackerObj.start();
        HashMap prereqResults = null;
        try {
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                prereqResults = this.runAllOrValidateInitialPrereqsForAutoDB(needThrowThrowableOnFirstFail, true);
            } else {
                OLogger.printlnOnLog((String)"No Prereq will be running as isContinueOnPrereqFailure() is set to false by opatchauto");
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyInitialPrereqs(boolean needThrowThrowableOnFirstFail)");
            trackerObj.end();
        }
        return prereqResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap runAllOrValidatePrereqs(boolean needThrowThrowableOnFirstFail, boolean isRunAllPrereqs) throws FailedPrereqException, Throwable {
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        Throwable th = null;
        if (prereqPatches == null || prereqPatches.length == 0) {
            throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for apply pre-requisites.");
        }
        if (!isRunAllPrereqs) {
            prereqResults = OUSession.getApplyPrereqResults();
        }
        ArrayList<String> patchesToApplyList = new ArrayList<String>();
        for (OPatchPatch prereqPatch : prereqPatches) {
            patchesToApplyList.add(prereqPatch.getPatchId());
        }
        PrereqAPI.setPatchesToApplyList(patchesToApplyList);
        try {
            int modelCode;
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE, this.checkFusionAppsCompatible(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, this.checkActiveServices(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, this.checkApplicable(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME, this.checkCentralInventoryForOH(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION, this.checkCentralInventoryForRWSession(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION, this.checkCentralInventoryLocation(), prereqResults);
            }
            if ((modelCode = PatchingModel.returnModelCode((String)this.context.getOracleHome())) != 2) {
                if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME)) {
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, this.checkForIdenticalPatchInOracleHome(), prereqResults);
                }
                if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES)) {
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, this.checkConflictAmongPatches(), prereqResults);
                }
                if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME)) {
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, this.checkConflictAgainstOH(), prereqResults);
                }
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_IF_ORACLE_HOME_ALREADY_LOCKED_FOR_PATCHING)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_ORACLE_HOME_ALREADY_LOCKED_FOR_PATCHING, this.checkIfOHLockedForPatching(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, this.checkOracleHome(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, this.checkOraInstLocation(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_OUI_LOCATION)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_LOCATION, this.checkOUILocation(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE, this.checkOUIVersionCompatible(), prereqResults);
            }
            if (!(!OPatchEnv.isDBHome((String)oh) || OPatchEnv.isCASFlow() || OPatchEnv.isNextGenHome() || !isRunAllPrereqs && this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE, this.checkOPatchCompatibleAgainstOH(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, this.checkPatchApplicableOnCurrentPlatform(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, this.checkPatchApplyDependents(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_SHIPHOME)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_SHIPHOME, this.checkPatchShipHome(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_REQUIRED_LIBRARIES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_REQUIRED_LIBRARIES, this.checkRequiredLibs(), prereqResults);
            }
            if (modelCode != 2 && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, this.checkSystemCommandAvailable(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_SYSTEM_SPACE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_SPACE, this.checkSystemSpace(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, this.checkMinimumOpatchVersion(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCHING_MODEL)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCHING_MODEL, this.checkPatchingModel(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_ALL_NO_OPS), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_SOME_NO_OPS), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_NONE_NO_OPS), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_IF_REQUIRED_DELETE_ACTION_EXIST)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_REQUIRED_DELETE_ACTION_EXIST, this.checkIfRequiredDeleteActionExist(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, this.checkForInputValues(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE, this.checkUserAdminPrivilege(), prereqResults);
            }
        }
        catch (Throwable t) {
            th = t;
            return th;
        }
        finally {
            if (th != null) {
                OLogger.printStackTrace((Throwable)new RuntimeException(th));
            }
            if (prereqResults != null) {
                OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
            }
            if (th != null) {
                throw th;
            }
        }
        return prereqResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap runAllOrValidatePrereqsForAutoDB(boolean needThrowThrowableOnFirstFail, boolean isRunAllPrereqs) throws FailedPrereqException, Throwable {
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        Throwable th = null;
        if (prereqPatches == null || prereqPatches.length == 0) {
            throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for apply pre-requisites.");
        }
        if (!isRunAllPrereqs) {
            prereqResults = OUSession.getApplyPrereqResults();
        }
        ArrayList<String> patchesToApplyList = new ArrayList<String>();
        for (OPatchPatch prereqPatch : prereqPatches) {
            patchesToApplyList.add(prereqPatch.getPatchId());
        }
        PrereqAPI.setPatchesToApplyList(patchesToApplyList);
        OneOffEntry[] apOneOffs = new OneOffEntry[prereqPatches.length];
        for (int i = 0; i < prereqPatches.length; ++i) {
            apOneOffs[i] = prereqPatches[i].getOneOffEntry();
        }
        try {
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_NONE_NO_OPS), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, this.checkConflictAgainstOH(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, this.checkConflictAmongPatches(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, this.checkForIdenticalPatchInOracleHome(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCHING_MODEL)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCHING_MODEL, this.checkPatchingModel(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPATIBLE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPATIBLE, this.checkPatchsetUpdateCompatible(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS, this.checkPatchsetUpdateComponents(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_FUSION_APPS_COMPATIBLE)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FUSION_APPS_COMPATIBLE, this.checkFusionAppsCompatible(), prereqResults);
            }
            if (Rules.SystemWrite_continue() && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, this.checkForInputValues(), prereqResults);
            }
            if (!(!Rules.SystemWrite_continue() || !OPatchSessionHelper.hasHotPatch((PrereqSet)new PrereqSet(apOneOffs)) || OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome((String)oh) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1() || !isRunAllPrereqs && this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_DB_INSTANCE_UP))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_DB_INSTANCE_UP, this.checkDBInstanceUp(), prereqResults);
            }
            if (Rules.OUIRead_continue() && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_SYSTEM_SPACE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_SPACE, this.checkSystemSpace(), prereqResults);
            }
            if (Rules.OUIRead_continue() && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, this.checkSystemCommandAvailable(), prereqResults);
            }
            if (!(OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome((String)oh) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1() || !isRunAllPrereqs && this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, this.checkPatchApplicableOnCurrentPlatform(), prereqResults);
            }
            if (!(OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome((String)oh) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1() || !isRunAllPrereqs && this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, this.checkApplicable(), prereqResults);
            }
            if (Rules.OUIRead_continue() && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_CONFLICT_WITH_PATCHSET_UPDATE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_WITH_PATCHSET_UPDATE, this.checkConflictWithPatchsetUpdate(), prereqResults);
            }
            if (!(OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome((String)oh) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1() || !isRunAllPrereqs && this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
            }
            if (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS)) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, this.checkPatchApplyDependents(), prereqResults);
            }
        }
        catch (Throwable t) {
            th = t;
            return th;
        }
        finally {
            if (th != null) {
                OLogger.printStackTrace((Throwable)new RuntimeException(th));
            }
            if (prereqResults != null) {
                OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
            }
            if (th != null) {
                throw th;
            }
        }
        return prereqResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap runAllOrValidateInitialPrereqsForAutoDB(boolean needThrowThrowableOnFirstFail, boolean isRunAllPrereqs) throws FailedPrereqException, Throwable {
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        Throwable th = null;
        if (prereqPatches == null || prereqPatches.length == 0) {
            throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for apply pre-requisites.");
        }
        if (!isRunAllPrereqs) {
            prereqResults = OUSession.getApplyPrereqResults();
        }
        ArrayList<String> patchesToApplyList = new ArrayList<String>();
        for (OPatchPatch prereqPatch : prereqPatches) {
            patchesToApplyList.add(prereqPatch.getPatchId());
        }
        PrereqAPI.setPatchesToApplyList(patchesToApplyList);
        OneOffEntry[] apOneOffs = new OneOffEntry[prereqPatches.length];
        for (int i = 0; i < prereqPatches.length; ++i) {
            apOneOffs[i] = prereqPatches[i].getOneOffEntry();
        }
        try {
            if (Rules.OUIRead_continue() && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, this.checkMinimumOpatchVersion(), prereqResults);
            }
            if (OPatchEnv.isDBHome((String)oh) && !OPatchEnv.isCASFlow() && !OPatchEnv.isNextGenHome() && Rules.OUIRead_continue() && (isRunAllPrereqs || !this.isKeyExist(prereqResults, OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE))) {
                this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OPATCH_OH_COMPATIBLE, this.checkOPatchCompatibleAgainstOH(), prereqResults);
            }
        }
        catch (Throwable t) {
            th = t;
            return th;
        }
        finally {
            if (th != null) {
                OLogger.printStackTrace((Throwable)new RuntimeException(th));
            }
            if (prereqResults != null) {
                OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
            }
            if (th != null) {
                throw th;
            }
        }
        return prereqResults;
    }

    public OPatchContext getContext() {
        return this.context;
    }

    private synchronized void compositeAdapter(boolean napply, OPatchPatch[] patches) throws OPatchException {
        HashSet<String> activeConstituents = new HashSet<String>();
        ArrayList<OPatchPatch> activeComposites = new ArrayList<OPatchPatch>();
        ArrayList<OPatchPatch> oneOffs = new ArrayList<OPatchPatch>();
        for (OPatchPatch patch : patches) {
            if (!patch.getActiveConstituent().equals("")) {
                activeConstituents.add(patch.getActiveConstituent());
                continue;
            }
            oneOffs.add(patch);
        }
        for (OPatchPatch patch : patches) {
            String patchId = patch.getPatchId();
            if (!activeConstituents.contains(patchId)) continue;
            activeComposites.add(patch);
        }
        try {
            if (activeConstituents.size() > 1) {
                throw new Exception("OPatchSDK only support one composite in NApply/NRollback session.");
            }
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            Path wsObj = WrapperFactory.getNioServiceWrapper().getPath(workSheetLoc, new String[0]);
            BufferedWriter bw = Files.newBufferedWriter(wsObj, Charset.forName("UTF-8"), new OpenOption[0]);
            PrintWriter pw = new PrintWriter(bw);
            if (napply) {
                String patchLocation;
                for (OPatchPatch oneOff : oneOffs) {
                    patchLocation = oneOff.getPatchLocation();
                    pw.println(patchLocation);
                }
                for (OPatchPatch oneOff : activeComposites) {
                    patchLocation = oneOff.getPatchLocation();
                    pw.println(WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]).getParent());
                }
            } else {
                String patchID;
                for (OPatchPatch oneOff : oneOffs) {
                    patchID = oneOff.getPatchLanguageId();
                    pw.println(patchID);
                }
                for (OPatchPatch oneOff : activeComposites) {
                    patchID = oneOff.getPatchLanguageId();
                    pw.println(patchID);
                }
            }
            pw.flush();
            bw.close();
            pw.close();
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAnalysisReport NApplyReport(OPatchPatch[] patches, OPatchNApplyOptions options) throws FailedPrereqException, OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApplyReport(OPatchPatch[] patches,OPatchNApplyOptions options)");
        OPatchAnalysisReport report = new OPatchAnalysisReport();
        try {
            report = new OPatchAnalysisReport(patches, this, options);
            if (options != null) {
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().noRelink = options.getNoRelink();
                this.getContext().autorollback_subsets = options.getAutorollbackSubsets();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
                this.getContext().local = options.isLocal();
                OPatchEnv.setFullDBCasRepo((boolean)options.isFullDBCasRepo());
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(true, patches);
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            cmdOptionStr.append(" -report");
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
        }
        catch (Throwable e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchAnalysisReport ereport = report;
            ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
        }
        finally {
            try {
                this.getContext().skipConflict = false;
                this.getContext().forceConflict = false;
                this.getContext().optimize = false;
                this.getContext().autorollback_subsets = false;
                this.getContext().ohInstanceUp = false;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                OPatchEnv.setNoPatchgen((boolean)false);
            }
            catch (OPatchException e) {
                OLogger.printStackTrace((Throwable)e);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApplyReport(OPatchPatch[] patches,OPatchNApplyOptions options)");
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAnalysisReport NApplyReportForAllPrereqs(OPatchPatch[] patches, OPatchNApplyOptions options) throws FailedPrereqException, OPatchException {
        if (!options.continueOnPrereqFailure()) {
            return this.NApplyReport(patches, options);
        }
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApplyReportForPrereqs(OPatchPatch[] patches,OPatchNApplyOptions options)");
        OPatchAnalysisReport report = new OPatchAnalysisReport();
        try {
            report = new OPatchAnalysisReport(patches, this, options);
            if (options != null) {
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                this.getContext().continueOnPrereqFailure = options.continueOnPrereqFailure();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
                OPatchEnv.setContinueOnPrereqFailure((boolean)options.continueOnPrereqFailure());
                OPatchEnv.setForceConflict((boolean)options.getforceConflict());
                OPatchEnv.setIgnoreConflict((boolean)options.getskipConflict());
                OPatchEnv.setOptimize((boolean)options.getOptimize());
                this.getContext().local = options.isLocal();
                OPatchEnv.setLocal((boolean)options.isLocal());
                OPatchEnv.setFullDBCasRepo((boolean)options.isFullDBCasRepo());
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            OUSession.phbasefile((String)workSheetLoc);
            this.compositeAdapter(true, patches);
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OLogger.disableConsoleOutput();
            patches = this.NApplyOptimizer(patches);
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                this.context.setPrereqPatchesToTest(patches, true);
                this.runAllApplyPrereqs(false);
                report.removeFailedAndSkipedPatchesFromNApplyPatches();
            }
        }
        catch (Throwable e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchAnalysisReport ereport = report;
            ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
        }
        finally {
            try {
                this.getContext().skipConflict = false;
                this.getContext().forceConflict = false;
                this.getContext().optimize = false;
                this.getContext().ohInstanceUp = false;
                this.getContext().continueOnPrereqFailure = false;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchEnv.setContinueOnPrereqFailure((boolean)false);
                OPatchEnv.setNoPatchgen((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                OLogger.enableConsoleOutput();
            }
            catch (OPatchException e) {
                OLogger.printStackTrace((Throwable)e);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApplyReportForPrereqs(OPatchPatch[] patches,OPatchNApplyOptions options)");
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAnalysisReport NApplyReportInitialPrereqs(OPatchPatch[] patches, OPatchNApplyOptions options) throws FailedPrereqException, OPatchException {
        if (!options.continueOnPrereqFailure()) {
            return this.NApplyReport(patches, options);
        }
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApplyReportInitialPrereqs(OPatchPatch[] patches,OPatchNApplyOptions options)");
        OPatchAnalysisReport report = new OPatchAnalysisReport();
        try {
            report = new OPatchAnalysisReport(patches, this, options);
            if (options != null) {
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                this.getContext().continueOnPrereqFailure = options.continueOnPrereqFailure();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
                OPatchEnv.setContinueOnPrereqFailure((boolean)options.continueOnPrereqFailure());
                OPatchEnv.setForceConflict((boolean)options.getforceConflict());
                OPatchEnv.setIgnoreConflict((boolean)options.getskipConflict());
                OPatchEnv.setOptimize((boolean)options.getOptimize());
                this.getContext().local = options.isLocal();
                OPatchEnv.setLocal((boolean)options.isLocal());
                OPatchEnv.setFullDBCasRepo((boolean)options.isFullDBCasRepo());
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            OUSession.phbasefile((String)workSheetLoc);
            this.compositeAdapter(true, patches);
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OLogger.disableConsoleOutput();
            patches = this.NApplyOptimizer(patches);
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                this.context.setPrereqPatchesToTest(patches, true);
                this.runAllApplyInitialPrereqs(false);
                List<OPatchPatch> sucP = null;
                sucP = report.getNApplyPatches();
                for (OPatchPatch sp : sucP) {
                    OLogger.printlnOnLog((String)("Successful Patch : " + sp.getPatchId()));
                }
            }
        }
        catch (Throwable e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchAnalysisReport ereport = report;
            ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
        }
        finally {
            try {
                this.getContext().skipConflict = false;
                this.getContext().forceConflict = false;
                this.getContext().optimize = false;
                this.getContext().ohInstanceUp = false;
                this.getContext().continueOnPrereqFailure = false;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchEnv.setContinueOnPrereqFailure((boolean)false);
                OPatchEnv.setNoPatchgen((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                OLogger.enableConsoleOutput();
            }
            catch (OPatchException e) {
                OLogger.printStackTrace((Throwable)e);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApplyReportInitialPrereqs(OPatchPatch[] patches,OPatchNApplyOptions options)");
        return report;
    }

    private OPatchPatch[] NApplyOptimizer(OPatchPatch[] patches) {
        HashMap<String, OPatchPatch> PatchToObject = new HashMap<String, OPatchPatch>();
        PatchObject[] mapObjects = new PatchObject[patches.length];
        for (int i = 0; i < patches.length; ++i) {
            mapObjects[i] = patches[i].getOneOffEntry().getPatchObject();
            PatchToObject.put(mapObjects[i].getPatchUniqID(), patches[i]);
        }
        mapObjects = OPatchSessionHelper.sortOnOverlay((PatchObject[])mapObjects, (boolean)true);
        OPatchPatch[] rePatches = new OPatchPatch[mapObjects.length];
        for (int i = 0; i < rePatches.length; ++i) {
            rePatches[i] = (OPatchPatch)PatchToObject.get(mapObjects[i].getPatchUniqID());
        }
        OPatchUtilHelper.prepareNApplyData((PatchObject[])mapObjects);
        return rePatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(OPatchPatch[] patches, OPatchNApplyOptions options) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(patches,options)");
        try {
            if (options != null) {
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().autorollback_subsets = options.getAutorollbackSubsets();
                this.getContext().local = options.isLocal();
                this.getContext().noRelink = options.getNoRelink();
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(true, patches);
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
            }
            finally {
                try {
                    this.getContext().skipConflict = false;
                    this.getContext().forceConflict = false;
                    this.getContext().optimize = false;
                    this.getContext().autorollback_subsets = false;
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {}
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            OPatchEnv.setNoPatchgen((boolean)false);
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(patches,options)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(IAnalysisReport report) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(IAnalysisReport report)");
        List<OPatchPatch> arrPatches = report.getNApplyPatches();
        OPatchPatch[] patches = new OPatchPatch[arrPatches.size()];
        arrPatches.toArray(patches);
        try {
            if (report.getOptions() != null) {
                OPatchNApplyOptions options = report.getOptions();
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().autorollback_subsets = options.getAutorollbackSubsets();
                this.getContext().local = options.isLocal();
                this.getContext().noRelink = options.getNoRelink();
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(true, patches);
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
            }
            finally {
                try {
                    this.getContext().skipConflict = false;
                    this.getContext().forceConflict = false;
                    this.getContext().optimize = false;
                    this.getContext().autorollback_subsets = false;
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {}
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            OPatchEnv.setNoPatchgen((boolean)false);
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(IAnalysisReport report)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NRollback(OPatchPatch[] patches, OPatchNRollbackOptions options) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NRollback(patches,options)");
        try {
            if (options != null) {
                this.getContext().optimize = options.getOptimize();
                this.getContext().noRelink = options.getNoRelink();
                this.getContext().autorollback_subsets = options.getAutorollbackSubsets();
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(false, patches);
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
            }
            finally {
                try {
                    this.getContext().optimize = false;
                    this.getContext().autorollback_subsets = false;
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {}
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            OPatchEnv.setNoPatchgen((boolean)false);
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollback(patches,options)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NRollback(IAnalysisReport report) throws OPatchException {
        List<OPatchPatch> arrPatches = report.getNRollbackPatches();
        OPatchPatch[] patches = new OPatchPatch[arrPatches.size()];
        arrPatches.toArray(patches);
        try {
            if (report.getNRollbackOptions() != null) {
                OPatchNRollbackOptions options = report.getNRollbackOptions();
                this.getContext().optimize = options.getOptimize();
                this.getContext().noRelink = options.getNoRelink();
                this.getContext().autorollback_subsets = options.getAutorollbackSubsets();
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(false, patches);
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
            }
            finally {
                try {
                    this.getContext().optimize = false;
                    this.getContext().autorollback_subsets = false;
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {}
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            OPatchEnv.setNoPatchgen((boolean)false);
        }
    }

    public synchronized IAnalysisReport NRollbackReport(OPatchPatch[] patches) throws OPatchException, FailedPrereqException {
        return this.NRollbackReport(patches, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAnalysisReport NRollbackReport(OPatchPatch[] patches, OPatchNRollbackOptions options) throws OPatchException, FailedPrereqException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NRollbackReport(OPatchPatch[] patches)");
        OPatchAnalysisReport report = new OPatchAnalysisReport();
        try {
            report = new OPatchAnalysisReport(patches, this, options);
            if (options != null) {
                this.getContext().optimize = options.getOptimize();
                this.getContext().autorollback_subsets = options.getAutorollbackSubsets();
                this.getContext().local = options.isLocal();
                this.getContext().noRelink = options.getNoRelink();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(false, patches);
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            cmdOptionStr.append(" -report");
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
        }
        catch (Throwable e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchAnalysisReport ereport = report;
            ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
        }
        finally {
            try {
                this.getContext().optimize = false;
                this.getContext().autorollback_subsets = false;
                this.getContext().ohInstanceUp = false;
                this.getContext().local = true;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                OPatchEnv.setNoPatchgen((boolean)false);
            }
            catch (OPatchException e) {
                OLogger.printStackTrace((Throwable)e);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollbackReport(OPatchPatch[] patches)");
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAnalysisReport NRollbackReportForAllPrereqs(OPatchPatch[] patches, OPatchNRollbackOptions options) throws OPatchException, FailedPrereqException {
        if (!options.continueOnPrereqFailure()) {
            return this.NRollbackReport(patches, options);
        }
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NRollbackReportForAllPrereqs(OPatchPatch[] patches)");
        OPatchAnalysisReport report = new OPatchAnalysisReport();
        try {
            if (options != null) {
                this.getContext().optimize = options.getOptimize();
                this.getContext().local = options.isLocal();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
                this.getContext().continueOnPrereqFailure = options.continueOnPrereqFailure();
                OPatchEnv.setContinueOnPrereqFailure((boolean)options.continueOnPrereqFailure());
                OPatchEnv.setOptimize((boolean)options.getOptimize());
                this.getContext().local = options.isLocal();
                OPatchEnv.setLocal((boolean)options.isLocal());
                OPatchEnv.setFullDBCasRepo((boolean)options.isFullDBCasRepo());
                OPatchEnv.setNoPatchgen((boolean)options.isNoPatchgen());
            }
            patches = this.NRollbackOptimizer(patches);
            report = new OPatchAnalysisReport(patches, this, options);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(false, patches);
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            cmdOptionStr.append(" -report");
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OLogger.disableConsoleOutput();
            if (OPatchEnv.isContinueOnPrereqFailure()) {
                this.context.setPrereqPatchesToTest(patches, false);
                this.runAllRollbackPrereqsForAutoDB(false);
                for (OPatchPatch patch : patches) {
                    OUSession.addNRollbackPatchesToReport((String)patch.getPatchId(), (boolean)false);
                }
                report.removeFailedAndSkipedPatchesFromNRollbackPatches();
            }
        }
        catch (Throwable e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchAnalysisReport ereport = report;
            ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
        }
        finally {
            try {
                this.getContext().optimize = false;
                this.getContext().ohInstanceUp = false;
                this.getContext().local = true;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                OLogger.enableConsoleOutput();
                OPatchEnv.setNoPatchgen((boolean)false);
            }
            catch (OPatchException e) {
                OLogger.printStackTrace((Throwable)e);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollbackReportForAllPrereqs(OPatchPatch[] patches)");
        return report;
    }

    private OPatchPatch[] NRollbackOptimizer(OPatchPatch[] patches) {
        if (patches.length < 1) {
            return patches;
        }
        if (patches.length == 1 && patches[0] == null) {
            return patches;
        }
        String oracleHomePath = this.getOracleHome();
        LinkedHashMap<String, OPatchPatch> PatchToObject = new LinkedHashMap<String, OPatchPatch>();
        PatchObject[] mapObjects = new PatchObject[patches.length];
        ArrayList<String> rbPatchIDList = new ArrayList<String>();
        for (int i = 0; i < patches.length; ++i) {
            mapObjects[i] = patches[i].getOneOffEntry().getPatchObject();
            String patchId = patches[i].getPatchId();
            String activeConstituent = CompositePatchObject.getActiveConstituent((String)oracleHomePath, (String)patchId);
            if (activeConstituent != null && !"".equals(activeConstituent)) {
                if (patchId == null || !patchId.equals(activeConstituent)) continue;
                PatchToObject.put(mapObjects[i].getPatchUniqID(), patches[i]);
                rbPatchIDList.add(patchId);
                continue;
            }
            PatchToObject.put(mapObjects[i].getPatchUniqID(), patches[i]);
            rbPatchIDList.add(patchId);
        }
        String[] rbPatchIDs = new String[rbPatchIDList.size()];
        rbPatchIDList.toArray(rbPatchIDs);
        ArrayList<String> compositeList = new ArrayList<String>();
        ArrayList<String> newPatchIDs = new ArrayList<String>();
        for (int i = 0; i < rbPatchIDs.length; ++i) {
            String rbPatchID = rbPatchIDs[i];
            if (CompositePatchObject.getActiveConstituent((String)oracleHomePath, (String)rbPatchID) != null) {
                String activeConstituent = CompositePatchObject.getActiveConstituent((String)oracleHomePath, (String)rbPatchID);
                if (rbPatchID.equals(activeConstituent)) {
                    compositeList.add(activeConstituent);
                    String[] constituentsToRollback = null;
                    constituentsToRollback = CompositePatchObject.getConstituentsToRollback((String)oracleHomePath, (String)rbPatchID);
                    for (int l = 0; l < constituentsToRollback.length; ++l) {
                        newPatchIDs.add(constituentsToRollback[l]);
                    }
                    try {
                        int all_subpatches_num = CompositePatchObject.getCompositeAutoRBOrder((String)rbPatchID, (String)oracleHomePath).size();
                        if (constituentsToRollback.length == all_subpatches_num) {
                            OPatchEnv.setInactivePSUTrainRollback((boolean)true);
                        }
                    }
                    catch (Exception ex) {
                        OPatchEnv.setInactivePSUTrainRollback((boolean)false);
                    }
                    OPatchEnv.setCompositeRollback((boolean)true);
                    OPatchEnv.setCompositeActiveID((String)activeConstituent);
                    continue;
                }
                OLogger.println((String)("ERROR: OPatch would not rollback a sub-patch that is not active. The patch id " + rbPatchID + " is a sub-patch of the active composite " + activeConstituent + ". OPatch will not rollback patch(es) " + rbPatchID + " until you have rolled back " + activeConstituent + "."));
                return null;
            }
            newPatchIDs.add(rbPatchID);
        }
        String[] newPatchIDArray = new String[newPatchIDs.size()];
        newPatchIDs.toArray(newPatchIDArray);
        OPatchEnv.setUserSuppliedPatchIDs((String[])newPatchIDArray);
        if (OPatchEnv.isOptimize()) {
            OneOffEntry[] dependents = OPatchSessionHelper.getCompleteDependentRollbackList((String)this.getOracleHome(), (String[])newPatchIDArray);
            String[] rollbackPatchIds = new String[dependents.length];
            if (dependents.length > rbPatchIDs.length) {
                for (int i = 0; i < dependents.length; ++i) {
                    rollbackPatchIds[i] = dependents[i].getPatchID();
                }
                rbPatchIDs = rollbackPatchIds;
            }
        } else {
            rbPatchIDs = newPatchIDArray;
        }
        PatchObject[] rbPatchObjects = new PatchObject[rbPatchIDs.length];
        try {
            rbPatchObjects = OPatchUtilHelper.getPatchesToRollback((String)this.getOracleHome(), (String[])rbPatchIDs, (String)OPatchEnv.getNRollbackSessionName());
            rbPatchObjects = OPatchSessionHelper.sortOnOverlay((PatchObject[])rbPatchObjects, (boolean)false);
            OPatchSessionHelper.groupCompositeByNeighbor((PatchObject[])rbPatchObjects);
            if (!OPatchSessionHelper.validateRollbackOrder((PatchObject[])rbPatchObjects)) {
                OLogger.log((String)"Rollback in the reverse order of apply.", (Object[])new Object[0]);
                rbPatchObjects = OPatchSessionHelper.sortOnApplyTime((PatchObject[])rbPatchObjects, (String)this.getOracleHome());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        OPatchPatch[] rePatches = new OPatchPatch[rbPatchObjects.length];
        for (int i = 0; i < rePatches.length; ++i) {
            rePatches[i] = (OPatchPatch)PatchToObject.get(rbPatchObjects[i].getPatchUniqID());
            if (rePatches[i] != null) continue;
            try {
                rePatches[i] = this.context.getInstalledActivePatch(rbPatchObjects[i].getPatchID());
                continue;
            }
            catch (OPatchException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        }
        return rePatches;
    }

    public boolean isCasEnabled() {
        return OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
    }

    public IAnalysisReport napplyPrepare(OPatchPatch[] patches, OPatchNApplyOptions options) throws OPatchException {
        IAnalysisReport report;
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: napplyPrepare(OPatchPatch[] patches, OPatchNApplyOptions options)");
        boolean isCAS = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
        if (!isCAS) {
            throw new OPatchException("napplyPrepare(OPatchPatch[] patches, OPatchNApplyOptions options) API is not supported in non CAS based OPatch");
        }
        try {
            report = this.NApplyReportForAllPrereqs(patches, options);
            if (report.getFailedPatches() != null && report.getFailedPatches().size() > 0) {
                return report;
            }
        }
        catch (FailedPrereqException e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchException e1 = new OPatchException(e.getMessage());
            e1.setStackTrace(e.getStackTrace());
            throw e1;
        }
        OPatchEnv.setReport((boolean)false);
        OPatchEnv.setCASPhase1();
        OPatchEnv.setCASFlow((boolean)true);
        OLogger.disableConsoleOutput();
        try {
            int i;
            OLogger.printlnOnLogAndVerbose((String)"OPatchTarget::napplyPrepare, start to run TwoPhasePatching.prepare.");
            TwoPhasePatching tp = new TwoPhasePatching();
            OPatchOverCAS.INSTANCE.initializeCAS(OPatchEnv.getOracleHome());
            List<OPatchPatch> nAPatches = report.getNApplyPatches();
            List<OPatchPatch> nRPatches = report.getNRollbackPatches();
            PatchObject[] applyPatches = new PatchObject[nAPatches.size()];
            PatchObject[] rollbackPatches = new PatchObject[nRPatches.size()];
            String oh = OPatchEnv.getOracleHome();
            for (i = 0; i < nAPatches.size(); ++i) {
                applyPatches[i] = OPatchUtilHelper.loadAndInitPatchObject((String)OPatchEnv.getNApplySessionName(), (String)nAPatches.get(i).getPatchLocation());
            }
            for (i = 0; i < nRPatches.size(); ++i) {
                rollbackPatches[i] = OPatchUtilHelper.loadAndInitPatchObject((String)OPatchEnv.getNApplySessionName(), (String)oh, (String)nRPatches.get(i).getPatchId());
            }
            if (applyPatches.length < 1 && rollbackPatches.length < 1) {
                IAnalysisReport i2 = report;
                return i2;
            }
            tp.prepare(rollbackPatches, applyPatches);
            PatchObject[] raw = OPatchUtilHelper.getPatchesToApply((String)oh, null, (String)OPatchEnv.getNApplySessionName());
            OPatchOverCASUtil.serializeStatus((String)oh, (PatchObject[])raw);
            OPatchOverCASUtil.cleanupFullDBCasRepoStatus((String)OPatchEnv.getOracleHome());
            if (options != null && options.isFullDBCasRepo()) {
                OLogger.justlog((int)OLogger.INFO, (String)"isFullDBcasRepo option provided for napplyPrepare. Serialize it...");
                OPatchOverCASUtil.serializeFullDBCasRepo((String)String.valueOf(options.isFullDBCasRepo()));
            }
        }
        catch (Throwable e) {
            OLogger.printlnOnLog((String)"OPatchTarget::napplyPrepare fails");
            OLogger.printStackTrace((Throwable)e);
            throw new OPatchException(e.getMessage());
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: napplyPrepare(OPatchPatch[] patches, OPatchNApplyOptions options)");
        return report;
    }

    public void napplyCommit(OPatchPatch[] patches) throws OPatchException {
        boolean isCAS = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: napplyCommit(OPatchPatch[] patches)");
        if (!isCAS) {
            throw new OPatchException("This API is not supported in non CAS based OPatch");
        }
        if (this.hasRunPhaseOne(patches)) {
            try {
                OLogger.printlnOnLogAndVerbose((String)"OPatchTarget::napplyCommit:: invoke prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY)");
                TwoPhasePatching tp = new TwoPhasePatching();
                OPatchOverCAS.INSTANCE.initializeCAS(OPatchEnv.getOracleHome());
                try {
                    NApplyDataSerializer serializer = new NApplyDataSerializer();
                    String fullDBcasRepo = OPatchOverCASUtil.deserializeFullDBCasRepo();
                    if (fullDBcasRepo != null) {
                        OPatchEnv.setFullDBCasRepo((boolean)Boolean.parseBoolean(fullDBcasRepo));
                    }
                }
                catch (Exception e) {
                    OLogger.printlnOnLog((String)"OPatchTarget::napplyCommit fails");
                    OLogger.printStackTrace((Throwable)e);
                    throw new OPatchException(e.getMessage());
                }
                tp.commit();
                OPatchOverCASUtil.cleanupCache((String)OPatchEnv.getOracleHome());
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            finally {
                OPatchOverCAS.INSTANCE.cleanupCAS();
            }
        }
        throw new OPatchException("Phase one has not run for these set of patches");
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: napplyCommit(OPatchPatch[] patches");
    }

    public IAnalysisReport nrollbackPrepare(OPatchPatch[] patches, OPatchNRollbackOptions options) throws OPatchException {
        IAnalysisReport report;
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: nrollbackPrepare(OPatchPatch[] patches, OPatchNRollbackOptions options)");
        boolean isCAS = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
        if (!isCAS) {
            throw new OPatchException("This API is not supported in non CAS based OPatch");
        }
        PatchObject[] userInputPatches = new PatchObject[patches.length];
        for (int i = 0; i < patches.length; ++i) {
            userInputPatches[i] = patches[i].getOneOffEntry().getPatchObject();
        }
        OPatchEnv.setCASFlow((boolean)true);
        try {
            report = this.NRollbackReportForAllPrereqs(patches, options);
            if (report.getFailedPatches() != null && report.getFailedPatches().size() > 0) {
                return report;
            }
        }
        catch (FailedPrereqException e) {
            OLogger.printStackTrace((Throwable)e);
            OPatchException e1 = new OPatchException(e.getMessage());
            e1.setStackTrace(e.getStackTrace());
            throw e1;
        }
        OPatchEnv.setReport((boolean)false);
        OPatchEnv.setCASPhase1();
        OPatchEnv.setCASFlow((boolean)true);
        OLogger.disableConsoleOutput();
        try {
            int i;
            OLogger.printlnOnLogAndVerbose((String)"OPatchTarget::nrollbackPrepare, start to run TwoPhasePatching.prepare.");
            TwoPhasePatching tp = new TwoPhasePatching();
            OPatchOverCAS.INSTANCE.initializeCAS(OPatchEnv.getOracleHome());
            List<OPatchPatch> nAPatches = report.getNApplyPatches();
            List<OPatchPatch> nRPatches = report.getNRollbackPatches();
            PatchObject[] applyPatches = new PatchObject[nAPatches.size()];
            PatchObject[] rollbackPatches = new PatchObject[nRPatches.size()];
            String oh = OPatchEnv.getOracleHome();
            for (i = 0; i < nAPatches.size(); ++i) {
                applyPatches[i] = OPatchUtilHelper.loadAndInitPatchObject((String)OPatchEnv.getNRollbackSessionName(), (String)nAPatches.get(i).getPatchLocation());
            }
            for (i = 0; i < nRPatches.size(); ++i) {
                rollbackPatches[i] = OPatchUtilHelper.loadAndInitPatchObject((String)OPatchEnv.getNRollbackSessionName(), (String)oh, (String)nRPatches.get(i).getPatchId());
            }
            if (applyPatches.length < 1 && rollbackPatches.length < 1) {
                IAnalysisReport iAnalysisReport = report;
                return iAnalysisReport;
            }
            tp.prepare(rollbackPatches, applyPatches);
            OPatchOverCASUtil.serializeStatus((String)oh, (PatchObject[])userInputPatches);
            if (options != null && options.isFullDBCasRepo()) {
                OLogger.justlog((int)OLogger.INFO, (String)"isFullDBcasRepo option provided for napplyRollback. Serialize it...");
                OPatchOverCASUtil.serializeFullDBCasRepo((String)String.valueOf(options.isFullDBCasRepo()));
            }
        }
        catch (Throwable e) {
            OLogger.printlnOnLog((String)"OPatchSDKV2::nApplyPhaseOne fails");
            OLogger.printStackTrace((Throwable)e);
            throw new OPatchException(e.getMessage());
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: nrollbackPrepare(OPatchPatch[] patches, OPatchNRollbackOptions options)");
        return report;
    }

    public void nrollbackCommit(OPatchPatch[] patches) throws OPatchException {
        boolean isCAS = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: nrollbackCommit(OPatchPatch[] patches)");
        if (!isCAS) {
            throw new OPatchException("This API is not supported in non CAS based OPatch");
        }
        if (this.hasRunPhaseOne(patches)) {
            try {
                OLogger.printlnOnLogAndVerbose((String)"OPatchTarget::napplyCommit:: invoke prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY)");
                TwoPhasePatching tp = new TwoPhasePatching();
                OPatchOverCAS.INSTANCE.initializeCAS(OPatchEnv.getOracleHome());
                try {
                    NApplyDataSerializer serializer = new NApplyDataSerializer();
                    String fullDBcasRepo = OPatchOverCASUtil.deserializeFullDBCasRepo();
                    if (fullDBcasRepo != null) {
                        OPatchEnv.setFullDBCasRepo((boolean)Boolean.parseBoolean(fullDBcasRepo));
                    }
                }
                catch (Exception e) {
                    OLogger.printlnOnLog((String)"OPatchTarget::napplyPrepare fails");
                    OLogger.printStackTrace((Throwable)e);
                    throw new OPatchException(e.getMessage());
                }
                tp.commit();
                OPatchOverCASUtil.cleanupCache((String)OPatchEnv.getOracleHome());
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            finally {
                OPatchOverCAS.INSTANCE.cleanupCAS();
            }
        }
        throw new OPatchException("Phase one has not run for these set of patches");
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: nrollbackCommit(OPatchPatch[] patches)");
    }

    public synchronized void clearCachedFiles() {
        this.lastTargetExeLogFile = "";
        try {
            OUSession.clearcache((String)this.getOracleHome());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkStability() throws OPatchException {
        String oracleHomePath = this.context.getOracleHome();
        try {
            OPatchOverCAS.INSTANCE.initializeCAS(oracleHomePath);
            boolean bl = CASClientFactory.getCASClient().isLastCheckpointCompleted(oracleHomePath);
            return bl;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }

    public void restoreStability() throws OPatchException {
        String oracleHomePath = this.context.getOracleHome();
        try {
            OPatchOverCAS.INSTANCE.initializeCAS(oracleHomePath);
            CASClientFactory.getCASClient().restore(oracleHomePath);
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        finally {
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
    }

    private boolean isKeyExist(HashMap prereqResults, OPatchPatchPrereq key) {
        boolean isExist = false;
        if (prereqResults != null && !(isExist = prereqResults.containsKey(key))) {
            OLogger.debug((String)("Executing prereq " + key + " as it was skipped during napply..."));
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultObject deleteInactivePatches() {
        ResultObject.RETURN_CODE code = ResultObject.RETURN_CODE.ERROR;
        String oracleHomePath = this.getOracleHome();
        String mesg = null;
        IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
        boolean alreadyLocked = rwServices.isLocked();
        try {
            if (!alreadyLocked) {
                rwServices.lock(oracleHomePath);
                alreadyLocked = true;
            }
            OLogger.justlog((int)OLogger.INFO, (String)"Deleting Inactive Patches .......");
            InactivePatchesUtil inactivePatchesUtil = new InactivePatchesUtil();
            int res = inactivePatchesUtil.deletePatches(false, false);
            if (res == 0) {
                mesg = "Inactive Patches have been deleted. Check log file for more details.";
                OLogger.justlog((int)OLogger.INFO, (String)mesg);
                code = ResultObject.RETURN_CODE.OK;
            } else if (res == 1) {
                mesg = "No inactive patches are eligible for delete. Check log file for more details.";
                OLogger.justlog((int)OLogger.INFO, (String)mesg);
                code = ResultObject.RETURN_CODE.NOOP;
            } else {
                mesg = "Delete Inactive Patches failed. Check log file for more details.";
                OLogger.justlog((int)OLogger.SEVERE, (String)mesg);
                code = ResultObject.RETURN_CODE.ERROR;
            }
        }
        catch (Exception e) {
            mesg = "Delete Inactive Patches failed. Check log file for more details.";
            OLogger.justlog((int)OLogger.SEVERE, (String)mesg);
            code = ResultObject.RETURN_CODE.ERROR;
            OLogger.printStackTrace((Throwable)e);
        }
        finally {
            if (alreadyLocked) {
                rwServices.release();
            }
        }
        String logLoc = this.getLastSessionLogFile();
        ResultObject resultObject = new ResultObject(code, mesg, logLoc);
        return resultObject;
    }

    static {
        OLogger.setOPatchCmdLineMode((boolean)false);
        isTargetInitialized = false;
    }

    public static class StatusCheck {
        public static final int PASSED = 0;
        public static final int FAILED = 1;
        public static final int NOT_EXECUTED = 2;
        private int status = 2;
        private String result = "n/a";

        public StatusCheck(int status, String result) {
            this.status = status;
            this.result = result;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String statusStr = "";
            if (this.status == 0) {
                statusStr = "PASSED";
            } else if (this.status == 1) {
                statusStr = "FAILED";
            } else if (this.status == 2) {
                statusStr = "NOT ATTEMPTED (serious failure)";
            }
            buff.append("[ Prerequisite Status: " + statusStr);
            if (this.result == null || this.result.equals("")) {
                this.result = "\"n/a\"";
            }
            if (this.status != 0) {
                buff.append(", Prerequisite output: " + this.result + "");
            }
            buff.append("]\n");
            return buff.toString();
        }

        protected void setResult(String mixedResult) {
            this.result = mixedResult;
        }

        public String getResult() {
            return this.result;
        }

        public int getStatusCode() {
            return this.status;
        }

        protected void setStatusCode(int value) {
            this.status = value;
        }
    }
}

