/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import model.common.AbstractBaseTarget;
import model.fafmw.NodeManager;
import model.fafmw.SOAResourceBundle;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import model.fafmw.WLServer;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchInventory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchext.Component;
import oracle.opatch.opatchext.FileInfo;
import oracle.opatch.opatchext.Patch;
import oracle.opatch.opatchfafmw.OPatchFAStepErrorCode;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchsdk.FAExecutionContext;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchBug;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchConfigWLDomain;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchExecutedArtifact;
import oracle.opatch.opatchsdk.OPatchExecutionStep;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAConfigContext;
import oracle.opatch.opatchsdk.OPatchFAConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchFATarget;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchSOADeployAction;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.wrappers.WrapperFactory;

final class OPatchUtils {
    private static PrintStream originalOut = null;
    private static PrintStream originalErr = null;

    private OPatchUtils() {
    }

    protected static boolean compareFileOffsets(String offset1, String offset2, String oracleHomePath) {
        StringBuffer filePath1 = new StringBuffer(oracleHomePath);
        StringBuffer filePath2 = new StringBuffer(oracleHomePath);
        filePath1.append(File.separator).append(offset1);
        filePath2.append(File.separator).append(offset2);
        try {
            Path f1 = WrapperFactory.getNioServiceWrapper().getPath(filePath1.toString(), new String[0]);
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(filePath2.toString(), new String[0]);
            String fcPath1 = f1.toAbsolutePath().normalize().toString();
            String fcPath2 = f2.toAbsolutePath().normalize().toString();
            return fcPath1.equals(fcPath2);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
    }

    static Patch[] getExtPatch(OPatchPatch[] patches) throws OPatchException {
        Patch[] pa = new Patch[patches.length];
        for (int i = 0; i < patches.length; ++i) {
            OPatchBug[] b = patches[i].getBugs();
            String[] overlay = patches[i].getOverLayPatchIDs();
            OPatchComponent[] c = patches[i].getComponentsAffected();
            String[] bugFixes = new String[b.length];
            for (int j = 0; j < bugFixes.length; ++j) {
                bugFixes[j] = b[j].getBugID();
            }
            Component[] comps = new Component[c.length];
            for (int j = 0; j < comps.length; ++j) {
                OPatchAction[] oa = patches[i].getActions(c[j]);
                FileInfo[] filesTouched = new FileInfo[oa.length];
                for (int k = 0; k < oa.length; ++k) {
                    filesTouched[k] = new FileInfo(oa[k].getRelativeChildPath());
                }
                comps[j] = new Component(c[j].getName(), c[j].getVersion(), filesTouched);
            }
            pa[i] = new Patch(patches[i].getPatchLanguageId(), patches[i].getPatchTripletId(), bugFixes, overlay, comps);
        }
        return pa;
    }

    static String[][] toStringsArray(OneOffEntry.NameVersionPair[] nvPairArray) {
        ArrayList vList;
        int i;
        if (nvPairArray == null || nvPairArray.length == 0) {
            return new String[0][0];
        }
        int countRows = nvPairArray.length;
        int countColumns = 1;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ArrayList> versions = new ArrayList<ArrayList>();
        String[][] comps = null;
        for (i = 0; i < countRows; ++i) {
            names.add(nvPairArray[i].getName());
            vList = nvPairArray[i].getVersions();
            versions.add(vList == null ? new ArrayList() : vList);
            countColumns = Math.max(countColumns, vList.size());
        }
        comps = new String[countRows][countColumns];
        for (i = 0; i < countRows; ++i) {
            comps[i][0] = (String)names.get(i);
            vList = (ArrayList)versions.get(i);
            for (int j = 1; j < countColumns; ++j) {
                try {
                    comps[i][j] = (String)vList.get(j - 1);
                    continue;
                }
                catch (Exception e) {
                    comps[i][j] = "";
                }
            }
        }
        return comps;
    }

    static String[][] toStringsArray(PatchInventory.NameVersionPair[] nvPairArray) {
        ArrayList vList;
        int i;
        if (nvPairArray == null || nvPairArray.length == 0) {
            return new String[0][0];
        }
        int countRows = nvPairArray.length;
        int countColumns = 1;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ArrayList> versions = new ArrayList<ArrayList>();
        String[][] comps = null;
        for (i = 0; i < countRows; ++i) {
            names.add(nvPairArray[i].getName());
            vList = nvPairArray[i].getVersions();
            versions.add(vList == null ? new ArrayList() : vList);
            countColumns = Math.max(countColumns, vList.size());
        }
        comps = new String[countRows][countColumns];
        for (i = 0; i < countRows; ++i) {
            comps[i][0] = (String)names.get(i);
            vList = (ArrayList)versions.get(i);
            for (int j = 1; j < countColumns; ++j) {
                try {
                    comps[i][j] = (String)vList.get(j - 1);
                    continue;
                }
                catch (Exception e) {
                    comps[i][j] = "";
                }
            }
        }
        return comps;
    }

    protected static boolean isApplied(OPatchPatch patch, String oracleHomePath) {
        boolean applied = false;
        try {
            if (PrereqAPI.getInstalledOneOff((String)oracleHomePath, (String)patch.getPatchLanguageId()) != null) {
                applied = true;
            }
            if (PrereqAPI.getInactiveOneOff((String)oracleHomePath, (String)patch.getPatchLanguageId()) != null) {
                applied = true;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("OPatch was not able to get information on installed patch in Oracle Home. " + t.getMessage(), t);
        }
        return applied;
    }

    protected static boolean isFileCopied(OPatchPatch patch, OPatchDeployAction artifact, String oh) throws Exception {
        OPatchAction[] oa = patch.getActions();
        ArrayList<String> copyPaths = new ArrayList<String>();
        for (int i = 0; i < oa.length; ++i) {
            if (!(oa[i] instanceof OPatchCopyAction)) continue;
            OPatchCopyAction oca = (OPatchCopyAction)oa[i];
            copyPaths.add(oca.getCompleteFilePath(oh));
        }
        String deployCompletePath = artifact.getCompleteDeployFilePath();
        return FMWClientFactory.isPresent((String)deployCompletePath, copyPaths);
    }

    protected static void lockHome(String oracleHomePath) throws OPatchException {
        try {
            OPatchSDK.lockHome((String)oracleHomePath);
        }
        catch (Throwable t) {
            OPatchException re = new OPatchException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    protected static String initLogFile(String oracleHomePath) throws OPatchException {
        String logFile = "";
        try {
            logFile = OPatchSDK.initLogFile((String)oracleHomePath);
        }
        catch (Throwable t) {
            OPatchException re = new OPatchException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return logFile;
    }

    protected static String initLogFile(String oracleHomePath, String timestampID, String keyword, boolean printLogFile, boolean plainFileFormat) throws OPatchException {
        String logFile = "";
        try {
            logFile = OPatchSDK.initLogFile((String)oracleHomePath, (String)timestampID, (String)keyword, (boolean)printLogFile, (boolean)plainFileFormat);
        }
        catch (Throwable t) {
            OPatchException re = new OPatchException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return logFile;
    }

    protected static String initLogFile(String oracleHomePath, String timestampID, String keyword, boolean printLogFile) throws OPatchException {
        String logFile = "";
        try {
            logFile = OPatchSDK.initLogFile((String)oracleHomePath, (String)timestampID, (String)keyword, (boolean)printLogFile);
        }
        catch (Throwable t) {
            OPatchException re = new OPatchException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        return logFile;
    }

    protected static void unlockHome(String oracleHomePath) throws OPatchException {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (readServices.isLocked()) {
            try {
                readServices.release();
            }
            catch (Throwable t) {
                OPatchException oe = new OPatchException(t.getMessage());
                oe.setStackTrace(t.getStackTrace());
                throw oe;
            }
        }
    }

    protected static void closeLogFile() {
        OPatchSDK.closeLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void logExecutionContext(String oracleHomePath, FAExecutionContext context, String tmpDir, OPatchFAAutomationAction action) {
        try {
            if (context == null) {
                return;
            }
            if (action.getFailedPrereqStep() != null) {
                return;
            }
            OPatchPatch patch = context.getPatch();
            String timestampID = "";
            timestampID = patch == null ? tmpDir : patch.getLogTimeStamp();
            String execLogFile = action.getExecLogFile();
            Path fExec = WrapperFactory.getNioServiceWrapper().getPath(execLogFile, new String[0]);
            if (execLogFile == null || execLogFile.equals("")) {
                String logFile = OPatchUtils.initLogFile(oracleHomePath, timestampID, "ExecutionContext", false, true);
                action.setExecLogFile(logFile);
            } else if (!Files.exists(fExec, new LinkOption[0])) {
                OLogger.initJavaLogger((String)oracleHomePath, (String)execLogFile, (String)"OFF", (String)"INFO", (boolean)true);
                action.setExecLogFile(execLogFile);
            } else {
                OLogger.reInitJavaLogger((String)execLogFile, (String)"OFF", (String)"INFO", (boolean)true);
            }
            OPatchExecutedArtifact artAction = context.getLastExecutedArtifact(action);
            if (artAction == null) {
                return;
            }
            OLogger.justlog((int)OLogger.INFO, (String)("\n" + artAction.toString()));
        }
        catch (Throwable throwable) {
        }
        finally {
            OPatchUtils.closeLogFile();
        }
    }

    protected static String[] getRevisionToUndeploy(OPatchFAConfigContext configContext, OPatchSOADeployAction action, WLDomain domain) {
        if (action == null) {
            OLogger.justlog((int)OLogger.INFO, (String)"The input SOA Deploy action is null.");
            return null;
        }
        String compositeName = action.getSOACompositeName();
        String compositeRevision = action.getSOACompositeRevision();
        if (configContext == null) {
            OLogger.justlog((int)OLogger.INFO, (String)"The configuration context that is to be searched for undeploy revision is null.");
            return null;
        }
        if ((compositeName = OPatchUtils.norm(compositeName)).equals("")) {
            OLogger.justlog((int)OLogger.INFO, (String)"Composite name given to find revision for deploy is empty.");
            return null;
        }
        if (domain == null) {
            OLogger.justlog((int)OLogger.INFO, (String)("Domain object <WLDomain> given for computing revision to undeploy for \"" + compositeName + "\" is null."));
            return null;
        }
        OPatchConfigWLDomain[] domainArr = configContext.getWLDomains();
        if (domainArr == null || domainArr.length == 0) {
            OLogger.justlog((int)OLogger.INFO, (String)"There are no domains registered in the configuration context.");
        }
        WLAdminServer inAdminServer = domain.getWLAdminServer();
        String inAdminURL = inAdminServer.getURL();
        int inAdminPort = inAdminServer.getPort();
        ArrayList soaCompWrappers = new ArrayList(2);
        for (int i = 0; i < domainArr.length; ++i) {
            OPatchConfigWLDomain presentDomain = domainArr[i];
            if (presentDomain.getWLDomain() != domain) continue;
            ArrayList<OPatchConfigWLDomain.SOACompositeWrapper> listCompWrappers = presentDomain.getSOACompositeWrappers();
            for (OPatchConfigWLDomain.SOACompositeWrapper compWrapper : listCompWrappers) {
                if (!compWrapper.getCompositeName().equals(compositeName)) continue;
                ArrayList<OPatchConfigWLDomain.SOACompositeRevisionHistory> history = compWrapper.getRevisionHistory();
                if (history.size() == 0) {
                    return null;
                }
                OPatchConfigWLDomain.SOACompositeRevisionHistory rh = history.get(history.size() - 1);
                if (!rh.getCurrentRevision().equals(compositeRevision)) continue;
                return new String[]{rh.getPreviousRevision(), rh.getCurrentRevision()};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void logConfigContext(String oracleHomePath, OPatchFAConfigContext context, String tmpDir, OPatchFAAutomationAction action) {
        try {
            if (context == null) {
                return;
            }
            OPatchPatch patch = action.getWrapperPatch();
            String timestampID = "";
            timestampID = patch == null ? tmpDir : patch.getLogTimeStamp();
            String configLogFile = action.getConfigLogFile();
            Path fConfig = WrapperFactory.getNioServiceWrapper().getPath(configLogFile, new String[0]);
            if (configLogFile == null || configLogFile.equals("")) {
                String logFile = OPatchUtils.initLogFile(oracleHomePath, timestampID, "ConfigContext", false, true);
                action.setConfigLogFile(logFile);
            } else if (!Files.exists(fConfig, new LinkOption[0])) {
                OLogger.initJavaLogger((String)oracleHomePath, (String)configLogFile, (String)"OFF", (String)"INFO", (boolean)true);
                action.setConfigLogFile(configLogFile);
            } else {
                OLogger.reInitJavaLogger((String)configLogFile, (String)"OFF", (String)"INFO", (boolean)true);
            }
            OLogger.justlog((int)OLogger.INFO, (String)context.toString());
        }
        catch (Throwable throwable) {
        }
        finally {
            OPatchUtils.closeLogFile();
        }
    }

    protected static OPatchStepOperation constructFailedStep(OPatchFAStep stepObj, String stepMsg, String errorMsg, RuntimeException excep) {
        OPatchStepOperation step = new OPatchStepOperation(stepObj);
        step.setStepMessage(stepMsg);
        step.setUserErrorMsg(errorMsg);
        step.setStatus(false);
        step.setExceptionTrace(excep);
        step.setErrorCode(OPatchFAStepErrorCode.getErrorCode((OPatchFAStep)stepObj));
        return step;
    }

    protected static void updatePrereq(FMWClient client, OPatchFAAutomationAction faAction) {
        OPatchStepAdapter clientPrereq;
        if (client != null && (clientPrereq = client.getFailedPrereqStep()) != null) {
            OPatchStepOperation failedStep = new OPatchStepOperation(clientPrereq.getStep());
            failedStep.setStepMessage(clientPrereq.getStepDescription());
            failedStep.setUserErrorMsg(clientPrereq.getErrorMessage());
            failedStep.setStatus(clientPrereq.isSuccess());
            failedStep.setExceptionTrace(clientPrereq.getExceptionObject());
            failedStep.setErrorCode(clientPrereq.getOPatchStepErrorCode());
            faAction.setFailedPrereqStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
    }

    protected static void updateConfig(WLDomain domain, String soaCompName, String prevRevision, String curRevision, String revToDelete, boolean failure, String host, int port) {
        if (domain == null) {
            return;
        }
        OPatchFAConfigContext context = OPatchFATarget.getConfigContext();
        if (context == null) {
            return;
        }
        ArrayList<OPatchConfigWLDomain> domains = context.getConfigWLDomains();
        for (int i = 0; i < domains.size(); ++i) {
            OPatchConfigWLDomain configDomain = domains.get(i);
            WLDomain storedDomain = configDomain.getWLDomain();
            if (domain != storedDomain) continue;
            configDomain.removeSOACompositeRevision(soaCompName, prevRevision, curRevision, revToDelete, failure, host, port);
        }
    }

    protected static void updateConfig(WLDomain domain, String soaCompName, String revBeforeDeploy, String revAfterDeploy, boolean failure, String host, int port) {
        if (domain == null) {
            return;
        }
        OPatchFAConfigContext context = OPatchFATarget.getConfigContext();
        if (context == null) {
            return;
        }
        ArrayList<OPatchConfigWLDomain> domains = context.getConfigWLDomains();
        for (int i = 0; i < domains.size(); ++i) {
            OPatchConfigWLDomain configDomain = domains.get(i);
            WLDomain storedDomain = configDomain.getWLDomain();
            if (domain != storedDomain) continue;
            configDomain.addSOAComposite(soaCompName, revBeforeDeploy, revAfterDeploy, failure, host, port);
        }
    }

    protected static void updateConfig(WLDomain domain, String rbJar, boolean failure, String host, int port) {
        if (domain == null) {
            return;
        }
        OPatchFAConfigContext context = OPatchFATarget.getConfigContext();
        if (context == null) {
            return;
        }
        ArrayList<OPatchConfigWLDomain> domains = context.getConfigWLDomains();
        SOAResourceBundle soaRB = new SOAResourceBundle();
        for (int i = 0; i < domains.size(); ++i) {
            OPatchConfigWLDomain configDomain = domains.get(i);
            WLDomain storedDomain = configDomain.getWLDomain();
            if (domain != storedDomain) continue;
            configDomain.addSOAResourceBundle(rbJar, failure, host, port);
        }
    }

    protected static void updateConfig(WLDomain domain, WLServer server, boolean isStart, boolean failure) {
        if (server == null) {
            return;
        }
        OPatchFAConfigContext context = OPatchFATarget.getConfigContext();
        if (context == null) {
            return;
        }
        ArrayList<OPatchConfigWLDomain> domains = context.getConfigWLDomains();
        for (int i = 0; i < domains.size(); ++i) {
            OPatchConfigWLDomain configDomain = domains.get(i);
            WLDomain storedDomain = configDomain.getWLDomain();
            if (domain != storedDomain) continue;
            configDomain.addManagedServer(server, isStart, failure);
        }
    }

    protected static void updateExecutionContext(FMWClient client, OPatchFAAutomationAction faAction, OPatchFAOperation operation) {
        try {
            OPatchStepOperation preStep;
            OPatchStepAdapter clientPrereq;
            if (client != null && (clientPrereq = client.getFailedPrereqStep()) != null) {
                OPatchStepOperation failedStep = new OPatchStepOperation(clientPrereq.getStep());
                failedStep.setStepMessage(clientPrereq.getStepDescription());
                failedStep.setUserErrorMsg(clientPrereq.getErrorMessage());
                failedStep.setStatus(clientPrereq.isSuccess());
                failedStep.setExceptionTrace(clientPrereq.getExceptionObject());
                failedStep.setErrorCode(clientPrereq.getOPatchStepErrorCode());
                faAction.setFailedPrereqStep(failedStep);
            }
            if ((preStep = faAction.getFailedPrereqStep()) != null) {
                return;
            }
            List recoverySteps = null;
            List allSteps = client.getAllExecutedSteps();
            recoverySteps = client.getRecoverySteps();
            OPatchStepAdapter failedPrereqStep = client.getFailedPrereqStep();
            OPatchExecutedArtifact artifact = new OPatchExecutedArtifact();
            artifact.setArtifactAction(faAction);
            artifact.setFAOperation(operation);
            artifact.setTime();
            artifact.setOperatedLogFile(faAction.getLastOperatedLogFile());
            ArrayList<OPatchExecutionStep> listOfSteps = new ArrayList<OPatchExecutionStep>();
            if (allSteps != null && allSteps.size() != 0) {
                for (int i = 0; i < allSteps.size(); ++i) {
                    OPatchExecutionStep es = new OPatchExecutionStep();
                    OPatchStepAdapter s = (OPatchStepAdapter)allSteps.get(i);
                    OPatchStepOperation so = new OPatchStepOperation(s.getStep());
                    so.setStepMessage(s.getStepDescription());
                    so.setUserErrorMsg(s.getErrorMessage());
                    so.setStatus(s.isSuccess());
                    so.setExceptionTrace(s.getExceptionObject());
                    so.setErrorCode(s.getOPatchStepErrorCode());
                    es.setExecutionStep(so);
                    listOfSteps.add(es);
                    if (s.isSuccess()) continue;
                    faAction.setOK(false);
                    es.setOperationSuccess(false);
                    if (recoverySteps == null || recoverySteps.size() == 0) break;
                    for (int j = 0; j < recoverySteps.size(); ++j) {
                        OPatchStepAdapter s1 = (OPatchStepAdapter)recoverySteps.get(j);
                        OPatchStepOperation sr = new OPatchStepOperation(s1.getStep());
                        sr.setStepMessage(s1.getStepDescription());
                        sr.setUserErrorMsg(s1.getErrorMessage());
                        sr.setStatus(s1.isSuccess());
                        sr.setExceptionTrace(s1.getExceptionObject());
                        sr.setErrorCode(s1.getOPatchStepErrorCode());
                        es.addRecoveryStep(sr);
                        if (s1.isSuccess()) continue;
                        es.setRecoverySuccess(false);
                    }
                    break;
                }
                artifact.setExecutionSteps(listOfSteps);
            }
            FAExecutionContext context = faAction.getOperatingFAContext();
            context.addArtifact(artifact);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void validateEndPointInstances(OPatchFAConfigInstance originalInstance) throws OPatchException {
        if (originalInstance == null) {
            throw new OPatchException("The original end point instance object of type <OPatchFAConfigInstance> is <null>. Please provide a non-null object.");
        }
        List<AbstractBaseTarget> endPointInstances = originalInstance.getEndPointInstances();
        if (endPointInstances == null) {
            throw new OPatchException("The end point instances obtained from <OPatchFAConfigInstance> is <null>. Please set end point instances in <OPatchFAConfigInstance> object.");
        }
        if (endPointInstances.size() == 0) {
            throw new OPatchException("There are no end point instances defined in <OPatchFAConfigInstance> object. Please define end point instances in <OPatchFAConfigInstance> object.");
        }
        ArrayList<OPatchConfigWLDomain> domains = new ArrayList<OPatchConfigWLDomain>();
        ArrayList<String> nodeManagers = new ArrayList<String>();
        ArrayList<String> servers = new ArrayList<String>();
        boolean domainDuplicate = false;
        boolean nmDuplicate = false;
        boolean serverDuplicate = false;
        for (int i = 0; i < endPointInstances.size(); ++i) {
            AbstractBaseTarget bt = endPointInstances.get(i);
            if (bt instanceof WLDomain) {
                OPatchConfigWLDomain wrap = new OPatchConfigWLDomain((WLDomain)bt);
                if (domains.contains(wrap)) {
                    domainDuplicate = true;
                }
                domains.add(wrap);
            }
            if (bt instanceof NodeManager) {
                NodeManager nm = (NodeManager)bt;
                String nmStr = OPatchUtils.norm(nm.getName());
                if (nodeManagers.contains(nmStr)) {
                    nmDuplicate = true;
                }
                nodeManagers.add(nmStr);
            }
            if (!(bt instanceof WLServer)) continue;
            WLServer s = (WLServer)bt;
            String serverStr = OPatchUtils.norm(s.getName());
            if (servers.contains(serverStr)) {
                serverDuplicate = true;
            }
            servers.add(serverStr);
        }
        if (domainDuplicate || nmDuplicate || serverDuplicate) {
            throw new OPatchException("OPatch finds that some of the end point instances (WLDomain, WLServer, NodeManager) are duplicates. Please check the instances.");
        }
    }

    protected static boolean checkFAObjectSanity(OPatchFAClonedConfigInstance faInstance, AbstractBaseTarget bt) {
        List<AbstractBaseTarget> allInstances = faInstance.getEndPointInstances();
        OPatchFAClonedConfigInstance copy = OPatchFATarget.getPrivateCopy();
        List<AbstractBaseTarget> privateInstances = copy.getEndPointInstances();
        boolean equalityFlag = false;
        for (int i = 0; i < allInstances.size(); ++i) {
            AbstractBaseTarget abt = allInstances.get(i);
            AbstractBaseTarget privateInst = privateInstances.get(i);
            if (bt != abt) continue;
            if (bt instanceof WLDomain) {
                WLDomain cloneDomain = (WLDomain)bt;
                OPatchConfigWLDomain d1 = new OPatchConfigWLDomain(cloneDomain);
                WLDomain privateDomain = (WLDomain)privateInst;
                OPatchConfigWLDomain d2 = new OPatchConfigWLDomain(privateDomain);
                if (!d1.equals(d2)) continue;
                equalityFlag = true;
                break;
            }
            if (bt instanceof NodeManager) {
                NodeManager nm1 = (NodeManager)bt;
                NodeManager nm2 = (NodeManager)privateInst;
                if (!OPatchUtils.norm(nm1.getName()).equals(OPatchUtils.norm(nm2.getName()))) continue;
                equalityFlag = true;
                break;
            }
            if (bt instanceof WLServer) {
                WLServer w1 = (WLServer)bt;
                WLServer w2 = (WLServer)privateInst;
                if (!OPatchUtils.norm(w1.getName()).equals(OPatchUtils.norm(w2.getName()))) continue;
                equalityFlag = true;
                break;
            }
            equalityFlag = true;
            break;
        }
        return equalityFlag;
    }

    static String norm(String s) {
        return s == null ? "" : s.trim();
    }

    public static void disableConsoleOutput() {
        if (null == originalOut) {
            originalOut = new PrintStream(System.out);
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
        }
        if (null == originalErr) {
            originalErr = new PrintStream(System.err);
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
        }
    }

    public static void enableConsoleOutput() {
        if (null != originalOut) {
            System.setOut(originalOut);
            originalOut = null;
        }
        if (null != originalErr) {
            System.setErr(originalErr);
            originalErr = null;
        }
    }

    public static boolean checkNoOpId(String[] ids, OPatchPatch patch) {
        String patchId = patch.getPatchId();
        for (String id : ids) {
            if (!id.equals(patchId)) continue;
            return true;
        }
        return false;
    }
}

