/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.SQLPatchStartupMode;
import oracle.opatchauto.core.binary.BundlePatchRollbackFilter;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.opatchauto.core.binary.systempatch.SystemPatchData;
import oracle.opatchauto.core.binary.systempatch.SystemPatchInformationLoader;
import oracle.opatchauto.core.binary.systempatch.SystemPatchStorageHelper;
import oracle.opatchauto.core.patchanalyzer.PatchAnalyzer;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;

public class BinaryPatchFilter {
    public PatchData getPatchInfoFromLocation(String oracleHome, String targetType, SessionPatches patches, boolean isRollback) {
        PatchData patchData = new PatchData();
        ArrayList<String> entireListOfIndividualPatches = new ArrayList<String>();
        ArrayList<String> croppedListOfIndividualPatches = new ArrayList<String>();
        ArrayList<String> skippedListOfIndividualPatches = new ArrayList<String>();
        HashMap<String, String> skippedReasonList = new HashMap<String, String>();
        List<String> patchLocationList = patches.getAllRegisteredPatches();
        if (patchLocationList.isEmpty()) {
            if (patches.getRegisteredRollbackPatchIDs().size() > 0) {
                OACLogger.info("Only patch IDs have been registered for this session");
            } else {
                OACLogger.severe("INVALID : No patches have been registered for this session");
                return patchData;
            }
        }
        for (String patchLocation : patchLocationList) {
            SessionPatches.PatchType patch_type = SessionPatches.getPatchType(patchLocation);
            if (SessionPatches.PatchType.SYSTEM_PATCH == patch_type) {
                Object info32;
                OACLogger.info("This patch is detected to be a System Patch: " + patchLocation);
                PatchAnalyzer analyzer = new PatchAnalyzer();
                SystemPatchBundleXML sysPatchModel = analyzer.analyzePatch(patchLocation);
                String systempatchID = sysPatchModel.getPatchID();
                List<PatchAnalyzer.SubPatchInfo> allSubPatches = analyzer.getSubPatchesInfoFromModel(sysPatchModel, null);
                for (PatchAnalyzer.SubPatchInfo subPatchInfo : allSubPatches) {
                    entireListOfIndividualPatches.add(subPatchInfo.getPatchLocation());
                }
                ArrayList<PatchAnalyzer.SubPatchInfo> chosenSubPatches = new ArrayList<PatchAnalyzer.SubPatchInfo>();
                if (targetType == null) {
                    chosenSubPatches.addAll(allSubPatches);
                } else {
                    chosenSubPatches.addAll(analyzer.getSubPatchesInfoFromModel(sysPatchModel, targetType));
                }
                for (Object info32 : allSubPatches) {
                    String reason;
                    String subPatchLoc = ((PatchAnalyzer.SubPatchInfo)info32).getPatchLocation();
                    if (!chosenSubPatches.contains(info32)) {
                        reason = this.getReason(oracleHome, targetType);
                        skippedReasonList.put(subPatchLoc, reason);
                        skippedListOfIndividualPatches.add(subPatchLoc);
                        continue;
                    }
                    if (isRollback) {
                        if (this.isPatchAppliedWithBundlePatch(oracleHome, systempatchID, ((PatchAnalyzer.SubPatchInfo)info32).getPatchID())) {
                            croppedListOfIndividualPatches.add(subPatchLoc);
                            continue;
                        }
                        reason = "Patch " + subPatchLoc + " is not applied as part of bundle patch " + systempatchID;
                        skippedReasonList.put(subPatchLoc, reason);
                        skippedListOfIndividualPatches.add(subPatchLoc);
                        continue;
                    }
                    croppedListOfIndividualPatches.add(subPatchLoc);
                }
                if (sysPatchModel == null) continue;
                SystemPatchData systemPatchData = new SystemPatchData();
                info32 = allSubPatches.iterator();
                while (info32.hasNext()) {
                    PatchAnalyzer.SubPatchInfo subPatch = (PatchAnalyzer.SubPatchInfo)info32.next();
                    if (!croppedListOfIndividualPatches.contains(subPatch.getPatchLocation())) continue;
                    systemPatchData.addApplicableSubPatchID(subPatch.getPatchID());
                }
                systemPatchData.setBundlePatchID(systempatchID);
                SystemPatchInformationLoader instance = SystemPatchInformationLoader.getInstance();
                if (isRollback) {
                    String bundle_locn = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome);
                    bundle_locn = bundle_locn + File.separator + systempatchID;
                    systemPatchData.setBundleXMLLocation(bundle_locn);
                    instance.setSystempatchInfoToBeRolledBack(systemPatchData);
                    continue;
                }
                systemPatchData.setBundleXMLLocation(patchLocation);
                instance.setSystemPatchInfoToBeApplied(systemPatchData);
                continue;
            }
            if (SessionPatches.PatchType.ONE_OFF != patch_type && SessionPatches.PatchType.COMPOSITE != patch_type) continue;
            if (this.isValidPatchForTarget(patchLocation, targetType)) {
                croppedListOfIndividualPatches.add(patchLocation);
            } else {
                skippedListOfIndividualPatches.add(patchLocation);
                skippedReasonList.put(patchLocation, "The Database Startup Mode of SQL Patch is not normal.");
            }
            entireListOfIndividualPatches.add(patchLocation);
        }
        patchData.setCompleteListOfPatches(entireListOfIndividualPatches);
        patchData.setCroppedListOfPatches(croppedListOfIndividualPatches);
        patchData.setSkippedListOfPatches(skippedListOfIndividualPatches);
        patchData.setSkippedReason(skippedReasonList);
        return patchData;
    }

    private String getReason(String oracleHome, String targetType) {
        String reason = null;
        reason = targetType == null ? "This patch is not applicable to the oracle home - \"" + oracleHome + "\"" : "This patch is not applicable to this specified target type - \"" + targetType + "\"";
        return reason;
    }

    private boolean isPatchAppliedWithBundlePatch(String oracleHome, String bundlePatchID, String patchID) {
        boolean isApplied = false;
        List<String> patchIDList = SystemPatchInformationLoader.getInstance().getAppliedSubpatchIDList(oracleHome, bundlePatchID);
        isApplied = patchIDList == null || patchIDList.isEmpty() ? true : patchIDList.contains(patchID);
        return isApplied;
    }

    private boolean isValidPatchForTarget(String patch_Loc, String targetType) {
        boolean isValid = true;
        if (targetType != null && (targetType.equals("cluster") || targetType.equals("has"))) {
            OPatchPatch[] patches = OPatchAutoBinaryUtil.getOpatchPatch(patch_Loc);
            if (patches == null) {
                return false;
            }
            for (OPatchPatch patch : patches) {
                try {
                    SQLPatchStartupMode mode = patch.getSqlPatchDatabaseStartupMode();
                    isValid = mode == SQLPatchStartupMode.NORMAL;
                }
                catch (OPatchException e) {
                    OACLogger.info("The Database Startup Mode of SQL Patch must be \"upgrade\" or \"normal\"");
                }
                if (isValid) continue;
                OACLogger.info("The Database Startup Mode of SQL Patch is not normal for Patch id " + patch.getPatchId());
                break;
            }
        }
        return isValid;
    }

    public PatchData getPatchInfoFromID(String oracleHome, String targetType, List<String> registeredRollBackIDList) {
        ArrayList<String> patchIdList = this.getRollbackPatchIDList(oracleHome, targetType, registeredRollBackIDList);
        PatchData patchData = this.filterRollBackIDList(oracleHome, targetType, patchIdList);
        return patchData;
    }

    private PatchData filterRollBackIDList(String oracleHome, String targetType, List<String> patchIdList) {
        PatchData patchData = new PatchData();
        patchData.setCompleteListOfPatches(patchIdList);
        ArrayList<String> validPatchIdList = new ArrayList<String>();
        ArrayList<String> skippedPatchIDList = new ArrayList<String>();
        HashMap<String, String> skippedReasonList = new HashMap<String, String>();
        if (!patchIdList.isEmpty()) {
            List<BundlePatchRollbackFilter.FilterResult> filterResultList = new BundlePatchRollbackFilter().filter(patchIdList, oracleHome, targetType);
            SystemPatchInformationLoader systemPatchInfoLoader = SystemPatchInformationLoader.getInstance();
            for (BundlePatchRollbackFilter.FilterResult filterResult : filterResultList) {
                String patchId = filterResult.getPatchId();
                if (filterResult.isPassed()) {
                    validPatchIdList.add(patchId);
                    String bundlePatchId = filterResult.getBundlePatchId();
                    if (bundlePatchId == null) continue;
                    String bundleLocn = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome);
                    bundleLocn = bundleLocn + File.separator + bundlePatchId;
                    SystemPatchData systempatchData = this.getSystempatchData(bundlePatchId);
                    if (systempatchData == null) {
                        systempatchData = new SystemPatchData();
                        systempatchData.setBundlePatchID(bundlePatchId);
                        systempatchData.setBundleXMLLocation(bundleLocn);
                        systempatchData.addApplicableSubPatchID(patchId);
                        systemPatchInfoLoader.setSystempatchInfoToBeRolledBack(systempatchData);
                        continue;
                    }
                    systempatchData.addApplicableSubPatchID(patchId);
                    continue;
                }
                skippedPatchIDList.add(patchId);
                skippedReasonList.put(patchId, filterResult.getFailureReason());
            }
        }
        patchData.setSkippedListOfPatches(skippedPatchIDList);
        patchData.setSkippedReason(skippedReasonList);
        patchData.setCroppedListOfPatches(validPatchIdList);
        return patchData;
    }

    private SystemPatchData getSystempatchData(String systemPatchID) {
        SystemPatchData systempatchdata = null;
        List<SystemPatchData> systemPatchDataList = SystemPatchInformationLoader.getInstance().getSystempatchInfoToBeRolledBack();
        for (SystemPatchData data : systemPatchDataList) {
            if (!data.getBundlePatchID().equals(systemPatchID)) continue;
            systempatchdata = data;
            break;
        }
        return systempatchdata;
    }

    private ArrayList<String> getRollbackPatchIDList(String oracleHome, String targetType, List<String> rollbackPatchIDList) {
        ArrayList<String> validList = new ArrayList<String>();
        for (String patchID : rollbackPatchIDList) {
            String bundleLocn = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome);
            File bundleXml = new File(bundleLocn = bundleLocn + File.separator + patchID, "bundle.xml");
            if (bundleXml.exists()) {
                Map<Object, Object> bundleEntries = new HashMap();
                ArrayList<String> targetTypeList = new ArrayList<String>();
                if (null != targetType) {
                    targetTypeList.add(targetType);
                }
                PatchAnalyzer analyzer = new PatchAnalyzer();
                try {
                    bundleEntries = analyzer.getPatchIDSFromBundleXML(bundleLocn, targetTypeList);
                    SystemPatchData systempatchData = new SystemPatchData();
                    if (bundleEntries.size() <= 0) continue;
                    systempatchData.setBundlePatchID(patchID);
                    systempatchData.setBundleXMLLocation(bundleLocn);
                    for (String string : bundleEntries.keySet()) {
                        List list = (List)bundleEntries.get(string);
                        validList.addAll(list);
                        systempatchData.addApplicableSubPatchIDList(list);
                    }
                    SystemPatchInformationLoader.getInstance().setSystempatchInfoToBeRolledBack(systempatchData);
                }
                catch (Exception exception) {}
                continue;
            }
            validList.add(patchID);
        }
        OACLogger.info("Rollback patch ID List:" + validList);
        return validList;
    }

    public class PatchData {
        List<String> entireListOfIndividualPatches = new ArrayList<String>();
        List<String> croppedListOfIndividualPatches = new ArrayList<String>();
        List<String> skippedListOfIndividualPatches = new ArrayList<String>();
        Map<String, String> skippedReason = new HashMap<String, String>();

        public List<String> getCompleteListOfPatches() {
            return this.entireListOfIndividualPatches;
        }

        public void setCompleteListOfPatches(List<String> entireListOfIndividualPatches) {
            this.entireListOfIndividualPatches.addAll(entireListOfIndividualPatches);
        }

        public List<String> getCroppedListOfPatches() {
            return this.croppedListOfIndividualPatches;
        }

        public void setCroppedListOfPatches(List<String> croppedListOfIndividualPatches) {
            this.croppedListOfIndividualPatches.addAll(croppedListOfIndividualPatches);
        }

        public List<String> getSkippedListOfPatches() {
            return this.skippedListOfIndividualPatches;
        }

        public void setSkippedListOfPatches(List<String> skippedListOfIndividualPatches) {
            this.skippedListOfIndividualPatches.addAll(skippedListOfIndividualPatches);
        }

        public Map<String, String> getSkippedReason() {
            return this.skippedReason;
        }

        public void setSkippedReason(Map<String, String> skippedReason) {
            this.skippedReason.putAll(skippedReason);
        }
    }
}

