/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import com.oracle.cie.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdk.ResultObject;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.patchanalyzer.PatchAnalyzer;
import oracle.opatchauto.core.patchanalyzer.PatchingConstants;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;

public class OPatchAutoBinaryUtil {
    public static boolean isOneOff(String patch_locn) {
        boolean value = false;
        try {
            OPatchPatch[] patches = OPatchPatch.getPatchesNoSymbolResolve((String)patch_locn);
            return patches.length == 1;
        }
        catch (OPatchException e) {
            OACLogger.info("This is not a OneOff patch: \"" + patch_locn + "\"");
            OACLogger.printStackTrace(e);
            value = false;
        }
        catch (Throwable t) {
            OACLogger.info("This is not a OneOff patch: \"" + patch_locn + "\"");
            OACLogger.printStackTrace(t);
            value = false;
        }
        return value;
    }

    public static boolean isComposite(String patch_locn) {
        boolean value = false;
        try {
            OPatchPatch[] patches;
            for (OPatchPatch subPatch : patches = OPatchPatch.getPatchesNoSymbolResolve((String)patch_locn)) {
                if (!subPatch.isComposite()) continue;
                OACLogger.info("Detected a composite Patch inside the patch at: " + subPatch.getPatchLocation() + "\nSubpatches : " + subPatch.getSubPatchIds());
                return true;
            }
        }
        catch (OPatchException ex) {
            OACLogger.info("This is not a Composite patch: \"" + patch_locn + "\"");
            OACLogger.printStackTrace(ex);
            value = false;
        }
        catch (Throwable t) {
            OACLogger.info("Hit an Error with this patch: \"" + patch_locn + "\"");
            OACLogger.printStackTrace(t);
            value = false;
        }
        return value;
    }

    public static OPatchPatch[] getOpatchPatch(String patchLocation) {
        OPatchPatch[] patches = null;
        try {
            patches = OPatchPatch.getPatchesNoSymbolResolve((String)patchLocation);
        }
        catch (OPatchException e) {
            OACLogger.info("This is not a valid patch: \"" + patchLocation + "\"");
            OACLogger.printStackTrace(e);
        }
        catch (Throwable t) {
            OACLogger.info("Hit an Error with this patch: \"" + patchLocation + "\"");
            OACLogger.printStackTrace(t);
        }
        return patches;
    }

    public static boolean isSystemPatch(String patch_locn) {
        boolean value = false;
        try {
            File patch_directory = new File(patch_locn);
            File bundle = new File(patch_directory, "bundle.xml");
            if (bundle.exists()) {
                if (OPatchAutoBinaryUtil.getSubPatchesInSystemPatch(patch_locn).size() > 0) {
                    value = true;
                } else {
                    OACLogger.info("No sub-patches found here, it is not a valid SystemPatch: \"" + patch_locn + "\"");
                    value = false;
                }
            } else {
                OACLogger.info("This is not a SystemPatch: \"" + patch_locn + "\"");
                value = false;
            }
        }
        catch (Exception e) {
            OACLogger.info("Unable to study this patch location \"" + patch_locn + "\". This directory will be ignored:");
            OACLogger.printStackTrace(e);
            value = false;
        }
        return value;
    }

    public static List<String> getSubPatchesInSystemPatch(String patchLocation) {
        ArrayList<String> patchLocationList = new ArrayList<String>();
        PatchAnalyzer patchAnalyzer = new PatchAnalyzer();
        SystemPatchBundleXML systemPatchDetails = patchAnalyzer.analyzePatch(patchLocation);
        List<PatchAnalyzer.SubPatchInfo> patchDataList = patchAnalyzer.getSubPatchesInfoFromModel(systemPatchDetails, null);
        for (PatchAnalyzer.SubPatchInfo data : patchDataList) {
            patchLocationList.add(data.getPatchLocation());
        }
        return patchLocationList;
    }

    protected static boolean checkValidLocn(String location) {
        File dirLoc = new File(location);
        return dirLoc.exists() && dirLoc.isDirectory();
    }

    protected static String getCustomLogDirForCore(String oh) {
        String customDir = !StringUtil.isNullOrEmpty((String)OACLogger.logDir) ? OACLogger.logDir + File.separator + "core" : oh + File.separator + "cfgtoollogs" + File.separator + "opatchauto" + File.separator + "core";
        File customDirFile = new File(customDir);
        if (customDirFile.exists() || customDirFile.mkdirs()) {
            return customDir;
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static String getOPatchAutoVersion() {
        return "13.9.5.0.0";
    }

    public static void printOutFile(String helpFileName) {
        StringBuffer helpM = new StringBuffer("\n");
        try {
            String thisLine;
            InputStream is = new OPatchAutoBinaryUtil().getClass().getResourceAsStream(helpFileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("/")) continue;
                helpM.append(thisLine);
                helpM.append("\n");
            }
            System.out.println(helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e) {
            OACLogger.console("File not found : " + helpFileName);
        }
    }

    public static PatchResult buildSuccessfulPR(String patch) {
        return OPatchAutoBinaryUtil.buildSuccessfulPR(patch, "", "");
    }

    public static PatchResult buildSuccessfulPR(String patch, String log) {
        return OPatchAutoBinaryUtil.buildSuccessfulPR(patch, "", log);
    }

    public static PatchResult buildSuccessfulPRwithID(String patch_id, String log) {
        return OPatchAutoBinaryUtil.buildSuccessfulPR("", patch_id, log);
    }

    public static PatchResult buildSuccessfulPR(String patch_locn, String patch_id, String log) {
        PatchResult pr = new PatchResult(patch_locn, patch_id);
        pr.setLogLocn(log);
        pr.setResultAsSuc();
        return pr;
    }

    public static PatchResult buildFailedPR(String patch, String reason) {
        return OPatchAutoBinaryUtil.buildFailedPR(patch, "", reason, "");
    }

    public static PatchResult buildFailedPR(String patch, String msg, Exception e, String log) {
        return OPatchAutoBinaryUtil.buildFailedPR(patch, "", msg + e.toString(), log);
    }

    public static PatchResult buildFailedPRwithID(String patch_id, String msg, Exception e, String log) {
        return OPatchAutoBinaryUtil.buildFailedPR("", patch_id, msg + e.toString(), log);
    }

    public static PatchResult buildFailedPR(String patch, String patch_id, String msg, Exception e, String log) {
        return OPatchAutoBinaryUtil.buildFailedPR(patch, patch_id, msg + e.toString(), log);
    }

    public static PatchResult buildFailedPR(String patch, String patch_id, String reason, String log) {
        PatchResult pr = new PatchResult(patch, patch_id);
        if (reason.length() > 500) {
            String short_reason = reason.substring(0, 500);
            short_reason = short_reason + " ...";
            pr.setReason(short_reason);
        } else {
            pr.setReason(reason);
        }
        pr.setLogLocn(log);
        pr.setResultAsFail();
        return pr;
    }

    public static PatchResult buildSkippedPR(String patch) {
        String reason = "";
        return OPatchAutoBinaryUtil.buildSkippedPR(patch, reason);
    }

    public static PatchResult buildSkippedPR(String patch, String reason) {
        PatchResult pr = new PatchResult(patch);
        pr.setReason(reason);
        pr.setResultAsSkip();
        return pr;
    }

    public static PatchResult buildSkippedPRwithID(String id, String reason) {
        PatchResult pr = new PatchResult("", id);
        pr.setReason(reason);
        pr.setResultAsSkip();
        return pr;
    }

    public static PatchResult buildSkippedPR(String patch, String reason, String log) {
        return OPatchAutoBinaryUtil.buildSkippedPR(patch, "", reason, log);
    }

    protected static PatchResult buildSkippedPRwithID(String id, String reason, String log) {
        return OPatchAutoBinaryUtil.buildSkippedPR("", id, reason, log);
    }

    protected static PatchResult buildSkippedPR(String patch, String id, String reason, String log) {
        PatchResult pr = new PatchResult(patch, id);
        pr.setReason(reason);
        pr.setLogLocn(log);
        pr.setResultAsSkip();
        return pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File destination) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            if (!destination.exists()) {
                destination.createNewFile();
            }
            is = new FileInputStream(source);
            os = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            int size = 0;
            while ((size = is.read(buffer)) > 0) {
                os.write(buffer, 0, size);
                os.flush();
            }
        }
        catch (Exception e) {
            OACLogger.printStackTrace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
                os.close();
                String lsCmd = "ls -al " + destination.getAbsolutePath();
                OPatchAutoBinaryUtil.executeCmd(lsCmd);
                String chmodCmd = "chmod 640 " + destination.getAbsolutePath();
                OPatchAutoBinaryUtil.executeCmd(chmodCmd);
            }
            catch (Exception e) {
                OACLogger.console("Exception occured while trying to close the input or output streams");
                OACLogger.printStackTrace(e);
            }
        }
        return true;
    }

    public static int executeCmd(String cmd) {
        int exitCode = 0;
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("bash");
        cmds.add("-c");
        cmds.add(cmd);
        ProcessBuilder pb = new ProcessBuilder(cmds);
        try {
            OACLogger.info("Executing command : " + ((Object)cmds).toString());
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream);
            ReaderThread rinput = new ReaderThread(inputStream);
            rinput.start();
            rerror.start();
            exitCode = process.waitFor();
            try {
                rerror.join();
                rinput.join();
                OACLogger.info("Output: " + rinput.outputString);
                OACLogger.info("Error message: " + rerror.outputString);
            }
            catch (InterruptedException ie) {
                OACLogger.printStackTrace(ie);
            }
            OACLogger.info("Finished executing the command");
        }
        catch (Throwable t) {
            OACLogger.info("Hit an Exception trying to run the above command:");
            OACLogger.printStackTrace(t);
            exitCode = -1;
        }
        OACLogger.info("Exit code: " + exitCode);
        return exitCode;
    }

    public static boolean deleteFileOrDirectory(String path) {
        try {
            File file = new File(path);
            if (!file.isDirectory() || file.listFiles().length == 0) {
                file.delete();
            } else {
                File[] sub_files;
                for (File subfile : sub_files = file.listFiles()) {
                    if (!subfile.isDirectory()) {
                        subfile.delete();
                        continue;
                    }
                    if (OPatchAutoBinaryUtil.deleteFileOrDirectory(subfile.getPath())) continue;
                    return false;
                }
            }
            file.delete();
        }
        catch (Exception e) {
            OACLogger.printStackTrace(e);
            return false;
        }
        return true;
    }

    public static PatchResult deleteInactivePatches(String oracleHome, String invPtrLocation, String logDir) {
        PatchResult result = null;
        try {
            OPatchContext.destroyContextReference();
            OPatchContext context = OPatchContext.getInstance((String)oracleHome, (String)invPtrLocation);
            String customDir = "";
            customDir = logDir == null || logDir.length() == 0 ? OPatchAutoBinaryUtil.getCustomLogDirForCore(oracleHome) : logDir + File.separator + "opatchauto" + File.separator + "core";
            context.setCustomScratchWorkingdirectory(customDir);
            OPatchTarget target = new OPatchTarget(context);
            ResultObject resultObject = target.deleteInactivePatches();
            result = OPatchAutoBinaryUtil.getDeleteInactiveResult(resultObject);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static PatchResult getDeleteInactiveResult(ResultObject resultObject) {
        PatchResult pr = new PatchResult(resultObject.getReturnCode(), resultObject.getMesg(), resultObject.getLogLocation());
        return pr;
    }

    public static boolean IsSubPatchCompositePatch(String subLocation) {
        File compositePatchDir = new File(subLocation);
        if (compositePatchDir.exists()) {
            for (File subPatch : compositePatchDir.listFiles()) {
                if (!subPatch.isDirectory()) continue;
                File subPatchinvxml = new File(subPatch, PatchingConstants.INVENTORY_XML);
                File compositeXml = new File(subPatch, PatchingConstants.COMPOSITE_XML);
                if (!subPatchinvxml.isFile() || !compositeXml.isFile()) continue;
                OACLogger.info("There is a composite patch in " + subLocation);
                return true;
            }
        }
        return false;
    }

    public static String removeFileSeperatorAtEnd(String source) {
        String tmpS = source;
        tmpS = tmpS.trim();
        while (tmpS.endsWith(File.separator)) {
            tmpS = tmpS.substring(0, tmpS.length() - 1);
        }
        source = tmpS;
        return source;
    }

    public static List<String> getAllPatchIds(String patch_locn, boolean isComposite) throws OPatchException {
        ArrayList<String> patchIds = new ArrayList<String>();
        if (isComposite) {
            OPatchPatch[] patchList;
            for (OPatchPatch patch : patchList = OPatchPatch.getPatches((String)patch_locn)) {
                patchIds.add(patch.getPatchId());
            }
        } else {
            OPatchPatch patch = new OPatchPatch(patch_locn);
            patchIds.add(patch.getPatchId());
        }
        return patchIds;
    }

    public static List<OPatchPatch> getPatchListFromPatchLocnForRollback(OPatchTarget target, String patch_locn, boolean isComposite) throws OPatchException {
        List<String> patchIds = OPatchAutoBinaryUtil.getAllPatchIds(patch_locn, isComposite);
        ArrayList<OPatchPatch> allPatchesList = new ArrayList<OPatchPatch>();
        for (String id : patchIds) {
            OPatchPatch patch = target.getContext().getInstalledActivePatch(id);
            if (patch == null) continue;
            allPatchesList.add(patch);
        }
        return allPatchesList;
    }

    public static List<OPatchPatch> getPatchListFromPatchLocnForApply(OPatchTarget target, String patch_locn, boolean isComposite) throws OPatchException {
        ArrayList<OPatchPatch> allPatchesList = new ArrayList<OPatchPatch>();
        if (isComposite) {
            OPatchPatch[] patchList;
            for (OPatchPatch patch : patchList = OPatchPatch.getPatches((String)patch_locn)) {
                OPatchPatch installedPatch = target.getContext().getInstalledActivePatch(patch.getPatchId());
                if (installedPatch != null) continue;
                allPatchesList.add(patch);
            }
        } else {
            OPatchPatch patch = new OPatchPatch(patch_locn);
            allPatchesList.add(patch);
        }
        return allPatchesList;
    }

    public static OPatchPatch[] getPatchListFromHome(String oracleHome, String invPtrLocation) {
        OPatchPatch[] activePatchList = null;
        try {
            OPatchContext context = OPatchContext.getInstance((String)oracleHome, (String)invPtrLocation);
            activePatchList = context.getInstalledActivePatches();
            return activePatchList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return activePatchList;
        }
    }

    public static boolean comparePaths(String path1, String path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.equals(path2)) {
            return true;
        }
        File file1 = new File(path1);
        File file2 = new File(path2);
        try {
            return file1.getCanonicalFile().equals(file2.getCanonicalFile());
        }
        catch (Exception ex) {
            return file1.getAbsoluteFile().equals(file2.getAbsoluteFile());
        }
    }

    public static boolean isCASEnabled() {
        boolean isCAS = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS);
        OACLogger.info("Is CAS Enabled=" + isCAS);
        return isCAS;
    }

    public static ArrayList<String> getAutoRollbackPatchIDs(IAnalysisReport report) {
        ArrayList<String> patchIDs = new ArrayList<String>();
        if (report == null) {
            OACLogger.info("The provided AnalysisReport is null, cannot detect auto-rollback patches from it.\n");
            return patchIDs;
        }
        List autoRollback = report.getNRollbackPatches();
        if (autoRollback == null) {
            OACLogger.info("Auto rollback patch list is null.\n");
            return patchIDs;
        }
        OACLogger.info("Total number of auto-rollback patches is " + autoRollback.size());
        for (OPatchPatch tmp : autoRollback) {
            String patchID = tmp.getPatchId();
            OACLogger.info("ID of auto-rollbacked patch is " + patchID);
            patchIDs.add(patchID);
        }
        return patchIDs;
    }

    static class ReaderThread
    extends Thread {
        private InputStreamReader isr;
        public String outputString;

        public ReaderThread(InputStreamReader isr) {
            this.isr = isr;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(this.isr);
                StringBuffer sb = new StringBuffer();
                String line = "";
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                this.outputString = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

