/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchType;
import oracle.opatch.opatchsdk.OPatchPlatform;
import oracle.opatch.opatchsdk.SQLPatchStartupMode;

public class OPatchPatchInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String patchLocation;
    private String patchID;
    private String patchType;
    private String uniquePatchID;
    private boolean isSQLPatch;
    private String sqlPatchDatabaseStartupMode;
    private boolean isComposite;
    private boolean isRollingPatch;
    private boolean isOnLinePatch;
    private boolean isInstanceShutDownPatch;
    private String minOPatchVersion;
    private List<String> subPatchList;
    private List<String> supportedPlatForm;

    public OPatchPatchInfo(OPatchPatch patch) {
        OPatchPlatform[] platformList;
        block9: {
            this.patchLocation = patch.getPatchLocation();
            this.patchID = patch.getPatchId();
            this.uniquePatchID = patch.getUniquePatchIdentifier();
            OPatchPatchType patchType = patch.getPatchType();
            this.patchType = patchType != null ? patchType.toString() : OPatchPatchType.SINGLETON.toString();
            this.isSQLPatch = patch.isSqlPatch();
            this.isSQLPatch = this.isMethodValid(patch.getClass(), "isSqlPatch", null) ? patch.isSqlPatch() : true;
            this.isComposite = patch.isComposite();
            this.isInstanceShutDownPatch = patch.isInstanceShutdownPatch();
            this.isRollingPatch = patch.isRollingPatch();
            this.isOnLinePatch = patch.isOnlinePatch();
            if (this.isSQLPatch) {
                try {
                    SQLPatchStartupMode mode = patch.getSqlPatchDatabaseStartupMode();
                    if (mode != null && mode.toString() != null && !mode.toString().equals("")) {
                        this.sqlPatchDatabaseStartupMode = mode.toString();
                        break block9;
                    }
                    this.sqlPatchDatabaseStartupMode = SQLPatchStartupMode.NORMAL.toString();
                }
                catch (OPatchException mode) {}
            } else {
                this.sqlPatchDatabaseStartupMode = SQLPatchStartupMode.NORMAL.toString();
            }
        }
        if (this.isComposite) {
            this.subPatchList = new ArrayList<String>();
            this.subPatchList.addAll(patch.getSubPatchIds());
        }
        if (patch.getMinimumOPatchVersion() != null) {
            this.minOPatchVersion = patch.getMinimumOPatchVersion().getVerString();
        }
        if ((platformList = patch.getPlatforms()) != null && platformList.length > 0) {
            this.supportedPlatForm = new ArrayList<String>();
            for (int i = 0; i < platformList.length; ++i) {
                this.supportedPlatForm.add(platformList[i].getID());
            }
        }
    }

    private boolean isMethodValid(Class className, String method, Class[] parameterTypes) {
        try {
            className.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public OPatchPatchInfo() {
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public void setPatchLocation(String patchLocation) {
        this.patchLocation = patchLocation;
    }

    public String getPatchID() {
        return this.patchID;
    }

    public void setPatchID(String patchID) {
        this.patchID = patchID;
    }

    public String getPatchType() {
        return this.patchType;
    }

    public void setPatchType(String patchType) {
        this.patchType = patchType;
    }

    public boolean isSQLPatch() {
        return this.isSQLPatch;
    }

    public void setSQLPatch(boolean isSQLPatch) {
        this.isSQLPatch = isSQLPatch;
    }

    public String getSqlPatchDatabaseStartupMode() {
        return this.sqlPatchDatabaseStartupMode;
    }

    public void setSqlPatchDatabaseStartupMode(String sqlPatchUpgradeMode) {
        this.sqlPatchDatabaseStartupMode = sqlPatchUpgradeMode;
    }

    public boolean isComposite() {
        return this.isComposite;
    }

    public void setComposite(boolean isComposite) {
        this.isComposite = isComposite;
    }

    public List<String> getSubPatchList() {
        return this.subPatchList;
    }

    public void setSubPatchList(List<String> subPatchList) {
        this.subPatchList = subPatchList;
    }

    public boolean isRollingPatch() {
        return this.isRollingPatch;
    }

    public void setRollingPatch(boolean isRollingPatch) {
        this.isRollingPatch = isRollingPatch;
    }

    public boolean isOnLinePatch() {
        return this.isOnLinePatch;
    }

    public void setOnLinePatch(boolean isOnLinePatch) {
        this.isOnLinePatch = isOnLinePatch;
    }

    public boolean isInstanceShutDownPatch() {
        return this.isInstanceShutDownPatch;
    }

    public void setInstanceShutDownPatch(boolean isInstanceShutDownPatch) {
        this.isInstanceShutDownPatch = isInstanceShutDownPatch;
    }

    public String getUniquePatchID() {
        return this.uniquePatchID;
    }

    public void setUniquePatchID(String uniquePatchID) {
        this.uniquePatchID = uniquePatchID;
    }

    public String getMinOPatchVersion() {
        return this.minOPatchVersion;
    }

    public void setMinOPatchVersion(String minOPatchVersion) {
        this.minOPatchVersion = minOPatchVersion;
    }

    public List<String> getSupportedPlatForms() {
        return this.supportedPlatForm;
    }

    public void setSupportedPlatForms(List<String> supportedPlatForm) {
        this.supportedPlatForm = supportedPlatForm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.patchID == null ? 0 : this.patchID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPatchPatchInfo other = (OPatchPatchInfo)obj;
        return !(this.patchID == null ? other.patchID != null : !this.patchID.equals(other.patchID));
    }

    public String toString() {
        return "OPatchPatchInfo [patchID=" + this.getPatchID() + ", patchLocation=" + this.getPatchLocation() + ", patchType=" + this.getPatchType() + ", isSQLPatch=" + this.isSQLPatch() + ", uniquePatchID=" + this.getUniquePatchID() + ", sqlPatchUpgradeMode=" + this.getSqlPatchDatabaseStartupMode() + ", isComposite=" + this.isComposite() + ", subPatchList=" + this.getSubPatchList() + ", isRollingpatch=" + this.isRollingPatch() + ", isOnlinepatch=" + this.isOnLinePatch() + "]";
    }
}

