/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.CASAction;
import oracle.opatchauto.core.binary.action.PatchBag;
import oracle.opatchauto.core.binary.action.PatchParamBag;

public class CASRollbackAction
extends CASAction {
    private static final byte ROLLINGBACK = 0;
    private static final byte ROLLEDBACK = 1;

    @Override
    public ActionResult execute(PatchParamBag paramBag) {
        OPatchTarget target = paramBag.getTarget();
        PatchingSessionOptions sessionOptions = paramBag.getSessionOptions();
        PatchBag patchbag = paramBag.getPatchbag();
        ActionResult actionResult = new ActionResult();
        List<OPatchPatch> patchList = patchbag.getPatchObjList();
        boolean hasRunPhaseOne = target.hasRunPhaseOne(patchList.toArray(new OPatchPatch[patchList.size()]));
        OACLogger.info("Has phase one executed for patches for target " + target.getOracleHome() + ":" + hasRunPhaseOne);
        if (hasRunPhaseOne) {
            actionResult = this.rollBackPatches(target, patchbag);
        } else {
            OACLogger.info("Analyzing patches before CAS rollback");
            actionResult = this.analyzeAndPreparePatches(target, sessionOptions, patchbag, true);
            if (actionResult.getStatus() != ActionResult.Status.FAILED) {
                try {
                    PatchBag updatedPatchBag = this.getUpdatedPatchBag(actionResult, paramBag.getContext());
                    actionResult = this.rollBackPatches(target, updatedPatchBag);
                }
                catch (OPatchException oPatchException) {
                    // empty catch block
                }
            }
        }
        return actionResult;
    }

    private ActionResult rollBackPatches(OPatchTarget target, PatchBag patchbag) {
        OACLogger.info("Committing patches rollback");
        ActionResult actionResult = new ActionResult();
        List<Object> resultList = new ArrayList();
        List<OPatchPatch> patchList = patchbag.getPatchObjList();
        this.printPatchDetails(patchbag, (byte)0);
        try {
            target.nrollbackCommit(patchList.toArray(new OPatchPatch[patchList.size()]));
            this.updateSystemPatchInformation(target.getOracleHome(), patchList, true);
            resultList = this.createPatchResult(patchbag, target.getLastSessionLogFile(), null);
            this.printPatchDetails(patchbag, (byte)1);
        }
        catch (OPatchException e) {
            resultList = this.createPatchResult(patchbag, target.getLastSessionLogFile(), (Exception)((Object)e));
        }
        for (PatchResult patchResult : resultList) {
            actionResult.addPatchResult(patchResult);
        }
        return actionResult;
    }

    private void printPatchDetails(PatchBag patchbag, byte status) {
        List<String> patchLocationList = patchbag.getPatchLocationList();
        List<String> rollbackIDList = patchbag.getPatchIDList();
        if (!patchLocationList.isEmpty()) {
            for (String patchLoc : patchLocationList) {
                if (status == 0) {
                    OACLogger.console("Rolling back patch " + patchLoc + "...\n");
                    continue;
                }
                OACLogger.console("Patch " + patchLoc + " rolled back.");
            }
        } else {
            for (String id : rollbackIDList) {
                if (status == 0) {
                    OACLogger.console("Rolling back patch " + id + "...\n");
                    continue;
                }
                OACLogger.console("Patch " + id + " rolled back.");
            }
        }
    }

    private List<PatchResult> createPatchResult(PatchBag patchbag, String logFile, Exception e) {
        PatchResult result;
        ArrayList<PatchResult> patchResultList = new ArrayList<PatchResult>();
        List<String> patchLocationList = patchbag.getPatchLocationList();
        List<String> rollbackIDList = patchbag.getPatchIDList();
        if (!patchLocationList.isEmpty()) {
            for (String patchLoc : patchLocationList) {
                result = null;
                result = e != null ? OPatchAutoBinaryUtil.buildFailedPR(patchLoc, "Failed during Patching: ", e, logFile) : OPatchAutoBinaryUtil.buildSuccessfulPR(patchLoc, logFile);
                patchResultList.add(result);
            }
        }
        if (!rollbackIDList.isEmpty()) {
            for (String id : rollbackIDList) {
                result = null;
                if (e != null) {
                    OPatchAutoBinaryUtil.buildFailedPRwithID(id, "Failed during Patching: ", e, logFile);
                } else {
                    result = OPatchAutoBinaryUtil.buildSuccessfulPRwithID(id, logFile);
                }
                patchResultList.add(result);
            }
        }
        return patchResultList;
    }
}

