/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import com.oracle.cie.common.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.BinaryAction;
import oracle.opatchauto.core.binary.action.PatchBag;
import oracle.opatchauto.core.binary.action.PatchParamBag;

public class OnlineAnalyzeAction
implements BinaryAction {
    private final boolean isRollback;

    public OnlineAnalyzeAction(boolean isRollback) {
        this.isRollback = isRollback;
    }

    @Override
    public ActionResult execute(PatchParamBag paramBag) {
        OPatchTarget target = paramBag.getTarget();
        PatchingSessionOptions sessionOptions = paramBag.getSessionOptions();
        PatchBag patchbag = paramBag.getPatchbag();
        ActionResult actionResult = new ActionResult();
        IAnalysisReport report = null;
        List<OPatchPatch> patchObjList = patchbag.getPatchObjList();
        List<String> patchLocationList = patchbag.getPatchLocationList();
        List<String> patchIDList = patchbag.getPatchIDList();
        try {
            if (this.isRollback) {
                OPatchNRollbackOptions rollbackOptions = new OPatchNRollbackOptions();
                rollbackOptions.ohInstanceUp(sessionOptions.isOhInstanceRunning()).noRelink(sessionOptions.isNoRelink()).noPatchgen(sessionOptions.isNoPatchgen()).continueOnPrereqFailure(true);
                if (OPatchAutoBinaryUtil.isCASEnabled() && sessionOptions.isPrepareHome()) {
                    OACLogger.info("Analysing patches and preparing home to rollback.");
                    report = target.nrollbackPrepare(patchObjList.toArray(new OPatchPatch[patchObjList.size()]), rollbackOptions);
                } else {
                    OACLogger.info("Analysing patches to rollback.");
                    report = target.NRollbackReportForAllPrereqs(patchObjList.toArray(new OPatchPatch[patchObjList.size()]), rollbackOptions);
                }
            } else {
                OPatchNApplyOptions options = new OPatchNApplyOptions();
                options.ohInstanceUp(sessionOptions.isOhInstanceRunning()).forceConflict(sessionOptions.isForceConflict()).skipConflict(sessionOptions.isSkipConflict()).noRelink(sessionOptions.isNoRelink()).noPatchgen(sessionOptions.isNoPatchgen()).continueOnPrereqFailure(true);
                if (OPatchAutoBinaryUtil.isCASEnabled() && sessionOptions.isPrepareHome()) {
                    OACLogger.info("Analysing patches and preparing home to apply.");
                    report = target.napplyPrepare(patchObjList.toArray(new OPatchPatch[patchObjList.size()]), options);
                } else {
                    OACLogger.info("Analysing patches to apply.");
                    OACLogger.info("Collecting auto-rollback IDs from OnlineAnalyzeAction\n");
                    report = target.NApplyReportInitialPrereqs(patchObjList.toArray(new OPatchPatch[patchObjList.size()]), options);
                    boolean found = false;
                    Map failedPatches = report.getFailedPatches();
                    if (failedPatches != null && failedPatches.size() > 0) {
                        found = true;
                    }
                    if (!found) {
                        report = target.NApplyReportForAllPrereqs(patchObjList.toArray(new OPatchPatch[patchObjList.size()]), options);
                        OPatchAutoBinaryUtil.getAutoRollbackPatchIDs(report);
                        OACLogger.info("Finished reading auto-rollback list.");
                    }
                }
            }
            if (sessionOptions.isPrepareHome()) {
                OACLogger.console("Analysis completed and prepared the home for patching.");
            } else {
                OACLogger.console("Analysis completed.");
            }
            PatchResult result = null;
            for (String patchLocn : patchLocationList) {
                result = this.analyzePrereqResult(patchLocn, "", target.getLastSessionLogFile(), report, this.isRollback, target.getOracleHome());
                actionResult.addPatchResult(result);
            }
            for (String patchId : patchIDList) {
                result = this.analyzePrereqResult("", patchId, target.getLastSessionLogFile(), report, this.isRollback, target.getOracleHome());
                actionResult.addPatchResult(result);
            }
            actionResult.setAnalysisReport(report);
        }
        catch (FailedPrereqException | OPatchException e) {
            OACLogger.console("Patch Analysis FAILED.");
            OACLogger.printStackTrace(e);
            String logFile = target.getLastSessionLogFile();
            for (String patchLoc : patchLocationList) {
                actionResult.addPatchResult(OPatchAutoBinaryUtil.buildFailedPR(patchLoc, "Failed during Analysis: ", new Exception(e), logFile));
            }
            for (String patchId : patchIDList) {
                actionResult.addPatchResult(OPatchAutoBinaryUtil.buildFailedPRwithID(patchId, "Failed during Analysis: ", new Exception(e), logFile));
            }
        }
        return actionResult;
    }

    private PatchResult analyzePrereqResult(String patchLocation, String patchID, String log, IAnalysisReport report, boolean isRollback, String oracleHome) {
        boolean isComposite;
        PatchResult patchResult = null;
        boolean found = false;
        StringBuffer reason = new StringBuffer();
        StringBuffer prereqSummary = new StringBuffer();
        prereqSummary.append("Analyzing prereq results of " + (patchLocation.length() < 1 ? patchID : patchLocation) + " :\n");
        Map failedPatches = report.getFailedPatches();
        Map skipPatches = report.getSkipPatches();
        if (failedPatches != null && failedPatches.size() > 0) {
            Set failedList = failedPatches.entrySet();
            for (Map.Entry<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> entry : failedList) {
                OPatchPatch failedPatch = (OPatchPatch)entry.getKey();
                OACLogger.info("Failed patch ID::" + failedPatch.getPatchId());
                if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                    if (!failedPatch.getPatchId().equals(patchID)) continue;
                    reason = this.fillFailedPrereqDetails(entry);
                    patchResult = OPatchAutoBinaryUtil.buildFailedPR("", patchID, reason.toString(), log);
                    found = true;
                    break;
                }
                isComposite = OPatchAutoBinaryUtil.isComposite(patchLocation);
                try {
                    List<String> patchIDList2 = OPatchAutoBinaryUtil.getAllPatchIds(patchLocation, isComposite);
                    if (!patchIDList2.contains(failedPatch.getPatchId())) continue;
                    reason = this.fillFailedPrereqDetails(entry);
                    patchResult = OPatchAutoBinaryUtil.buildFailedPR(patchLocation, "", reason.toString(), log);
                    found = true;
                    break;
                }
                catch (OPatchException patchIDList2) {
                }
            }
        }
        if (!found && skipPatches != null && skipPatches.size() > 0) {
            Set skippedList = skipPatches.entrySet();
            for (Map.Entry entry : skippedList) {
                OPatchPatch skippedpatch = (OPatchPatch)entry.getKey();
                OACLogger.info("Skipped patch ID::" + skippedpatch.getPatchId());
                if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                    if (!skippedpatch.getPatchId().equals(patchID)) continue;
                    reason.append(this.getSkippedReason(oracleHome, patchLocation));
                    prereqSummary.append(reason.toString());
                    OACLogger.info(prereqSummary.toString());
                    patchResult = OPatchAutoBinaryUtil.buildSkippedPRwithID(patchID, reason.toString());
                    found = true;
                    break;
                }
                isComposite = OPatchAutoBinaryUtil.isComposite(patchLocation);
                try {
                    List<String> patchIDList = OPatchAutoBinaryUtil.getAllPatchIds(patchLocation, isComposite);
                    if (!patchIDList.contains(skippedpatch.getPatchId())) continue;
                    reason.append(this.getSkippedReason(oracleHome, patchLocation));
                    prereqSummary.append(reason.toString());
                    OACLogger.info(prereqSummary.toString());
                    patchResult = OPatchAutoBinaryUtil.buildSkippedPR(patchLocation, reason.toString(), log);
                    found = true;
                    break;
                }
                catch (OPatchException e) {
                    OACLogger.info("Exception while getting patch IDs" + e.getLocalizedMessage());
                }
            }
        }
        if (!found) {
            List successfulPatches = null;
            successfulPatches = isRollback ? report.getNRollbackPatches() : report.getNApplyPatches();
            if (successfulPatches.size() == 0) {
                reason.append("Failed during Analysis: ").append(patchLocation + " is not applicable to the oracle home " + oracleHome);
                prereqSummary.append(reason.toString());
                patchResult = StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true) ? OPatchAutoBinaryUtil.buildFailedPR("", patchID, reason.toString(), log) : OPatchAutoBinaryUtil.buildFailedPR(patchLocation, "", reason.toString(), log);
            } else {
                for (OPatchPatch oPatchPatch : successfulPatches) {
                    if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                        if (!oPatchPatch.getPatchId().equals(patchID)) continue;
                        patchResult = OPatchAutoBinaryUtil.buildSuccessfulPRwithID(patchID, log);
                        prereqSummary.append("Patch analysis completed successfully for " + patchID);
                        found = true;
                        continue;
                    }
                    boolean isComposite2 = OPatchAutoBinaryUtil.isComposite(patchLocation);
                    try {
                        List<String> patchIDList3 = OPatchAutoBinaryUtil.getAllPatchIds(patchLocation, isComposite2);
                        if (!patchIDList3.contains(oPatchPatch.getPatchId())) continue;
                        patchResult = OPatchAutoBinaryUtil.buildSuccessfulPR(patchLocation, log);
                        prereqSummary.append("Patch analysis completed successfully for " + patchLocation);
                        found = true;
                    }
                    catch (OPatchException oPatchException) {}
                }
                if (!found && !isRollback) {
                    reason.append(patchLocation + " is not applicable to the oracle home " + oracleHome);
                    prereqSummary.append(reason.toString());
                    patchResult = OPatchAutoBinaryUtil.buildSkippedPR(patchLocation, reason.toString(), log);
                }
            }
            OACLogger.info(prereqSummary.toString());
        }
        return patchResult;
    }

    private String getSkippedReason(String oracleHome, String patchLocation) {
        String reason = null;
        reason = this.isRollback ? patchLocation + " is not required to be rolled back from oracle home " + oracleHome : patchLocation + " is not required to be applied to oracle home " + oracleHome;
        return reason;
    }

    private StringBuffer fillFailedPrereqDetails(Map.Entry<OPatchPatch, Map<OPatchPatchPrereq, OPatchTarget.StatusCheck>> tmpPatchPrereqInfo) {
        StringBuffer reason = new StringBuffer();
        StringBuffer prereqSummary = new StringBuffer();
        reason.append("Failed during Analysis: ");
        prereqSummary.append(reason);
        Map<OPatchPatchPrereq, OPatchTarget.StatusCheck> prereqs = tmpPatchPrereqInfo.getValue();
        Set<Map.Entry<OPatchPatchPrereq, OPatchTarget.StatusCheck>> prereqList = prereqs.entrySet();
        for (Map.Entry<OPatchPatchPrereq, OPatchTarget.StatusCheck> prereq : prereqList) {
            prereqSummary.append(prereq.getKey().toString() + " :- " + prereq.getValue().toString());
            if (prereq.getValue().getStatusCode() != 1) continue;
            reason.append(prereq.getKey().toString()).append(" Failed, ").append(prereq.getValue().toString());
        }
        OACLogger.info(prereqSummary.toString());
        return reason;
    }
}

