/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.systempatch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.systempatch.AppliedSystemPatchInformation;
import oracle.opatchauto.core.binary.systempatch.AppliedSystempatchInformationList;
import oracle.opatchauto.core.binary.systempatch.SystemPatchData;
import oracle.opatchauto.core.binary.systempatch.SystemPatchStorageHelper;

public class SystemPatchInformationLoader {
    private static final String SYSTEM_PATCH_INFORMATION_STORE_XML = "systemPatchInformationStore.xml";
    private AppliedSystempatchInformationList systempatchinformationList;
    private List<SystemPatchData> systemPatchToBeApplied = new ArrayList<SystemPatchData>();
    private List<SystemPatchData> systemPatchToBeRollback = new ArrayList<SystemPatchData>();

    private SystemPatchInformationLoader() {
    }

    public static SystemPatchInformationLoader getInstance() {
        SystemPatchInformationLoader systemPatchInfoLoader = Loader.systemPatchInfoLoader;
        return systemPatchInfoLoader;
    }

    public List<String> getAppliedSubpatchIDList(String oracleHome, String bundlepatchID) {
        List<String> appliedSubpatchIDList = null;
        if (this.systempatchinformationList == null) {
            this.loadSystemPatchInformation(oracleHome);
        }
        List<AppliedSystemPatchInformation> list = this.systempatchinformationList.getSystemPatchInformationList();
        for (AppliedSystemPatchInformation info : list) {
            if (!info.getSystempatchID().equals(bundlepatchID)) continue;
            appliedSubpatchIDList = info.getAppliedPatchList();
            break;
        }
        return appliedSubpatchIDList;
    }

    public void setSystempatchInfoToBeRolledBack(SystemPatchData systempatchData) {
        this.systemPatchToBeRollback.add(systempatchData);
    }

    public List<SystemPatchData> getSystempatchInfoToBeRolledBack() {
        return this.systemPatchToBeRollback;
    }

    public void setSystemPatchInfoToBeApplied(SystemPatchData systempatchData) {
        this.systemPatchToBeApplied.add(systempatchData);
    }

    public List<SystemPatchData> getSystemPatchInfoToBeApplied() {
        return this.systemPatchToBeApplied;
    }

    public String getSystemPatchID(List<OPatchPatch> patches, boolean isRollback) {
        String systempatchID = null;
        List<SystemPatchData> systempatchDataList = isRollback ? this.systemPatchToBeRollback : this.systemPatchToBeApplied;
        for (OPatchPatch patch : patches) {
            for (SystemPatchData data : systempatchDataList) {
                if (!data.getApplicableSubPatchIDList().contains(patch.getPatchId())) continue;
                systempatchID = data.getBundlePatchID();
                break;
            }
            if (systempatchID == null) continue;
            break;
        }
        return systempatchID;
    }

    public void updateSubpatchInformationStore(String oracleHome, String systempatchID, List<String> subPatchIDList, boolean isRollback) {
        if (isRollback) {
            this.removeSubPatchInformation(oracleHome, systempatchID, subPatchIDList);
        } else {
            this.storeSubPatchInformation(oracleHome, systempatchID, subPatchIDList);
        }
    }

    private synchronized void storeSubPatchInformation(String oracleHome, String systempatchID, List<String> appliedPatchIDList) {
        if (!this.systemPatchToBeApplied.isEmpty()) {
            if (this.systempatchinformationList == null) {
                this.loadSystemPatchInformation(oracleHome);
            }
            List<String> patchIDList = this.findSubpatchIDList(appliedPatchIDList, this.systemPatchToBeApplied);
            OACLogger.info("Storing patch ID list " + patchIDList + " for system patch " + systempatchID);
            this.systempatchinformationList.storeSystemPatchInformation(systempatchID, patchIDList);
            this.save(oracleHome);
        }
    }

    private synchronized void removeSubPatchInformation(String oracleHome, String systempatchID, List<String> rolledBackPatchIDList) {
        if (this.systempatchinformationList == null) {
            this.loadSystemPatchInformation(oracleHome);
        }
        List<String> patchIDList = this.findSubpatchIDList(rolledBackPatchIDList, this.systemPatchToBeRollback);
        OACLogger.info("Removing patch ID list " + patchIDList + " for system patch " + systempatchID);
        this.systempatchinformationList.removeSystemPatchInformation(systempatchID, patchIDList);
        this.save(oracleHome);
    }

    private List<String> findSubpatchIDList(List<String> appliedPatchIDList, List<SystemPatchData> systemPatchDataList) {
        ArrayList<String> patchIDList = new ArrayList<String>();
        for (SystemPatchData data : systemPatchDataList) {
            List<String> subpatchIDList = data.getApplicableSubPatchIDList();
            for (String subpatchID : subpatchIDList) {
                if (!appliedPatchIDList.contains(subpatchID)) continue;
                patchIDList.add(subpatchID);
            }
        }
        return patchIDList;
    }

    private void loadSystemPatchInformation(String oracleHome) {
        String patchInfoFile = this.getPatchInfoFile(oracleHome);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AppliedSystempatchInformationList.class});
            Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
            this.systempatchinformationList = (AppliedSystempatchInformationList)jaxbMarshaller.unmarshal(new File(patchInfoFile));
        }
        catch (JAXBException e) {
            this.systempatchinformationList = new AppliedSystempatchInformationList();
        }
    }

    private String getPatchInfoFile(String oracleHome) {
        String storageLocation = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome);
        File destinationDir = new File(storageLocation);
        destinationDir.mkdirs();
        String patchInfoFile = storageLocation + File.separator + SYSTEM_PATCH_INFORMATION_STORE_XML;
        return patchInfoFile;
    }

    private void save(String oracleHome) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AppliedSystempatchInformationList.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            String systemPatchInfoFile = this.getPatchInfoFile(oracleHome);
            jaxbMarshaller.marshal((Object)this.systempatchinformationList, new File(systemPatchInfoFile));
            String chmodCmd = "chmod 640 " + systemPatchInfoFile;
            OPatchAutoBinaryUtil.executeCmd(chmodCmd);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private static class Loader {
        static SystemPatchInformationLoader systemPatchInfoLoader = new SystemPatchInformationLoader();

        private Loader() {
        }
    }
}

