/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.patchanalyzer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.systempatch.SystemPatchStorageHelper;
import oracle.opatchauto.core.patchanalyzer.PatchPackageException;
import oracle.opatchauto.core.patchanalyzer.systempatch.ISystemPatchGenerator;
import oracle.opatchauto.core.patchanalyzer.systempatch.SubpatchModel;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;
import oracle.opatchauto.core.patchanalyzer.systempatch.bundlepatch.BundlePatchGenerator;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.EngSystemPatchGenerator;

public class PatchAnalyzer {
    private static final byte ENG_SYS_PATCH = 1;
    private static final byte BUNDLE_PATCH = 2;
    public static final String CONTENT_TYPE_JDK = new String("jdk");
    public static final String JRE = new String("jre");
    private Map<Byte, ISystemPatchGenerator> systempatchGenerator = new TreeMap<Byte, ISystemPatchGenerator>();

    public PatchAnalyzer() {
        this.systempatchGenerator.put((byte)1, new EngSystemPatchGenerator());
        this.systempatchGenerator.put((byte)2, new BundlePatchGenerator());
    }

    public SystemPatchBundleXML analyzePatch(String patchLocation) {
        SystemPatchBundleXML systemPatchBundle = null;
        Set<Byte> keySet = this.systempatchGenerator.keySet();
        for (Byte generatorKey : keySet) {
            try {
                ISystemPatchGenerator generator = this.systempatchGenerator.get(generatorKey);
                if (!generator.isPatchValid(patchLocation) || (systemPatchBundle = generator.generate(patchLocation, true)) == null) continue;
                break;
            }
            catch (PatchPackageException e) {
                OACLogger.severe(e.getLocalizedMessage());
            }
        }
        return systemPatchBundle;
    }

    public boolean isPatchvalid(String patchLocation) {
        boolean isPatchValid = false;
        Set<Byte> keySet = this.systempatchGenerator.keySet();
        for (Byte generatorKey : keySet) {
            try {
                ISystemPatchGenerator generator = this.systempatchGenerator.get(generatorKey);
                isPatchValid = generator.isPatchValid(patchLocation);
                if (!isPatchValid) continue;
                break;
            }
            catch (PatchPackageException e) {
                OACLogger.severe(e.getLocalizedMessage());
            }
        }
        return isPatchValid;
    }

    public Map<String, List<String>> getPatchIDSFromBundleXML(String patchLocation, List<String> filters) throws PatchPackageException {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        ISystemPatchGenerator engSyspatchGenerator = this.systempatchGenerator.get((byte)1);
        if (engSyspatchGenerator.isPatchValid(patchLocation)) {
            SystemPatchBundleXML esysBundle = engSyspatchGenerator.generate(patchLocation, false);
            if (esysBundle == null) {
                return resultMap;
            }
            List<SubpatchModel> subpatchList = esysBundle.getSubpatchList();
            if (subpatchList != null) {
                for (SubpatchModel subPatchXml : subpatchList) {
                    List<String> targetTypeList = subPatchXml.getTargetTypes();
                    if (targetTypeList == null) continue;
                    for (String targetType : targetTypeList) {
                        if (filters != null && !filters.isEmpty() && !filters.contains(targetType)) continue;
                        if (!resultMap.containsKey(targetType)) {
                            resultMap.put(targetType, new ArrayList());
                        }
                        List patchIds = (List)resultMap.get(targetType);
                        patchIds.add(subPatchXml.getPatchID());
                    }
                }
            }
        }
        return resultMap;
    }

    public SystemPatchBundleXML getSystemPatchModel(String patchLocation) throws PatchPackageException {
        SystemPatchBundleXML esysBundle = null;
        ISystemPatchGenerator engSyspatchGenerator = this.systempatchGenerator.get((byte)1);
        if (engSyspatchGenerator.isPatchValid(patchLocation)) {
            esysBundle = engSyspatchGenerator.generate(patchLocation, false);
        }
        return esysBundle == null ? null : esysBundle;
    }

    public List<SubPatchInfo> getSubPatchesInfoFromModel(SystemPatchBundleXML systemPatchDetails, String targetType) {
        List<SubpatchModel> subPatchList;
        ArrayList<SubPatchInfo> patchDataList = new ArrayList<SubPatchInfo>();
        if (systemPatchDetails != null && (subPatchList = systemPatchDetails.getSubpatchList()) != null && subPatchList.size() > 0) {
            String bundlePatchLoc = OPatchAutoBinaryUtil.removeFileSeperatorAtEnd(systemPatchDetails.getPatchLocation());
            for (SubpatchModel subPatch : subPatchList) {
                StringBuffer subPatchLocation = new StringBuffer(bundlePatchLoc);
                subPatchLocation.append(File.separator);
                subPatchLocation.append(subPatch.getLocation());
                if (targetType == null) {
                    patchDataList.add(this.getSubPatchInfo(subPatch, subPatchLocation.toString()));
                    continue;
                }
                List<String> types = subPatch.getTargetTypes();
                if (targetType.equals("cluster")) {
                    if (!types.contains("cluster") && !types.contains("crs")) continue;
                    patchDataList.add(this.getSubPatchInfo(subPatch, subPatchLocation.toString()));
                    continue;
                }
                if (targetType.equals("has")) {
                    if (!types.contains("has") && !types.contains("siha")) continue;
                    patchDataList.add(this.getSubPatchInfo(subPatch, subPatchLocation.toString()));
                    continue;
                }
                if (targetType.equals("oracle_database")) {
                    if (!types.contains("oracle_database") && !types.contains("sidb")) continue;
                    patchDataList.add(this.getSubPatchInfo(subPatch, subPatchLocation.toString()));
                    continue;
                }
                if (targetType.equals("rac_database")) {
                    if (!types.contains("rac_database") && !types.contains("rac")) continue;
                    patchDataList.add(this.getSubPatchInfo(subPatch, subPatchLocation.toString()));
                    continue;
                }
                if (!types.contains(targetType)) continue;
                patchDataList.add(this.getSubPatchInfo(subPatch, subPatchLocation.toString()));
            }
        }
        return patchDataList;
    }

    private SubPatchInfo getSubPatchInfo(SubpatchModel subPatch, String subPatchLocation) {
        SubPatchInfo data = new SubPatchInfo(subPatch.getPatchID(), subPatchLocation);
        return data;
    }

    public boolean isJDKPatch(String opatchLocation) throws PatchMetadataLoadingException, InvalidPatchMetadataException, PatchNotFoundException {
        boolean isJDKPatch = false;
        if (null != opatchLocation && !"".equals(opatchLocation)) {
            Patch patch = BasePatchFactory.instance().createPatch(opatchLocation);
            for (PatchInventory pi : patch.getPatchInventories()) {
                if (!pi.getPatchChara().getContentType().getValue().equals(CONTENT_TYPE_JDK)) continue;
                isJDKPatch = true;
            }
            if (isJDKPatch) {
                OACLogger.info("Patch " + patch.getPatchId() + " is a jdk patch");
            }
        }
        return isJDKPatch;
    }

    public List<String> getSubPatchIDsForSystemPatchID(String id, String oracleHome) {
        String bundle_locn;
        File bundleXml;
        ArrayList<String> subPatchIds = new ArrayList<String>();
        if (null != id && (bundleXml = new File(bundle_locn = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome) + File.separator + id, "bundle.xml")).exists()) {
            try {
                Map<String, List<String>> bundleEntries = this.getPatchIDSFromBundleXML(bundle_locn, new ArrayList<String>());
                if (null != bundleEntries && bundleEntries.size() > 0) {
                    for (List<String> subIds : bundleEntries.values()) {
                        subPatchIds.addAll(subIds);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return subPatchIds;
    }

    public boolean isSystemPatch(String patchID, String oracleHome) {
        boolean isSystempatch = false;
        String bundle_locn = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome) + File.separator + patchID;
        File bundleXml = new File(bundle_locn, "bundle.xml");
        if (bundleXml.exists()) {
            isSystempatch = true;
        }
        return isSystempatch;
    }

    public boolean isJavaSessionStartedFromHome(String home) {
        return OPatchAutoBinaryUtil.comparePaths(System.getProperty("java.home"), home + File.separator + CONTENT_TYPE_JDK + File.separator + JRE) || OPatchAutoBinaryUtil.comparePaths(System.getProperty("java.home"), home + File.separator + CONTENT_TYPE_JDK);
    }

    public class SubPatchInfo {
        private final String patchID;
        private final String patchLocation;

        public SubPatchInfo(String patchID, String patchLocation) {
            this.patchID = patchID;
            this.patchLocation = patchLocation;
        }

        public String getPatchID() {
            return this.patchID;
        }

        public String getPatchLocation() {
            return this.patchLocation;
        }

        private PatchAnalyzer getOuterType() {
            return PatchAnalyzer.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.patchID == null ? 0 : this.patchID.hashCode());
            result = 31 * result + (this.patchLocation == null ? 0 : this.patchLocation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubPatchInfo other = (SubPatchInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.patchID == null ? other.patchID != null : !this.patchID.equals(other.patchID)) {
                return false;
            }
            return !(this.patchLocation == null ? other.patchLocation != null : !this.patchLocation.equals(other.patchLocation));
        }
    }
}

