/*
 * Decompiled with CFR 0.152.
 */
package de.transfact.stempeluhr;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundPlayer
implements LineListener {
    boolean isPlaybackCompleted;

    @Override
    public void update(LineEvent event) {
        if (LineEvent.Type.START != event.getType() && LineEvent.Type.STOP == event.getType()) {
            this.isPlaybackCompleted = true;
        }
    }

    void play() {
        try {
            InputStream audioSrc = this.getClass().getClassLoader().getResourceAsStream("beep.wav");
            BufferedInputStream bufferedIn = new BufferedInputStream(audioSrc);
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(bufferedIn);
            AudioFormat format = audioStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip audioClip = (Clip)AudioSystem.getLine(info);
            audioClip.addLineListener(this);
            audioClip.open(audioStream);
            FloatControl gainControl = (FloatControl)audioClip.getControl(FloatControl.Type.MASTER_GAIN);
            gainControl.setValue(6.0f);
            audioClip.start();
            while (!this.isPlaybackCompleted) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            audioClip.close();
            audioStream.close();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
            System.out.println("Error occured during playback process:" + ex.getMessage());
        }
    }
}

